/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.RestorableState;
import com.google.cloud.WriteChannel;
import java.io.IOException;
import java.nio.ByteBuffer;

public class FakeWriteChannel
implements WriteChannel {
    private boolean open = true;
    private final boolean throwExceptionOnWrite;

    public FakeWriteChannel() {
        this.throwExceptionOnWrite = false;
    }

    public FakeWriteChannel(boolean throwExceptionOnWrite) {
        this.throwExceptionOnWrite = throwExceptionOnWrite;
    }

    public void setChunkSize(int i) {
    }

    public RestorableState<WriteChannel> capture() {
        return null;
    }

    public int write(ByteBuffer src) throws IOException {
        if (this.throwExceptionOnWrite) {
            throw new IOException("Intentionally triggered");
        }
        int bytesWritten = 0;
        int capacity = src.capacity();
        if (src.limit() - src.position() <= capacity / 2) {
            bytesWritten = src.limit();
            src.position(src.limit());
        } else {
            bytesWritten = capacity / 2;
            src.position(src.position() + capacity / 2);
        }
        return bytesWritten;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void close() throws IOException {
        this.open = false;
    }
}

