/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.ReadChannel;
import com.google.cloud.RestorableState;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;

public class FakeReadChannel
implements ReadChannel {
    public static final int CHUNK_SIZE = 1024;
    private final List<REQUEST_TYPE> orderRequestsList;
    private final Iterator<REQUEST_TYPE> requestTypesIterator;
    private boolean open = true;
    private long position;
    private long limit = Long.MAX_VALUE;
    private ByteString content;
    private long currentPosition = 0L;

    public FakeReadChannel(ByteString content) {
        this.content = content;
        this.orderRequestsList = null;
        this.requestTypesIterator = null;
    }

    public FakeReadChannel(ByteString content, List<REQUEST_TYPE> orderRequestsList) {
        this.content = content;
        this.orderRequestsList = orderRequestsList;
        this.requestTypesIterator = orderRequestsList.iterator();
    }

    public boolean isOpen() {
        return this.open;
    }

    public void close() {
        this.open = false;
    }

    public void seek(long position) throws IOException {
        this.position = position;
        this.currentPosition = position;
    }

    public ReadChannel limit(long limit) {
        this.limit = limit;
        return this;
    }

    public void setChunkSize(int i) {
    }

    public RestorableState<ReadChannel> capture() {
        return null;
    }

    private int readInternal(ByteBuffer dst, long startIndex, long bytesToRead) {
        if (this.currentPosition >= this.limit) {
            return -1;
        }
        long readStart = startIndex;
        long readEnd = Math.min(Math.min(startIndex + bytesToRead, startIndex + (long)dst.remaining()), Math.min((long)this.content.size(), this.limit));
        ByteString messageData = this.content.substring(Math.toIntExact(readStart), Math.toIntExact(readEnd));
        for (Byte messageDatum : messageData) {
            dst.put(messageDatum);
        }
        return messageData.size();
    }

    public int read(ByteBuffer dst) throws IOException {
        REQUEST_TYPE requestType = REQUEST_TYPE.READ_CHUNK;
        if (this.requestTypesIterator != null && this.requestTypesIterator.hasNext()) {
            requestType = this.requestTypesIterator.next();
        }
        int bytesRead = 0;
        switch (requestType) {
            case ZERO_READ: {
                bytesRead = 0;
                break;
            }
            case NEGATIVE_READ: {
                bytesRead = -1;
                break;
            }
            case READ_EXCEPTION: {
                throw new IOException("Exception occurred in read");
            }
            case PARTIAL_READ: {
                bytesRead = this.readInternal(dst, this.currentPosition, dst.remaining() / 2);
                this.currentPosition += (long)bytesRead;
                throw new IOException("Partial Read Exception");
            }
            default: {
                bytesRead = this.readInternal(dst, this.currentPosition, 1024L);
            }
        }
        if (bytesRead > 0) {
            this.currentPosition += (long)bytesRead;
        }
        return bytesRead;
    }

    public static enum REQUEST_TYPE {
        READ_CHUNK,
        READ_EXCEPTION,
        PARTIAL_READ,
        NEGATIVE_READ,
        ZERO_READ;

    }
}

