/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.DeleteFolderOperation;
import com.google.cloud.hadoop.gcsio.FolderInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.common.base.Strings;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.FutureCallback;
import com.google.storage.control.v2.StorageControlClient;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class DeleteFolderOperationTest {
    private static final String BUCKET_NAME = "foo-bucket";
    @Mock
    private BlockingQueue<FolderInfo> mockFolderDeleteBlockingQueue;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void checkDeletionOrderForHnBucketBalancedFolders() throws IOException {
        int i;
        String folderString = "test-folder-start/";
        LinkedList<FolderInfo> foldersToDelete = new LinkedList<FolderInfo>();
        this.addFolders(foldersToDelete, folderString);
        CustomDeleteFolderOperationTest deleteFolderOperation = new CustomDeleteFolderOperationTest(foldersToDelete, GoogleCloudStorageOptions.DEFAULT, null);
        List<FolderInfo> orderOfDeletion = deleteFolderOperation.getOrderOfDeletion();
        deleteFolderOperation.performDeleteOperation();
        Truth.assertThat((Integer)orderOfDeletion.size()).isEqualTo((Object)foldersToDelete.size());
        HashMap<String, Integer> deletionOrder = new HashMap<String, Integer>();
        for (i = 0; i < orderOfDeletion.size(); ++i) {
            deletionOrder.put(orderOfDeletion.get(i).getFolderName(), i);
        }
        for (i = 0; i < orderOfDeletion.size(); ++i) {
            FolderInfo curFolder = orderOfDeletion.get(i);
            String curFolderName = curFolder.getFolderName();
            String parentFolderName = curFolder.getParentFolderName();
            if (Strings.isNullOrEmpty((String)parentFolderName)) continue;
            Truth.assertThat((Boolean)((Integer)deletionOrder.get(parentFolderName) > (Integer)deletionOrder.get(curFolderName) ? 1 : 0)).isTrue();
        }
    }

    @Test
    public void checkDeletionOrderForHnBucketSkewedFolders() throws IOException {
        Object folderString = "test-folder-start/";
        LinkedList<FolderInfo> foldersToDelete = new LinkedList<FolderInfo>();
        for (int i = 0; i < 10; ++i) {
            foldersToDelete.add(new FolderInfo(FolderInfo.createFolderInfoObject((String)BUCKET_NAME, (String)folderString)));
            folderString = (String)folderString + "test-folder-" + i + "/";
        }
        CustomDeleteFolderOperationTest deleteFolderOperation = new CustomDeleteFolderOperationTest(foldersToDelete, GoogleCloudStorageOptions.DEFAULT, null);
        deleteFolderOperation.performDeleteOperation();
        List<FolderInfo> orderOfDeletion = deleteFolderOperation.getOrderOfDeletion();
        Truth.assertThat((Integer)orderOfDeletion.size()).isEqualTo((Object)foldersToDelete.size());
        for (int i = 1; i < orderOfDeletion.size(); ++i) {
            FolderInfo prev = orderOfDeletion.get(i - 1);
            FolderInfo cur = orderOfDeletion.get(i);
            Truth.assertThat((String)prev.getParentFolderName()).isEqualTo((Object)cur.getFolderName());
        }
    }

    @Test
    public void checkExceptionTypeWhenPollTimesOutForPerformDeleteOperation() throws Exception {
        LinkedList<FolderInfo> foldersToDelete = new LinkedList<FolderInfo>();
        this.addFolders(foldersToDelete, "test-folder");
        DeleteFolderOperation deleteFolderOperation = new DeleteFolderOperation(foldersToDelete, GoogleCloudStorageOptions.DEFAULT, null);
        this.setMockFolderDeleteBlockingQueue(deleteFolderOperation);
        Mockito.when((Object)this.mockFolderDeleteBlockingQueue.poll(1L, TimeUnit.MINUTES)).thenReturn(null);
        IOException exception = (IOException)Assert.assertThrows(IOException.class, () -> deleteFolderOperation.performDeleteOperation());
        Truth.assertThat((Throwable)exception).hasMessageThat().isEqualTo((Object)"Received IllegalStateException while deletion of folder resource : Timed out while getting a folder from blocking queue.");
    }

    private void setMockFolderDeleteBlockingQueue(DeleteFolderOperation deleteFolderOperation) throws NoSuchFieldException, IllegalAccessException {
        Field queueField = DeleteFolderOperation.class.getDeclaredField("folderDeleteBlockingQueue");
        queueField.setAccessible(true);
        queueField.set(deleteFolderOperation, this.mockFolderDeleteBlockingQueue);
    }

    private void addFolders(List<FolderInfo> foldersToDelete, String curFolderName) {
        Random r = new Random();
        ArrayDeque<Object> q = new ArrayDeque<Object>();
        q.add(curFolderName);
        while (!q.isEmpty()) {
            String top = (String)q.poll();
            foldersToDelete.add(new FolderInfo(FolderInfo.createFolderInfoObject((String)BUCKET_NAME, (String)top)));
            if (foldersToDelete.size() > 2000) {
                return;
            }
            for (int i = 0; i < 3; ++i) {
                long nextFolderName = r.nextInt(100000);
                q.add(top + nextFolderName + "/");
            }
        }
    }

    private class CustomDeleteFolderOperationTest
    extends DeleteFolderOperation {
        private List<FolderInfo> orderOfDeletion;

        CustomDeleteFolderOperationTest(List<FolderInfo> folders, GoogleCloudStorageOptions storageOptions, StorageControlClient storageControlClient) {
            super(folders, storageOptions, storageControlClient);
            this.orderOfDeletion = new ArrayList<FolderInfo>(folders.size());
        }

        public List<FolderInfo> getOrderOfDeletion() {
            return this.orderOfDeletion;
        }

        public void queueSingleFolderDelete(FolderInfo folder, int attempt) {
            this.addToToBatchExecutorQueue(() -> null, this.getDeletionCallback(folder));
        }

        private synchronized void addToOrderOfDeletion(FolderInfo folderDeleted) {
            this.orderOfDeletion.add(folderDeleted);
        }

        protected FutureCallback getDeletionCallback(final FolderInfo resourceId) {
            return new FutureCallback<Void>(){

                public synchronized void onSuccess(Void result) {
                    CustomDeleteFolderOperationTest.this.addToOrderOfDeletion(resourceId);
                    CustomDeleteFolderOperationTest.this.successfullDeletionOfFolderResource(resourceId);
                }

                public void onFailure(Throwable t) {
                }
            };
        }
    }
}

