/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.CreateFileOptions;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CreateFileOptionsTest {
    @Test
    public void validOptions() {
        CreateFileOptions.builder().setAttributes((Map)ImmutableMap.of((Object)"Innocuous", (Object)"text".getBytes(StandardCharsets.UTF_8))).setContentType("text").setWriteMode(CreateFileOptions.WriteMode.OVERWRITE).setOverwriteGenerationId(0L).build();
    }

    @Test
    public void invalidOptions_contentType_shouldNotBeSetViaAttributes() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> CreateFileOptions.builder().setAttributes((Map)ImmutableMap.of((Object)"Content-Type", (Object)"text".getBytes(StandardCharsets.UTF_8))).setContentType("text").build());
        Truth.assertThat((Throwable)thrown).hasMessageThat().isEqualTo((Object)"The Content-Type attribute must be set via the contentType option");
    }

    @Test
    public void invalidOptions_createNew_overwriteGenerationShouldNotBeSet() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> CreateFileOptions.builder().setWriteMode(CreateFileOptions.WriteMode.CREATE_NEW).setOverwriteGenerationId(0L).build());
        Truth.assertThat((Throwable)thrown).hasMessageThat().isEqualTo((Object)"overwriteGenerationId is set to 0 but it can be set only in OVERWRITE mode");
    }
}

