/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.googleapis.batch.json.JsonBatchCallback;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.StorageRequest;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.gcsio.BatchHelper;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageTest;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageTestUtils;
import com.google.cloud.hadoop.gcsio.TrackingHttpRequestInitializer;
import com.google.cloud.hadoop.util.testing.MockHttpTransportHelper;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BatchHelperTest {
    private BatchHelper.Factory batchFactory;
    private TrackingHttpRequestInitializer httpRequestInitializer;

    @Before
    public void setUp() {
        this.batchFactory = new BatchHelper.Factory();
        this.httpRequestInitializer = new TrackingHttpRequestInitializer();
    }

    @Test
    public void newBatchHelper_throwsException_whenMaxRequestsPerBatchZero() {
        Storage storage = new Storage(GoogleCloudStorageTestUtils.HTTP_TRANSPORT, (JsonFactory)GsonFactory.getDefaultInstance(), (HttpRequestInitializer)this.httpRequestInitializer);
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.batchFactory.newBatchHelper((HttpRequestInitializer)this.httpRequestInitializer, storage, 0, 1, 1, ""));
        Truth.assertThat((Throwable)e).hasMessageThat().startsWith("maxRequestsPerBatch should be greater than 0");
    }

    @Test
    public void newBatchHelper_throwsException_whenTotalRequestsZero() {
        Storage storage = new Storage(GoogleCloudStorageTestUtils.HTTP_TRANSPORT, (JsonFactory)GsonFactory.getDefaultInstance(), (HttpRequestInitializer)this.httpRequestInitializer);
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.batchFactory.newBatchHelper((HttpRequestInitializer)this.httpRequestInitializer, storage, 1, 0, 1, ""));
        Truth.assertThat((Throwable)e).hasMessageThat().startsWith("totalRequests should be greater than 0");
    }

    @Test
    public void newBatchHelper_throwsException_whenMaxThreadsLessThanZero() {
        Storage storage = new Storage(GoogleCloudStorageTestUtils.HTTP_TRANSPORT, (JsonFactory)GsonFactory.getDefaultInstance(), (HttpRequestInitializer)this.httpRequestInitializer);
        IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> this.batchFactory.newBatchHelper((HttpRequestInitializer)this.httpRequestInitializer, storage, 1, 1, -1, ""));
        Truth.assertThat((Throwable)e).hasMessageThat().startsWith("maxThreads should be greater or equal to 0");
    }

    @Test
    public void allRequestsAreSentInSingleBatch_withZeroMaxThreads() throws IOException {
        String objectName1 = "bar-object-01";
        String objectName2 = "bar-object-02";
        StorageObject object1 = GoogleCloudStorageTest.newStorageObject("foo-bucket", objectName1);
        StorageObject object2 = GoogleCloudStorageTest.newStorageObject("foo-bucket", objectName2);
        MockHttpTransport transport = MockHttpTransportHelper.mockBatchTransport((int)2, (LowLevelHttpResponse[])new LowLevelHttpResponse[]{MockHttpTransportHelper.jsonDataResponse((Object)object1), MockHttpTransportHelper.jsonDataResponse((Object)object2)});
        Storage storage = new Storage((HttpTransport)transport, (JsonFactory)GsonFactory.getDefaultInstance(), (HttpRequestInitializer)this.httpRequestInitializer);
        BatchHelper batchHelper = this.batchFactory.newBatchHelper((HttpRequestInitializer)this.httpRequestInitializer, storage, 2, 2, 0, "");
        batchHelper.queue((StorageRequest)storage.objects().get("foo-bucket", objectName1), this.assertCallback(object1));
        Truth.assertThat(this.httpRequestInitializer.getAllRequestStrings()).isEmpty();
        batchHelper.queue((StorageRequest)storage.objects().get("foo-bucket", objectName2), this.assertCallback(object2));
        Truth.assertThat(this.httpRequestInitializer.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.batchRequestString(), TrackingHttpRequestInitializer.getRequestString("foo-bucket", objectName1, null), TrackingHttpRequestInitializer.getRequestString("foo-bucket", objectName2, null)});
        this.httpRequestInitializer.reset();
        batchHelper.flush();
        Truth.assertThat(this.httpRequestInitializer.getAllRequestStrings()).isEmpty();
    }

    @Test
    public void allRequestsAreSentInSingleBatch_withOneMaxThreads() throws IOException {
        String objectName1 = "bar-object-01";
        String objectName2 = "bar-object-02";
        StorageObject object1 = GoogleCloudStorageTest.newStorageObject("foo-bucket", objectName1);
        StorageObject object2 = GoogleCloudStorageTest.newStorageObject("foo-bucket", objectName2);
        MockHttpTransport transport = MockHttpTransportHelper.mockBatchTransport((int)2, (LowLevelHttpResponse[])new LowLevelHttpResponse[]{MockHttpTransportHelper.jsonDataResponse((Object)object1), MockHttpTransportHelper.jsonDataResponse((Object)object2)});
        Storage storage = new Storage((HttpTransport)transport, (JsonFactory)GsonFactory.getDefaultInstance(), (HttpRequestInitializer)this.httpRequestInitializer);
        BatchHelper batchHelper = this.batchFactory.newBatchHelper((HttpRequestInitializer)this.httpRequestInitializer, storage, 2, 2, 1, "");
        batchHelper.queue((StorageRequest)storage.objects().get("foo-bucket", objectName1), this.assertCallback(object1));
        Truth.assertThat(this.httpRequestInitializer.getAllRequestStrings()).isEmpty();
        batchHelper.queue((StorageRequest)storage.objects().get("foo-bucket", objectName2), this.assertCallback(object2));
        Truth.assertThat(this.httpRequestInitializer.getAllRequestStrings()).isEmpty();
        batchHelper.flush();
        Truth.assertThat(this.httpRequestInitializer.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.batchRequestString(), TrackingHttpRequestInitializer.getRequestString("foo-bucket", objectName1, null), TrackingHttpRequestInitializer.getRequestString("foo-bucket", objectName2, null)});
    }

    @Test
    public void queue_throwsException_afterFlushMethodWasCalled() throws IOException {
        String objectName1 = "bar-object-01";
        StorageObject object1 = GoogleCloudStorageTest.newStorageObject("foo-bucket", objectName1);
        MockHttpTransport transport = MockHttpTransportHelper.mockBatchTransport((int)1, (LowLevelHttpResponse[])new LowLevelHttpResponse[]{MockHttpTransportHelper.jsonDataResponse((Object)object1)});
        Storage storage = new Storage((HttpTransport)transport, (JsonFactory)GsonFactory.getDefaultInstance(), (HttpRequestInitializer)this.httpRequestInitializer);
        BatchHelper batchHelper = this.batchFactory.newBatchHelper((HttpRequestInitializer)this.httpRequestInitializer, storage, 1);
        batchHelper.flush();
        Storage.Objects.Get request = storage.objects().get("foo-bucket", objectName1);
        JsonBatchCallback<StorageObject> callback = this.assertCallback(object1);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> batchHelper.queue((StorageRequest)request, callback));
        Truth.assertThat((Throwable)e).hasMessageThat().startsWith("requestsExecutor should not be terminated to queue batch requests");
        Truth.assertThat(this.httpRequestInitializer.getAllRequests()).isEmpty();
    }

    @Test
    public void testIsEmpty() {
        Storage storage = new Storage(GoogleCloudStorageTestUtils.HTTP_TRANSPORT, (JsonFactory)GsonFactory.getDefaultInstance(), (HttpRequestInitializer)this.httpRequestInitializer);
        BatchHelper batchHelper = this.batchFactory.newBatchHelper((HttpRequestInitializer)this.httpRequestInitializer, storage, 2);
        Truth.assertThat((Boolean)batchHelper.isEmpty()).isTrue();
    }

    private JsonBatchCallback<StorageObject> assertCallback(final StorageObject expectedObject) {
        return new JsonBatchCallback<StorageObject>(){

            public void onSuccess(StorageObject storageObject, HttpHeaders responseHeaders) {
                Truth.assertThat((Map)storageObject).isEqualTo((Object)expectedObject);
            }

            public void onFailure(GoogleJsonError e, HttpHeaders responseHeaders) {
            }
        };
    }
}

