/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.BatchExecutor;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.FutureCallback;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BatchExecutorTest {
    private BatchExecutor batchExecutor;

    @Before
    public void setUp() {
        this.batchExecutor = new BatchExecutor(10);
    }

    @Test
    public void queue_succeeds() {
        this.batchExecutor.queue(() -> true, this.assertCallBack());
    }

    @Test
    public void queue_throwsException_afterShutdownCalled() throws IOException {
        this.batchExecutor.shutdown();
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> this.batchExecutor.queue(() -> null, null));
        Truth.assertThat((Throwable)e).hasMessageThat().startsWith("requestExecutor should not be terminated to queue request");
    }

    private FutureCallback<Boolean> assertCallBack() {
        return new FutureCallback<Boolean>(){

            public void onSuccess(Boolean result) {
                Truth.assertThat((Boolean)result).isEqualTo((Object)true);
            }

            public void onFailure(Throwable throwable) {
            }
        };
    }
}

