/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.common.flogger.GoogleLogger;
import com.google.common.truth.Truth;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class AssertingLogHandler
extends Handler {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final Gson GSON = new Gson();
    private static final Type LOG_RECORD_TYPE = new TypeToken<Map<String, Object>>(){}.getType();
    private List<Map<String, Object>> logRecords = new ArrayList<Map<String, Object>>();
    private List<String> methods = new ArrayList<String>();

    @Override
    public void publish(LogRecord record) {
        if (this.isLoggable(record)) {
            this.logRecords.add(AssertingLogHandler.logRecordToMap(record));
            this.methods.add(record.getSourceMethodName());
            ((GoogleLogger.Api)logger.atInfo()).log("Message %d: %s", this.logRecords.size(), (Object)GSON.toJson(AssertingLogHandler.logRecordToMap(record)));
        }
    }

    @Override
    public void flush() {
        this.logRecords.clear();
        this.methods.clear();
    }

    @Override
    public void close() {
        this.logRecords = null;
        this.methods = null;
    }

    public void assertLogCount(int n) {
        Truth.assertThat(this.logRecords).hasSize(n);
        Truth.assertThat(this.methods).hasSize(n);
    }

    public Map<String, Object> getLogRecordAtIndex(int index) {
        return this.logRecords.get(index);
    }

    public List<Map<String, Object>> getSubListOfRecords(int startIndex, int endIndex) {
        ArrayList<Map<String, Object>> recordSubList = new ArrayList<Map<String, Object>>();
        for (int i = startIndex; i <= endIndex; ++i) {
            recordSubList.add(this.logRecords.get(i));
        }
        return recordSubList;
    }

    public List<Map<String, Object>> getAllLogRecords() {
        return this.logRecords;
    }

    public void verifyCommonTraceFields() {
        for (Map<String, Object> event : this.logRecords) {
            Truth.assertThat(event.keySet()).containsAtLeast((Object)"details", (Object)"elapsedmillis", new Object[]{"eventtime", "initiatingthreadname", "remoteaddress", "requestinfo"});
        }
    }

    public Logger getLoggerForClass(String className) {
        Logger grpcTracingLogger = Logger.getLogger(className);
        grpcTracingLogger.setUseParentHandlers(false);
        grpcTracingLogger.addHandler(this);
        grpcTracingLogger.setLevel(Level.INFO);
        return grpcTracingLogger;
    }

    public void verifyJsonLogFields(String bucketName, String objectPrefix) {
        for (Map<String, Object> logRecord : this.logRecords) {
            Truth.assertThat((Object)logRecord.get("response_time")).isNotNull();
            Truth.assertThat((Object)logRecord.get("response_headers")).isNotNull();
            Truth.assertThat((Object)logRecord.get("request_headers")).isNotNull();
            Truth.assertThat((Object)logRecord.get("request_method")).isNotNull();
            Truth.assertThat((String)logRecord.get("request_url").toString()).startsWith("https://storage.googleapis.com/");
            Truth.assertThat((String)logRecord.get("request_url").toString()).contains((CharSequence)bucketName);
            Truth.assertThat((String)logRecord.get("request_url").toString()).contains((CharSequence)objectPrefix);
            Truth.assertThat((Object)logRecord.get("response_status_code")).isNotNull();
        }
    }

    String getMethodAtIndex(int index) {
        return this.methods.get(index);
    }

    private static Map<String, Object> logRecordToMap(LogRecord logRecord) {
        return (Map)GSON.fromJson(logRecord.getMessage(), LOG_RECORD_TYPE);
    }
}

