/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * Modify at your own risk.
 */

package com.google.api.services.storage.preprod.model;

/**
 * JSON template to produce a JSON-style HMAC Key metadata resource.
 *
 * <p>This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Storage JSON API. For a detailed explanation
 * see: <a
 * href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HmacKeyMetadata extends com.google.api.client.json.GenericJson {

  /** The ID of the HMAC Key. The value may be {@code null}. */
  @com.google.api.client.util.Key private String accessId;

  /** HTTP 1.1 Entity tag for the HMAC key. The value may be {@code null}. */
  @com.google.api.client.util.Key private String etag;

  /**
   * The ID of the HMAC key, including the Project ID and the Access ID. The value may be {@code
   * null}.
   */
  @com.google.api.client.util.Key private String id;

  /**
   * The kind of item this is. For HMAC Key metadata, this is always storage#hmacKeyMetadata. The
   * value may be {@code null}.
   */
  @com.google.api.client.util.Key private String kind;

  /**
   * Project ID owning the service account to which the key authenticates. The value may be {@code
   * null}.
   */
  @com.google.api.client.util.Key private String projectId;

  /** The link to this resource. The value may be {@code null}. */
  @com.google.api.client.util.Key private String selfLink;

  /** The email address of the key's associated service account. The value may be {@code null}. */
  @com.google.api.client.util.Key private String serviceAccountEmail;

  /**
   * The state of the key. Can be one of ACTIVE, INACTIVE, or DELETED. The value may be {@code
   * null}.
   */
  @com.google.api.client.util.Key private String state;

  /** The creation time of the HMAC key in RFC 3339 format. The value may be {@code null}. */
  @com.google.api.client.util.Key private com.google.api.client.util.DateTime timeCreated;

  /**
   * The last modification time of the HMAC key metadata in RFC 3339 format. The value may be {@code
   * null}.
   */
  @com.google.api.client.util.Key private com.google.api.client.util.DateTime updated;

  /**
   * The ID of the HMAC Key.
   *
   * @return value or {@code null} for none
   */
  public String getAccessId() {
    return accessId;
  }

  /**
   * The ID of the HMAC Key.
   *
   * @param accessId accessId or {@code null} for none
   */
  public HmacKeyMetadata setAccessId(String accessId) {
    this.accessId = accessId;
    return this;
  }

  /**
   * HTTP 1.1 Entity tag for the HMAC key.
   *
   * @return value or {@code null} for none
   */
  public String getEtag() {
    return etag;
  }

  /**
   * HTTP 1.1 Entity tag for the HMAC key.
   *
   * @param etag etag or {@code null} for none
   */
  public HmacKeyMetadata setEtag(String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The ID of the HMAC key, including the Project ID and the Access ID.
   *
   * @return value or {@code null} for none
   */
  public String getId() {
    return id;
  }

  /**
   * The ID of the HMAC key, including the Project ID and the Access ID.
   *
   * @param id id or {@code null} for none
   */
  public HmacKeyMetadata setId(String id) {
    this.id = id;
    return this;
  }

  /**
   * The kind of item this is. For HMAC Key metadata, this is always storage#hmacKeyMetadata.
   *
   * @return value or {@code null} for none
   */
  public String getKind() {
    return kind;
  }

  /**
   * The kind of item this is. For HMAC Key metadata, this is always storage#hmacKeyMetadata.
   *
   * @param kind kind or {@code null} for none
   */
  public HmacKeyMetadata setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Project ID owning the service account to which the key authenticates.
   *
   * @return value or {@code null} for none
   */
  public String getProjectId() {
    return projectId;
  }

  /**
   * Project ID owning the service account to which the key authenticates.
   *
   * @param projectId projectId or {@code null} for none
   */
  public HmacKeyMetadata setProjectId(String projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * The link to this resource.
   *
   * @return value or {@code null} for none
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * The link to this resource.
   *
   * @param selfLink selfLink or {@code null} for none
   */
  public HmacKeyMetadata setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The email address of the key's associated service account.
   *
   * @return value or {@code null} for none
   */
  public String getServiceAccountEmail() {
    return serviceAccountEmail;
  }

  /**
   * The email address of the key's associated service account.
   *
   * @param serviceAccountEmail serviceAccountEmail or {@code null} for none
   */
  public HmacKeyMetadata setServiceAccountEmail(String serviceAccountEmail) {
    this.serviceAccountEmail = serviceAccountEmail;
    return this;
  }

  /**
   * The state of the key. Can be one of ACTIVE, INACTIVE, or DELETED.
   *
   * @return value or {@code null} for none
   */
  public String getState() {
    return state;
  }

  /**
   * The state of the key. Can be one of ACTIVE, INACTIVE, or DELETED.
   *
   * @param state state or {@code null} for none
   */
  public HmacKeyMetadata setState(String state) {
    this.state = state;
    return this;
  }

  /**
   * The creation time of the HMAC key in RFC 3339 format.
   *
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getTimeCreated() {
    return timeCreated;
  }

  /**
   * The creation time of the HMAC key in RFC 3339 format.
   *
   * @param timeCreated timeCreated or {@code null} for none
   */
  public HmacKeyMetadata setTimeCreated(com.google.api.client.util.DateTime timeCreated) {
    this.timeCreated = timeCreated;
    return this;
  }

  /**
   * The last modification time of the HMAC key metadata in RFC 3339 format.
   *
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getUpdated() {
    return updated;
  }

  /**
   * The last modification time of the HMAC key metadata in RFC 3339 format.
   *
   * @param updated updated or {@code null} for none
   */
  public HmacKeyMetadata setUpdated(com.google.api.client.util.DateTime updated) {
    this.updated = updated;
    return this;
  }

  @Override
  public HmacKeyMetadata set(String fieldName, Object value) {
    return (HmacKeyMetadata) super.set(fieldName, value);
  }

  @Override
  public HmacKeyMetadata clone() {
    return (HmacKeyMetadata) super.clone();
  }
}
