/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * Modify at your own risk.
 */

package com.google.api.services.storage.preprod.model;

/**
 * A directory.
 *
 * <p>This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Storage JSON API. For a detailed explanation
 * see: <a
 * href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Directory extends com.google.api.client.json.GenericJson {

  /** The name of the bucket containing this directory. The value may be {@code null}. */
  @com.google.api.client.util.Key private String bucket;

  /**
   * The ID of the directory, including the bucket name, directory name. The value may be {@code
   * null}.
   */
  @com.google.api.client.util.Key private String id;

  /**
   * The kind of item this is. For directories, this is always storage#directory. The value may be
   * {@code null}.
   */
  @com.google.api.client.util.Key private String kind;

  /**
   * The version of the metadata for this directory at this generation. Used for preconditions and
   * for detecting changes in metadata. A metageneration number is only meaningful in the context of
   * a particular generation of a particular directory. The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private Long metageneration;

  /**
   * The name of the directory. Required if not specified by URL parameter. The value may be {@code
   * null}.
   */
  @com.google.api.client.util.Key private String name;

  /** The link to this directory. The value may be {@code null}. */
  @com.google.api.client.util.Key private String selfLink;

  /** The creation time of the directory in RFC 3339 format. The value may be {@code null}. */
  @com.google.api.client.util.Key private com.google.api.client.util.DateTime timeCreated;

  /**
   * The modification time of the directory metadata in RFC 3339 format. The value may be {@code
   * null}.
   */
  @com.google.api.client.util.Key private com.google.api.client.util.DateTime updated;

  /**
   * The name of the bucket containing this directory.
   *
   * @return value or {@code null} for none
   */
  public String getBucket() {
    return bucket;
  }

  /**
   * The name of the bucket containing this directory.
   *
   * @param bucket bucket or {@code null} for none
   */
  public Directory setBucket(String bucket) {
    this.bucket = bucket;
    return this;
  }

  /**
   * The ID of the directory, including the bucket name, directory name.
   *
   * @return value or {@code null} for none
   */
  public String getId() {
    return id;
  }

  /**
   * The ID of the directory, including the bucket name, directory name.
   *
   * @param id id or {@code null} for none
   */
  public Directory setId(String id) {
    this.id = id;
    return this;
  }

  /**
   * The kind of item this is. For directories, this is always storage#directory.
   *
   * @return value or {@code null} for none
   */
  public String getKind() {
    return kind;
  }

  /**
   * The kind of item this is. For directories, this is always storage#directory.
   *
   * @param kind kind or {@code null} for none
   */
  public Directory setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The version of the metadata for this directory at this generation. Used for preconditions and
   * for detecting changes in metadata. A metageneration number is only meaningful in the context of
   * a particular generation of a particular directory.
   *
   * @return value or {@code null} for none
   */
  public Long getMetageneration() {
    return metageneration;
  }

  /**
   * The version of the metadata for this directory at this generation. Used for preconditions and
   * for detecting changes in metadata. A metageneration number is only meaningful in the context of
   * a particular generation of a particular directory.
   *
   * @param metageneration metageneration or {@code null} for none
   */
  public Directory setMetageneration(Long metageneration) {
    this.metageneration = metageneration;
    return this;
  }

  /**
   * The name of the directory. Required if not specified by URL parameter.
   *
   * @return value or {@code null} for none
   */
  public String getName() {
    return name;
  }

  /**
   * The name of the directory. Required if not specified by URL parameter.
   *
   * @param name name or {@code null} for none
   */
  public Directory setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * The link to this directory.
   *
   * @return value or {@code null} for none
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * The link to this directory.
   *
   * @param selfLink selfLink or {@code null} for none
   */
  public Directory setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The creation time of the directory in RFC 3339 format.
   *
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getTimeCreated() {
    return timeCreated;
  }

  /**
   * The creation time of the directory in RFC 3339 format.
   *
   * @param timeCreated timeCreated or {@code null} for none
   */
  public Directory setTimeCreated(com.google.api.client.util.DateTime timeCreated) {
    this.timeCreated = timeCreated;
    return this;
  }

  /**
   * The modification time of the directory metadata in RFC 3339 format.
   *
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getUpdated() {
    return updated;
  }

  /**
   * The modification time of the directory metadata in RFC 3339 format.
   *
   * @param updated updated or {@code null} for none
   */
  public Directory setUpdated(com.google.api.client.util.DateTime updated) {
    this.updated = updated;
    return this;
  }

  @Override
  public Directory set(String fieldName, Object value) {
    return (Directory) super.set(fieldName, value);
  }

  @Override
  public Directory clone() {
    return (Directory) super.clone();
  }
}
