/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * Modify at your own risk.
 */

package com.google.api.services.storage.preprod;

import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.BucketAccessControl;
import com.google.api.services.storage.model.Channel;
import com.google.api.services.storage.model.HmacKey;
import com.google.api.services.storage.model.HmacKeyMetadata;
import com.google.api.services.storage.model.HmacKeysMetadata;
import com.google.api.services.storage.model.Notification;
import com.google.api.services.storage.model.ObjectAccessControl;
import com.google.api.services.storage.model.Policy;
import com.google.api.services.storage.model.RewriteResponse;
import com.google.api.services.storage.model.StorageObject;
import com.google.api.services.storage.preprod.model.TestIamPermissionsResponse;

/**
 * Service definition for Storage (v1_preprod).
 *
 * <p>Stores and retrieves potentially large, immutable data objects.
 *
 * <p>For more information about this service, see the <a
 * href="https://developers.google.com/storage/docs/json_api/" target="_blank">API Documentation</a>
 *
 * <p>This service uses {@link com.google.api.services.storage.preprod.StorageRequestInitializer} to
 * initialize global parameters via its {@link Builder}.
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Storage
    extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1
            && com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. "
            + "You need at least version 1.15 of google-api-client to run version "
            + "1.25.0-SNAPSHOT of the Cloud Storage JSON API library.",
        com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL =
      "https://storage-preprod-test-unified.googleusercontent.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "storage/v1_preprod/";

  /**
   * The default encoded batch path of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "storage/v1_preprod";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>Use {@link Builder} if you need to specify any of the optional parameters.
   *
   * @param transport HTTP transport, which should normally be:
   *     <ul>
   *       <li>Google App Engine: {@code
   *           com.google.api.client.extensions.appengine.http.UrlFetchTransport}
   *       <li>Android: {@code newCompatibleTransport} from {@code
   *           com.google.api.client.extensions.android.http.AndroidHttp}
   *       <li>Java: {@link
   *           com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *     </ul>
   *
   * @param jsonFactory JSON factory, which may be:
   *     <ul>
   *       <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}
   *       <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}
   *       <li>Android Honeycomb or higher: {@code
   *           com.google.api.client.extensions.android.json.AndroidJsonFactory}
   *     </ul>
   *
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Storage(
      com.google.api.client.http.HttpTransport transport,
      com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /** @param builder builder */
  Storage(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(
      com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest)
      throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the BucketAccessControls collection.
   *
   * <p>The typical use is:
   *
   * <pre>
   *   {@code Storage storage = new Storage(...);}
   *   {@code Storage.BucketAccessControls.List request = storage.bucketAccessControls().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public BucketAccessControls bucketAccessControls() {
    return new BucketAccessControls();
  }

  /** The "bucketAccessControls" collection of methods. */
  public class BucketAccessControls {

    /**
     * Permanently deletes the ACL entry for the specified entity on the specified bucket.
     *
     * <p>Create a request for the method "bucketAccessControls.delete".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param entity The entity holding the permission. Can be user-userId, user-emailAddress,
     *     group-groupId, group- emailAddress, allUsers, or allAuthenticatedUsers.
     * @return the request
     */
    public Delete delete(String bucket, String entity) throws java.io.IOException {
      Delete result = new Delete(bucket, entity);
      initialize(result);
      return result;
    }

    public class Delete extends com.google.api.services.storage.preprod.StorageRequest<Void> {

      private static final String REST_PATH = "b/{bucket}/acl/{entity}";

      /**
       * Permanently deletes the ACL entry for the specified entity on the specified bucket.
       *
       * <p>Create a request for the method "bucketAccessControls.delete".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of a bucket.
       * @param entity The entity holding the permission. Can be user-userId, user-emailAddress,
       *     group-groupId, group- emailAddress, allUsers, or allAuthenticatedUsers.
       * @since 1.13
       */
      protected Delete(String bucket, String entity) {
        super(Storage.this, "DELETE", REST_PATH, null, Void.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        this.entity =
            com.google.api.client.util.Preconditions.checkNotNull(
                entity, "Required parameter entity must be specified.");
      }

      @Override
      public Delete setAlt(String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUserIp(String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of a bucket. */
      public String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Delete setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      @com.google.api.client.util.Key private String entity;

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group- emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public String getEntity() {
        return entity;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public Delete setEntity(String entity) {
        this.entity = entity;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public Delete setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the ACL entry for the specified entity on the specified bucket.
     *
     * <p>Create a request for the method "bucketAccessControls.get".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param entity The entity holding the permission. Can be user-userId, user-emailAddress,
     *     group-groupId, group- emailAddress, allUsers, or allAuthenticatedUsers.
     * @return the request
     */
    public Get get(String bucket, String entity) throws java.io.IOException {
      Get result = new Get(bucket, entity);
      initialize(result);
      return result;
    }

    public class Get
        extends com.google.api.services.storage.preprod.StorageRequest<BucketAccessControl> {

      private static final String REST_PATH = "b/{bucket}/acl/{entity}";

      /**
       * Returns the ACL entry for the specified entity on the specified bucket.
       *
       * <p>Create a request for the method "bucketAccessControls.get".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * <p>{@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of a bucket.
       * @param entity The entity holding the permission. Can be user-userId, user-emailAddress,
       *     group-groupId, group- emailAddress, allUsers, or allAuthenticatedUsers.
       * @since 1.13
       */
      protected Get(String bucket, String entity) {
        super(
            Storage.this,
            "GET",
            REST_PATH,
            null,
            com.google.api.services.storage.model.BucketAccessControl.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        this.entity =
            com.google.api.client.util.Preconditions.checkNotNull(
                entity, "Required parameter entity must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead()
          throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of a bucket. */
      public String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Get setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      @com.google.api.client.util.Key private String entity;

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group- emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public String getEntity() {
        return entity;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public Get setEntity(String entity) {
        this.entity = entity;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public Get setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a new ACL entry on the specified bucket.
     *
     * <p>Create a request for the method "bucketAccessControls.insert".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param content the {@link com.google.api.services.storage.model.BucketAccessControl}
     * @return the request
     */
    public Insert insert(
        String bucket, com.google.api.services.storage.model.BucketAccessControl content)
        throws java.io.IOException {
      Insert result = new Insert(bucket, content);
      initialize(result);
      return result;
    }

    public class Insert
        extends com.google.api.services.storage.preprod.StorageRequest<BucketAccessControl> {

      private static final String REST_PATH = "b/{bucket}/acl";

      /**
       * Creates a new ACL entry on the specified bucket.
       *
       * <p>Create a request for the method "bucketAccessControls.insert".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of a bucket.
       * @param content the {@link com.google.api.services.storage.model.BucketAccessControl}
       * @since 1.13
       */
      protected Insert(
          String bucket, com.google.api.services.storage.model.BucketAccessControl content) {
        super(
            Storage.this,
            "POST",
            REST_PATH,
            content,
            com.google.api.services.storage.model.BucketAccessControl.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getEntity(), "BucketAccessControl.getEntity()");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getRole(), "BucketAccessControl.getRole()");
      }

      @Override
      public Insert setAlt(String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUserIp(String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of a bucket. */
      public String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Insert setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public Insert setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves ACL entries on the specified bucket.
     *
     * <p>Create a request for the method "bucketAccessControls.list".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @return the request
     */
    public List list(String bucket) throws java.io.IOException {
      List result = new List(bucket);
      initialize(result);
      return result;
    }

    public class List
        extends com.google.api.services.storage.preprod.StorageRequest<
            com.google.api.services.storage.preprod.model.BucketAccessControls> {

      private static final String REST_PATH = "b/{bucket}/acl";

      /**
       * Retrieves ACL entries on the specified bucket.
       *
       * <p>Create a request for the method "bucketAccessControls.list".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * <p>{@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of a bucket.
       * @since 1.13
       */
      protected List(String bucket) {
        super(
            Storage.this,
            "GET",
            REST_PATH,
            null,
            com.google.api.services.storage.preprod.model.BucketAccessControls.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead()
          throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUserIp(String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of a bucket. */
      public String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public List setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public List setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Patches an ACL entry on the specified bucket.
     *
     * <p>Create a request for the method "bucketAccessControls.patch".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param entity The entity holding the permission. Can be user-userId, user-emailAddress,
     *     group-groupId, group- emailAddress, allUsers, or allAuthenticatedUsers.
     * @param content the {@link com.google.api.services.storage.model.BucketAccessControl}
     * @return the request
     */
    public Patch patch(
        String bucket,
        String entity,
        com.google.api.services.storage.model.BucketAccessControl content)
        throws java.io.IOException {
      Patch result = new Patch(bucket, entity, content);
      initialize(result);
      return result;
    }

    public class Patch
        extends com.google.api.services.storage.preprod.StorageRequest<BucketAccessControl> {

      private static final String REST_PATH = "b/{bucket}/acl/{entity}";

      /**
       * Patches an ACL entry on the specified bucket.
       *
       * <p>Create a request for the method "bucketAccessControls.patch".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of a bucket.
       * @param entity The entity holding the permission. Can be user-userId, user-emailAddress,
       *     group-groupId, group- emailAddress, allUsers, or allAuthenticatedUsers.
       * @param content the {@link com.google.api.services.storage.model.BucketAccessControl}
       * @since 1.13
       */
      protected Patch(
          String bucket,
          String entity,
          com.google.api.services.storage.model.BucketAccessControl content) {
        super(
            Storage.this,
            "PATCH",
            REST_PATH,
            content,
            com.google.api.services.storage.model.BucketAccessControl.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        this.entity =
            com.google.api.client.util.Preconditions.checkNotNull(
                entity, "Required parameter entity must be specified.");
      }

      @Override
      public Patch setAlt(String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUserIp(String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of a bucket. */
      public String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Patch setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      @com.google.api.client.util.Key private String entity;

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group- emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public String getEntity() {
        return entity;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public Patch setEntity(String entity) {
        this.entity = entity;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public Patch setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates an ACL entry on the specified bucket.
     *
     * <p>Create a request for the method "bucketAccessControls.update".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param entity The entity holding the permission. Can be user-userId, user-emailAddress,
     *     group-groupId, group- emailAddress, allUsers, or allAuthenticatedUsers.
     * @param content the {@link com.google.api.services.storage.model.BucketAccessControl}
     * @return the request
     */
    public Update update(
        String bucket,
        String entity,
        com.google.api.services.storage.model.BucketAccessControl content)
        throws java.io.IOException {
      Update result = new Update(bucket, entity, content);
      initialize(result);
      return result;
    }

    public class Update
        extends com.google.api.services.storage.preprod.StorageRequest<BucketAccessControl> {

      private static final String REST_PATH = "b/{bucket}/acl/{entity}";

      /**
       * Updates an ACL entry on the specified bucket.
       *
       * <p>Create a request for the method "bucketAccessControls.update".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of a bucket.
       * @param entity The entity holding the permission. Can be user-userId, user-emailAddress,
       *     group-groupId, group- emailAddress, allUsers, or allAuthenticatedUsers.
       * @param content the {@link com.google.api.services.storage.model.BucketAccessControl}
       * @since 1.13
       */
      protected Update(
          String bucket,
          String entity,
          com.google.api.services.storage.model.BucketAccessControl content) {
        super(
            Storage.this,
            "PUT",
            REST_PATH,
            content,
            com.google.api.services.storage.model.BucketAccessControl.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        this.entity =
            com.google.api.client.util.Preconditions.checkNotNull(
                entity, "Required parameter entity must be specified.");
      }

      @Override
      public Update setAlt(String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUserIp(String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of a bucket. */
      public String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Update setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      @com.google.api.client.util.Key private String entity;

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group- emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public String getEntity() {
        return entity;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public Update setEntity(String entity) {
        this.entity = entity;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public Update setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }
  }

  /**
   * An accessor for creating requests from the Buckets collection.
   *
   * <p>The typical use is:
   *
   * <pre>
   *   {@code Storage storage = new Storage(...);}
   *   {@code Storage.Buckets.List request = storage.buckets().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Buckets buckets() {
    return new Buckets();
  }

  /** The "buckets" collection of methods. */
  public class Buckets {

    /**
     * Permanently deletes an empty bucket.
     *
     * <p>Create a request for the method "buckets.delete".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @return the request
     */
    public Delete delete(String bucket) throws java.io.IOException {
      Delete result = new Delete(bucket);
      initialize(result);
      return result;
    }

    public class Delete extends com.google.api.services.storage.preprod.StorageRequest<Void> {

      private static final String REST_PATH = "b/{bucket}";

      /**
       * Permanently deletes an empty bucket.
       *
       * <p>Create a request for the method "buckets.delete".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of a bucket.
       * @since 1.13
       */
      protected Delete(String bucket) {
        super(Storage.this, "DELETE", REST_PATH, null, Void.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
      }

      @Override
      public Delete setAlt(String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUserIp(String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of a bucket. */
      public String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Delete setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /** If set, only deletes the bucket if its metageneration matches this value. */
      @com.google.api.client.util.Key private Long ifMetagenerationMatch;

      /** If set, only deletes the bucket if its metageneration matches this value. */
      public Long getIfMetagenerationMatch() {
        return ifMetagenerationMatch;
      }

      /** If set, only deletes the bucket if its metageneration matches this value. */
      public Delete setIfMetagenerationMatch(Long ifMetagenerationMatch) {
        this.ifMetagenerationMatch = ifMetagenerationMatch;
        return this;
      }

      /** If set, only deletes the bucket if its metageneration does not match this value. */
      @com.google.api.client.util.Key private Long ifMetagenerationNotMatch;

      /** If set, only deletes the bucket if its metageneration does not match this value. */
      public Long getIfMetagenerationNotMatch() {
        return ifMetagenerationNotMatch;
      }

      /** If set, only deletes the bucket if its metageneration does not match this value. */
      public Delete setIfMetagenerationNotMatch(Long ifMetagenerationNotMatch) {
        this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public Delete setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns metadata for the specified bucket.
     *
     * <p>Create a request for the method "buckets.get".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @return the request
     */
    public Get get(String bucket) throws java.io.IOException {
      Get result = new Get(bucket);
      initialize(result);
      return result;
    }

    public class Get extends com.google.api.services.storage.preprod.StorageRequest<Bucket> {

      private static final String REST_PATH = "b/{bucket}";

      /**
       * Returns metadata for the specified bucket.
       *
       * <p>Create a request for the method "buckets.get".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * <p>{@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of a bucket.
       * @since 1.13
       */
      protected Get(String bucket) {
        super(
            Storage.this,
            "GET",
            REST_PATH,
            null,
            com.google.api.services.storage.model.Bucket.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead()
          throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of a bucket. */
      public String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Get setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration matches the given value.
       */
      @com.google.api.client.util.Key private Long ifMetagenerationMatch;

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration matches the given value.
       */
      public Long getIfMetagenerationMatch() {
        return ifMetagenerationMatch;
      }

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration matches the given value.
       */
      public Get setIfMetagenerationMatch(Long ifMetagenerationMatch) {
        this.ifMetagenerationMatch = ifMetagenerationMatch;
        return this;
      }

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration does not match the given value.
       */
      @com.google.api.client.util.Key private Long ifMetagenerationNotMatch;

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration does not match the given value.
       */
      public Long getIfMetagenerationNotMatch() {
        return ifMetagenerationNotMatch;
      }

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration does not match the given value.
       */
      public Get setIfMetagenerationNotMatch(Long ifMetagenerationNotMatch) {
        this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
        return this;
      }

      /** Set of properties to return. Defaults to noAcl. */
      @com.google.api.client.util.Key private String projection;

      /** Set of properties to return. Defaults to noAcl. */
      public String getProjection() {
        return projection;
      }

      /** Set of properties to return. Defaults to noAcl. */
      public Get setProjection(String projection) {
        this.projection = projection;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public Get setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Returns an IAM policy for the specified bucket.
     *
     * <p>Create a request for the method "buckets.getIamPolicy".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @return the request
     */
    public GetIamPolicy getIamPolicy(String bucket) throws java.io.IOException {
      GetIamPolicy result = new GetIamPolicy(bucket);
      initialize(result);
      return result;
    }

    public class GetIamPolicy
        extends com.google.api.services.storage.preprod.StorageRequest<Policy> {

      private static final String REST_PATH = "b/{bucket}/iam";

      /**
       * Returns an IAM policy for the specified bucket.
       *
       * <p>Create a request for the method "buckets.getIamPolicy".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of a bucket.
       * @since 1.13
       */
      protected GetIamPolicy(String bucket) {
        super(
            Storage.this,
            "GET",
            REST_PATH,
            null,
            com.google.api.services.storage.model.Policy.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead()
          throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetIamPolicy setAlt(String alt) {
        return (GetIamPolicy) super.setAlt(alt);
      }

      @Override
      public GetIamPolicy setFields(String fields) {
        return (GetIamPolicy) super.setFields(fields);
      }

      @Override
      public GetIamPolicy setKey(String key) {
        return (GetIamPolicy) super.setKey(key);
      }

      @Override
      public GetIamPolicy setOauthToken(String oauthToken) {
        return (GetIamPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
        return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetIamPolicy setQuotaUser(String quotaUser) {
        return (GetIamPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetIamPolicy setUploadType(String uploadType) {
        return (GetIamPolicy) super.setUploadType(uploadType);
      }

      @Override
      public GetIamPolicy setUserIp(String userIp) {
        return (GetIamPolicy) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of a bucket. */
      public String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public GetIamPolicy setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * The IAM policy format version to be returned. If the optionsRequestedPolicyVersion is for
       * an older version that doesn't support part of the requested IAM policy, the request fails.
       */
      @com.google.api.client.util.Key private Integer optionsRequestedPolicyVersion;

      /**
       * The IAM policy format version to be returned. If the optionsRequestedPolicyVersion is for
       * an older version that doesn't support part of the requested IAM policy, the request fails.
       *
       * <p>[minimum: 1]
       */
      public Integer getOptionsRequestedPolicyVersion() {
        return optionsRequestedPolicyVersion;
      }

      /**
       * The IAM policy format version to be returned. If the optionsRequestedPolicyVersion is for
       * an older version that doesn't support part of the requested IAM policy, the request fails.
       */
      public GetIamPolicy setOptionsRequestedPolicyVersion(Integer optionsRequestedPolicyVersion) {
        this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public GetIamPolicy setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public GetIamPolicy set(String parameterName, Object value) {
        return (GetIamPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Creates a new bucket.
     *
     * <p>Create a request for the method "buckets.insert".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project A valid API project identifier.
     * @param content the {@link com.google.api.services.storage.model.Bucket}
     * @return the request
     */
    public Insert insert(String project, com.google.api.services.storage.model.Bucket content)
        throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends com.google.api.services.storage.preprod.StorageRequest<Bucket> {

      private static final String REST_PATH = "b";

      /**
       * Creates a new bucket.
       *
       * <p>Create a request for the method "buckets.insert".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param project A valid API project identifier.
       * @param content the {@link com.google.api.services.storage.model.Bucket}
       * @since 1.13
       */
      protected Insert(String project, com.google.api.services.storage.model.Bucket content) {
        super(
            Storage.this,
            "POST",
            REST_PATH,
            content,
            com.google.api.services.storage.model.Bucket.class);
        this.project =
            com.google.api.client.util.Preconditions.checkNotNull(
                project, "Required parameter project must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getName(), "Bucket.getName()");
      }

      @Override
      public Insert setAlt(String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUserIp(String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** A valid API project identifier. */
      @com.google.api.client.util.Key private String project;

      /** A valid API project identifier. */
      public String getProject() {
        return project;
      }

      /** A valid API project identifier. */
      public Insert setProject(String project) {
        this.project = project;
        return this;
      }

      /** Apply a predefined set of access controls to this bucket. */
      @com.google.api.client.util.Key private String predefinedAcl;

      /** Apply a predefined set of access controls to this bucket. */
      public String getPredefinedAcl() {
        return predefinedAcl;
      }

      /** Apply a predefined set of access controls to this bucket. */
      public Insert setPredefinedAcl(String predefinedAcl) {
        this.predefinedAcl = predefinedAcl;
        return this;
      }

      /** Apply a predefined set of default object access controls to this bucket. */
      @com.google.api.client.util.Key private String predefinedDefaultObjectAcl;

      /** Apply a predefined set of default object access controls to this bucket. */
      public String getPredefinedDefaultObjectAcl() {
        return predefinedDefaultObjectAcl;
      }

      /** Apply a predefined set of default object access controls to this bucket. */
      public Insert setPredefinedDefaultObjectAcl(String predefinedDefaultObjectAcl) {
        this.predefinedDefaultObjectAcl = predefinedDefaultObjectAcl;
        return this;
      }

      /**
       * Set of properties to return. Defaults to noAcl, unless the bucket resource specifies acl or
       * defaultObjectAcl properties, when it defaults to full.
       */
      @com.google.api.client.util.Key private String projection;

      /**
       * Set of properties to return. Defaults to noAcl, unless the bucket resource specifies acl or
       * defaultObjectAcl properties, when it defaults to full.
       */
      public String getProjection() {
        return projection;
      }

      /**
       * Set of properties to return. Defaults to noAcl, unless the bucket resource specifies acl or
       * defaultObjectAcl properties, when it defaults to full.
       */
      public Insert setProjection(String projection) {
        this.projection = projection;
        return this;
      }

      /** The project to be billed for this request. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. */
      public Insert setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of buckets for a given project.
     *
     * <p>Create a request for the method "buckets.list".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project A valid API project identifier.
     * @return the request
     */
    public List list(String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List
        extends com.google.api.services.storage.preprod.StorageRequest<
            com.google.api.services.storage.model.Buckets> {

      private static final String REST_PATH = "b";

      /**
       * Retrieves a list of buckets for a given project.
       *
       * <p>Create a request for the method "buckets.list".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * <p>{@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param project A valid API project identifier.
       * @since 1.13
       */
      protected List(String project) {
        super(
            Storage.this,
            "GET",
            REST_PATH,
            null,
            com.google.api.services.storage.model.Buckets.class);
        this.project =
            com.google.api.client.util.Preconditions.checkNotNull(
                project, "Required parameter project must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead()
          throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUserIp(String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** A valid API project identifier. */
      @com.google.api.client.util.Key private String project;

      /** A valid API project identifier. */
      public String getProject() {
        return project;
      }

      /** A valid API project identifier. */
      public List setProject(String project) {
        this.project = project;
        return this;
      }

      /**
       * Maximum number of buckets to return in a single response. The service will use this
       * parameter or 1,000 items, whichever is smaller.
       */
      @com.google.api.client.util.Key private Long maxResults;

      /**
       * Maximum number of buckets to return in a single response. The service will use this
       * parameter or 1,000 items, whichever is smaller. [default: 1000] [minimum: 0]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /**
       * Maximum number of buckets to return in a single response. The service will use this
       * parameter or 1,000 items, whichever is smaller.
       */
      public List setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * A previously-returned page token representing part of the larger set of results to view.
       */
      @com.google.api.client.util.Key private String pageToken;

      /**
       * A previously-returned page token representing part of the larger set of results to view.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
       * A previously-returned page token representing part of the larger set of results to view.
       */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Filter results to buckets whose names begin with this prefix. */
      @com.google.api.client.util.Key private String prefix;

      /** Filter results to buckets whose names begin with this prefix. */
      public String getPrefix() {
        return prefix;
      }

      /** Filter results to buckets whose names begin with this prefix. */
      public List setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
      }

      /** Set of properties to return. Defaults to noAcl. */
      @com.google.api.client.util.Key private String projection;

      /** Set of properties to return. Defaults to noAcl. */
      public String getProjection() {
        return projection;
      }

      /** Set of properties to return. Defaults to noAcl. */
      public List setProjection(String projection) {
        this.projection = projection;
        return this;
      }

      /** The project to be billed for this request. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. */
      public List setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Locks retention policy on a bucket.
     *
     * <p>Create a request for the method "buckets.lockRetentionPolicy".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link LockRetentionPolicy#execute()} method to invoke the remote
     * operation.
     *
     * @param bucket Name of a bucket.
     * @param ifMetagenerationMatch Makes the operation conditional on whether bucket's current
     *     metageneration matches the given value.
     * @return the request
     */
    public LockRetentionPolicy lockRetentionPolicy(String bucket, Long ifMetagenerationMatch)
        throws java.io.IOException {
      LockRetentionPolicy result = new LockRetentionPolicy(bucket, ifMetagenerationMatch);
      initialize(result);
      return result;
    }

    public class LockRetentionPolicy
        extends com.google.api.services.storage.preprod.StorageRequest<Bucket> {

      private static final String REST_PATH = "b/{bucket}/lockRetentionPolicy";

      /**
       * Locks retention policy on a bucket.
       *
       * <p>Create a request for the method "buckets.lockRetentionPolicy".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link LockRetentionPolicy#execute()} method to invoke the
       * remote operation.
       *
       * <p>{@link LockRetentionPolicy#initialize(com.google.api.client.googleapis.services.
       * AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor.
       *
       * @param bucket Name of a bucket.
       * @param ifMetagenerationMatch Makes the operation conditional on whether bucket's current
       *     metageneration matches the given value.
       * @since 1.13
       */
      protected LockRetentionPolicy(String bucket, Long ifMetagenerationMatch) {
        super(
            Storage.this,
            "POST",
            REST_PATH,
            null,
            com.google.api.services.storage.model.Bucket.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        this.ifMetagenerationMatch =
            com.google.api.client.util.Preconditions.checkNotNull(
                ifMetagenerationMatch,
                "Required parameter ifMetagenerationMatch must be specified.");
      }

      @Override
      public LockRetentionPolicy setAlt(String alt) {
        return (LockRetentionPolicy) super.setAlt(alt);
      }

      @Override
      public LockRetentionPolicy setFields(String fields) {
        return (LockRetentionPolicy) super.setFields(fields);
      }

      @Override
      public LockRetentionPolicy setKey(String key) {
        return (LockRetentionPolicy) super.setKey(key);
      }

      @Override
      public LockRetentionPolicy setOauthToken(String oauthToken) {
        return (LockRetentionPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public LockRetentionPolicy setPrettyPrint(Boolean prettyPrint) {
        return (LockRetentionPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public LockRetentionPolicy setQuotaUser(String quotaUser) {
        return (LockRetentionPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public LockRetentionPolicy setUploadType(String uploadType) {
        return (LockRetentionPolicy) super.setUploadType(uploadType);
      }

      @Override
      public LockRetentionPolicy setUserIp(String userIp) {
        return (LockRetentionPolicy) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of a bucket. */
      public String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public LockRetentionPolicy setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * Makes the operation conditional on whether bucket's current metageneration matches the
       * given value.
       */
      @com.google.api.client.util.Key private Long ifMetagenerationMatch;

      /**
       * Makes the operation conditional on whether bucket's current metageneration matches the
       * given value.
       */
      public Long getIfMetagenerationMatch() {
        return ifMetagenerationMatch;
      }

      /**
       * Makes the operation conditional on whether bucket's current metageneration matches the
       * given value.
       */
      public LockRetentionPolicy setIfMetagenerationMatch(Long ifMetagenerationMatch) {
        this.ifMetagenerationMatch = ifMetagenerationMatch;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public LockRetentionPolicy setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public LockRetentionPolicy set(String parameterName, Object value) {
        return (LockRetentionPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Patches a bucket. Changes to the bucket will be readable immediately after writing, but
     * configuration changes may take time to propagate.
     *
     * <p>Create a request for the method "buckets.patch".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param content the {@link com.google.api.services.storage.model.Bucket}
     * @return the request
     */
    public Patch patch(String bucket, com.google.api.services.storage.model.Bucket content)
        throws java.io.IOException {
      Patch result = new Patch(bucket, content);
      initialize(result);
      return result;
    }

    public class Patch extends com.google.api.services.storage.preprod.StorageRequest<Bucket> {

      private static final String REST_PATH = "b/{bucket}";

      /**
       * Patches a bucket. Changes to the bucket will be readable immediately after writing, but
       * configuration changes may take time to propagate.
       *
       * <p>Create a request for the method "buckets.patch".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of a bucket.
       * @param content the {@link com.google.api.services.storage.model.Bucket}
       * @since 1.13
       */
      protected Patch(String bucket, com.google.api.services.storage.model.Bucket content) {
        super(
            Storage.this,
            "PATCH",
            REST_PATH,
            content,
            com.google.api.services.storage.model.Bucket.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
      }

      @Override
      public Patch setAlt(String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUserIp(String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of a bucket. */
      public String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Patch setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration matches the given value.
       */
      @com.google.api.client.util.Key private Long ifMetagenerationMatch;

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration matches the given value.
       */
      public Long getIfMetagenerationMatch() {
        return ifMetagenerationMatch;
      }

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration matches the given value.
       */
      public Patch setIfMetagenerationMatch(Long ifMetagenerationMatch) {
        this.ifMetagenerationMatch = ifMetagenerationMatch;
        return this;
      }

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration does not match the given value.
       */
      @com.google.api.client.util.Key private Long ifMetagenerationNotMatch;

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration does not match the given value.
       */
      public Long getIfMetagenerationNotMatch() {
        return ifMetagenerationNotMatch;
      }

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration does not match the given value.
       */
      public Patch setIfMetagenerationNotMatch(Long ifMetagenerationNotMatch) {
        this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
        return this;
      }

      /** Apply a predefined set of access controls to this bucket. */
      @com.google.api.client.util.Key private String predefinedAcl;

      /** Apply a predefined set of access controls to this bucket. */
      public String getPredefinedAcl() {
        return predefinedAcl;
      }

      /** Apply a predefined set of access controls to this bucket. */
      public Patch setPredefinedAcl(String predefinedAcl) {
        this.predefinedAcl = predefinedAcl;
        return this;
      }

      /** Apply a predefined set of default object access controls to this bucket. */
      @com.google.api.client.util.Key private String predefinedDefaultObjectAcl;

      /** Apply a predefined set of default object access controls to this bucket. */
      public String getPredefinedDefaultObjectAcl() {
        return predefinedDefaultObjectAcl;
      }

      /** Apply a predefined set of default object access controls to this bucket. */
      public Patch setPredefinedDefaultObjectAcl(String predefinedDefaultObjectAcl) {
        this.predefinedDefaultObjectAcl = predefinedDefaultObjectAcl;
        return this;
      }

      /** Set of properties to return. Defaults to full. */
      @com.google.api.client.util.Key private String projection;

      /** Set of properties to return. Defaults to full. */
      public String getProjection() {
        return projection;
      }

      /** Set of properties to return. Defaults to full. */
      public Patch setProjection(String projection) {
        this.projection = projection;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public Patch setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates an IAM policy for the specified bucket.
     *
     * <p>Create a request for the method "buckets.setIamPolicy".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param content the {@link com.google.api.services.storage.model.Policy}
     * @return the request
     */
    public SetIamPolicy setIamPolicy(
        String bucket, com.google.api.services.storage.model.Policy content)
        throws java.io.IOException {
      SetIamPolicy result = new SetIamPolicy(bucket, content);
      initialize(result);
      return result;
    }

    public class SetIamPolicy
        extends com.google.api.services.storage.preprod.StorageRequest<Policy> {

      private static final String REST_PATH = "b/{bucket}/iam";

      /**
       * Updates an IAM policy for the specified bucket.
       *
       * <p>Create a request for the method "buckets.setIamPolicy".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of a bucket.
       * @param content the {@link com.google.api.services.storage.model.Policy}
       * @since 1.13
       */
      protected SetIamPolicy(String bucket, com.google.api.services.storage.model.Policy content) {
        super(
            Storage.this,
            "PUT",
            REST_PATH,
            content,
            com.google.api.services.storage.model.Policy.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
      }

      @Override
      public SetIamPolicy setAlt(String alt) {
        return (SetIamPolicy) super.setAlt(alt);
      }

      @Override
      public SetIamPolicy setFields(String fields) {
        return (SetIamPolicy) super.setFields(fields);
      }

      @Override
      public SetIamPolicy setKey(String key) {
        return (SetIamPolicy) super.setKey(key);
      }

      @Override
      public SetIamPolicy setOauthToken(String oauthToken) {
        return (SetIamPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
        return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetIamPolicy setQuotaUser(String quotaUser) {
        return (SetIamPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetIamPolicy setUploadType(String uploadType) {
        return (SetIamPolicy) super.setUploadType(uploadType);
      }

      @Override
      public SetIamPolicy setUserIp(String userIp) {
        return (SetIamPolicy) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of a bucket. */
      public String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public SetIamPolicy setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public SetIamPolicy setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public SetIamPolicy set(String parameterName, Object value) {
        return (SetIamPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Tests a set of permissions on the given bucket to see which, if any, are held by the caller.
     *
     * <p>Create a request for the method "buckets.testIamPermissions".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
     * operation.
     *
     * @param bucket Name of a bucket.
     * @param permissions Permissions to test.
     * @return the request
     */
    public TestIamPermissions testIamPermissions(String bucket, java.util.List<String> permissions)
        throws java.io.IOException {
      TestIamPermissions result = new TestIamPermissions(bucket, permissions);
      initialize(result);
      return result;
    }

    public class TestIamPermissions
        extends com.google.api.services.storage.preprod.StorageRequest<TestIamPermissionsResponse> {

      private static final String REST_PATH = "b/{bucket}/iam/testPermissions";

      /**
       * Tests a set of permissions on the given bucket to see which, if any, are held by the
       * caller.
       *
       * <p>Create a request for the method "buckets.testIamPermissions".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link TestIamPermissions#execute()} method to invoke the
       * remote operation.
       *
       * <p>{@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor.
       *
       * @param bucket Name of a bucket.
       * @param permissions Permissions to test.
       * @since 1.13
       */
      protected TestIamPermissions(String bucket, java.util.List<String> permissions) {
        super(Storage.this, "GET", REST_PATH, null, TestIamPermissionsResponse.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        this.permissions =
            com.google.api.client.util.Preconditions.checkNotNull(
                permissions, "Required parameter permissions must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead()
          throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public TestIamPermissions setAlt(String alt) {
        return (TestIamPermissions) super.setAlt(alt);
      }

      @Override
      public TestIamPermissions setFields(String fields) {
        return (TestIamPermissions) super.setFields(fields);
      }

      @Override
      public TestIamPermissions setKey(String key) {
        return (TestIamPermissions) super.setKey(key);
      }

      @Override
      public TestIamPermissions setOauthToken(String oauthToken) {
        return (TestIamPermissions) super.setOauthToken(oauthToken);
      }

      @Override
      public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
        return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public TestIamPermissions setQuotaUser(String quotaUser) {
        return (TestIamPermissions) super.setQuotaUser(quotaUser);
      }

      @Override
      public TestIamPermissions setUploadType(String uploadType) {
        return (TestIamPermissions) super.setUploadType(uploadType);
      }

      @Override
      public TestIamPermissions setUserIp(String userIp) {
        return (TestIamPermissions) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of a bucket. */
      public String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public TestIamPermissions setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /** Permissions to test. */
      @com.google.api.client.util.Key private java.util.List<String> permissions;

      /** Permissions to test. */
      public java.util.List<String> getPermissions() {
        return permissions;
      }

      /** Permissions to test. */
      public TestIamPermissions setPermissions(java.util.List<String> permissions) {
        this.permissions = permissions;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public TestIamPermissions setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public TestIamPermissions set(String parameterName, Object value) {
        return (TestIamPermissions) super.set(parameterName, value);
      }
    }
    /**
     * Updates a bucket. Changes to the bucket will be readable immediately after writing, but
     * configuration changes may take time to propagate.
     *
     * <p>Create a request for the method "buckets.update".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param content the {@link com.google.api.services.storage.model.Bucket}
     * @return the request
     */
    public Update update(String bucket, com.google.api.services.storage.model.Bucket content)
        throws java.io.IOException {
      Update result = new Update(bucket, content);
      initialize(result);
      return result;
    }

    public class Update extends com.google.api.services.storage.preprod.StorageRequest<Bucket> {

      private static final String REST_PATH = "b/{bucket}";

      /**
       * Updates a bucket. Changes to the bucket will be readable immediately after writing, but
       * configuration changes may take time to propagate.
       *
       * <p>Create a request for the method "buckets.update".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of a bucket.
       * @param content the {@link com.google.api.services.storage.model.Bucket}
       * @since 1.13
       */
      protected Update(String bucket, com.google.api.services.storage.model.Bucket content) {
        super(
            Storage.this,
            "PUT",
            REST_PATH,
            content,
            com.google.api.services.storage.model.Bucket.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
      }

      @Override
      public Update setAlt(String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUserIp(String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of a bucket. */
      public String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Update setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration matches the given value.
       */
      @com.google.api.client.util.Key private Long ifMetagenerationMatch;

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration matches the given value.
       */
      public Long getIfMetagenerationMatch() {
        return ifMetagenerationMatch;
      }

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration matches the given value.
       */
      public Update setIfMetagenerationMatch(Long ifMetagenerationMatch) {
        this.ifMetagenerationMatch = ifMetagenerationMatch;
        return this;
      }

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration does not match the given value.
       */
      @com.google.api.client.util.Key private Long ifMetagenerationNotMatch;

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration does not match the given value.
       */
      public Long getIfMetagenerationNotMatch() {
        return ifMetagenerationNotMatch;
      }

      /**
       * Makes the return of the bucket metadata conditional on whether the bucket's current
       * metageneration does not match the given value.
       */
      public Update setIfMetagenerationNotMatch(Long ifMetagenerationNotMatch) {
        this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
        return this;
      }

      /** Apply a predefined set of access controls to this bucket. */
      @com.google.api.client.util.Key private String predefinedAcl;

      /** Apply a predefined set of access controls to this bucket. */
      public String getPredefinedAcl() {
        return predefinedAcl;
      }

      /** Apply a predefined set of access controls to this bucket. */
      public Update setPredefinedAcl(String predefinedAcl) {
        this.predefinedAcl = predefinedAcl;
        return this;
      }

      /** Apply a predefined set of default object access controls to this bucket. */
      @com.google.api.client.util.Key private String predefinedDefaultObjectAcl;

      /** Apply a predefined set of default object access controls to this bucket. */
      public String getPredefinedDefaultObjectAcl() {
        return predefinedDefaultObjectAcl;
      }

      /** Apply a predefined set of default object access controls to this bucket. */
      public Update setPredefinedDefaultObjectAcl(String predefinedDefaultObjectAcl) {
        this.predefinedDefaultObjectAcl = predefinedDefaultObjectAcl;
        return this;
      }

      /** Set of properties to return. Defaults to full. */
      @com.google.api.client.util.Key private String projection;

      /** Set of properties to return. Defaults to full. */
      public String getProjection() {
        return projection;
      }

      /** Set of properties to return. Defaults to full. */
      public Update setProjection(String projection) {
        this.projection = projection;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public Update setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }
  }

  /**
   * An accessor for creating requests from the Channels collection.
   *
   * <p>The typical use is:
   *
   * <pre>
   *   {@code Storage storage = new Storage(...);}
   *   {@code Storage.Channels.List request = storage.channels().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Channels channels() {
    return new Channels();
  }

  /** The "channels" collection of methods. */
  public class Channels {

    /**
     * Stop watching resources through this channel
     *
     * <p>Create a request for the method "channels.stop".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Stop#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.storage.model.Channel}
     * @return the request
     */
    public Stop stop(com.google.api.services.storage.model.Channel content)
        throws java.io.IOException {
      Stop result = new Stop(content);
      initialize(result);
      return result;
    }

    public class Stop extends com.google.api.services.storage.preprod.StorageRequest<Void> {

      private static final String REST_PATH = "channels/stop";

      /**
       * Stop watching resources through this channel
       *
       * <p>Create a request for the method "channels.stop".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Stop#execute()} method to invoke the remote operation.
       *
       * <p>{@link
       * Stop#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param content the {@link com.google.api.services.storage.model.Channel}
       * @since 1.13
       */
      protected Stop(com.google.api.services.storage.model.Channel content) {
        super(Storage.this, "POST", REST_PATH, content, Void.class);
      }

      @Override
      public Stop setAlt(String alt) {
        return (Stop) super.setAlt(alt);
      }

      @Override
      public Stop setFields(String fields) {
        return (Stop) super.setFields(fields);
      }

      @Override
      public Stop setKey(String key) {
        return (Stop) super.setKey(key);
      }

      @Override
      public Stop setOauthToken(String oauthToken) {
        return (Stop) super.setOauthToken(oauthToken);
      }

      @Override
      public Stop setPrettyPrint(Boolean prettyPrint) {
        return (Stop) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Stop setQuotaUser(String quotaUser) {
        return (Stop) super.setQuotaUser(quotaUser);
      }

      @Override
      public Stop setUploadType(String uploadType) {
        return (Stop) super.setUploadType(uploadType);
      }

      @Override
      public Stop setUserIp(String userIp) {
        return (Stop) super.setUserIp(userIp);
      }

      @Override
      public Stop set(String parameterName, Object value) {
        return (Stop) super.set(parameterName, value);
      }
    }
  }

  /**
   * An accessor for creating requests from the DefaultObjectAccessControls collection.
   *
   * <p>The typical use is:
   *
   * <pre>
   *   {@code Storage storage = new Storage(...);}
   *   {@code Storage.DefaultObjectAccessControls.List request = storage.defaultObjectAccessControls().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public DefaultObjectAccessControls defaultObjectAccessControls() {
    return new DefaultObjectAccessControls();
  }

  /** The "defaultObjectAccessControls" collection of methods. */
  public class DefaultObjectAccessControls {

    /**
     * Permanently deletes the default object ACL entry for the specified entity on the specified
     * bucket.
     *
     * <p>Create a request for the method "defaultObjectAccessControls.delete".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param entity The entity holding the permission. Can be user-userId, user-emailAddress,
     *     group-groupId, group- emailAddress, allUsers, or allAuthenticatedUsers.
     * @return the request
     */
    public Delete delete(String bucket, String entity) throws java.io.IOException {
      Delete result = new Delete(bucket, entity);
      initialize(result);
      return result;
    }

    public class Delete extends com.google.api.services.storage.preprod.StorageRequest<Void> {

      private static final String REST_PATH = "b/{bucket}/defaultObjectAcl/{entity}";

      /**
       * Permanently deletes the default object ACL entry for the specified entity on the specified
       * bucket.
       *
       * <p>Create a request for the method "defaultObjectAccessControls.delete".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of a bucket.
       * @param entity The entity holding the permission. Can be user-userId, user-emailAddress,
       *     group-groupId, group- emailAddress, allUsers, or allAuthenticatedUsers.
       * @since 1.13
       */
      protected Delete(String bucket, String entity) {
        super(Storage.this, "DELETE", REST_PATH, null, Void.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        this.entity =
            com.google.api.client.util.Preconditions.checkNotNull(
                entity, "Required parameter entity must be specified.");
      }

      @Override
      public Delete setAlt(String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUserIp(String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of a bucket. */
      public String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Delete setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      @com.google.api.client.util.Key private String entity;

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group- emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public String getEntity() {
        return entity;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public Delete setEntity(String entity) {
        this.entity = entity;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public Delete setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the default object ACL entry for the specified entity on the specified bucket.
     *
     * <p>Create a request for the method "defaultObjectAccessControls.get".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param entity The entity holding the permission. Can be user-userId, user-emailAddress,
     *     group-groupId, group- emailAddress, allUsers, or allAuthenticatedUsers.
     * @return the request
     */
    public Get get(String bucket, String entity) throws java.io.IOException {
      Get result = new Get(bucket, entity);
      initialize(result);
      return result;
    }

    public class Get
        extends com.google.api.services.storage.preprod.StorageRequest<ObjectAccessControl> {

      private static final String REST_PATH = "b/{bucket}/defaultObjectAcl/{entity}";

      /**
       * Returns the default object ACL entry for the specified entity on the specified bucket.
       *
       * <p>Create a request for the method "defaultObjectAccessControls.get".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * <p>{@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of a bucket.
       * @param entity The entity holding the permission. Can be user-userId, user-emailAddress,
       *     group-groupId, group- emailAddress, allUsers, or allAuthenticatedUsers.
       * @since 1.13
       */
      protected Get(String bucket, String entity) {
        super(
            Storage.this,
            "GET",
            REST_PATH,
            null,
            com.google.api.services.storage.model.ObjectAccessControl.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        this.entity =
            com.google.api.client.util.Preconditions.checkNotNull(
                entity, "Required parameter entity must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead()
          throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of a bucket. */
      public String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Get setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      @com.google.api.client.util.Key private String entity;

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group- emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public String getEntity() {
        return entity;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public Get setEntity(String entity) {
        this.entity = entity;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public Get setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a new default object ACL entry on the specified bucket.
     *
     * <p>Create a request for the method "defaultObjectAccessControls.insert".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param content the {@link com.google.api.services.storage.model.ObjectAccessControl}
     * @return the request
     */
    public Insert insert(
        String bucket, com.google.api.services.storage.model.ObjectAccessControl content)
        throws java.io.IOException {
      Insert result = new Insert(bucket, content);
      initialize(result);
      return result;
    }

    public class Insert
        extends com.google.api.services.storage.preprod.StorageRequest<ObjectAccessControl> {

      private static final String REST_PATH = "b/{bucket}/defaultObjectAcl";

      /**
       * Creates a new default object ACL entry on the specified bucket.
       *
       * <p>Create a request for the method "defaultObjectAccessControls.insert".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of a bucket.
       * @param content the {@link com.google.api.services.storage.model.ObjectAccessControl}
       * @since 1.13
       */
      protected Insert(
          String bucket, com.google.api.services.storage.model.ObjectAccessControl content) {
        super(
            Storage.this,
            "POST",
            REST_PATH,
            content,
            com.google.api.services.storage.model.ObjectAccessControl.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getEntity(), "ObjectAccessControl.getEntity()");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getRole(), "ObjectAccessControl.getRole()");
      }

      @Override
      public Insert setAlt(String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUserIp(String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of a bucket. */
      public String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Insert setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public Insert setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves default object ACL entries on the specified bucket.
     *
     * <p>Create a request for the method "defaultObjectAccessControls.list".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @return the request
     */
    public List list(String bucket) throws java.io.IOException {
      List result = new List(bucket);
      initialize(result);
      return result;
    }

    public class List
        extends com.google.api.services.storage.preprod.StorageRequest<
            com.google.api.services.storage.preprod.model.ObjectAccessControls> {

      private static final String REST_PATH = "b/{bucket}/defaultObjectAcl";

      /**
       * Retrieves default object ACL entries on the specified bucket.
       *
       * <p>Create a request for the method "defaultObjectAccessControls.list".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * <p>{@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of a bucket.
       * @since 1.13
       */
      protected List(String bucket) {
        super(
            Storage.this,
            "GET",
            REST_PATH,
            null,
            com.google.api.services.storage.preprod.model.ObjectAccessControls.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead()
          throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUserIp(String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of a bucket. */
      public String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public List setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * If present, only return default ACL listing if the bucket's current metageneration matches
       * this value.
       */
      @com.google.api.client.util.Key private Long ifMetagenerationMatch;

      /**
       * If present, only return default ACL listing if the bucket's current metageneration matches
       * this value.
       */
      public Long getIfMetagenerationMatch() {
        return ifMetagenerationMatch;
      }

      /**
       * If present, only return default ACL listing if the bucket's current metageneration matches
       * this value.
       */
      public List setIfMetagenerationMatch(Long ifMetagenerationMatch) {
        this.ifMetagenerationMatch = ifMetagenerationMatch;
        return this;
      }

      /**
       * If present, only return default ACL listing if the bucket's current metageneration does not
       * match the given value.
       */
      @com.google.api.client.util.Key private Long ifMetagenerationNotMatch;

      /**
       * If present, only return default ACL listing if the bucket's current metageneration does not
       * match the given value.
       */
      public Long getIfMetagenerationNotMatch() {
        return ifMetagenerationNotMatch;
      }

      /**
       * If present, only return default ACL listing if the bucket's current metageneration does not
       * match the given value.
       */
      public List setIfMetagenerationNotMatch(Long ifMetagenerationNotMatch) {
        this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public List setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Patches a default object ACL entry on the specified bucket.
     *
     * <p>Create a request for the method "defaultObjectAccessControls.patch".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param entity The entity holding the permission. Can be user-userId, user-emailAddress,
     *     group-groupId, group- emailAddress, allUsers, or allAuthenticatedUsers.
     * @param content the {@link com.google.api.services.storage.model.ObjectAccessControl}
     * @return the request
     */
    public Patch patch(
        String bucket,
        String entity,
        com.google.api.services.storage.model.ObjectAccessControl content)
        throws java.io.IOException {
      Patch result = new Patch(bucket, entity, content);
      initialize(result);
      return result;
    }

    public class Patch
        extends com.google.api.services.storage.preprod.StorageRequest<ObjectAccessControl> {

      private static final String REST_PATH = "b/{bucket}/defaultObjectAcl/{entity}";

      /**
       * Patches a default object ACL entry on the specified bucket.
       *
       * <p>Create a request for the method "defaultObjectAccessControls.patch".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of a bucket.
       * @param entity The entity holding the permission. Can be user-userId, user-emailAddress,
       *     group-groupId, group- emailAddress, allUsers, or allAuthenticatedUsers.
       * @param content the {@link com.google.api.services.storage.model.ObjectAccessControl}
       * @since 1.13
       */
      protected Patch(
          String bucket,
          String entity,
          com.google.api.services.storage.model.ObjectAccessControl content) {
        super(
            Storage.this,
            "PATCH",
            REST_PATH,
            content,
            com.google.api.services.storage.model.ObjectAccessControl.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        this.entity =
            com.google.api.client.util.Preconditions.checkNotNull(
                entity, "Required parameter entity must be specified.");
      }

      @Override
      public Patch setAlt(String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUserIp(String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of a bucket. */
      public String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Patch setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      @com.google.api.client.util.Key private String entity;

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group- emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public String getEntity() {
        return entity;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public Patch setEntity(String entity) {
        this.entity = entity;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public Patch setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates a default object ACL entry on the specified bucket.
     *
     * <p>Create a request for the method "defaultObjectAccessControls.update".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param entity The entity holding the permission. Can be user-userId, user-emailAddress,
     *     group-groupId, group- emailAddress, allUsers, or allAuthenticatedUsers.
     * @param content the {@link com.google.api.services.storage.model.ObjectAccessControl}
     * @return the request
     */
    public Update update(
        String bucket,
        String entity,
        com.google.api.services.storage.model.ObjectAccessControl content)
        throws java.io.IOException {
      Update result = new Update(bucket, entity, content);
      initialize(result);
      return result;
    }

    public class Update
        extends com.google.api.services.storage.preprod.StorageRequest<ObjectAccessControl> {

      private static final String REST_PATH = "b/{bucket}/defaultObjectAcl/{entity}";

      /**
       * Updates a default object ACL entry on the specified bucket.
       *
       * <p>Create a request for the method "defaultObjectAccessControls.update".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of a bucket.
       * @param entity The entity holding the permission. Can be user-userId, user-emailAddress,
       *     group-groupId, group- emailAddress, allUsers, or allAuthenticatedUsers.
       * @param content the {@link com.google.api.services.storage.model.ObjectAccessControl}
       * @since 1.13
       */
      protected Update(
          String bucket,
          String entity,
          com.google.api.services.storage.model.ObjectAccessControl content) {
        super(
            Storage.this,
            "PUT",
            REST_PATH,
            content,
            com.google.api.services.storage.model.ObjectAccessControl.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        this.entity =
            com.google.api.client.util.Preconditions.checkNotNull(
                entity, "Required parameter entity must be specified.");
      }

      @Override
      public Update setAlt(String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUserIp(String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of a bucket. */
      public String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Update setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      @com.google.api.client.util.Key private String entity;

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group- emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public String getEntity() {
        return entity;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public Update setEntity(String entity) {
        this.entity = entity;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public Update setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }
  }

  /**
   * An accessor for creating requests from the Directories collection.
   *
   * <p>The typical use is:
   *
   * <pre>
   *   {@code Storage storage = new Storage(...);}
   *   {@code Storage.Directories.List request = storage.directories().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Directories directories() {
    return new Directories();
  }

  /** The "directories" collection of methods. */
  public class Directories {

    /**
     * Permanently deletes a directory.
     *
     * <p>Create a request for the method "directories.delete".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of the bucket in which the directory resides.
     * @param directory Name of a directory.
     * @return the request
     */
    public Delete delete(String bucket, String directory) throws java.io.IOException {
      Delete result = new Delete(bucket, directory);
      initialize(result);
      return result;
    }

    public class Delete extends com.google.api.services.storage.preprod.StorageRequest<Void> {

      private static final String REST_PATH = "b/{bucket}/d/{directory}";

      /**
       * Permanently deletes a directory.
       *
       * <p>Create a request for the method "directories.delete".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of the bucket in which the directory resides.
       * @param directory Name of a directory.
       * @since 1.13
       */
      protected Delete(String bucket, String directory) {
        super(Storage.this, "DELETE", REST_PATH, null, Void.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        this.directory =
            com.google.api.client.util.Preconditions.checkNotNull(
                directory, "Required parameter directory must be specified.");
      }

      @Override
      public Delete setAlt(String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUserIp(String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the bucket in which the directory resides. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of the bucket in which the directory resides. */
      public String getBucket() {
        return bucket;
      }

      /** Name of the bucket in which the directory resides. */
      public Delete setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /** Name of a directory. */
      @com.google.api.client.util.Key private String directory;

      /** Name of a directory. */
      public String getDirectory() {
        return directory;
      }

      /** Name of a directory. */
      public Delete setDirectory(String directory) {
        this.directory = directory;
        return this;
      }

      /** If set, only deletes the directory if its metageneration matches this value. */
      @com.google.api.client.util.Key private Long ifMetagenerationMatch;

      /** If set, only deletes the directory if its metageneration matches this value. */
      public Long getIfMetagenerationMatch() {
        return ifMetagenerationMatch;
      }

      /** If set, only deletes the directory if its metageneration matches this value. */
      public Delete setIfMetagenerationMatch(Long ifMetagenerationMatch) {
        this.ifMetagenerationMatch = ifMetagenerationMatch;
        return this;
      }

      /** If set, only deletes the directory if its metageneration does not match this value. */
      @com.google.api.client.util.Key private Long ifMetagenerationNotMatch;

      /** If set, only deletes the directory if its metageneration does not match this value. */
      public Long getIfMetagenerationNotMatch() {
        return ifMetagenerationNotMatch;
      }

      /** If set, only deletes the directory if its metageneration does not match this value. */
      public Delete setIfMetagenerationNotMatch(Long ifMetagenerationNotMatch) {
        this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns metadata for the specified directory.
     *
     * <p>Create a request for the method "directories.get".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of the bucket in which the directory resides.
     * @param directory Name of a directory.
     * @return the request
     */
    public Get get(String bucket, String directory) throws java.io.IOException {
      Get result = new Get(bucket, directory);
      initialize(result);
      return result;
    }

    public class Get
        extends com.google.api.services.storage.preprod.StorageRequest<
            com.google.api.services.storage.preprod.model.Directory> {

      private static final String REST_PATH = "b/{bucket}/d/{directory}";

      /**
       * Returns metadata for the specified directory.
       *
       * <p>Create a request for the method "directories.get".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * <p>{@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of the bucket in which the directory resides.
       * @param directory Name of a directory.
       * @since 1.13
       */
      protected Get(String bucket, String directory) {
        super(
            Storage.this,
            "GET",
            REST_PATH,
            null,
            com.google.api.services.storage.preprod.model.Directory.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        this.directory =
            com.google.api.client.util.Preconditions.checkNotNull(
                directory, "Required parameter directory must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead()
          throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the bucket in which the directory resides. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of the bucket in which the directory resides. */
      public String getBucket() {
        return bucket;
      }

      /** Name of the bucket in which the directory resides. */
      public Get setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /** Name of a directory. */
      @com.google.api.client.util.Key private String directory;

      /** Name of a directory. */
      public String getDirectory() {
        return directory;
      }

      /** Name of a directory. */
      public Get setDirectory(String directory) {
        this.directory = directory;
        return this;
      }

      /**
       * Makes the return of the directory metadata conditional on whether the directory's current
       * metageneration matches the given value.
       */
      @com.google.api.client.util.Key private Long ifMetagenerationMatch;

      /**
       * Makes the return of the directory metadata conditional on whether the directory's current
       * metageneration matches the given value.
       */
      public Long getIfMetagenerationMatch() {
        return ifMetagenerationMatch;
      }

      /**
       * Makes the return of the directory metadata conditional on whether the directory's current
       * metageneration matches the given value.
       */
      public Get setIfMetagenerationMatch(Long ifMetagenerationMatch) {
        this.ifMetagenerationMatch = ifMetagenerationMatch;
        return this;
      }

      /**
       * Makes the return of the directory metadata conditional on whether the directory's current
       * metageneration does not match the given value.
       */
      @com.google.api.client.util.Key private Long ifMetagenerationNotMatch;

      /**
       * Makes the return of the directory metadata conditional on whether the directory's current
       * metageneration does not match the given value.
       */
      public Long getIfMetagenerationNotMatch() {
        return ifMetagenerationNotMatch;
      }

      /**
       * Makes the return of the directory metadata conditional on whether the directory's current
       * metageneration does not match the given value.
       */
      public Get setIfMetagenerationNotMatch(Long ifMetagenerationNotMatch) {
        this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a new directory.
     *
     * <p>Create a request for the method "directories.insert".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of the bucket in which the directory resides.
     * @param content the {@link com.google.api.services.storage.preprod.model.Directory}
     * @return the request
     */
    public Insert insert(
        String bucket, com.google.api.services.storage.preprod.model.Directory content)
        throws java.io.IOException {
      Insert result = new Insert(bucket, content);
      initialize(result);
      return result;
    }

    public class Insert
        extends com.google.api.services.storage.preprod.StorageRequest<
            com.google.api.services.storage.preprod.model.Directory> {

      private static final String REST_PATH = "b/{bucket}/d";

      /**
       * Creates a new directory.
       *
       * <p>Create a request for the method "directories.insert".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of the bucket in which the directory resides.
       * @param content the {@link com.google.api.services.storage.preprod.model.Directory}
       * @since 1.13
       */
      protected Insert(
          String bucket, com.google.api.services.storage.preprod.model.Directory content) {
        super(
            Storage.this,
            "POST",
            REST_PATH,
            content,
            com.google.api.services.storage.preprod.model.Directory.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
      }

      @Override
      public Insert setAlt(String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUserIp(String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of the bucket in which the directory resides. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of the bucket in which the directory resides. */
      public String getBucket() {
        return bucket;
      }

      /** Name of the bucket in which the directory resides. */
      public Insert setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of directories matching the criteria.
     *
     * <p>Create a request for the method "directories.list".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of the bucket in which to look for directories.
     * @return the request
     */
    public List list(String bucket) throws java.io.IOException {
      List result = new List(bucket);
      initialize(result);
      return result;
    }

    public class List
        extends com.google.api.services.storage.preprod.StorageRequest<
            com.google.api.services.storage.preprod.model.Directories> {

      private static final String REST_PATH = "b/{bucket}/d";

      /**
       * Retrieves a list of directories matching the criteria.
       *
       * <p>Create a request for the method "directories.list".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * <p>{@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of the bucket in which to look for directories.
       * @since 1.13
       */
      protected List(String bucket) {
        super(
            Storage.this,
            "GET",
            REST_PATH,
            null,
            com.google.api.services.storage.preprod.model.Directories.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead()
          throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUserIp(String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the bucket in which to look for directories. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of the bucket in which to look for directories. */
      public String getBucket() {
        return bucket;
      }

      /** Name of the bucket in which to look for directories. */
      public List setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /** Maximum number of items return in a single page of responses. */
      @com.google.api.client.util.Key private Long maxResults;

      /**
       * Maximum number of items return in a single page of responses. [default: 1000] [minimum: 0]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /** Maximum number of items return in a single page of responses. */
      public List setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * A previously-returned page token representing part of the larger set of results to view.
       */
      @com.google.api.client.util.Key private String pageToken;

      /**
       * A previously-returned page token representing part of the larger set of results to view.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
       * A previously-returned page token representing part of the larger set of results to view.
       */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Filter results to directories whose paths begin with this prefix. */
      @com.google.api.client.util.Key private String prefix;

      /** Filter results to directories whose paths begin with this prefix. */
      public String getPrefix() {
        return prefix;
      }

      /** Filter results to directories whose paths begin with this prefix. */
      public List setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Renames a source directory to a destination directory.
     *
     * <p>Create a request for the method "directories.rename".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Rename#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of the bucket in which the directories are in.
     * @param sourceDirectory Name of the source directory.
     * @param destinationDirectory Name of the directory.
     * @return the request
     */
    public Rename rename(String bucket, String sourceDirectory, String destinationDirectory)
        throws java.io.IOException {
      Rename result = new Rename(bucket, sourceDirectory, destinationDirectory);
      initialize(result);
      return result;
    }

    public class Rename
        extends com.google.api.services.storage.preprod.StorageRequest<
            com.google.api.services.storage.preprod.model.Directory> {

      private static final String REST_PATH =
          "b/{bucket}/d/{sourceDirectory}/renameTo/d/{destinationDirectory}";

      /**
       * Renames a source directory to a destination directory.
       *
       * <p>Create a request for the method "directories.rename".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Rename#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * Rename#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of the bucket in which the directories are in.
       * @param sourceDirectory Name of the source directory.
       * @param destinationDirectory Name of the directory.
       * @since 1.13
       */
      protected Rename(String bucket, String sourceDirectory, String destinationDirectory) {
        super(
            Storage.this,
            "POST",
            REST_PATH,
            null,
            com.google.api.services.storage.preprod.model.Directory.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        this.sourceDirectory =
            com.google.api.client.util.Preconditions.checkNotNull(
                sourceDirectory, "Required parameter sourceDirectory must be specified.");
        this.destinationDirectory =
            com.google.api.client.util.Preconditions.checkNotNull(
                destinationDirectory, "Required parameter destinationDirectory must be specified.");
      }

      @Override
      public Rename setAlt(String alt) {
        return (Rename) super.setAlt(alt);
      }

      @Override
      public Rename setFields(String fields) {
        return (Rename) super.setFields(fields);
      }

      @Override
      public Rename setKey(String key) {
        return (Rename) super.setKey(key);
      }

      @Override
      public Rename setOauthToken(String oauthToken) {
        return (Rename) super.setOauthToken(oauthToken);
      }

      @Override
      public Rename setPrettyPrint(Boolean prettyPrint) {
        return (Rename) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Rename setQuotaUser(String quotaUser) {
        return (Rename) super.setQuotaUser(quotaUser);
      }

      @Override
      public Rename setUploadType(String uploadType) {
        return (Rename) super.setUploadType(uploadType);
      }

      @Override
      public Rename setUserIp(String userIp) {
        return (Rename) super.setUserIp(userIp);
      }

      /** Name of the bucket in which the directories are in. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of the bucket in which the directories are in. */
      public String getBucket() {
        return bucket;
      }

      /** Name of the bucket in which the directories are in. */
      public Rename setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /** Name of the source directory. */
      @com.google.api.client.util.Key private String sourceDirectory;

      /** Name of the source directory. */
      public String getSourceDirectory() {
        return sourceDirectory;
      }

      /** Name of the source directory. */
      public Rename setSourceDirectory(String sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
        return this;
      }

      /** Name of the directory. */
      @com.google.api.client.util.Key private String destinationDirectory;

      /** Name of the directory. */
      public String getDestinationDirectory() {
        return destinationDirectory;
      }

      /** Name of the directory. */
      public Rename setDestinationDirectory(String destinationDirectory) {
        this.destinationDirectory = destinationDirectory;
        return this;
      }

      /**
       * Makes the operation conditional on whether the source object's current metageneration
       * matches the given value.
       */
      @com.google.api.client.util.Key private Long ifSourceMetagenerationMatch;

      /**
       * Makes the operation conditional on whether the source object's current metageneration
       * matches the given value.
       */
      public Long getIfSourceMetagenerationMatch() {
        return ifSourceMetagenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the source object's current metageneration
       * matches the given value.
       */
      public Rename setIfSourceMetagenerationMatch(Long ifSourceMetagenerationMatch) {
        this.ifSourceMetagenerationMatch = ifSourceMetagenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the source object's current metageneration does
       * not match the given value.
       */
      @com.google.api.client.util.Key private Long ifSourceMetagenerationNotMatch;

      /**
       * Makes the operation conditional on whether the source object's current metageneration does
       * not match the given value.
       */
      public Long getIfSourceMetagenerationNotMatch() {
        return ifSourceMetagenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the source object's current metageneration does
       * not match the given value.
       */
      public Rename setIfSourceMetagenerationNotMatch(Long ifSourceMetagenerationNotMatch) {
        this.ifSourceMetagenerationNotMatch = ifSourceMetagenerationNotMatch;
        return this;
      }

      @Override
      public Rename set(String parameterName, Object value) {
        return (Rename) super.set(parameterName, value);
      }
    }
  }

  /**
   * An accessor for creating requests from the Notifications collection.
   *
   * <p>The typical use is:
   *
   * <pre>
   *   {@code Storage storage = new Storage(...);}
   *   {@code Storage.Notifications.List request = storage.notifications().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Notifications notifications() {
    return new Notifications();
  }

  /** The "notifications" collection of methods. */
  public class Notifications {

    /**
     * Permanently deletes a notification subscription.
     *
     * <p>Create a request for the method "notifications.delete".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param bucket The parent bucket of the notification.
     * @param notification ID of the notification to delete.
     * @return the request
     */
    public Delete delete(String bucket, String notification) throws java.io.IOException {
      Delete result = new Delete(bucket, notification);
      initialize(result);
      return result;
    }

    public class Delete extends com.google.api.services.storage.preprod.StorageRequest<Void> {

      private static final String REST_PATH = "b/{bucket}/notificationConfigs/{notification}";

      /**
       * Permanently deletes a notification subscription.
       *
       * <p>Create a request for the method "notifications.delete".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket The parent bucket of the notification.
       * @param notification ID of the notification to delete.
       * @since 1.13
       */
      protected Delete(String bucket, String notification) {
        super(Storage.this, "DELETE", REST_PATH, null, Void.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        this.notification =
            com.google.api.client.util.Preconditions.checkNotNull(
                notification, "Required parameter notification must be specified.");
      }

      @Override
      public Delete setAlt(String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUserIp(String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** The parent bucket of the notification. */
      @com.google.api.client.util.Key private String bucket;

      /** The parent bucket of the notification. */
      public String getBucket() {
        return bucket;
      }

      /** The parent bucket of the notification. */
      public Delete setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /** ID of the notification to delete. */
      @com.google.api.client.util.Key private String notification;

      /** ID of the notification to delete. */
      public String getNotification() {
        return notification;
      }

      /** ID of the notification to delete. */
      public Delete setNotification(String notification) {
        this.notification = notification;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public Delete setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * View a notification configuration.
     *
     * <p>Create a request for the method "notifications.get".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param bucket The parent bucket of the notification.
     * @param notification Notification ID
     * @return the request
     */
    public Get get(String bucket, String notification) throws java.io.IOException {
      Get result = new Get(bucket, notification);
      initialize(result);
      return result;
    }

    public class Get extends com.google.api.services.storage.preprod.StorageRequest<Notification> {

      private static final String REST_PATH = "b/{bucket}/notificationConfigs/{notification}";

      /**
       * View a notification configuration.
       *
       * <p>Create a request for the method "notifications.get".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * <p>{@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket The parent bucket of the notification.
       * @param notification Notification ID
       * @since 1.13
       */
      protected Get(String bucket, String notification) {
        super(
            Storage.this,
            "GET",
            REST_PATH,
            null,
            com.google.api.services.storage.model.Notification.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        this.notification =
            com.google.api.client.util.Preconditions.checkNotNull(
                notification, "Required parameter notification must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead()
          throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** The parent bucket of the notification. */
      @com.google.api.client.util.Key private String bucket;

      /** The parent bucket of the notification. */
      public String getBucket() {
        return bucket;
      }

      /** The parent bucket of the notification. */
      public Get setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /** Notification ID */
      @com.google.api.client.util.Key private String notification;

      /** Notification ID */
      public String getNotification() {
        return notification;
      }

      /** Notification ID */
      public Get setNotification(String notification) {
        this.notification = notification;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public Get setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a notification subscription for a given bucket.
     *
     * <p>Create a request for the method "notifications.insert".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param bucket The parent bucket of the notification.
     * @param content the {@link com.google.api.services.storage.model.Notification}
     * @return the request
     */
    public Insert insert(String bucket, com.google.api.services.storage.model.Notification content)
        throws java.io.IOException {
      Insert result = new Insert(bucket, content);
      initialize(result);
      return result;
    }

    public class Insert
        extends com.google.api.services.storage.preprod.StorageRequest<Notification> {

      private static final String REST_PATH = "b/{bucket}/notificationConfigs";

      /**
       * Creates a notification subscription for a given bucket.
       *
       * <p>Create a request for the method "notifications.insert".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket The parent bucket of the notification.
       * @param content the {@link com.google.api.services.storage.model.Notification}
       * @since 1.13
       */
      protected Insert(String bucket, com.google.api.services.storage.model.Notification content) {
        super(
            Storage.this,
            "POST",
            REST_PATH,
            content,
            com.google.api.services.storage.model.Notification.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getPayloadFormat(), "Notification.getPayloadFormat()");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getTopic(), "Notification.getTopic()");
      }

      @Override
      public Insert setAlt(String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUserIp(String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** The parent bucket of the notification. */
      @com.google.api.client.util.Key private String bucket;

      /** The parent bucket of the notification. */
      public String getBucket() {
        return bucket;
      }

      /** The parent bucket of the notification. */
      public Insert setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public Insert setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of notification subscriptions for a given bucket.
     *
     * <p>Create a request for the method "notifications.list".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a Google Cloud Storage bucket.
     * @return the request
     */
    public List list(String bucket) throws java.io.IOException {
      List result = new List(bucket);
      initialize(result);
      return result;
    }

    public class List
        extends com.google.api.services.storage.preprod.StorageRequest<
            com.google.api.services.storage.model.Notifications> {

      private static final String REST_PATH = "b/{bucket}/notificationConfigs";

      /**
       * Retrieves a list of notification subscriptions for a given bucket.
       *
       * <p>Create a request for the method "notifications.list".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * <p>{@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of a Google Cloud Storage bucket.
       * @since 1.13
       */
      protected List(String bucket) {
        super(
            Storage.this,
            "GET",
            REST_PATH,
            null,
            com.google.api.services.storage.model.Notifications.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead()
          throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUserIp(String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of a Google Cloud Storage bucket. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of a Google Cloud Storage bucket. */
      public String getBucket() {
        return bucket;
      }

      /** Name of a Google Cloud Storage bucket. */
      public List setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public List setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
  }

  /**
   * An accessor for creating requests from the ObjectAccessControls collection.
   *
   * <p>The typical use is:
   *
   * <pre>
   *   {@code Storage storage = new Storage(...);}
   *   {@code Storage.ObjectAccessControls.List request = storage.objectAccessControls().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public ObjectAccessControls objectAccessControls() {
    return new ObjectAccessControls();
  }

  /** The "objectAccessControls" collection of methods. */
  public class ObjectAccessControls {

    /**
     * Permanently deletes the ACL entry for the specified entity on the specified object.
     *
     * <p>Create a request for the method "objectAccessControls.delete".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param object__ Name of the object. For information about how to URL encode object names to
     *     be path safe, see Encoding URI Path Parts.
     * @param entity The entity holding the permission. Can be user-userId, user-emailAddress,
     *     group-groupId, group- emailAddress, allUsers, or allAuthenticatedUsers.
     * @return the request
     */
    public Delete delete(String bucket, String object__, String entity) throws java.io.IOException {
      Delete result = new Delete(bucket, object__, entity);
      initialize(result);
      return result;
    }

    public class Delete extends com.google.api.services.storage.preprod.StorageRequest<Void> {

      private static final String REST_PATH = "b/{bucket}/o/{object}/acl/{entity}";

      /**
       * Permanently deletes the ACL entry for the specified entity on the specified object.
       *
       * <p>Create a request for the method "objectAccessControls.delete".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of a bucket.
       * @param object__ Name of the object. For information about how to URL encode object names to
       *     be path safe, see Encoding URI Path Parts.
       * @param entity The entity holding the permission. Can be user-userId, user-emailAddress,
       *     group-groupId, group- emailAddress, allUsers, or allAuthenticatedUsers.
       * @since 1.13
       */
      protected Delete(String bucket, String object__, String entity) {
        super(Storage.this, "DELETE", REST_PATH, null, Void.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        this.object__ =
            com.google.api.client.util.Preconditions.checkNotNull(
                object__, "Required parameter object__ must be specified.");
        this.entity =
            com.google.api.client.util.Preconditions.checkNotNull(
                entity, "Required parameter entity must be specified.");
      }

      @Override
      public Delete setAlt(String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUserIp(String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of a bucket. */
      public String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Delete setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      @com.google.api.client.util.Key("object")
      private String object__;

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      public String getObject() {
        return object__;
      }

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      public Delete setObject(String object__) {
        this.object__ = object__;
        return this;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      @com.google.api.client.util.Key private String entity;

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group- emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public String getEntity() {
        return entity;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public Delete setEntity(String entity) {
        this.entity = entity;
        return this;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      @com.google.api.client.util.Key private Long generation;

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public Long getGeneration() {
        return generation;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public Delete setGeneration(Long generation) {
        this.generation = generation;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public Delete setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the ACL entry for the specified entity on the specified object.
     *
     * <p>Create a request for the method "objectAccessControls.get".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param object__ Name of the object. For information about how to URL encode object names to
     *     be path safe, see Encoding URI Path Parts.
     * @param entity The entity holding the permission. Can be user-userId, user-emailAddress,
     *     group-groupId, group- emailAddress, allUsers, or allAuthenticatedUsers.
     * @return the request
     */
    public Get get(String bucket, String object__, String entity) throws java.io.IOException {
      Get result = new Get(bucket, object__, entity);
      initialize(result);
      return result;
    }

    public class Get
        extends com.google.api.services.storage.preprod.StorageRequest<ObjectAccessControl> {

      private static final String REST_PATH = "b/{bucket}/o/{object}/acl/{entity}";

      /**
       * Returns the ACL entry for the specified entity on the specified object.
       *
       * <p>Create a request for the method "objectAccessControls.get".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * <p>{@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of a bucket.
       * @param object__ Name of the object. For information about how to URL encode object names to
       *     be path safe, see Encoding URI Path Parts.
       * @param entity The entity holding the permission. Can be user-userId, user-emailAddress,
       *     group-groupId, group- emailAddress, allUsers, or allAuthenticatedUsers.
       * @since 1.13
       */
      protected Get(String bucket, String object__, String entity) {
        super(
            Storage.this,
            "GET",
            REST_PATH,
            null,
            com.google.api.services.storage.model.ObjectAccessControl.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        this.object__ =
            com.google.api.client.util.Preconditions.checkNotNull(
                object__, "Required parameter object__ must be specified.");
        this.entity =
            com.google.api.client.util.Preconditions.checkNotNull(
                entity, "Required parameter entity must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead()
          throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of a bucket. */
      public String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Get setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      @com.google.api.client.util.Key("object")
      private String object__;

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      public String getObject() {
        return object__;
      }

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      public Get setObject(String object__) {
        this.object__ = object__;
        return this;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      @com.google.api.client.util.Key private String entity;

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group- emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public String getEntity() {
        return entity;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public Get setEntity(String entity) {
        this.entity = entity;
        return this;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      @com.google.api.client.util.Key private Long generation;

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public Long getGeneration() {
        return generation;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public Get setGeneration(Long generation) {
        this.generation = generation;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public Get setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a new ACL entry on the specified object.
     *
     * <p>Create a request for the method "objectAccessControls.insert".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param object__ Name of the object. For information about how to URL encode object names to
     *     be path safe, see Encoding URI Path Parts.
     * @param content the {@link com.google.api.services.storage.model.ObjectAccessControl}
     * @return the request
     */
    public Insert insert(
        String bucket,
        String object__,
        com.google.api.services.storage.model.ObjectAccessControl content)
        throws java.io.IOException {
      Insert result = new Insert(bucket, object__, content);
      initialize(result);
      return result;
    }

    public class Insert
        extends com.google.api.services.storage.preprod.StorageRequest<ObjectAccessControl> {

      private static final String REST_PATH = "b/{bucket}/o/{object}/acl";

      /**
       * Creates a new ACL entry on the specified object.
       *
       * <p>Create a request for the method "objectAccessControls.insert".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of a bucket.
       * @param object__ Name of the object. For information about how to URL encode object names to
       *     be path safe, see Encoding URI Path Parts.
       * @param content the {@link com.google.api.services.storage.model.ObjectAccessControl}
       * @since 1.13
       */
      protected Insert(
          String bucket,
          String object__,
          com.google.api.services.storage.model.ObjectAccessControl content) {
        super(
            Storage.this,
            "POST",
            REST_PATH,
            content,
            com.google.api.services.storage.model.ObjectAccessControl.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        this.object__ =
            com.google.api.client.util.Preconditions.checkNotNull(
                object__, "Required parameter object__ must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getEntity(), "ObjectAccessControl.getEntity()");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getRole(), "ObjectAccessControl.getRole()");
      }

      @Override
      public Insert setAlt(String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUserIp(String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of a bucket. */
      public String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Insert setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      @com.google.api.client.util.Key("object")
      private String object__;

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      public String getObject() {
        return object__;
      }

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      public Insert setObject(String object__) {
        this.object__ = object__;
        return this;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      @com.google.api.client.util.Key private Long generation;

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public Long getGeneration() {
        return generation;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public Insert setGeneration(Long generation) {
        this.generation = generation;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public Insert setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves ACL entries on the specified object.
     *
     * <p>Create a request for the method "objectAccessControls.list".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param object__ Name of the object. For information about how to URL encode object names to
     *     be path safe, see Encoding URI Path Parts.
     * @return the request
     */
    public List list(String bucket, String object__) throws java.io.IOException {
      List result = new List(bucket, object__);
      initialize(result);
      return result;
    }

    public class List
        extends com.google.api.services.storage.preprod.StorageRequest<
            com.google.api.services.storage.preprod.model.ObjectAccessControls> {

      private static final String REST_PATH = "b/{bucket}/o/{object}/acl";

      /**
       * Retrieves ACL entries on the specified object.
       *
       * <p>Create a request for the method "objectAccessControls.list".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * <p>{@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of a bucket.
       * @param object__ Name of the object. For information about how to URL encode object names to
       *     be path safe, see Encoding URI Path Parts.
       * @since 1.13
       */
      protected List(String bucket, String object__) {
        super(
            Storage.this,
            "GET",
            REST_PATH,
            null,
            com.google.api.services.storage.preprod.model.ObjectAccessControls.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        this.object__ =
            com.google.api.client.util.Preconditions.checkNotNull(
                object__, "Required parameter object__ must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead()
          throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUserIp(String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of a bucket. */
      public String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public List setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      @com.google.api.client.util.Key("object")
      private String object__;

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      public String getObject() {
        return object__;
      }

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      public List setObject(String object__) {
        this.object__ = object__;
        return this;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      @com.google.api.client.util.Key private Long generation;

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public Long getGeneration() {
        return generation;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public List setGeneration(Long generation) {
        this.generation = generation;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public List setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Patches an ACL entry on the specified object.
     *
     * <p>Create a request for the method "objectAccessControls.patch".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param object__ Name of the object. For information about how to URL encode object names to
     *     be path safe, see Encoding URI Path Parts.
     * @param entity The entity holding the permission. Can be user-userId, user-emailAddress,
     *     group-groupId, group- emailAddress, allUsers, or allAuthenticatedUsers.
     * @param content the {@link com.google.api.services.storage.model.ObjectAccessControl}
     * @return the request
     */
    public Patch patch(
        String bucket,
        String object__,
        String entity,
        com.google.api.services.storage.model.ObjectAccessControl content)
        throws java.io.IOException {
      Patch result = new Patch(bucket, object__, entity, content);
      initialize(result);
      return result;
    }

    public class Patch
        extends com.google.api.services.storage.preprod.StorageRequest<ObjectAccessControl> {

      private static final String REST_PATH = "b/{bucket}/o/{object}/acl/{entity}";

      /**
       * Patches an ACL entry on the specified object.
       *
       * <p>Create a request for the method "objectAccessControls.patch".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of a bucket.
       * @param object__ Name of the object. For information about how to URL encode object names to
       *     be path safe, see Encoding URI Path Parts.
       * @param entity The entity holding the permission. Can be user-userId, user-emailAddress,
       *     group-groupId, group- emailAddress, allUsers, or allAuthenticatedUsers.
       * @param content the {@link com.google.api.services.storage.model.ObjectAccessControl}
       * @since 1.13
       */
      protected Patch(
          String bucket,
          String object__,
          String entity,
          com.google.api.services.storage.model.ObjectAccessControl content) {
        super(
            Storage.this,
            "PATCH",
            REST_PATH,
            content,
            com.google.api.services.storage.model.ObjectAccessControl.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        this.object__ =
            com.google.api.client.util.Preconditions.checkNotNull(
                object__, "Required parameter object__ must be specified.");
        this.entity =
            com.google.api.client.util.Preconditions.checkNotNull(
                entity, "Required parameter entity must be specified.");
      }

      @Override
      public Patch setAlt(String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUserIp(String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of a bucket. */
      public String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Patch setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      @com.google.api.client.util.Key("object")
      private String object__;

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      public String getObject() {
        return object__;
      }

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      public Patch setObject(String object__) {
        this.object__ = object__;
        return this;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      @com.google.api.client.util.Key private String entity;

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group- emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public String getEntity() {
        return entity;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public Patch setEntity(String entity) {
        this.entity = entity;
        return this;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      @com.google.api.client.util.Key private Long generation;

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public Long getGeneration() {
        return generation;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public Patch setGeneration(Long generation) {
        this.generation = generation;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public Patch setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates an ACL entry on the specified object.
     *
     * <p>Create a request for the method "objectAccessControls.update".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of a bucket.
     * @param object__ Name of the object. For information about how to URL encode object names to
     *     be path safe, see Encoding URI Path Parts.
     * @param entity The entity holding the permission. Can be user-userId, user-emailAddress,
     *     group-groupId, group- emailAddress, allUsers, or allAuthenticatedUsers.
     * @param content the {@link com.google.api.services.storage.model.ObjectAccessControl}
     * @return the request
     */
    public Update update(
        String bucket,
        String object__,
        String entity,
        com.google.api.services.storage.model.ObjectAccessControl content)
        throws java.io.IOException {
      Update result = new Update(bucket, object__, entity, content);
      initialize(result);
      return result;
    }

    public class Update
        extends com.google.api.services.storage.preprod.StorageRequest<ObjectAccessControl> {

      private static final String REST_PATH = "b/{bucket}/o/{object}/acl/{entity}";

      /**
       * Updates an ACL entry on the specified object.
       *
       * <p>Create a request for the method "objectAccessControls.update".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of a bucket.
       * @param object__ Name of the object. For information about how to URL encode object names to
       *     be path safe, see Encoding URI Path Parts.
       * @param entity The entity holding the permission. Can be user-userId, user-emailAddress,
       *     group-groupId, group- emailAddress, allUsers, or allAuthenticatedUsers.
       * @param content the {@link com.google.api.services.storage.model.ObjectAccessControl}
       * @since 1.13
       */
      protected Update(
          String bucket,
          String object__,
          String entity,
          com.google.api.services.storage.model.ObjectAccessControl content) {
        super(
            Storage.this,
            "PUT",
            REST_PATH,
            content,
            com.google.api.services.storage.model.ObjectAccessControl.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        this.object__ =
            com.google.api.client.util.Preconditions.checkNotNull(
                object__, "Required parameter object__ must be specified.");
        this.entity =
            com.google.api.client.util.Preconditions.checkNotNull(
                entity, "Required parameter entity must be specified.");
      }

      @Override
      public Update setAlt(String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUserIp(String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Name of a bucket. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of a bucket. */
      public String getBucket() {
        return bucket;
      }

      /** Name of a bucket. */
      public Update setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      @com.google.api.client.util.Key("object")
      private String object__;

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      public String getObject() {
        return object__;
      }

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      public Update setObject(String object__) {
        this.object__ = object__;
        return this;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      @com.google.api.client.util.Key private String entity;

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group- emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public String getEntity() {
        return entity;
      }

      /**
       * The entity holding the permission. Can be user-userId, user-emailAddress, group-groupId,
       * group-emailAddress, allUsers, or allAuthenticatedUsers.
       */
      public Update setEntity(String entity) {
        this.entity = entity;
        return this;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      @com.google.api.client.util.Key private Long generation;

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public Long getGeneration() {
        return generation;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public Update setGeneration(Long generation) {
        this.generation = generation;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public Update setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }
  }

  /**
   * An accessor for creating requests from the Objects collection.
   *
   * <p>The typical use is:
   *
   * <pre>
   *   {@code Storage storage = new Storage(...);}
   *   {@code Storage.Objects.List request = storage.objects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Objects objects() {
    return new Objects();
  }

  /** The "objects" collection of methods. */
  public class Objects {

    /**
     * Concatenates a list of existing objects into a new object in the same bucket.
     *
     * <p>Create a request for the method "objects.compose".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Compose#execute()} method to invoke the remote operation.
     *
     * @param destinationBucket Name of the bucket containing the source objects. The destination
     *     object is stored in this bucket.
     * @param destinationObject Name of the new object. For information about how to URL encode
     *     object names to be path safe, see Encoding URI Path Parts.
     * @param content the {@link com.google.api.services.storage.model.ComposeRequest}
     * @return the request
     */
    public Compose compose(
        String destinationBucket,
        String destinationObject,
        com.google.api.services.storage.model.ComposeRequest content)
        throws java.io.IOException {
      Compose result = new Compose(destinationBucket, destinationObject, content);
      initialize(result);
      return result;
    }

    public class Compose
        extends com.google.api.services.storage.preprod.StorageRequest<StorageObject> {

      private static final String REST_PATH = "b/{destinationBucket}/o/{destinationObject}/compose";

      /**
       * Concatenates a list of existing objects into a new object in the same bucket.
       *
       * <p>Create a request for the method "objects.compose".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Compose#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * Compose#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param destinationBucket Name of the bucket containing the source objects. The destination
       *     object is stored in this bucket.
       * @param destinationObject Name of the new object. For information about how to URL encode
       *     object names to be path safe, see Encoding URI Path Parts.
       * @param content the {@link com.google.api.services.storage.model.ComposeRequest}
       * @since 1.13
       */
      protected Compose(
          String destinationBucket,
          String destinationObject,
          com.google.api.services.storage.model.ComposeRequest content) {
        super(
            Storage.this,
            "POST",
            REST_PATH,
            content,
            com.google.api.services.storage.model.StorageObject.class);
        this.destinationBucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                destinationBucket, "Required parameter destinationBucket must be specified.");
        this.destinationObject =
            com.google.api.client.util.Preconditions.checkNotNull(
                destinationObject, "Required parameter destinationObject must be specified.");
      }

      @Override
      public Compose setAlt(String alt) {
        return (Compose) super.setAlt(alt);
      }

      @Override
      public Compose setFields(String fields) {
        return (Compose) super.setFields(fields);
      }

      @Override
      public Compose setKey(String key) {
        return (Compose) super.setKey(key);
      }

      @Override
      public Compose setOauthToken(String oauthToken) {
        return (Compose) super.setOauthToken(oauthToken);
      }

      @Override
      public Compose setPrettyPrint(Boolean prettyPrint) {
        return (Compose) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Compose setQuotaUser(String quotaUser) {
        return (Compose) super.setQuotaUser(quotaUser);
      }

      @Override
      public Compose setUploadType(String uploadType) {
        return (Compose) super.setUploadType(uploadType);
      }

      @Override
      public Compose setUserIp(String userIp) {
        return (Compose) super.setUserIp(userIp);
      }

      /**
       * Name of the bucket containing the source objects. The destination object is stored in this
       * bucket.
       */
      @com.google.api.client.util.Key private String destinationBucket;

      /**
       * Name of the bucket containing the source objects. The destination object is stored in this
       * bucket.
       */
      public String getDestinationBucket() {
        return destinationBucket;
      }

      /**
       * Name of the bucket containing the source objects. The destination object is stored in this
       * bucket.
       */
      public Compose setDestinationBucket(String destinationBucket) {
        this.destinationBucket = destinationBucket;
        return this;
      }

      /**
       * Name of the new object. For information about how to URL encode object names to be path
       * safe, see Encoding URI Path Parts.
       */
      @com.google.api.client.util.Key private String destinationObject;

      /**
       * Name of the new object. For information about how to URL encode object names to be path
       * safe, see Encoding URI Path Parts.
       */
      public String getDestinationObject() {
        return destinationObject;
      }

      /**
       * Name of the new object. For information about how to URL encode object names to be path
       * safe, see Encoding URI Path Parts.
       */
      public Compose setDestinationObject(String destinationObject) {
        this.destinationObject = destinationObject;
        return this;
      }

      /** Apply a predefined set of access controls to the destination object. */
      @com.google.api.client.util.Key private String destinationPredefinedAcl;

      /** Apply a predefined set of access controls to the destination object. */
      public String getDestinationPredefinedAcl() {
        return destinationPredefinedAcl;
      }

      /** Apply a predefined set of access controls to the destination object. */
      public Compose setDestinationPredefinedAcl(String destinationPredefinedAcl) {
        this.destinationPredefinedAcl = destinationPredefinedAcl;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value. Setting to 0 makes the operation succeed only if there are no live versions of
       * the object.
       */
      @com.google.api.client.util.Key private Long ifGenerationMatch;

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value. Setting to 0 makes the operation succeed only if there are no live versions of
       * the object.
       */
      public Long getIfGenerationMatch() {
        return ifGenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value. Setting to 0 makes the operation succeed only if there are no live versions of
       * the object.
       */
      public Compose setIfGenerationMatch(Long ifGenerationMatch) {
        this.ifGenerationMatch = ifGenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      @com.google.api.client.util.Key private Long ifMetagenerationMatch;

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      public Long getIfMetagenerationMatch() {
        return ifMetagenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      public Compose setIfMetagenerationMatch(Long ifMetagenerationMatch) {
        this.ifMetagenerationMatch = ifMetagenerationMatch;
        return this;
      }

      /**
       * Not currently supported. Specifying the parameter causes the request to fail with status
       * code 400 - Bad Request.
       */
      @com.google.api.client.util.Key private String kmsKeyName;

      /**
       * Not currently supported. Specifying the parameter causes the request to fail with status
       * code 400 - Bad Request.
       */
      public String getKmsKeyName() {
        return kmsKeyName;
      }

      /**
       * Not currently supported. Specifying the parameter causes the request to fail with status
       * code 400 - Bad Request.
       */
      public Compose setKmsKeyName(String kmsKeyName) {
        this.kmsKeyName = kmsKeyName;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public Compose setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Compose set(String parameterName, Object value) {
        return (Compose) super.set(parameterName, value);
      }
    }
    /**
     * Copies a source object to a destination object. Optionally overrides metadata.
     *
     * <p>Create a request for the method "objects.copy".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Copy#execute()} method to invoke the remote operation.
     *
     * @param sourceBucket Name of the bucket in which to find the source object.
     * @param sourceObject Name of the source object. For information about how to URL encode object
     *     names to be path safe, see Encoding URI Path Parts.
     * @param destinationBucket Name of the bucket in which to store the new object. Overrides the
     *     provided object metadata's bucket value, if any.For information about how to URL encode
     *     object names to be path safe, see Encoding URI Path Parts.
     * @param destinationObject Name of the new object. Required when the object metadata is not
     *     otherwise provided. Overrides the object metadata's name value, if any.
     * @param content the {@link com.google.api.services.storage.model.StorageObject}
     * @return the request
     */
    public Copy copy(
        String sourceBucket,
        String sourceObject,
        String destinationBucket,
        String destinationObject,
        com.google.api.services.storage.model.StorageObject content)
        throws java.io.IOException {
      Copy result =
          new Copy(sourceBucket, sourceObject, destinationBucket, destinationObject, content);
      initialize(result);
      return result;
    }

    public class Copy
        extends com.google.api.services.storage.preprod.StorageRequest<StorageObject> {

      private static final String REST_PATH =
          "b/{sourceBucket}/o/{sourceObject}/copyTo/b/{destinationBucket}/o/{destinationObject}";

      /**
       * Copies a source object to a destination object. Optionally overrides metadata.
       *
       * <p>Create a request for the method "objects.copy".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Copy#execute()} method to invoke the remote operation.
       *
       * <p>{@link
       * Copy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param sourceBucket Name of the bucket in which to find the source object.
       * @param sourceObject Name of the source object. For information about how to URL encode
       *     object names to be path safe, see Encoding URI Path Parts.
       * @param destinationBucket Name of the bucket in which to store the new object. Overrides the
       *     provided object metadata's bucket value, if any.For information about how to URL encode
       *     object names to be path safe, see Encoding URI Path Parts.
       * @param destinationObject Name of the new object. Required when the object metadata is not
       *     otherwise provided. Overrides the object metadata's name value, if any.
       * @param content the {@link com.google.api.services.storage.model.StorageObject}
       * @since 1.13
       */
      protected Copy(
          String sourceBucket,
          String sourceObject,
          String destinationBucket,
          String destinationObject,
          com.google.api.services.storage.model.StorageObject content) {
        super(
            Storage.this,
            "POST",
            REST_PATH,
            content,
            com.google.api.services.storage.model.StorageObject.class);
        this.sourceBucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                sourceBucket, "Required parameter sourceBucket must be specified.");
        this.sourceObject =
            com.google.api.client.util.Preconditions.checkNotNull(
                sourceObject, "Required parameter sourceObject must be specified.");
        this.destinationBucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                destinationBucket, "Required parameter destinationBucket must be specified.");
        this.destinationObject =
            com.google.api.client.util.Preconditions.checkNotNull(
                destinationObject, "Required parameter destinationObject must be specified.");
      }

      @Override
      public Copy setAlt(String alt) {
        return (Copy) super.setAlt(alt);
      }

      @Override
      public Copy setFields(String fields) {
        return (Copy) super.setFields(fields);
      }

      @Override
      public Copy setKey(String key) {
        return (Copy) super.setKey(key);
      }

      @Override
      public Copy setOauthToken(String oauthToken) {
        return (Copy) super.setOauthToken(oauthToken);
      }

      @Override
      public Copy setPrettyPrint(Boolean prettyPrint) {
        return (Copy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Copy setQuotaUser(String quotaUser) {
        return (Copy) super.setQuotaUser(quotaUser);
      }

      @Override
      public Copy setUploadType(String uploadType) {
        return (Copy) super.setUploadType(uploadType);
      }

      @Override
      public Copy setUserIp(String userIp) {
        return (Copy) super.setUserIp(userIp);
      }

      /** Name of the bucket in which to find the source object. */
      @com.google.api.client.util.Key private String sourceBucket;

      /** Name of the bucket in which to find the source object. */
      public String getSourceBucket() {
        return sourceBucket;
      }

      /** Name of the bucket in which to find the source object. */
      public Copy setSourceBucket(String sourceBucket) {
        this.sourceBucket = sourceBucket;
        return this;
      }

      /**
       * Name of the source object. For information about how to URL encode object names to be path
       * safe, see Encoding URI Path Parts.
       */
      @com.google.api.client.util.Key private String sourceObject;

      /**
       * Name of the source object. For information about how to URL encode object names to be path
       * safe, see Encoding URI Path Parts.
       */
      public String getSourceObject() {
        return sourceObject;
      }

      /**
       * Name of the source object. For information about how to URL encode object names to be path
       * safe, see Encoding URI Path Parts.
       */
      public Copy setSourceObject(String sourceObject) {
        this.sourceObject = sourceObject;
        return this;
      }

      /**
       * Name of the bucket in which to store the new object. Overrides the provided object
       * metadata's bucket value, if any.For information about how to URL encode object names to be
       * path safe, see Encoding URI Path Parts.
       */
      @com.google.api.client.util.Key private String destinationBucket;

      /**
       * Name of the bucket in which to store the new object. Overrides the provided object
       * metadata's bucket value, if any.For information about how to URL encode object names to be
       * path safe, see Encoding URI Path Parts.
       */
      public String getDestinationBucket() {
        return destinationBucket;
      }

      /**
       * Name of the bucket in which to store the new object. Overrides the provided object
       * metadata's bucket value, if any.For information about how to URL encode object names to be
       * path safe, see Encoding URI Path Parts.
       */
      public Copy setDestinationBucket(String destinationBucket) {
        this.destinationBucket = destinationBucket;
        return this;
      }

      /**
       * Name of the new object. Required when the object metadata is not otherwise provided.
       * Overrides the object metadata's name value, if any.
       */
      @com.google.api.client.util.Key private String destinationObject;

      /**
       * Name of the new object. Required when the object metadata is not otherwise provided.
       * Overrides the object metadata's name value, if any.
       */
      public String getDestinationObject() {
        return destinationObject;
      }

      /**
       * Name of the new object. Required when the object metadata is not otherwise provided.
       * Overrides the object metadata's name value, if any.
       */
      public Copy setDestinationObject(String destinationObject) {
        this.destinationObject = destinationObject;
        return this;
      }

      /**
       * Resource name of the Cloud KMS key, of the form projects/my-
       * project/locations/global/keyRings/my-kr/cryptoKeys/my-key, that will be used to encrypt the
       * object. Overrides the object metadata's kms_key_name value, if any.
       */
      @com.google.api.client.util.Key private String destinationKmsKeyName;

      /**
       * Resource name of the Cloud KMS key, of the form
       * projects/my-project/locations/global/keyRings/my- kr/cryptoKeys/my-key, that will be used
       * to encrypt the object. Overrides the object metadata's kms_key_name value, if any.
       */
      public String getDestinationKmsKeyName() {
        return destinationKmsKeyName;
      }

      /**
       * Resource name of the Cloud KMS key, of the form projects/my-
       * project/locations/global/keyRings/my-kr/cryptoKeys/my-key, that will be used to encrypt the
       * object. Overrides the object metadata's kms_key_name value, if any.
       */
      public Copy setDestinationKmsKeyName(String destinationKmsKeyName) {
        this.destinationKmsKeyName = destinationKmsKeyName;
        return this;
      }

      /** Apply a predefined set of access controls to the destination object. */
      @com.google.api.client.util.Key private String destinationPredefinedAcl;

      /** Apply a predefined set of access controls to the destination object. */
      public String getDestinationPredefinedAcl() {
        return destinationPredefinedAcl;
      }

      /** Apply a predefined set of access controls to the destination object. */
      public Copy setDestinationPredefinedAcl(String destinationPredefinedAcl) {
        this.destinationPredefinedAcl = destinationPredefinedAcl;
        return this;
      }

      /**
       * Makes the operation conditional on whether the destination object's current generation
       * matches the given value. Setting to 0 makes the operation succeed only if there are no live
       * versions of the object.
       */
      @com.google.api.client.util.Key private Long ifGenerationMatch;

      /**
       * Makes the operation conditional on whether the destination object's current generation
       * matches the given value. Setting to 0 makes the operation succeed only if there are no live
       * versions of the object.
       */
      public Long getIfGenerationMatch() {
        return ifGenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the destination object's current generation
       * matches the given value. Setting to 0 makes the operation succeed only if there are no live
       * versions of the object.
       */
      public Copy setIfGenerationMatch(Long ifGenerationMatch) {
        this.ifGenerationMatch = ifGenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the destination object's current generation does
       * not match the given value. If no live object exists, the precondition fails. Setting to 0
       * makes the operation succeed only if there is a live version of the object.
       */
      @com.google.api.client.util.Key private Long ifGenerationNotMatch;

      /**
       * Makes the operation conditional on whether the destination object's current generation does
       * not match the given value. If no live object exists, the precondition fails. Setting to 0
       * makes the operation succeed only if there is a live version of the object.
       */
      public Long getIfGenerationNotMatch() {
        return ifGenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the destination object's current generation does
       * not match the given value. If no live object exists, the precondition fails. Setting to 0
       * makes the operation succeed only if there is a live version of the object.
       */
      public Copy setIfGenerationNotMatch(Long ifGenerationNotMatch) {
        this.ifGenerationNotMatch = ifGenerationNotMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the destination object's current metageneration
       * matches the given value.
       */
      @com.google.api.client.util.Key private Long ifMetagenerationMatch;

      /**
       * Makes the operation conditional on whether the destination object's current metageneration
       * matches the given value.
       */
      public Long getIfMetagenerationMatch() {
        return ifMetagenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the destination object's current metageneration
       * matches the given value.
       */
      public Copy setIfMetagenerationMatch(Long ifMetagenerationMatch) {
        this.ifMetagenerationMatch = ifMetagenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the destination object's current metageneration
       * does not match the given value.
       */
      @com.google.api.client.util.Key private Long ifMetagenerationNotMatch;

      /**
       * Makes the operation conditional on whether the destination object's current metageneration
       * does not match the given value.
       */
      public Long getIfMetagenerationNotMatch() {
        return ifMetagenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the destination object's current metageneration
       * does not match the given value.
       */
      public Copy setIfMetagenerationNotMatch(Long ifMetagenerationNotMatch) {
        this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the source object's current generation matches
       * the given value.
       */
      @com.google.api.client.util.Key private Long ifSourceGenerationMatch;

      /**
       * Makes the operation conditional on whether the source object's current generation matches
       * the given value.
       */
      public Long getIfSourceGenerationMatch() {
        return ifSourceGenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the source object's current generation matches
       * the given value.
       */
      public Copy setIfSourceGenerationMatch(Long ifSourceGenerationMatch) {
        this.ifSourceGenerationMatch = ifSourceGenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the source object's current generation does not
       * match the given value.
       */
      @com.google.api.client.util.Key private Long ifSourceGenerationNotMatch;

      /**
       * Makes the operation conditional on whether the source object's current generation does not
       * match the given value.
       */
      public Long getIfSourceGenerationNotMatch() {
        return ifSourceGenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the source object's current generation does not
       * match the given value.
       */
      public Copy setIfSourceGenerationNotMatch(Long ifSourceGenerationNotMatch) {
        this.ifSourceGenerationNotMatch = ifSourceGenerationNotMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the source object's current metageneration
       * matches the given value.
       */
      @com.google.api.client.util.Key private Long ifSourceMetagenerationMatch;

      /**
       * Makes the operation conditional on whether the source object's current metageneration
       * matches the given value.
       */
      public Long getIfSourceMetagenerationMatch() {
        return ifSourceMetagenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the source object's current metageneration
       * matches the given value.
       */
      public Copy setIfSourceMetagenerationMatch(Long ifSourceMetagenerationMatch) {
        this.ifSourceMetagenerationMatch = ifSourceMetagenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the source object's current metageneration does
       * not match the given value.
       */
      @com.google.api.client.util.Key private Long ifSourceMetagenerationNotMatch;

      /**
       * Makes the operation conditional on whether the source object's current metageneration does
       * not match the given value.
       */
      public Long getIfSourceMetagenerationNotMatch() {
        return ifSourceMetagenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the source object's current metageneration does
       * not match the given value.
       */
      public Copy setIfSourceMetagenerationNotMatch(Long ifSourceMetagenerationNotMatch) {
        this.ifSourceMetagenerationNotMatch = ifSourceMetagenerationNotMatch;
        return this;
      }

      /**
       * Set of properties to return. Defaults to noAcl, unless the object resource specifies the
       * acl property, when it defaults to full.
       */
      @com.google.api.client.util.Key private String projection;

      /**
       * Set of properties to return. Defaults to noAcl, unless the object resource specifies the
       * acl property, when it defaults to full.
       */
      public String getProjection() {
        return projection;
      }

      /**
       * Set of properties to return. Defaults to noAcl, unless the object resource specifies the
       * acl property, when it defaults to full.
       */
      public Copy setProjection(String projection) {
        this.projection = projection;
        return this;
      }

      /**
       * If present, selects a specific revision of the source object (as opposed to the latest
       * version, the default).
       */
      @com.google.api.client.util.Key private Long sourceGeneration;

      /**
       * If present, selects a specific revision of the source object (as opposed to the latest
       * version, the default).
       */
      public Long getSourceGeneration() {
        return sourceGeneration;
      }

      /**
       * If present, selects a specific revision of the source object (as opposed to the latest
       * version, the default).
       */
      public Copy setSourceGeneration(Long sourceGeneration) {
        this.sourceGeneration = sourceGeneration;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public Copy setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Copy set(String parameterName, Object value) {
        return (Copy) super.set(parameterName, value);
      }
    }
    /**
     * Deletes an object and its metadata. Deletions are permanent if versioning is not enabled for
     * the bucket, or if the generation parameter is used.
     *
     * <p>Create a request for the method "objects.delete".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of the bucket in which the object resides.
     * @param object__ Name of the object. For information about how to URL encode object names to
     *     be path safe, see Encoding URI Path Parts.
     * @return the request
     */
    public Delete delete(String bucket, String object__) throws java.io.IOException {
      Delete result = new Delete(bucket, object__);
      initialize(result);
      return result;
    }

    public class Delete extends com.google.api.services.storage.preprod.StorageRequest<Void> {

      private static final String REST_PATH = "b/{bucket}/o/{object}";

      /**
       * Deletes an object and its metadata. Deletions are permanent if versioning is not enabled
       * for the bucket, or if the generation parameter is used.
       *
       * <p>Create a request for the method "objects.delete".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of the bucket in which the object resides.
       * @param object__ Name of the object. For information about how to URL encode object names to
       *     be path safe, see Encoding URI Path Parts.
       * @since 1.13
       */
      protected Delete(String bucket, String object__) {
        super(Storage.this, "DELETE", REST_PATH, null, Void.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        this.object__ =
            com.google.api.client.util.Preconditions.checkNotNull(
                object__, "Required parameter object__ must be specified.");
      }

      @Override
      public Delete setAlt(String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUserIp(String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the bucket in which the object resides. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of the bucket in which the object resides. */
      public String getBucket() {
        return bucket;
      }

      /** Name of the bucket in which the object resides. */
      public Delete setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      @com.google.api.client.util.Key("object")
      private String object__;

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      public String getObject() {
        return object__;
      }

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      public Delete setObject(String object__) {
        this.object__ = object__;
        return this;
      }

      /**
       * If present, permanently deletes a specific revision of this object (as opposed to the
       * latest version, the default).
       */
      @com.google.api.client.util.Key private Long generation;

      /**
       * If present, permanently deletes a specific revision of this object (as opposed to the
       * latest version, the default).
       */
      public Long getGeneration() {
        return generation;
      }

      /**
       * If present, permanently deletes a specific revision of this object (as opposed to the
       * latest version, the default).
       */
      public Delete setGeneration(Long generation) {
        this.generation = generation;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value. Setting to 0 makes the operation succeed only if there are no live versions of
       * the object.
       */
      @com.google.api.client.util.Key private Long ifGenerationMatch;

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value. Setting to 0 makes the operation succeed only if there are no live versions of
       * the object.
       */
      public Long getIfGenerationMatch() {
        return ifGenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value. Setting to 0 makes the operation succeed only if there are no live versions of
       * the object.
       */
      public Delete setIfGenerationMatch(Long ifGenerationMatch) {
        this.ifGenerationMatch = ifGenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current generation does not match
       * the given value. If no live object exists, the precondition fails. Setting to 0 makes the
       * operation succeed only if there is a live version of the object.
       */
      @com.google.api.client.util.Key private Long ifGenerationNotMatch;

      /**
       * Makes the operation conditional on whether the object's current generation does not match
       * the given value. If no live object exists, the precondition fails. Setting to 0 makes the
       * operation succeed only if there is a live version of the object.
       */
      public Long getIfGenerationNotMatch() {
        return ifGenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current generation does not match
       * the given value. If no live object exists, the precondition fails. Setting to 0 makes the
       * operation succeed only if there is a live version of the object.
       */
      public Delete setIfGenerationNotMatch(Long ifGenerationNotMatch) {
        this.ifGenerationNotMatch = ifGenerationNotMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      @com.google.api.client.util.Key private Long ifMetagenerationMatch;

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      public Long getIfMetagenerationMatch() {
        return ifMetagenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      public Delete setIfMetagenerationMatch(Long ifMetagenerationMatch) {
        this.ifMetagenerationMatch = ifMetagenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration does not
       * match the given value.
       */
      @com.google.api.client.util.Key private Long ifMetagenerationNotMatch;

      /**
       * Makes the operation conditional on whether the object's current metageneration does not
       * match the given value.
       */
      public Long getIfMetagenerationNotMatch() {
        return ifMetagenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration does not
       * match the given value.
       */
      public Delete setIfMetagenerationNotMatch(Long ifMetagenerationNotMatch) {
        this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public Delete setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves an object or its metadata.
     *
     * <p>Create a request for the method "objects.get".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of the bucket in which the object resides.
     * @param object__ Name of the object. For information about how to URL encode object names to
     *     be path safe, see Encoding URI Path Parts.
     * @return the request
     */
    public Get get(String bucket, String object__) throws java.io.IOException {
      Get result = new Get(bucket, object__);
      initialize(result);
      return result;
    }

    public class Get extends com.google.api.services.storage.preprod.StorageRequest<StorageObject> {

      private static final String REST_PATH = "b/{bucket}/o/{object}";

      /**
       * Retrieves an object or its metadata.
       *
       * <p>Create a request for the method "objects.get".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * <p>{@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of the bucket in which the object resides.
       * @param object__ Name of the object. For information about how to URL encode object names to
       *     be path safe, see Encoding URI Path Parts.
       * @since 1.13
       */
      protected Get(String bucket, String object__) {
        super(
            Storage.this,
            "GET",
            REST_PATH,
            null,
            com.google.api.services.storage.model.StorageObject.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        this.object__ =
            com.google.api.client.util.Preconditions.checkNotNull(
                object__, "Required parameter object__ must be specified.");
        initializeMediaDownload();
      }

      @Override
      public void executeMediaAndDownloadTo(java.io.OutputStream outputStream)
          throws java.io.IOException {
        super.executeMediaAndDownloadTo(outputStream);
      }

      @Override
      public java.io.InputStream executeMediaAsInputStream() throws java.io.IOException {
        return super.executeMediaAsInputStream();
      }

      @Override
      public com.google.api.client.http.HttpResponse executeMedia() throws java.io.IOException {
        return super.executeMedia();
      }

      @Override
      public com.google.api.client.http.GenericUrl buildHttpRequestUrl() {
        String baseUrl =
            ("media".equals(get("alt")) && getMediaHttpUploader() == null)
                ? getRootUrl() + "download/" + getServicePath()
                : getBaseUrl();
        return new com.google.api.client.http.GenericUrl(
            com.google.api.client.http.UriTemplate.expand(baseUrl, getUriTemplate(), this, true));
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead()
          throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUserIp(String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the bucket in which the object resides. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of the bucket in which the object resides. */
      public String getBucket() {
        return bucket;
      }

      /** Name of the bucket in which the object resides. */
      public Get setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      @com.google.api.client.util.Key("object")
      private String object__;

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      public String getObject() {
        return object__;
      }

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      public Get setObject(String object__) {
        this.object__ = object__;
        return this;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      @com.google.api.client.util.Key private Long generation;

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public Long getGeneration() {
        return generation;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public Get setGeneration(Long generation) {
        this.generation = generation;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value. Setting to 0 makes the operation succeed only if there are no live versions of
       * the object.
       */
      @com.google.api.client.util.Key private Long ifGenerationMatch;

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value. Setting to 0 makes the operation succeed only if there are no live versions of
       * the object.
       */
      public Long getIfGenerationMatch() {
        return ifGenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value. Setting to 0 makes the operation succeed only if there are no live versions of
       * the object.
       */
      public Get setIfGenerationMatch(Long ifGenerationMatch) {
        this.ifGenerationMatch = ifGenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current generation does not match
       * the given value. If no live object exists, the precondition fails. Setting to 0 makes the
       * operation succeed only if there is a live version of the object.
       */
      @com.google.api.client.util.Key private Long ifGenerationNotMatch;

      /**
       * Makes the operation conditional on whether the object's current generation does not match
       * the given value. If no live object exists, the precondition fails. Setting to 0 makes the
       * operation succeed only if there is a live version of the object.
       */
      public Long getIfGenerationNotMatch() {
        return ifGenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current generation does not match
       * the given value. If no live object exists, the precondition fails. Setting to 0 makes the
       * operation succeed only if there is a live version of the object.
       */
      public Get setIfGenerationNotMatch(Long ifGenerationNotMatch) {
        this.ifGenerationNotMatch = ifGenerationNotMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      @com.google.api.client.util.Key private Long ifMetagenerationMatch;

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      public Long getIfMetagenerationMatch() {
        return ifMetagenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      public Get setIfMetagenerationMatch(Long ifMetagenerationMatch) {
        this.ifMetagenerationMatch = ifMetagenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration does not
       * match the given value.
       */
      @com.google.api.client.util.Key private Long ifMetagenerationNotMatch;

      /**
       * Makes the operation conditional on whether the object's current metageneration does not
       * match the given value.
       */
      public Long getIfMetagenerationNotMatch() {
        return ifMetagenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration does not
       * match the given value.
       */
      public Get setIfMetagenerationNotMatch(Long ifMetagenerationNotMatch) {
        this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
        return this;
      }

      /** Set of properties to return. Defaults to noAcl. */
      @com.google.api.client.util.Key private String projection;

      /** Set of properties to return. Defaults to noAcl. */
      public String getProjection() {
        return projection;
      }

      /** Set of properties to return. Defaults to noAcl. */
      public Get setProjection(String projection) {
        this.projection = projection;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public Get setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Returns an IAM policy for the specified object.
     *
     * <p>Create a request for the method "objects.getIamPolicy".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of the bucket in which the object resides.
     * @param object__ Name of the object. For information about how to URL encode object names to
     *     be path safe, see Encoding URI Path Parts.
     * @return the request
     */
    public GetIamPolicy getIamPolicy(String bucket, String object__) throws java.io.IOException {
      GetIamPolicy result = new GetIamPolicy(bucket, object__);
      initialize(result);
      return result;
    }

    public class GetIamPolicy
        extends com.google.api.services.storage.preprod.StorageRequest<Policy> {

      private static final String REST_PATH = "b/{bucket}/o/{object}/iam";

      /**
       * Returns an IAM policy for the specified object.
       *
       * <p>Create a request for the method "objects.getIamPolicy".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of the bucket in which the object resides.
       * @param object__ Name of the object. For information about how to URL encode object names to
       *     be path safe, see Encoding URI Path Parts.
       * @since 1.13
       */
      protected GetIamPolicy(String bucket, String object__) {
        super(
            Storage.this,
            "GET",
            REST_PATH,
            null,
            com.google.api.services.storage.model.Policy.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        this.object__ =
            com.google.api.client.util.Preconditions.checkNotNull(
                object__, "Required parameter object__ must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead()
          throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetIamPolicy setAlt(String alt) {
        return (GetIamPolicy) super.setAlt(alt);
      }

      @Override
      public GetIamPolicy setFields(String fields) {
        return (GetIamPolicy) super.setFields(fields);
      }

      @Override
      public GetIamPolicy setKey(String key) {
        return (GetIamPolicy) super.setKey(key);
      }

      @Override
      public GetIamPolicy setOauthToken(String oauthToken) {
        return (GetIamPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
        return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetIamPolicy setQuotaUser(String quotaUser) {
        return (GetIamPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetIamPolicy setUploadType(String uploadType) {
        return (GetIamPolicy) super.setUploadType(uploadType);
      }

      @Override
      public GetIamPolicy setUserIp(String userIp) {
        return (GetIamPolicy) super.setUserIp(userIp);
      }

      /** Name of the bucket in which the object resides. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of the bucket in which the object resides. */
      public String getBucket() {
        return bucket;
      }

      /** Name of the bucket in which the object resides. */
      public GetIamPolicy setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      @com.google.api.client.util.Key("object")
      private String object__;

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      public String getObject() {
        return object__;
      }

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      public GetIamPolicy setObject(String object__) {
        this.object__ = object__;
        return this;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      @com.google.api.client.util.Key private Long generation;

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public Long getGeneration() {
        return generation;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public GetIamPolicy setGeneration(Long generation) {
        this.generation = generation;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public GetIamPolicy setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public GetIamPolicy set(String parameterName, Object value) {
        return (GetIamPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Stores a new object and metadata.
     *
     * <p>Create a request for the method "objects.insert".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of the bucket in which to store the new object. Overrides the provided
     *     object metadata's bucket value, if any.
     * @param content the {@link com.google.api.services.storage.model.StorageObject}
     * @return the request
     */
    public Insert insert(String bucket, com.google.api.services.storage.model.StorageObject content)
        throws java.io.IOException {
      Insert result = new Insert(bucket, content);
      initialize(result);
      return result;
    }

    /**
     * Stores a new object and metadata.
     *
     * <p>Create a request for the method "objects.insert".
     *
     * <p>This request holds the parameters needed by the the storage server. After setting any
     * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * <p>This method should be used for uploading media content.
     *
     * @param bucket Name of the bucket in which to store the new object. Overrides the provided
     *     object metadata's bucket value, if any.
     * @param content the {@link com.google.api.services.storage.model.StorageObject} media metadata
     *     or {@code null} if none
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Insert insert(
        String bucket,
        com.google.api.services.storage.model.StorageObject content,
        com.google.api.client.http.AbstractInputStreamContent mediaContent)
        throws java.io.IOException {
      Insert result = new Insert(bucket, content, mediaContent);
      initialize(result);
      return result;
    }

    public class Insert
        extends com.google.api.services.storage.preprod.StorageRequest<StorageObject> {

      private static final String REST_PATH = "b/{bucket}/o";

      /**
       * Stores a new object and metadata.
       *
       * <p>Create a request for the method "objects.insert".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of the bucket in which to store the new object. Overrides the provided
       *     object metadata's bucket value, if any.
       * @param content the {@link com.google.api.services.storage.model.StorageObject}
       * @since 1.13
       */
      protected Insert(String bucket, com.google.api.services.storage.model.StorageObject content) {
        super(
            Storage.this,
            "POST",
            REST_PATH,
            content,
            com.google.api.services.storage.model.StorageObject.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
      }

      /**
       * Stores a new object and metadata.
       *
       * <p>Create a request for the method "objects.insert".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * <p>This constructor should be used for uploading media content.
       *
       * @param bucket Name of the bucket in which to store the new object. Overrides the provided
       *     object metadata's bucket value, if any.
       * @param content the {@link com.google.api.services.storage.model.StorageObject} media
       *     metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Insert(
          String bucket,
          com.google.api.services.storage.model.StorageObject content,
          com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(
            Storage.this,
            "POST",
            "/upload/" + getServicePath() + REST_PATH,
            content,
            com.google.api.services.storage.model.StorageObject.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Insert setAlt(String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUserIp(String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * Name of the bucket in which to store the new object. Overrides the provided object
       * metadata's bucket value, if any.
       */
      @com.google.api.client.util.Key private String bucket;

      /**
       * Name of the bucket in which to store the new object. Overrides the provided object
       * metadata's bucket value, if any.
       */
      public String getBucket() {
        return bucket;
      }

      /**
       * Name of the bucket in which to store the new object. Overrides the provided object
       * metadata's bucket value, if any.
       */
      public Insert setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * If set, sets the contentEncoding property of the final object to this value. Setting this
       * parameter is equivalent to setting the contentEncoding metadata property. This can be
       * useful when uploading an object with uploadType=media to indicate the encoding of the
       * content being uploaded.
       */
      @com.google.api.client.util.Key private String contentEncoding;

      /**
       * If set, sets the contentEncoding property of the final object to this value. Setting this
       * parameter is equivalent to setting the contentEncoding metadata property. This can be
       * useful when uploading an object with uploadType=media to indicate the encoding of the
       * content being uploaded.
       */
      public String getContentEncoding() {
        return contentEncoding;
      }

      /**
       * If set, sets the contentEncoding property of the final object to this value. Setting this
       * parameter is equivalent to setting the contentEncoding metadata property. This can be
       * useful when uploading an object with uploadType=media to indicate the encoding of the
       * content being uploaded.
       */
      public Insert setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value. Setting to 0 makes the operation succeed only if there are no live versions of
       * the object.
       */
      @com.google.api.client.util.Key private Long ifGenerationMatch;

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value. Setting to 0 makes the operation succeed only if there are no live versions of
       * the object.
       */
      public Long getIfGenerationMatch() {
        return ifGenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value. Setting to 0 makes the operation succeed only if there are no live versions of
       * the object.
       */
      public Insert setIfGenerationMatch(Long ifGenerationMatch) {
        this.ifGenerationMatch = ifGenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current generation does not match
       * the given value. If no live object exists, the precondition fails. Setting to 0 makes the
       * operation succeed only if there is a live version of the object.
       */
      @com.google.api.client.util.Key private Long ifGenerationNotMatch;

      /**
       * Makes the operation conditional on whether the object's current generation does not match
       * the given value. If no live object exists, the precondition fails. Setting to 0 makes the
       * operation succeed only if there is a live version of the object.
       */
      public Long getIfGenerationNotMatch() {
        return ifGenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current generation does not match
       * the given value. If no live object exists, the precondition fails. Setting to 0 makes the
       * operation succeed only if there is a live version of the object.
       */
      public Insert setIfGenerationNotMatch(Long ifGenerationNotMatch) {
        this.ifGenerationNotMatch = ifGenerationNotMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      @com.google.api.client.util.Key private Long ifMetagenerationMatch;

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      public Long getIfMetagenerationMatch() {
        return ifMetagenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      public Insert setIfMetagenerationMatch(Long ifMetagenerationMatch) {
        this.ifMetagenerationMatch = ifMetagenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration does not
       * match the given value.
       */
      @com.google.api.client.util.Key private Long ifMetagenerationNotMatch;

      /**
       * Makes the operation conditional on whether the object's current metageneration does not
       * match the given value.
       */
      public Long getIfMetagenerationNotMatch() {
        return ifMetagenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration does not
       * match the given value.
       */
      public Insert setIfMetagenerationNotMatch(Long ifMetagenerationNotMatch) {
        this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
        return this;
      }

      /**
       * Resource name of the Cloud KMS key, of the form projects/my-
       * project/locations/global/keyRings/my-kr/cryptoKeys/my-key, that will be used to encrypt the
       * object. Overrides the object metadata's kms_key_name value, if any.
       */
      @com.google.api.client.util.Key private String kmsKeyName;

      /**
       * Resource name of the Cloud KMS key, of the form
       * projects/my-project/locations/global/keyRings/my- kr/cryptoKeys/my-key, that will be used
       * to encrypt the object. Overrides the object metadata's kms_key_name value, if any.
       */
      public String getKmsKeyName() {
        return kmsKeyName;
      }

      /**
       * Resource name of the Cloud KMS key, of the form projects/my-
       * project/locations/global/keyRings/my-kr/cryptoKeys/my-key, that will be used to encrypt the
       * object. Overrides the object metadata's kms_key_name value, if any.
       */
      public Insert setKmsKeyName(String kmsKeyName) {
        this.kmsKeyName = kmsKeyName;
        return this;
      }

      /**
       * Name of the object. Required when the object metadata is not otherwise provided. Overrides
       * the object metadata's name value, if any. For information about how to URL encode object
       * names to be path safe, see Encoding URI Path Parts.
       */
      @com.google.api.client.util.Key private String name;

      /**
       * Name of the object. Required when the object metadata is not otherwise provided. Overrides
       * the object metadata's name value, if any. For information about how to URL encode object
       * names to be path safe, see Encoding URI Path Parts.
       */
      public String getName() {
        return name;
      }

      /**
       * Name of the object. Required when the object metadata is not otherwise provided. Overrides
       * the object metadata's name value, if any. For information about how to URL encode object
       * names to be path safe, see Encoding URI Path Parts.
       */
      public Insert setName(String name) {
        this.name = name;
        return this;
      }

      /** Apply a predefined set of access controls to this object. */
      @com.google.api.client.util.Key private String predefinedAcl;

      /** Apply a predefined set of access controls to this object. */
      public String getPredefinedAcl() {
        return predefinedAcl;
      }

      /** Apply a predefined set of access controls to this object. */
      public Insert setPredefinedAcl(String predefinedAcl) {
        this.predefinedAcl = predefinedAcl;
        return this;
      }

      /**
       * Set of properties to return. Defaults to noAcl, unless the object resource specifies the
       * acl property, when it defaults to full.
       */
      @com.google.api.client.util.Key private String projection;

      /**
       * Set of properties to return. Defaults to noAcl, unless the object resource specifies the
       * acl property, when it defaults to full.
       */
      public String getProjection() {
        return projection;
      }

      /**
       * Set of properties to return. Defaults to noAcl, unless the object resource specifies the
       * acl property, when it defaults to full.
       */
      public Insert setProjection(String projection) {
        this.projection = projection;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public Insert setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of objects matching the criteria.
     *
     * <p>Create a request for the method "objects.list".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of the bucket in which to look for objects.
     * @return the request
     */
    public List list(String bucket) throws java.io.IOException {
      List result = new List(bucket);
      initialize(result);
      return result;
    }

    public class List
        extends com.google.api.services.storage.preprod.StorageRequest<
            com.google.api.services.storage.model.Objects> {

      private static final String REST_PATH = "b/{bucket}/o";

      /**
       * Retrieves a list of objects matching the criteria.
       *
       * <p>Create a request for the method "objects.list".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * <p>{@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of the bucket in which to look for objects.
       * @since 1.13
       */
      protected List(String bucket) {
        super(
            Storage.this,
            "GET",
            REST_PATH,
            null,
            com.google.api.services.storage.model.Objects.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead()
          throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUserIp(String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Name of the bucket in which to look for objects. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of the bucket in which to look for objects. */
      public String getBucket() {
        return bucket;
      }

      /** Name of the bucket in which to look for objects. */
      public List setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * Returns results in a directory-like mode. items will contain only objects whose names,
       * aside from the prefix, do not contain delimiter. Objects whose names, aside from the
       * prefix, contain delimiter will have their name, truncated after the delimiter, returned in
       * prefixes. Duplicate prefixes are omitted.
       */
      @com.google.api.client.util.Key private String delimiter;

      /**
       * Returns results in a directory-like mode. items will contain only objects whose names,
       * aside from the prefix, do not contain delimiter. Objects whose names, aside from the
       * prefix, contain delimiter will have their name, truncated after the delimiter, returned in
       * prefixes. Duplicate prefixes are omitted.
       */
      public String getDelimiter() {
        return delimiter;
      }

      /**
       * Returns results in a directory-like mode. items will contain only objects whose names,
       * aside from the prefix, do not contain delimiter. Objects whose names, aside from the
       * prefix, contain delimiter will have their name, truncated after the delimiter, returned in
       * prefixes. Duplicate prefixes are omitted.
       */
      public List setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
      }

      /**
       * Filter results to objects whose names are lexicographically before endOffset. If
       * startOffset is also set, the objects listed will have names between startOffset (inclusive)
       * and endOffset (exclusive).
       */
      @com.google.api.client.util.Key private String endOffset;

      /**
       * Filter results to objects whose names are lexicographically before endOffset. If
       * startOffset is also set, the objects listed will have names between startOffset (inclusive)
       * and endOffset (exclusive).
       */
      public String getEndOffset() {
        return endOffset;
      }

      /**
       * Filter results to objects whose names are lexicographically before endOffset. If
       * startOffset is also set, the objects listed will have names between startOffset (inclusive)
       * and endOffset (exclusive).
       */
      public List setEndOffset(String endOffset) {
        this.endOffset = endOffset;
        return this;
      }

      /**
       * If true, objects that end in exactly one instance of delimiter will have their metadata
       * included in items in addition to prefixes.
       */
      @com.google.api.client.util.Key private Boolean includeTrailingDelimiter;

      /**
       * If true, objects that end in exactly one instance of delimiter will have their metadata
       * included in items in addition to prefixes.
       */
      public Boolean getIncludeTrailingDelimiter() {
        return includeTrailingDelimiter;
      }

      /**
       * If true, objects that end in exactly one instance of delimiter will have their metadata
       * included in items in addition to prefixes.
       */
      public List setIncludeTrailingDelimiter(Boolean includeTrailingDelimiter) {
        this.includeTrailingDelimiter = includeTrailingDelimiter;
        return this;
      }

      /**
       * Maximum number of items plus prefixes to return in a single page of responses. As duplicate
       * prefixes are omitted, fewer total results may be returned than requested. The service will
       * use this parameter or 1,000 items, whichever is smaller.
       */
      @com.google.api.client.util.Key private Long maxResults;

      /**
       * Maximum number of items plus prefixes to return in a single page of responses. As duplicate
       * prefixes are omitted, fewer total results may be returned than requested. The service will
       * use this parameter or 1,000 items, whichever is smaller. [default: 1000] [minimum: 0]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /**
       * Maximum number of items plus prefixes to return in a single page of responses. As duplicate
       * prefixes are omitted, fewer total results may be returned than requested. The service will
       * use this parameter or 1,000 items, whichever is smaller.
       */
      public List setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * A previously-returned page token representing part of the larger set of results to view.
       */
      @com.google.api.client.util.Key private String pageToken;

      /**
       * A previously-returned page token representing part of the larger set of results to view.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
       * A previously-returned page token representing part of the larger set of results to view.
       */
      public List setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Filter results to objects whose names begin with this prefix. */
      @com.google.api.client.util.Key private String prefix;

      /** Filter results to objects whose names begin with this prefix. */
      public String getPrefix() {
        return prefix;
      }

      /** Filter results to objects whose names begin with this prefix. */
      public List setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
      }

      /** Set of properties to return. Defaults to noAcl. */
      @com.google.api.client.util.Key private String projection;

      /** Set of properties to return. Defaults to noAcl. */
      public String getProjection() {
        return projection;
      }

      /** Set of properties to return. Defaults to noAcl. */
      public List setProjection(String projection) {
        this.projection = projection;
        return this;
      }

      /**
       * Filter results to objects whose names are lexicographically equal to or after startOffset.
       * If endOffset is also set, the objects listed will have names between startOffset
       * (inclusive) and endOffset (exclusive).
       */
      @com.google.api.client.util.Key private String startOffset;

      /**
       * Filter results to objects whose names are lexicographically equal to or after startOffset.
       * If endOffset is also set, the objects listed will have names between startOffset
       * (inclusive) and endOffset (exclusive).
       */
      public String getStartOffset() {
        return startOffset;
      }

      /**
       * Filter results to objects whose names are lexicographically equal to or after startOffset.
       * If endOffset is also set, the objects listed will have names between startOffset
       * (inclusive) and endOffset (exclusive).
       */
      public List setStartOffset(String startOffset) {
        this.startOffset = startOffset;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public List setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      /**
       * If true, lists all versions of an object as distinct results. The default is false. For
       * more information, see Object Versioning.
       */
      @com.google.api.client.util.Key private Boolean versions;

      /**
       * If true, lists all versions of an object as distinct results. The default is false. For
       * more information, see Object Versioning.
       */
      public Boolean getVersions() {
        return versions;
      }

      /**
       * If true, lists all versions of an object as distinct results. The default is false. For
       * more information, see Object Versioning.
       */
      public List setVersions(Boolean versions) {
        this.versions = versions;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Patches an object's metadata.
     *
     * <p>Create a request for the method "objects.patch".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of the bucket in which the object resides.
     * @param object__ Name of the object. For information about how to URL encode object names to
     *     be path safe, see Encoding URI Path Parts.
     * @param content the {@link com.google.api.services.storage.model.StorageObject}
     * @return the request
     */
    public Patch patch(
        String bucket, String object__, com.google.api.services.storage.model.StorageObject content)
        throws java.io.IOException {
      Patch result = new Patch(bucket, object__, content);
      initialize(result);
      return result;
    }

    public class Patch
        extends com.google.api.services.storage.preprod.StorageRequest<StorageObject> {

      private static final String REST_PATH = "b/{bucket}/o/{object}";

      /**
       * Patches an object's metadata.
       *
       * <p>Create a request for the method "objects.patch".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of the bucket in which the object resides.
       * @param object__ Name of the object. For information about how to URL encode object names to
       *     be path safe, see Encoding URI Path Parts.
       * @param content the {@link com.google.api.services.storage.model.StorageObject}
       * @since 1.13
       */
      protected Patch(
          String bucket,
          String object__,
          com.google.api.services.storage.model.StorageObject content) {
        super(
            Storage.this,
            "PATCH",
            REST_PATH,
            content,
            com.google.api.services.storage.model.StorageObject.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        this.object__ =
            com.google.api.client.util.Preconditions.checkNotNull(
                object__, "Required parameter object__ must be specified.");
      }

      @Override
      public Patch setAlt(String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUserIp(String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Name of the bucket in which the object resides. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of the bucket in which the object resides. */
      public String getBucket() {
        return bucket;
      }

      /** Name of the bucket in which the object resides. */
      public Patch setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      @com.google.api.client.util.Key("object")
      private String object__;

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      public String getObject() {
        return object__;
      }

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      public Patch setObject(String object__) {
        this.object__ = object__;
        return this;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      @com.google.api.client.util.Key private Long generation;

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public Long getGeneration() {
        return generation;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public Patch setGeneration(Long generation) {
        this.generation = generation;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value. Setting to 0 makes the operation succeed only if there are no live versions of
       * the object.
       */
      @com.google.api.client.util.Key private Long ifGenerationMatch;

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value. Setting to 0 makes the operation succeed only if there are no live versions of
       * the object.
       */
      public Long getIfGenerationMatch() {
        return ifGenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value. Setting to 0 makes the operation succeed only if there are no live versions of
       * the object.
       */
      public Patch setIfGenerationMatch(Long ifGenerationMatch) {
        this.ifGenerationMatch = ifGenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current generation does not match
       * the given value. If no live object exists, the precondition fails. Setting to 0 makes the
       * operation succeed only if there is a live version of the object.
       */
      @com.google.api.client.util.Key private Long ifGenerationNotMatch;

      /**
       * Makes the operation conditional on whether the object's current generation does not match
       * the given value. If no live object exists, the precondition fails. Setting to 0 makes the
       * operation succeed only if there is a live version of the object.
       */
      public Long getIfGenerationNotMatch() {
        return ifGenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current generation does not match
       * the given value. If no live object exists, the precondition fails. Setting to 0 makes the
       * operation succeed only if there is a live version of the object.
       */
      public Patch setIfGenerationNotMatch(Long ifGenerationNotMatch) {
        this.ifGenerationNotMatch = ifGenerationNotMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      @com.google.api.client.util.Key private Long ifMetagenerationMatch;

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      public Long getIfMetagenerationMatch() {
        return ifMetagenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      public Patch setIfMetagenerationMatch(Long ifMetagenerationMatch) {
        this.ifMetagenerationMatch = ifMetagenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration does not
       * match the given value.
       */
      @com.google.api.client.util.Key private Long ifMetagenerationNotMatch;

      /**
       * Makes the operation conditional on whether the object's current metageneration does not
       * match the given value.
       */
      public Long getIfMetagenerationNotMatch() {
        return ifMetagenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration does not
       * match the given value.
       */
      public Patch setIfMetagenerationNotMatch(Long ifMetagenerationNotMatch) {
        this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
        return this;
      }

      /** Apply a predefined set of access controls to this object. */
      @com.google.api.client.util.Key private String predefinedAcl;

      /** Apply a predefined set of access controls to this object. */
      public String getPredefinedAcl() {
        return predefinedAcl;
      }

      /** Apply a predefined set of access controls to this object. */
      public Patch setPredefinedAcl(String predefinedAcl) {
        this.predefinedAcl = predefinedAcl;
        return this;
      }

      /** Set of properties to return. Defaults to full. */
      @com.google.api.client.util.Key private String projection;

      /** Set of properties to return. Defaults to full. */
      public String getProjection() {
        return projection;
      }

      /** Set of properties to return. Defaults to full. */
      public Patch setProjection(String projection) {
        this.projection = projection;
        return this;
      }

      /** The project to be billed for this request, for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request, for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request, for Requester Pays buckets. */
      public Patch setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Rewrites a source object to a destination object. Optionally overrides metadata.
     *
     * <p>Create a request for the method "objects.rewrite".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Rewrite#execute()} method to invoke the remote operation.
     *
     * @param sourceBucket Name of the bucket in which to find the source object.
     * @param sourceObject Name of the source object. For information about how to URL encode object
     *     names to be path safe, see Encoding URI Path Parts.
     * @param destinationBucket Name of the bucket in which to store the new object. Overrides the
     *     provided object metadata's bucket value, if any.
     * @param destinationObject Name of the new object. Required when the object metadata is not
     *     otherwise provided. Overrides the object metadata's name value, if any. For information
     *     about how to URL encode object names to be path safe, see Encoding URI Path Parts.
     * @param content the {@link com.google.api.services.storage.model.StorageObject}
     * @return the request
     */
    public Rewrite rewrite(
        String sourceBucket,
        String sourceObject,
        String destinationBucket,
        String destinationObject,
        com.google.api.services.storage.model.StorageObject content)
        throws java.io.IOException {
      Rewrite result =
          new Rewrite(sourceBucket, sourceObject, destinationBucket, destinationObject, content);
      initialize(result);
      return result;
    }

    public class Rewrite
        extends com.google.api.services.storage.preprod.StorageRequest<RewriteResponse> {

      private static final String REST_PATH =
          "b/{sourceBucket}/o/{sourceObject}/rewriteTo/b/{destinationBucket}/o/{destinationObject}";

      /**
       * Rewrites a source object to a destination object. Optionally overrides metadata.
       *
       * <p>Create a request for the method "objects.rewrite".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Rewrite#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * Rewrite#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param sourceBucket Name of the bucket in which to find the source object.
       * @param sourceObject Name of the source object. For information about how to URL encode
       *     object names to be path safe, see Encoding URI Path Parts.
       * @param destinationBucket Name of the bucket in which to store the new object. Overrides the
       *     provided object metadata's bucket value, if any.
       * @param destinationObject Name of the new object. Required when the object metadata is not
       *     otherwise provided. Overrides the object metadata's name value, if any. For information
       *     about how to URL encode object names to be path safe, see Encoding URI Path Parts.
       * @param content the {@link com.google.api.services.storage.model.StorageObject}
       * @since 1.13
       */
      protected Rewrite(
          String sourceBucket,
          String sourceObject,
          String destinationBucket,
          String destinationObject,
          com.google.api.services.storage.model.StorageObject content) {
        super(
            Storage.this,
            "POST",
            REST_PATH,
            content,
            com.google.api.services.storage.model.RewriteResponse.class);
        this.sourceBucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                sourceBucket, "Required parameter sourceBucket must be specified.");
        this.sourceObject =
            com.google.api.client.util.Preconditions.checkNotNull(
                sourceObject, "Required parameter sourceObject must be specified.");
        this.destinationBucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                destinationBucket, "Required parameter destinationBucket must be specified.");
        this.destinationObject =
            com.google.api.client.util.Preconditions.checkNotNull(
                destinationObject, "Required parameter destinationObject must be specified.");
      }

      @Override
      public Rewrite setAlt(String alt) {
        return (Rewrite) super.setAlt(alt);
      }

      @Override
      public Rewrite setFields(String fields) {
        return (Rewrite) super.setFields(fields);
      }

      @Override
      public Rewrite setKey(String key) {
        return (Rewrite) super.setKey(key);
      }

      @Override
      public Rewrite setOauthToken(String oauthToken) {
        return (Rewrite) super.setOauthToken(oauthToken);
      }

      @Override
      public Rewrite setPrettyPrint(Boolean prettyPrint) {
        return (Rewrite) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Rewrite setQuotaUser(String quotaUser) {
        return (Rewrite) super.setQuotaUser(quotaUser);
      }

      @Override
      public Rewrite setUploadType(String uploadType) {
        return (Rewrite) super.setUploadType(uploadType);
      }

      @Override
      public Rewrite setUserIp(String userIp) {
        return (Rewrite) super.setUserIp(userIp);
      }

      /** Name of the bucket in which to find the source object. */
      @com.google.api.client.util.Key private String sourceBucket;

      /** Name of the bucket in which to find the source object. */
      public String getSourceBucket() {
        return sourceBucket;
      }

      /** Name of the bucket in which to find the source object. */
      public Rewrite setSourceBucket(String sourceBucket) {
        this.sourceBucket = sourceBucket;
        return this;
      }

      /**
       * Name of the source object. For information about how to URL encode object names to be path
       * safe, see Encoding URI Path Parts.
       */
      @com.google.api.client.util.Key private String sourceObject;

      /**
       * Name of the source object. For information about how to URL encode object names to be path
       * safe, see Encoding URI Path Parts.
       */
      public String getSourceObject() {
        return sourceObject;
      }

      /**
       * Name of the source object. For information about how to URL encode object names to be path
       * safe, see Encoding URI Path Parts.
       */
      public Rewrite setSourceObject(String sourceObject) {
        this.sourceObject = sourceObject;
        return this;
      }

      /**
       * Name of the bucket in which to store the new object. Overrides the provided object
       * metadata's bucket value, if any.
       */
      @com.google.api.client.util.Key private String destinationBucket;

      /**
       * Name of the bucket in which to store the new object. Overrides the provided object
       * metadata's bucket value, if any.
       */
      public String getDestinationBucket() {
        return destinationBucket;
      }

      /**
       * Name of the bucket in which to store the new object. Overrides the provided object
       * metadata's bucket value, if any.
       */
      public Rewrite setDestinationBucket(String destinationBucket) {
        this.destinationBucket = destinationBucket;
        return this;
      }

      /**
       * Name of the new object. Required when the object metadata is not otherwise provided.
       * Overrides the object metadata's name value, if any. For information about how to URL encode
       * object names to be path safe, see Encoding URI Path Parts.
       */
      @com.google.api.client.util.Key private String destinationObject;

      /**
       * Name of the new object. Required when the object metadata is not otherwise provided.
       * Overrides the object metadata's name value, if any. For information about how to URL encode
       * object names to be path safe, see Encoding URI Path Parts.
       */
      public String getDestinationObject() {
        return destinationObject;
      }

      /**
       * Name of the new object. Required when the object metadata is not otherwise provided.
       * Overrides the object metadata's name value, if any. For information about how to URL encode
       * object names to be path safe, see Encoding URI Path Parts.
       */
      public Rewrite setDestinationObject(String destinationObject) {
        this.destinationObject = destinationObject;
        return this;
      }

      /**
       * Resource name of the Cloud KMS key, of the form projects/my-
       * project/locations/global/keyRings/my-kr/cryptoKeys/my-key, that will be used to encrypt the
       * object. Overrides the object metadata's kms_key_name value, if any.
       */
      @com.google.api.client.util.Key private String destinationKmsKeyName;

      /**
       * Resource name of the Cloud KMS key, of the form
       * projects/my-project/locations/global/keyRings/my- kr/cryptoKeys/my-key, that will be used
       * to encrypt the object. Overrides the object metadata's kms_key_name value, if any.
       */
      public String getDestinationKmsKeyName() {
        return destinationKmsKeyName;
      }

      /**
       * Resource name of the Cloud KMS key, of the form projects/my-
       * project/locations/global/keyRings/my-kr/cryptoKeys/my-key, that will be used to encrypt the
       * object. Overrides the object metadata's kms_key_name value, if any.
       */
      public Rewrite setDestinationKmsKeyName(String destinationKmsKeyName) {
        this.destinationKmsKeyName = destinationKmsKeyName;
        return this;
      }

      /** Apply a predefined set of access controls to the destination object. */
      @com.google.api.client.util.Key private String destinationPredefinedAcl;

      /** Apply a predefined set of access controls to the destination object. */
      public String getDestinationPredefinedAcl() {
        return destinationPredefinedAcl;
      }

      /** Apply a predefined set of access controls to the destination object. */
      public Rewrite setDestinationPredefinedAcl(String destinationPredefinedAcl) {
        this.destinationPredefinedAcl = destinationPredefinedAcl;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value. Setting to 0 makes the operation succeed only if there are no live versions of
       * the object.
       */
      @com.google.api.client.util.Key private Long ifGenerationMatch;

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value. Setting to 0 makes the operation succeed only if there are no live versions of
       * the object.
       */
      public Long getIfGenerationMatch() {
        return ifGenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value. Setting to 0 makes the operation succeed only if there are no live versions of
       * the object.
       */
      public Rewrite setIfGenerationMatch(Long ifGenerationMatch) {
        this.ifGenerationMatch = ifGenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current generation does not match
       * the given value. If no live object exists, the precondition fails. Setting to 0 makes the
       * operation succeed only if there is a live version of the object.
       */
      @com.google.api.client.util.Key private Long ifGenerationNotMatch;

      /**
       * Makes the operation conditional on whether the object's current generation does not match
       * the given value. If no live object exists, the precondition fails. Setting to 0 makes the
       * operation succeed only if there is a live version of the object.
       */
      public Long getIfGenerationNotMatch() {
        return ifGenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current generation does not match
       * the given value. If no live object exists, the precondition fails. Setting to 0 makes the
       * operation succeed only if there is a live version of the object.
       */
      public Rewrite setIfGenerationNotMatch(Long ifGenerationNotMatch) {
        this.ifGenerationNotMatch = ifGenerationNotMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the destination object's current metageneration
       * matches the given value.
       */
      @com.google.api.client.util.Key private Long ifMetagenerationMatch;

      /**
       * Makes the operation conditional on whether the destination object's current metageneration
       * matches the given value.
       */
      public Long getIfMetagenerationMatch() {
        return ifMetagenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the destination object's current metageneration
       * matches the given value.
       */
      public Rewrite setIfMetagenerationMatch(Long ifMetagenerationMatch) {
        this.ifMetagenerationMatch = ifMetagenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the destination object's current metageneration
       * does not match the given value.
       */
      @com.google.api.client.util.Key private Long ifMetagenerationNotMatch;

      /**
       * Makes the operation conditional on whether the destination object's current metageneration
       * does not match the given value.
       */
      public Long getIfMetagenerationNotMatch() {
        return ifMetagenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the destination object's current metageneration
       * does not match the given value.
       */
      public Rewrite setIfMetagenerationNotMatch(Long ifMetagenerationNotMatch) {
        this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the source object's current generation matches
       * the given value.
       */
      @com.google.api.client.util.Key private Long ifSourceGenerationMatch;

      /**
       * Makes the operation conditional on whether the source object's current generation matches
       * the given value.
       */
      public Long getIfSourceGenerationMatch() {
        return ifSourceGenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the source object's current generation matches
       * the given value.
       */
      public Rewrite setIfSourceGenerationMatch(Long ifSourceGenerationMatch) {
        this.ifSourceGenerationMatch = ifSourceGenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the source object's current generation does not
       * match the given value.
       */
      @com.google.api.client.util.Key private Long ifSourceGenerationNotMatch;

      /**
       * Makes the operation conditional on whether the source object's current generation does not
       * match the given value.
       */
      public Long getIfSourceGenerationNotMatch() {
        return ifSourceGenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the source object's current generation does not
       * match the given value.
       */
      public Rewrite setIfSourceGenerationNotMatch(Long ifSourceGenerationNotMatch) {
        this.ifSourceGenerationNotMatch = ifSourceGenerationNotMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the source object's current metageneration
       * matches the given value.
       */
      @com.google.api.client.util.Key private Long ifSourceMetagenerationMatch;

      /**
       * Makes the operation conditional on whether the source object's current metageneration
       * matches the given value.
       */
      public Long getIfSourceMetagenerationMatch() {
        return ifSourceMetagenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the source object's current metageneration
       * matches the given value.
       */
      public Rewrite setIfSourceMetagenerationMatch(Long ifSourceMetagenerationMatch) {
        this.ifSourceMetagenerationMatch = ifSourceMetagenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the source object's current metageneration does
       * not match the given value.
       */
      @com.google.api.client.util.Key private Long ifSourceMetagenerationNotMatch;

      /**
       * Makes the operation conditional on whether the source object's current metageneration does
       * not match the given value.
       */
      public Long getIfSourceMetagenerationNotMatch() {
        return ifSourceMetagenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the source object's current metageneration does
       * not match the given value.
       */
      public Rewrite setIfSourceMetagenerationNotMatch(Long ifSourceMetagenerationNotMatch) {
        this.ifSourceMetagenerationNotMatch = ifSourceMetagenerationNotMatch;
        return this;
      }

      /**
       * The maximum number of bytes that will be rewritten per rewrite request. Most callers
       * shouldn't need to specify this parameter - it is primarily in place to support testing. If
       * specified the value must be an integral multiple of 1 MiB (1048576). Also, this only
       * applies to requests where the source and destination span locations and/or storage classes.
       * Finally, this value must not change across rewrite calls else you'll get an error that the
       * rewriteToken is invalid.
       */
      @com.google.api.client.util.Key private Long maxBytesRewrittenPerCall;

      /**
       * The maximum number of bytes that will be rewritten per rewrite request. Most callers
       * shouldn't need to specify this parameter - it is primarily in place to support testing. If
       * specified the value must be an integral multiple of 1 MiB (1048576). Also, this only
       * applies to requests where the source and destination span locations and/or storage classes.
       * Finally, this value must not change across rewrite calls else you'll get an error that the
       * rewriteToken is invalid.
       */
      public Long getMaxBytesRewrittenPerCall() {
        return maxBytesRewrittenPerCall;
      }

      /**
       * The maximum number of bytes that will be rewritten per rewrite request. Most callers
       * shouldn't need to specify this parameter - it is primarily in place to support testing. If
       * specified the value must be an integral multiple of 1 MiB (1048576). Also, this only
       * applies to requests where the source and destination span locations and/or storage classes.
       * Finally, this value must not change across rewrite calls else you'll get an error that the
       * rewriteToken is invalid.
       */
      public Rewrite setMaxBytesRewrittenPerCall(Long maxBytesRewrittenPerCall) {
        this.maxBytesRewrittenPerCall = maxBytesRewrittenPerCall;
        return this;
      }

      /**
       * Set of properties to return. Defaults to noAcl, unless the object resource specifies the
       * acl property, when it defaults to full.
       */
      @com.google.api.client.util.Key private String projection;

      /**
       * Set of properties to return. Defaults to noAcl, unless the object resource specifies the
       * acl property, when it defaults to full.
       */
      public String getProjection() {
        return projection;
      }

      /**
       * Set of properties to return. Defaults to noAcl, unless the object resource specifies the
       * acl property, when it defaults to full.
       */
      public Rewrite setProjection(String projection) {
        this.projection = projection;
        return this;
      }

      /**
       * Include this field (from the previous rewrite response) on each rewrite request after the
       * first one, until the rewrite response 'done' flag is true. Calls that provide a
       * rewriteToken can omit all other request fields, but if included those fields must match the
       * values provided in the first rewrite request.
       */
      @com.google.api.client.util.Key private String rewriteToken;

      /**
       * Include this field (from the previous rewrite response) on each rewrite request after the
       * first one, until the rewrite response 'done' flag is true. Calls that provide a
       * rewriteToken can omit all other request fields, but if included those fields must match the
       * values provided in the first rewrite request.
       */
      public String getRewriteToken() {
        return rewriteToken;
      }

      /**
       * Include this field (from the previous rewrite response) on each rewrite request after the
       * first one, until the rewrite response 'done' flag is true. Calls that provide a
       * rewriteToken can omit all other request fields, but if included those fields must match the
       * values provided in the first rewrite request.
       */
      public Rewrite setRewriteToken(String rewriteToken) {
        this.rewriteToken = rewriteToken;
        return this;
      }

      /**
       * If present, selects a specific revision of the source object (as opposed to the latest
       * version, the default).
       */
      @com.google.api.client.util.Key private Long sourceGeneration;

      /**
       * If present, selects a specific revision of the source object (as opposed to the latest
       * version, the default).
       */
      public Long getSourceGeneration() {
        return sourceGeneration;
      }

      /**
       * If present, selects a specific revision of the source object (as opposed to the latest
       * version, the default).
       */
      public Rewrite setSourceGeneration(Long sourceGeneration) {
        this.sourceGeneration = sourceGeneration;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public Rewrite setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Rewrite set(String parameterName, Object value) {
        return (Rewrite) super.set(parameterName, value);
      }
    }
    /**
     * Updates an IAM policy for the specified object.
     *
     * <p>Create a request for the method "objects.setIamPolicy".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of the bucket in which the object resides.
     * @param object__ Name of the object. For information about how to URL encode object names to
     *     be path safe, see Encoding URI Path Parts.
     * @param content the {@link com.google.api.services.storage.model.Policy}
     * @return the request
     */
    public SetIamPolicy setIamPolicy(
        String bucket, String object__, com.google.api.services.storage.model.Policy content)
        throws java.io.IOException {
      SetIamPolicy result = new SetIamPolicy(bucket, object__, content);
      initialize(result);
      return result;
    }

    public class SetIamPolicy
        extends com.google.api.services.storage.preprod.StorageRequest<Policy> {

      private static final String REST_PATH = "b/{bucket}/o/{object}/iam";

      /**
       * Updates an IAM policy for the specified object.
       *
       * <p>Create a request for the method "objects.setIamPolicy".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of the bucket in which the object resides.
       * @param object__ Name of the object. For information about how to URL encode object names to
       *     be path safe, see Encoding URI Path Parts.
       * @param content the {@link com.google.api.services.storage.model.Policy}
       * @since 1.13
       */
      protected SetIamPolicy(
          String bucket, String object__, com.google.api.services.storage.model.Policy content) {
        super(
            Storage.this,
            "PUT",
            REST_PATH,
            content,
            com.google.api.services.storage.model.Policy.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        this.object__ =
            com.google.api.client.util.Preconditions.checkNotNull(
                object__, "Required parameter object__ must be specified.");
      }

      @Override
      public SetIamPolicy setAlt(String alt) {
        return (SetIamPolicy) super.setAlt(alt);
      }

      @Override
      public SetIamPolicy setFields(String fields) {
        return (SetIamPolicy) super.setFields(fields);
      }

      @Override
      public SetIamPolicy setKey(String key) {
        return (SetIamPolicy) super.setKey(key);
      }

      @Override
      public SetIamPolicy setOauthToken(String oauthToken) {
        return (SetIamPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
        return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetIamPolicy setQuotaUser(String quotaUser) {
        return (SetIamPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetIamPolicy setUploadType(String uploadType) {
        return (SetIamPolicy) super.setUploadType(uploadType);
      }

      @Override
      public SetIamPolicy setUserIp(String userIp) {
        return (SetIamPolicy) super.setUserIp(userIp);
      }

      /** Name of the bucket in which the object resides. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of the bucket in which the object resides. */
      public String getBucket() {
        return bucket;
      }

      /** Name of the bucket in which the object resides. */
      public SetIamPolicy setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      @com.google.api.client.util.Key("object")
      private String object__;

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      public String getObject() {
        return object__;
      }

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      public SetIamPolicy setObject(String object__) {
        this.object__ = object__;
        return this;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      @com.google.api.client.util.Key private Long generation;

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public Long getGeneration() {
        return generation;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public SetIamPolicy setGeneration(Long generation) {
        this.generation = generation;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public SetIamPolicy setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public SetIamPolicy set(String parameterName, Object value) {
        return (SetIamPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Tests a set of permissions on the given object to see which, if any, are held by the caller.
     *
     * <p>Create a request for the method "objects.testIamPermissions".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
     * operation.
     *
     * @param bucket Name of the bucket in which the object resides.
     * @param object__ Name of the object. For information about how to URL encode object names to
     *     be path safe, see Encoding URI Path Parts.
     * @param permissions Permissions to test.
     * @return the request
     */
    public TestIamPermissions testIamPermissions(
        String bucket, String object__, java.util.List<String> permissions)
        throws java.io.IOException {
      TestIamPermissions result = new TestIamPermissions(bucket, object__, permissions);
      initialize(result);
      return result;
    }

    public class TestIamPermissions
        extends com.google.api.services.storage.preprod.StorageRequest<TestIamPermissionsResponse> {

      private static final String REST_PATH = "b/{bucket}/o/{object}/iam/testPermissions";

      /**
       * Tests a set of permissions on the given object to see which, if any, are held by the
       * caller.
       *
       * <p>Create a request for the method "objects.testIamPermissions".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link TestIamPermissions#execute()} method to invoke the
       * remote operation.
       *
       * <p>{@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor.
       *
       * @param bucket Name of the bucket in which the object resides.
       * @param object__ Name of the object. For information about how to URL encode object names to
       *     be path safe, see Encoding URI Path Parts.
       * @param permissions Permissions to test.
       * @since 1.13
       */
      protected TestIamPermissions(
          String bucket, String object__, java.util.List<String> permissions) {
        super(Storage.this, "GET", REST_PATH, null, TestIamPermissionsResponse.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        this.object__ =
            com.google.api.client.util.Preconditions.checkNotNull(
                object__, "Required parameter object__ must be specified.");
        this.permissions =
            com.google.api.client.util.Preconditions.checkNotNull(
                permissions, "Required parameter permissions must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead()
          throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public TestIamPermissions setAlt(String alt) {
        return (TestIamPermissions) super.setAlt(alt);
      }

      @Override
      public TestIamPermissions setFields(String fields) {
        return (TestIamPermissions) super.setFields(fields);
      }

      @Override
      public TestIamPermissions setKey(String key) {
        return (TestIamPermissions) super.setKey(key);
      }

      @Override
      public TestIamPermissions setOauthToken(String oauthToken) {
        return (TestIamPermissions) super.setOauthToken(oauthToken);
      }

      @Override
      public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
        return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public TestIamPermissions setQuotaUser(String quotaUser) {
        return (TestIamPermissions) super.setQuotaUser(quotaUser);
      }

      @Override
      public TestIamPermissions setUploadType(String uploadType) {
        return (TestIamPermissions) super.setUploadType(uploadType);
      }

      @Override
      public TestIamPermissions setUserIp(String userIp) {
        return (TestIamPermissions) super.setUserIp(userIp);
      }

      /** Name of the bucket in which the object resides. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of the bucket in which the object resides. */
      public String getBucket() {
        return bucket;
      }

      /** Name of the bucket in which the object resides. */
      public TestIamPermissions setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      @com.google.api.client.util.Key("object")
      private String object__;

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      public String getObject() {
        return object__;
      }

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      public TestIamPermissions setObject(String object__) {
        this.object__ = object__;
        return this;
      }

      /** Permissions to test. */
      @com.google.api.client.util.Key private java.util.List<String> permissions;

      /** Permissions to test. */
      public java.util.List<String> getPermissions() {
        return permissions;
      }

      /** Permissions to test. */
      public TestIamPermissions setPermissions(java.util.List<String> permissions) {
        this.permissions = permissions;
        return this;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      @com.google.api.client.util.Key private Long generation;

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public Long getGeneration() {
        return generation;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public TestIamPermissions setGeneration(Long generation) {
        this.generation = generation;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public TestIamPermissions setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public TestIamPermissions set(String parameterName, Object value) {
        return (TestIamPermissions) super.set(parameterName, value);
      }
    }
    /**
     * Updates an object's metadata.
     *
     * <p>Create a request for the method "objects.update".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of the bucket in which the object resides.
     * @param object__ Name of the object. For information about how to URL encode object names to
     *     be path safe, see Encoding URI Path Parts.
     * @param content the {@link com.google.api.services.storage.model.StorageObject}
     * @return the request
     */
    public Update update(
        String bucket, String object__, com.google.api.services.storage.model.StorageObject content)
        throws java.io.IOException {
      Update result = new Update(bucket, object__, content);
      initialize(result);
      return result;
    }

    public class Update
        extends com.google.api.services.storage.preprod.StorageRequest<StorageObject> {

      private static final String REST_PATH = "b/{bucket}/o/{object}";

      /**
       * Updates an object's metadata.
       *
       * <p>Create a request for the method "objects.update".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of the bucket in which the object resides.
       * @param object__ Name of the object. For information about how to URL encode object names to
       *     be path safe, see Encoding URI Path Parts.
       * @param content the {@link com.google.api.services.storage.model.StorageObject}
       * @since 1.13
       */
      protected Update(
          String bucket,
          String object__,
          com.google.api.services.storage.model.StorageObject content) {
        super(
            Storage.this,
            "PUT",
            REST_PATH,
            content,
            com.google.api.services.storage.model.StorageObject.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
        this.object__ =
            com.google.api.client.util.Preconditions.checkNotNull(
                object__, "Required parameter object__ must be specified.");
      }

      @Override
      public Update setAlt(String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUserIp(String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Name of the bucket in which the object resides. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of the bucket in which the object resides. */
      public String getBucket() {
        return bucket;
      }

      /** Name of the bucket in which the object resides. */
      public Update setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      @com.google.api.client.util.Key("object")
      private String object__;

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      public String getObject() {
        return object__;
      }

      /**
       * Name of the object. For information about how to URL encode object names to be path safe,
       * see Encoding URI Path Parts.
       */
      public Update setObject(String object__) {
        this.object__ = object__;
        return this;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      @com.google.api.client.util.Key private Long generation;

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public Long getGeneration() {
        return generation;
      }

      /**
       * If present, selects a specific revision of this object (as opposed to the latest version,
       * the default).
       */
      public Update setGeneration(Long generation) {
        this.generation = generation;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value. Setting to 0 makes the operation succeed only if there are no live versions of
       * the object.
       */
      @com.google.api.client.util.Key private Long ifGenerationMatch;

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value. Setting to 0 makes the operation succeed only if there are no live versions of
       * the object.
       */
      public Long getIfGenerationMatch() {
        return ifGenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current generation matches the
       * given value. Setting to 0 makes the operation succeed only if there are no live versions of
       * the object.
       */
      public Update setIfGenerationMatch(Long ifGenerationMatch) {
        this.ifGenerationMatch = ifGenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current generation does not match
       * the given value. If no live object exists, the precondition fails. Setting to 0 makes the
       * operation succeed only if there is a live version of the object.
       */
      @com.google.api.client.util.Key private Long ifGenerationNotMatch;

      /**
       * Makes the operation conditional on whether the object's current generation does not match
       * the given value. If no live object exists, the precondition fails. Setting to 0 makes the
       * operation succeed only if there is a live version of the object.
       */
      public Long getIfGenerationNotMatch() {
        return ifGenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current generation does not match
       * the given value. If no live object exists, the precondition fails. Setting to 0 makes the
       * operation succeed only if there is a live version of the object.
       */
      public Update setIfGenerationNotMatch(Long ifGenerationNotMatch) {
        this.ifGenerationNotMatch = ifGenerationNotMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      @com.google.api.client.util.Key private Long ifMetagenerationMatch;

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      public Long getIfMetagenerationMatch() {
        return ifMetagenerationMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration matches the
       * given value.
       */
      public Update setIfMetagenerationMatch(Long ifMetagenerationMatch) {
        this.ifMetagenerationMatch = ifMetagenerationMatch;
        return this;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration does not
       * match the given value.
       */
      @com.google.api.client.util.Key private Long ifMetagenerationNotMatch;

      /**
       * Makes the operation conditional on whether the object's current metageneration does not
       * match the given value.
       */
      public Long getIfMetagenerationNotMatch() {
        return ifMetagenerationNotMatch;
      }

      /**
       * Makes the operation conditional on whether the object's current metageneration does not
       * match the given value.
       */
      public Update setIfMetagenerationNotMatch(Long ifMetagenerationNotMatch) {
        this.ifMetagenerationNotMatch = ifMetagenerationNotMatch;
        return this;
      }

      /** Apply a predefined set of access controls to this object. */
      @com.google.api.client.util.Key private String predefinedAcl;

      /** Apply a predefined set of access controls to this object. */
      public String getPredefinedAcl() {
        return predefinedAcl;
      }

      /** Apply a predefined set of access controls to this object. */
      public Update setPredefinedAcl(String predefinedAcl) {
        this.predefinedAcl = predefinedAcl;
        return this;
      }

      /** Set of properties to return. Defaults to full. */
      @com.google.api.client.util.Key private String projection;

      /** Set of properties to return. Defaults to full. */
      public String getProjection() {
        return projection;
      }

      /** Set of properties to return. Defaults to full. */
      public Update setProjection(String projection) {
        this.projection = projection;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public Update setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }
    /**
     * Watch for changes on all objects in a bucket.
     *
     * <p>Create a request for the method "objects.watchAll".
     *
     * <p>This request holds the parameters needed by the storage server. After setting any optional
     * parameters, call the {@link WatchAll#execute()} method to invoke the remote operation.
     *
     * @param bucket Name of the bucket in which to look for objects.
     * @param content the {@link com.google.api.services.storage.model.Channel}
     * @return the request
     */
    public WatchAll watchAll(String bucket, com.google.api.services.storage.model.Channel content)
        throws java.io.IOException {
      WatchAll result = new WatchAll(bucket, content);
      initialize(result);
      return result;
    }

    public class WatchAll extends com.google.api.services.storage.preprod.StorageRequest<Channel> {

      private static final String REST_PATH = "b/{bucket}/o/watch";

      /**
       * Watch for changes on all objects in a bucket.
       *
       * <p>Create a request for the method "objects.watchAll".
       *
       * <p>This request holds the parameters needed by the the storage server. After setting any
       * optional parameters, call the {@link WatchAll#execute()} method to invoke the remote
       * operation.
       *
       * <p>{@link
       * WatchAll#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor.
       *
       * @param bucket Name of the bucket in which to look for objects.
       * @param content the {@link com.google.api.services.storage.model.Channel}
       * @since 1.13
       */
      protected WatchAll(String bucket, com.google.api.services.storage.model.Channel content) {
        super(
            Storage.this,
            "POST",
            REST_PATH,
            content,
            com.google.api.services.storage.model.Channel.class);
        this.bucket =
            com.google.api.client.util.Preconditions.checkNotNull(
                bucket, "Required parameter bucket must be specified.");
      }

      @Override
      public WatchAll setAlt(String alt) {
        return (WatchAll) super.setAlt(alt);
      }

      @Override
      public WatchAll setFields(String fields) {
        return (WatchAll) super.setFields(fields);
      }

      @Override
      public WatchAll setKey(String key) {
        return (WatchAll) super.setKey(key);
      }

      @Override
      public WatchAll setOauthToken(String oauthToken) {
        return (WatchAll) super.setOauthToken(oauthToken);
      }

      @Override
      public WatchAll setPrettyPrint(Boolean prettyPrint) {
        return (WatchAll) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public WatchAll setQuotaUser(String quotaUser) {
        return (WatchAll) super.setQuotaUser(quotaUser);
      }

      @Override
      public WatchAll setUploadType(String uploadType) {
        return (WatchAll) super.setUploadType(uploadType);
      }

      @Override
      public WatchAll setUserIp(String userIp) {
        return (WatchAll) super.setUserIp(userIp);
      }

      /** Name of the bucket in which to look for objects. */
      @com.google.api.client.util.Key private String bucket;

      /** Name of the bucket in which to look for objects. */
      public String getBucket() {
        return bucket;
      }

      /** Name of the bucket in which to look for objects. */
      public WatchAll setBucket(String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * Returns results in a directory-like mode. items will contain only objects whose names,
       * aside from the prefix, do not contain delimiter. Objects whose names, aside from the
       * prefix, contain delimiter will have their name, truncated after the delimiter, returned in
       * prefixes. Duplicate prefixes are omitted.
       */
      @com.google.api.client.util.Key private String delimiter;

      /**
       * Returns results in a directory-like mode. items will contain only objects whose names,
       * aside from the prefix, do not contain delimiter. Objects whose names, aside from the
       * prefix, contain delimiter will have their name, truncated after the delimiter, returned in
       * prefixes. Duplicate prefixes are omitted.
       */
      public String getDelimiter() {
        return delimiter;
      }

      /**
       * Returns results in a directory-like mode. items will contain only objects whose names,
       * aside from the prefix, do not contain delimiter. Objects whose names, aside from the
       * prefix, contain delimiter will have their name, truncated after the delimiter, returned in
       * prefixes. Duplicate prefixes are omitted.
       */
      public WatchAll setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
      }

      /**
       * Filter results to objects whose names are lexicographically before endOffset. If
       * startOffset is also set, the objects listed will have names between startOffset (inclusive)
       * and endOffset (exclusive).
       */
      @com.google.api.client.util.Key private String endOffset;

      /**
       * Filter results to objects whose names are lexicographically before endOffset. If
       * startOffset is also set, the objects listed will have names between startOffset (inclusive)
       * and endOffset (exclusive).
       */
      public String getEndOffset() {
        return endOffset;
      }

      /**
       * Filter results to objects whose names are lexicographically before endOffset. If
       * startOffset is also set, the objects listed will have names between startOffset (inclusive)
       * and endOffset (exclusive).
       */
      public WatchAll setEndOffset(String endOffset) {
        this.endOffset = endOffset;
        return this;
      }

      /**
       * If true, objects that end in exactly one instance of delimiter will have their metadata
       * included in items in addition to prefixes.
       */
      @com.google.api.client.util.Key private Boolean includeTrailingDelimiter;

      /**
       * If true, objects that end in exactly one instance of delimiter will have their metadata
       * included in items in addition to prefixes.
       */
      public Boolean getIncludeTrailingDelimiter() {
        return includeTrailingDelimiter;
      }

      /**
       * If true, objects that end in exactly one instance of delimiter will have their metadata
       * included in items in addition to prefixes.
       */
      public WatchAll setIncludeTrailingDelimiter(Boolean includeTrailingDelimiter) {
        this.includeTrailingDelimiter = includeTrailingDelimiter;
        return this;
      }

      /**
       * Maximum number of items plus prefixes to return in a single page of responses. As duplicate
       * prefixes are omitted, fewer total results may be returned than requested. The service will
       * use this parameter or 1,000 items, whichever is smaller.
       */
      @com.google.api.client.util.Key private Long maxResults;

      /**
       * Maximum number of items plus prefixes to return in a single page of responses. As duplicate
       * prefixes are omitted, fewer total results may be returned than requested. The service will
       * use this parameter or 1,000 items, whichever is smaller. [default: 1000] [minimum: 0]
       */
      public Long getMaxResults() {
        return maxResults;
      }

      /**
       * Maximum number of items plus prefixes to return in a single page of responses. As duplicate
       * prefixes are omitted, fewer total results may be returned than requested. The service will
       * use this parameter or 1,000 items, whichever is smaller.
       */
      public WatchAll setMaxResults(Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * A previously-returned page token representing part of the larger set of results to view.
       */
      @com.google.api.client.util.Key private String pageToken;

      /**
       * A previously-returned page token representing part of the larger set of results to view.
       */
      public String getPageToken() {
        return pageToken;
      }

      /**
       * A previously-returned page token representing part of the larger set of results to view.
       */
      public WatchAll setPageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Filter results to objects whose names begin with this prefix. */
      @com.google.api.client.util.Key private String prefix;

      /** Filter results to objects whose names begin with this prefix. */
      public String getPrefix() {
        return prefix;
      }

      /** Filter results to objects whose names begin with this prefix. */
      public WatchAll setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
      }

      /** Set of properties to return. Defaults to noAcl. */
      @com.google.api.client.util.Key private String projection;

      /** Set of properties to return. Defaults to noAcl. */
      public String getProjection() {
        return projection;
      }

      /** Set of properties to return. Defaults to noAcl. */
      public WatchAll setProjection(String projection) {
        this.projection = projection;
        return this;
      }

      /**
       * Filter results to objects whose names are lexicographically equal to or after startOffset.
       * If endOffset is also set, the objects listed will have names between startOffset
       * (inclusive) and endOffset (exclusive).
       */
      @com.google.api.client.util.Key private String startOffset;

      /**
       * Filter results to objects whose names are lexicographically equal to or after startOffset.
       * If endOffset is also set, the objects listed will have names between startOffset
       * (inclusive) and endOffset (exclusive).
       */
      public String getStartOffset() {
        return startOffset;
      }

      /**
       * Filter results to objects whose names are lexicographically equal to or after startOffset.
       * If endOffset is also set, the objects listed will have names between startOffset
       * (inclusive) and endOffset (exclusive).
       */
      public WatchAll setStartOffset(String startOffset) {
        this.startOffset = startOffset;
        return this;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      @com.google.api.client.util.Key private String userProject;

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public String getUserProject() {
        return userProject;
      }

      /** The project to be billed for this request. Required for Requester Pays buckets. */
      public WatchAll setUserProject(String userProject) {
        this.userProject = userProject;
        return this;
      }

      /**
       * If true, lists all versions of an object as distinct results. The default is false. For
       * more information, see Object Versioning.
       */
      @com.google.api.client.util.Key private Boolean versions;

      /**
       * If true, lists all versions of an object as distinct results. The default is false. For
       * more information, see Object Versioning.
       */
      public Boolean getVersions() {
        return versions;
      }

      /**
       * If true, lists all versions of an object as distinct results. The default is false. For
       * more information, see Object Versioning.
       */
      public WatchAll setVersions(Boolean versions) {
        this.versions = versions;
        return this;
      }

      @Override
      public WatchAll set(String parameterName, Object value) {
        return (WatchAll) super.set(parameterName, value);
      }
    }
  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:
   *
   * <pre>
   *   {@code Storage storage = new Storage(...);}
   *   {@code Storage.Projects.List request = storage.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /** The "projects" collection of methods. */
  public class Projects {

    /**
     * An accessor for creating requests from the HmacKeys collection.
     *
     * <p>The typical use is:
     *
     * <pre>
     *   {@code Storage storage = new Storage(...);}
     *   {@code Storage.HmacKeys.List request = storage.hmacKeys().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public HmacKeys hmacKeys() {
      return new HmacKeys();
    }

    /** The "hmacKeys" collection of methods. */
    public class HmacKeys {

      /**
       * Creates a new HMAC key for the specified service account.
       *
       * <p>Create a request for the method "hmacKeys.create".
       *
       * <p>This request holds the parameters needed by the storage server. After setting any
       * optional parameters, call the {@link Create#execute()} method to invoke the remote
       * operation.
       *
       * @param projectId Project ID owning the service account.
       * @param serviceAccountEmail Email address of the service account.
       * @return the request
       */
      public Create create(String projectId, String serviceAccountEmail)
          throws java.io.IOException {
        Create result = new Create(projectId, serviceAccountEmail);
        initialize(result);
        return result;
      }

      public class Create extends com.google.api.services.storage.preprod.StorageRequest<HmacKey> {

        private static final String REST_PATH = "projects/{projectId}/hmacKeys";

        /**
         * Creates a new HMAC key for the specified service account.
         *
         * <p>Create a request for the method "hmacKeys.create".
         *
         * <p>This request holds the parameters needed by the the storage server. After setting any
         * optional parameters, call the {@link Create#execute()} method to invoke the remote
         * operation.
         *
         * <p>{@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor.
         *
         * @param projectId Project ID owning the service account.
         * @param serviceAccountEmail Email address of the service account.
         * @since 1.13
         */
        protected Create(String projectId, String serviceAccountEmail) {
          super(
              Storage.this,
              "POST",
              REST_PATH,
              null,
              com.google.api.services.storage.model.HmacKey.class);
          this.projectId =
              com.google.api.client.util.Preconditions.checkNotNull(
                  projectId, "Required parameter projectId must be specified.");
          this.serviceAccountEmail =
              com.google.api.client.util.Preconditions.checkNotNull(
                  serviceAccountEmail, "Required parameter serviceAccountEmail must be specified.");
        }

        @Override
        public Create setAlt(String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setFields(String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUserIp(String userIp) {
          return (Create) super.setUserIp(userIp);
        }

        /** Project ID owning the service account. */
        @com.google.api.client.util.Key private String projectId;

        /** Project ID owning the service account. */
        public String getProjectId() {
          return projectId;
        }

        /** Project ID owning the service account. */
        public Create setProjectId(String projectId) {
          this.projectId = projectId;
          return this;
        }

        /** Email address of the service account. */
        @com.google.api.client.util.Key private String serviceAccountEmail;

        /** Email address of the service account. */
        public String getServiceAccountEmail() {
          return serviceAccountEmail;
        }

        /** Email address of the service account. */
        public Create setServiceAccountEmail(String serviceAccountEmail) {
          this.serviceAccountEmail = serviceAccountEmail;
          return this;
        }

        /** The project to be billed for this request. */
        @com.google.api.client.util.Key private String userProject;

        /** The project to be billed for this request. */
        public String getUserProject() {
          return userProject;
        }

        /** The project to be billed for this request. */
        public Create setUserProject(String userProject) {
          this.userProject = userProject;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes an HMAC key.
       *
       * <p>Create a request for the method "hmacKeys.delete".
       *
       * <p>This request holds the parameters needed by the storage server. After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote
       * operation.
       *
       * @param projectId Project ID owning the requested key
       * @param accessId Name of the HMAC key to be deleted.
       * @return the request
       */
      public Delete delete(String projectId, String accessId) throws java.io.IOException {
        Delete result = new Delete(projectId, accessId);
        initialize(result);
        return result;
      }

      public class Delete extends com.google.api.services.storage.preprod.StorageRequest<Void> {

        private static final String REST_PATH = "projects/{projectId}/hmacKeys/{accessId}";

        /**
         * Deletes an HMAC key.
         *
         * <p>Create a request for the method "hmacKeys.delete".
         *
         * <p>This request holds the parameters needed by the the storage server. After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote
         * operation.
         *
         * <p>{@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor.
         *
         * @param projectId Project ID owning the requested key
         * @param accessId Name of the HMAC key to be deleted.
         * @since 1.13
         */
        protected Delete(String projectId, String accessId) {
          super(Storage.this, "DELETE", REST_PATH, null, Void.class);
          this.projectId =
              com.google.api.client.util.Preconditions.checkNotNull(
                  projectId, "Required parameter projectId must be specified.");
          this.accessId =
              com.google.api.client.util.Preconditions.checkNotNull(
                  accessId, "Required parameter accessId must be specified.");
        }

        @Override
        public Delete setAlt(String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setFields(String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUserIp(String userIp) {
          return (Delete) super.setUserIp(userIp);
        }

        /** Project ID owning the requested key */
        @com.google.api.client.util.Key private String projectId;

        /** Project ID owning the requested key */
        public String getProjectId() {
          return projectId;
        }

        /** Project ID owning the requested key */
        public Delete setProjectId(String projectId) {
          this.projectId = projectId;
          return this;
        }

        /** Name of the HMAC key to be deleted. */
        @com.google.api.client.util.Key private String accessId;

        /** Name of the HMAC key to be deleted. */
        public String getAccessId() {
          return accessId;
        }

        /** Name of the HMAC key to be deleted. */
        public Delete setAccessId(String accessId) {
          this.accessId = accessId;
          return this;
        }

        /** The project to be billed for this request. */
        @com.google.api.client.util.Key private String userProject;

        /** The project to be billed for this request. */
        public String getUserProject() {
          return userProject;
        }

        /** The project to be billed for this request. */
        public Delete setUserProject(String userProject) {
          this.userProject = userProject;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Retrieves an HMAC key's metadata
       *
       * <p>Create a request for the method "hmacKeys.get".
       *
       * <p>This request holds the parameters needed by the storage server. After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param projectId Project ID owning the service account of the requested key.
       * @param accessId Name of the HMAC key.
       * @return the request
       */
      public Get get(String projectId, String accessId) throws java.io.IOException {
        Get result = new Get(projectId, accessId);
        initialize(result);
        return result;
      }

      public class Get
          extends com.google.api.services.storage.preprod.StorageRequest<HmacKeyMetadata> {

        private static final String REST_PATH = "projects/{projectId}/hmacKeys/{accessId}";

        /**
         * Retrieves an HMAC key's metadata
         *
         * <p>Create a request for the method "hmacKeys.get".
         *
         * <p>This request holds the parameters needed by the the storage server. After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote
         * operation.
         *
         * <p>{@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor.
         *
         * @param projectId Project ID owning the service account of the requested key.
         * @param accessId Name of the HMAC key.
         * @since 1.13
         */
        protected Get(String projectId, String accessId) {
          super(
              Storage.this,
              "GET",
              REST_PATH,
              null,
              com.google.api.services.storage.model.HmacKeyMetadata.class);
          this.projectId =
              com.google.api.client.util.Preconditions.checkNotNull(
                  projectId, "Required parameter projectId must be specified.");
          this.accessId =
              com.google.api.client.util.Preconditions.checkNotNull(
                  accessId, "Required parameter accessId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead()
            throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead()
            throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get setAlt(String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setFields(String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUserIp(String userIp) {
          return (Get) super.setUserIp(userIp);
        }

        /** Project ID owning the service account of the requested key. */
        @com.google.api.client.util.Key private String projectId;

        /** Project ID owning the service account of the requested key. */
        public String getProjectId() {
          return projectId;
        }

        /** Project ID owning the service account of the requested key. */
        public Get setProjectId(String projectId) {
          this.projectId = projectId;
          return this;
        }

        /** Name of the HMAC key. */
        @com.google.api.client.util.Key private String accessId;

        /** Name of the HMAC key. */
        public String getAccessId() {
          return accessId;
        }

        /** Name of the HMAC key. */
        public Get setAccessId(String accessId) {
          this.accessId = accessId;
          return this;
        }

        /** The project to be billed for this request. */
        @com.google.api.client.util.Key private String userProject;

        /** The project to be billed for this request. */
        public String getUserProject() {
          return userProject;
        }

        /** The project to be billed for this request. */
        public Get setUserProject(String userProject) {
          this.userProject = userProject;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Retrieves a list of HMAC keys matching the criteria.
       *
       * <p>Create a request for the method "hmacKeys.list".
       *
       * <p>This request holds the parameters needed by the storage server. After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param projectId Name of the project in which to look for HMAC keys.
       * @return the request
       */
      public List list(String projectId) throws java.io.IOException {
        List result = new List(projectId);
        initialize(result);
        return result;
      }

      public class List
          extends com.google.api.services.storage.preprod.StorageRequest<HmacKeysMetadata> {

        private static final String REST_PATH = "projects/{projectId}/hmacKeys";

        /**
         * Retrieves a list of HMAC keys matching the criteria.
         *
         * <p>Create a request for the method "hmacKeys.list".
         *
         * <p>This request holds the parameters needed by the the storage server. After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote
         * operation.
         *
         * <p>{@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor.
         *
         * @param projectId Name of the project in which to look for HMAC keys.
         * @since 1.13
         */
        protected List(String projectId) {
          super(
              Storage.this,
              "GET",
              REST_PATH,
              null,
              com.google.api.services.storage.model.HmacKeysMetadata.class);
          this.projectId =
              com.google.api.client.util.Preconditions.checkNotNull(
                  projectId, "Required parameter projectId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead()
            throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead()
            throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List setAlt(String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setFields(String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUserIp(String userIp) {
          return (List) super.setUserIp(userIp);
        }

        /** Name of the project in which to look for HMAC keys. */
        @com.google.api.client.util.Key private String projectId;

        /** Name of the project in which to look for HMAC keys. */
        public String getProjectId() {
          return projectId;
        }

        /** Name of the project in which to look for HMAC keys. */
        public List setProjectId(String projectId) {
          this.projectId = projectId;
          return this;
        }

        /**
         * Maximum number of items to return in a single page of responses. The service uses this
         * parameter or 250 items, whichever is smaller. The max number of items per page will also
         * be limited by the number of distinct service accounts in the response. If the number of
         * service accounts in a single response is too high, the page will truncated and a next
         * page token will be returned.
         */
        @com.google.api.client.util.Key private Long maxResults;

        /**
         * Maximum number of items to return in a single page of responses. The service uses this
         * parameter or 250 items, whichever is smaller. The max number of items per page will also
         * be limited by the number of distinct service accounts in the response. If the number of
         * service accounts in a single response is too high, the page will truncated and a next
         * page token will be returned. [default: 250] [minimum: 0]
         */
        public Long getMaxResults() {
          return maxResults;
        }

        /**
         * Maximum number of items to return in a single page of responses. The service uses this
         * parameter or 250 items, whichever is smaller. The max number of items per page will also
         * be limited by the number of distinct service accounts in the response. If the number of
         * service accounts in a single response is too high, the page will truncated and a next
         * page token will be returned.
         */
        public List setMaxResults(Long maxResults) {
          this.maxResults = maxResults;
          return this;
        }

        /**
         * A previously-returned page token representing part of the larger set of results to view.
         */
        @com.google.api.client.util.Key private String pageToken;

        /**
         * A previously-returned page token representing part of the larger set of results to view.
         */
        public String getPageToken() {
          return pageToken;
        }

        /**
         * A previously-returned page token representing part of the larger set of results to view.
         */
        public List setPageToken(String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /** If present, only keys for the given service account are returned. */
        @com.google.api.client.util.Key private String serviceAccountEmail;

        /** If present, only keys for the given service account are returned. */
        public String getServiceAccountEmail() {
          return serviceAccountEmail;
        }

        /** If present, only keys for the given service account are returned. */
        public List setServiceAccountEmail(String serviceAccountEmail) {
          this.serviceAccountEmail = serviceAccountEmail;
          return this;
        }

        /** Whether or not to show keys in the DELETED state. */
        @com.google.api.client.util.Key private Boolean showDeletedKeys;

        /** Whether or not to show keys in the DELETED state. */
        public Boolean getShowDeletedKeys() {
          return showDeletedKeys;
        }

        /** Whether or not to show keys in the DELETED state. */
        public List setShowDeletedKeys(Boolean showDeletedKeys) {
          this.showDeletedKeys = showDeletedKeys;
          return this;
        }

        /** The project to be billed for this request. */
        @com.google.api.client.util.Key private String userProject;

        /** The project to be billed for this request. */
        public String getUserProject() {
          return userProject;
        }

        /** The project to be billed for this request. */
        public List setUserProject(String userProject) {
          this.userProject = userProject;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates the state of an HMAC key. See the HMAC Key resource descriptor for valid states.
       *
       * <p>Create a request for the method "hmacKeys.update".
       *
       * <p>This request holds the parameters needed by the storage server. After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote
       * operation.
       *
       * @param projectId Project ID owning the service account of the updated key.
       * @param accessId Name of the HMAC key being updated.
       * @param content the {@link com.google.api.services.storage.model.HmacKeyMetadata}
       * @return the request
       */
      public Update update(
          String projectId,
          String accessId,
          com.google.api.services.storage.model.HmacKeyMetadata content)
          throws java.io.IOException {
        Update result = new Update(projectId, accessId, content);
        initialize(result);
        return result;
      }

      public class Update
          extends com.google.api.services.storage.preprod.StorageRequest<HmacKeyMetadata> {

        private static final String REST_PATH = "projects/{projectId}/hmacKeys/{accessId}";

        /**
         * Updates the state of an HMAC key. See the HMAC Key resource descriptor for valid states.
         *
         * <p>Create a request for the method "hmacKeys.update".
         *
         * <p>This request holds the parameters needed by the the storage server. After setting any
         * optional parameters, call the {@link Update#execute()} method to invoke the remote
         * operation.
         *
         * <p>{@link
         * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor.
         *
         * @param projectId Project ID owning the service account of the updated key.
         * @param accessId Name of the HMAC key being updated.
         * @param content the {@link com.google.api.services.storage.model.HmacKeyMetadata}
         * @since 1.13
         */
        protected Update(
            String projectId,
            String accessId,
            com.google.api.services.storage.model.HmacKeyMetadata content) {
          super(
              Storage.this,
              "PUT",
              REST_PATH,
              content,
              com.google.api.services.storage.model.HmacKeyMetadata.class);
          this.projectId =
              com.google.api.client.util.Preconditions.checkNotNull(
                  projectId, "Required parameter projectId must be specified.");
          this.accessId =
              com.google.api.client.util.Preconditions.checkNotNull(
                  accessId, "Required parameter accessId must be specified.");
        }

        @Override
        public Update setAlt(String alt) {
          return (Update) super.setAlt(alt);
        }

        @Override
        public Update setFields(String fields) {
          return (Update) super.setFields(fields);
        }

        @Override
        public Update setKey(String key) {
          return (Update) super.setKey(key);
        }

        @Override
        public Update setOauthToken(String oauthToken) {
          return (Update) super.setOauthToken(oauthToken);
        }

        @Override
        public Update setPrettyPrint(Boolean prettyPrint) {
          return (Update) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Update setQuotaUser(String quotaUser) {
          return (Update) super.setQuotaUser(quotaUser);
        }

        @Override
        public Update setUploadType(String uploadType) {
          return (Update) super.setUploadType(uploadType);
        }

        @Override
        public Update setUserIp(String userIp) {
          return (Update) super.setUserIp(userIp);
        }

        /** Project ID owning the service account of the updated key. */
        @com.google.api.client.util.Key private String projectId;

        /** Project ID owning the service account of the updated key. */
        public String getProjectId() {
          return projectId;
        }

        /** Project ID owning the service account of the updated key. */
        public Update setProjectId(String projectId) {
          this.projectId = projectId;
          return this;
        }

        /** Name of the HMAC key being updated. */
        @com.google.api.client.util.Key private String accessId;

        /** Name of the HMAC key being updated. */
        public String getAccessId() {
          return accessId;
        }

        /** Name of the HMAC key being updated. */
        public Update setAccessId(String accessId) {
          this.accessId = accessId;
          return this;
        }

        /** The project to be billed for this request. */
        @com.google.api.client.util.Key private String userProject;

        /** The project to be billed for this request. */
        public String getUserProject() {
          return userProject;
        }

        /** The project to be billed for this request. */
        public Update setUserProject(String userProject) {
          this.userProject = userProject;
          return this;
        }

        @Override
        public Update set(String parameterName, Object value) {
          return (Update) super.set(parameterName, value);
        }
      }
    }
    /**
     * An accessor for creating requests from the ServiceAccount collection.
     *
     * <p>The typical use is:
     *
     * <pre>
     *   {@code Storage storage = new Storage(...);}
     *   {@code Storage.ServiceAccount.List request = storage.serviceAccount().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public ServiceAccount serviceAccount() {
      return new ServiceAccount();
    }

    /** The "serviceAccount" collection of methods. */
    public class ServiceAccount {

      /**
       * Get the email address of this project's Google Cloud Storage service account.
       *
       * <p>Create a request for the method "serviceAccount.get".
       *
       * <p>This request holds the parameters needed by the storage server. After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param projectId Project ID
       * @return the request
       */
      public Get get(String projectId) throws java.io.IOException {
        Get result = new Get(projectId);
        initialize(result);
        return result;
      }

      public class Get
          extends StorageRequest<com.google.api.services.storage.model.ServiceAccount> {

        private static final String REST_PATH = "projects/{projectId}/serviceAccount";

        /**
         * Get the email address of this project's Google Cloud Storage service account.
         *
         * <p>Create a request for the method "serviceAccount.get".
         *
         * <p>This request holds the parameters needed by the the storage server. After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote
         * operation.
         *
         * <p>{@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor.
         *
         * @param projectId Project ID
         * @since 1.13
         */
        protected Get(String projectId) {
          super(
              Storage.this,
              "GET",
              REST_PATH,
              null,
              com.google.api.services.storage.model.ServiceAccount.class);
          this.projectId =
              com.google.api.client.util.Preconditions.checkNotNull(
                  projectId, "Required parameter projectId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead()
            throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead()
            throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get setAlt(String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setFields(String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUserIp(String userIp) {
          return (Get) super.setUserIp(userIp);
        }

        /** Project ID */
        @com.google.api.client.util.Key private String projectId;

        /** Project ID */
        public String getProjectId() {
          return projectId;
        }

        /** Project ID */
        public Get setProjectId(String projectId) {
          this.projectId = projectId;
          return this;
        }

        /** The project to be billed for this request. */
        @com.google.api.client.util.Key private String userProject;

        /** The project to be billed for this request. */
        public String getUserProject() {
          return userProject;
        }

        /** The project to be billed for this request. */
        public Get setUserProject(String userProject) {
          this.userProject = userProject;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
    }
  }

  /**
   * Builder for {@link Storage}.
   *
   * <p>Implementation is not thread-safe.
   *
   * @since 1.3.0
   */
  public static final class Builder
      extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *     <ul>
     *       <li>Google App Engine: {@code
     *           com.google.api.client.extensions.appengine.http.UrlFetchTransport}
     *       <li>Android: {@code newCompatibleTransport} from {@code
     *           com.google.api.client.extensions.android.http.AndroidHttp}
     *       <li>Java: {@link
     *           com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *     </ul>
     *
     * @param jsonFactory JSON factory, which may be:
     *     <ul>
     *       <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}
     *       <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}
     *       <li>Android Honeycomb or higher: {@code
     *           com.google.api.client.extensions.android.json.AndroidJsonFactory}
     *     </ul>
     *
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(
        com.google.api.client.http.HttpTransport transport,
        com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link Storage}. */
    @Override
    public Storage build() {
      return new Storage(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link com.google.api.services.storage.preprod.StorageRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setStorageRequestInitializer(
        StorageRequestInitializer storageRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(storageRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer
            googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
