/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.ClientProto;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.compute.ComputeCredential;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.util.CredentialAdapter;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.google.storage.v1.StorageGrpc;
import com.google.google.storage.v1.StorageOuterClass;
import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.Context;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.alts.GoogleDefaultChannelBuilder;
import io.grpc.auth.MoreCallCredentials;
import io.grpc.stub.AbstractStub;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

class StorageStubProvider {
    private static final double GRPC_MAX_RETRY_ATTEMPTS = 10.0;
    private static final int MEDIA_CHANNEL_MAX_POOL_SIZE = 12;
    private static final ImmutableSet<Status.Code> STUB_BROKEN_ERROR_CODES = ImmutableSet.of((Object)Status.Code.DEADLINE_EXCEEDED, (Object)Status.Code.UNAVAILABLE);
    private static final String DEFAULT_GCS_GRPC_SERVER_ADDRESS = (String)StorageOuterClass.getDescriptor().findServiceByName("Storage").getOptions().getExtension(ClientProto.defaultHost);
    private final GoogleCloudStorageReadOptions readOptions;
    private final String userAgent;
    private final ExecutorService backgroundTasksThreadPool;
    private final List<ChannelAndRequestCounter> mediaChannelPool;
    private final GrpcDecorator grpcDecorator;

    StorageStubProvider(GoogleCloudStorageOptions options, ExecutorService backgroundTasksThreadPool, GrpcDecorator grpcDecorator) {
        this.readOptions = options.getReadChannelOptions();
        this.userAgent = options.getAppName();
        this.backgroundTasksThreadPool = backgroundTasksThreadPool;
        this.mediaChannelPool = new ArrayList<ChannelAndRequestCounter>();
        this.grpcDecorator = (GrpcDecorator)Preconditions.checkNotNull((Object)grpcDecorator, (Object)"grpcDecorator cannot be null");
    }

    private ChannelAndRequestCounter buildManagedChannel() {
        ActiveRequestCounter counter = new ActiveRequestCounter();
        String target = Strings.isNullOrEmpty((String)this.readOptions.getGrpcServerAddress()) ? DEFAULT_GCS_GRPC_SERVER_ADDRESS : this.readOptions.getGrpcServerAddress();
        ManagedChannel channel = this.grpcDecorator.createChannelBuilder(target).enableRetry().intercept(new ClientInterceptor[]{counter}).userAgent(this.userAgent).build();
        return new ChannelAndRequestCounter(channel, counter);
    }

    public static boolean isStubBroken(Status.Code statusCode) {
        return STUB_BROKEN_ERROR_CODES.contains((Object)statusCode);
    }

    public StorageGrpc.StorageBlockingStub newBlockingStub() {
        StorageGrpc.StorageBlockingStub stub = StorageGrpc.newBlockingStub((Channel)this.getManagedChannel());
        this.grpcDecorator.applyCallOption((AbstractStub<?>)stub);
        return stub;
    }

    public StorageGrpc.StorageStub newAsyncStub() {
        StorageGrpc.StorageStub stub = (StorageGrpc.StorageStub)StorageGrpc.newStub((Channel)this.getManagedChannel()).withExecutor(this.backgroundTasksThreadPool);
        this.grpcDecorator.applyCallOption((AbstractStub<?>)stub);
        return stub;
    }

    private synchronized ManagedChannel getManagedChannel() {
        if (this.mediaChannelPool.size() >= 12) {
            return this.mediaChannelPool.stream().min(Comparator.comparingInt(ChannelAndRequestCounter::activeRequests)).get().channel;
        }
        ChannelAndRequestCounter channel = this.buildManagedChannel();
        this.mediaChannelPool.add(channel);
        return channel.channel;
    }

    public void shutdown() {
        this.mediaChannelPool.parallelStream().forEach(c -> ((ChannelAndRequestCounter)c).channel.shutdownNow());
    }

    public static StorageStubProvider newInstance(GoogleCloudStorageOptions options, ExecutorService backgroundTasksThreadPool, Credential credential) {
        boolean useDirectpath = credential != null && Objects.equals(credential.getTokenServerEncodedUrl(), ComputeCredential.TOKEN_SERVER_ENCODED_URL);
        return new StorageStubProvider(options, backgroundTasksThreadPool, useDirectpath ? new DirectpathPathGrpcDecorator(options.getReadChannelOptions()) : new CloudPathGrpcDecorator((Credentials)new CredentialAdapter(credential)));
    }

    public static StorageStubProvider newInstance(GoogleCloudStorageOptions options, ExecutorService backgroundTasksThreadPool, Credentials credentials) {
        boolean useDirectpath = credentials instanceof ComputeEngineCredentials;
        return new StorageStubProvider(options, backgroundTasksThreadPool, useDirectpath ? new DirectpathPathGrpcDecorator(options.getReadChannelOptions()) : new CloudPathGrpcDecorator(credentials));
    }

    static class DirectpathPathGrpcDecorator
    implements GrpcDecorator {
        private final GoogleCloudStorageReadOptions readOptions;

        DirectpathPathGrpcDecorator(GoogleCloudStorageReadOptions readOptions) {
            this.readOptions = readOptions;
        }

        @Override
        public ManagedChannelBuilder<?> createChannelBuilder(String target) {
            return GoogleDefaultChannelBuilder.forTarget((String)target).defaultServiceConfig(this.getGrpcServiceConfig());
        }

        @Override
        public AbstractStub<?> applyCallOption(AbstractStub<?> stub) {
            return stub;
        }

        private Map<String, Object> getGrpcServiceConfig() {
            ImmutableMap name = ImmutableMap.of((Object)"service", (Object)"google.storage.v1.Storage");
            ImmutableMap retryPolicy = ImmutableMap.builder().put((Object)"maxAttempts", (Object)10.0).put((Object)"initialBackoff", (Object)Durations.toString((Duration)Durations.fromMillis((long)this.readOptions.getBackoffInitialIntervalMillis()))).put((Object)"maxBackoff", (Object)Durations.toString((Duration)Durations.fromMillis((long)this.readOptions.getBackoffMaxIntervalMillis()))).put((Object)"backoffMultiplier", (Object)this.readOptions.getBackoffMultiplier()).put((Object)"retryableStatusCodes", (Object)ImmutableList.of((Object)"UNAVAILABLE", (Object)"RESOURCE_EXHAUSTED")).build();
            ImmutableMap methodConfig = ImmutableMap.of((Object)"name", (Object)ImmutableList.of((Object)name), (Object)"retryPolicy", (Object)retryPolicy);
            ImmutableMap pickFirstStrategy = ImmutableMap.of((Object)"pick_first", (Object)ImmutableMap.of());
            ImmutableMap childPolicy = ImmutableMap.of((Object)"childPolicy", (Object)ImmutableList.of((Object)pickFirstStrategy));
            ImmutableMap grpcLbPolicy = ImmutableMap.of((Object)"grpclb", (Object)childPolicy);
            return ImmutableMap.of((Object)"methodConfig", (Object)ImmutableList.of((Object)methodConfig), (Object)"loadBalancingConfig", (Object)ImmutableList.of((Object)grpcLbPolicy));
        }
    }

    static class CloudPathGrpcDecorator
    implements GrpcDecorator {
        private final Credentials credentials;

        CloudPathGrpcDecorator(Credentials credentials) {
            this.credentials = credentials;
        }

        @Override
        public ManagedChannelBuilder<?> createChannelBuilder(String target) {
            return ManagedChannelBuilder.forTarget((String)target);
        }

        @Override
        public AbstractStub<?> applyCallOption(AbstractStub<?> stub) {
            return stub.withCallCredentials(MoreCallCredentials.from((Credentials)this.credentials));
        }
    }

    static interface GrpcDecorator {
        public ManagedChannelBuilder<?> createChannelBuilder(String var1);

        public AbstractStub<?> applyCallOption(AbstractStub<?> var1);
    }

    class ChannelAndRequestCounter {
        private final ManagedChannel channel;
        private final ActiveRequestCounter counter;

        public ChannelAndRequestCounter(ManagedChannel channel, ActiveRequestCounter counter) {
            this.channel = channel;
            this.counter = counter;
        }

        public int activeRequests() {
            return this.counter.ongoingRequestCount.get();
        }
    }

    final class ActiveRequestCounter
    implements ClientInterceptor {
        private final AtomicInteger ongoingRequestCount = new AtomicInteger(0);

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
            ClientCall newCall = channel.newCall(methodDescriptor, callOptions);
            final AtomicBoolean countedCancel = new AtomicBoolean(false);
            Context.current().addListener(context -> {
                if (countedCancel.compareAndSet(false, true)) {
                    this.ongoingRequestCount.decrementAndGet();
                }
            }, (Executor)StorageStubProvider.this.backgroundTasksThreadPool);
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(newCall){

                public void cancel(@Nullable String message, @Nullable Throwable cause) {
                    if (countedCancel.compareAndSet(false, true)) {
                        ActiveRequestCounter.this.ongoingRequestCount.decrementAndGet();
                    }
                    super.cancel(message, cause);
                }

                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    ActiveRequestCounter.this.ongoingRequestCount.incrementAndGet();
                    this.delegate().start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        public void onClose(Status status, Metadata trailers) {
                            if (countedCancel.compareAndSet(false, true)) {
                                ActiveRequestCounter.this.ongoingRequestCount.decrementAndGet();
                            }
                            super.onClose(status, trailers);
                        }
                    }, headers);
                }
            };
        }
    }
}

