/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio.integration;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.ListObjectOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.TrackingHttpRequestInitializer;
import com.google.cloud.hadoop.gcsio.testing.TestConfiguration;
import com.google.cloud.hadoop.util.CheckedFunction;
import com.google.cloud.hadoop.util.CredentialFactory;
import com.google.cloud.hadoop.util.CredentialOptions;
import com.google.cloud.hadoop.util.RetryHttpInitializer;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.flogger.GoogleLogger;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.junit.Assert;

public class GoogleCloudStorageTestHelper {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final String APP_NAME = "GHFS/test";
    private static final int BUFFER_SIZE_MAX_BYTES = 0x2000000;

    public static GoogleCloudStorage createGoogleCloudStorage() {
        try {
            return new GoogleCloudStorageImpl(GoogleCloudStorageTestHelper.getStandardOptionBuilder().build(), GoogleCloudStorageTestHelper.getCredential());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create GoogleCloudStorage instance", e);
        }
    }

    public static Credential getCredential() throws IOException {
        CredentialOptions credentialOptions = CredentialOptions.builder().setServiceAccountEmail(TestConfiguration.getInstance().getServiceAccount()).setServiceAccountKeyFile(TestConfiguration.getInstance().getPrivateKeyFile()).build();
        CredentialFactory credentialFactory = new CredentialFactory(credentialOptions);
        try {
            return credentialFactory.getCredential((List)CredentialFactory.DEFAULT_SCOPES);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Failed to create test credentials", e);
        }
    }

    public static GoogleCloudStorageOptions.Builder getStandardOptionBuilder() {
        return GoogleCloudStorageOptions.builder().setAppName(APP_NAME).setProjectId((String)Preconditions.checkNotNull((Object)TestConfiguration.getInstance().getProjectId()));
    }

    public static void assertByteArrayEquals(byte[] expected, byte[] actual) {
        if (expected == null ^ actual == null) {
            Assert.fail((String)String.format("Expected was '%s', actual was '%s'", expected, actual));
        } else if (expected == null && actual == null) {
            return;
        }
        if (expected.length != actual.length) {
            Assert.fail((String)String.format("Length mismatch: expected: %d, actual: %d", expected.length, actual.length));
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            Assert.fail((String)String.format("Mismatch at index %d. expected: 0x%02x, actual: 0x%02x", i, expected[i], actual[i]));
        }
    }

    public static void assertObjectContent(GoogleCloudStorage gcs, StorageResourceId resourceId, byte[] expectedBytes) throws IOException {
        GoogleCloudStorageTestHelper.assertObjectContent(gcs, resourceId, expectedBytes, 1);
    }

    public static void assertObjectContent(GoogleCloudStorage gcs, StorageResourceId resourceId, GoogleCloudStorageReadOptions readOptions, byte[] expectedBytes) throws IOException {
        GoogleCloudStorageTestHelper.assertObjectContent(gcs, resourceId, readOptions, expectedBytes, 1);
    }

    public static void assertObjectContent(GoogleCloudStorage gcs, StorageResourceId id, GoogleCloudStorageReadOptions readOptions, byte[] expectedBytes, int expectedBytesCount, int offset) throws IOException {
        Preconditions.checkArgument((expectedBytesCount > 0 ? 1 : 0) != 0, (Object)"expectedBytesCount should be greater than 0");
        int expectedBytesLength = expectedBytes.length;
        long expectedBytesTotalLength = (long)expectedBytesLength * (long)expectedBytesCount;
        ByteBuffer buffer = ByteBuffer.allocate(Math.min(0x2000000, expectedBytesLength));
        long totalRead = 0L;
        try (SeekableByteChannel channel = gcs.open(id, readOptions);){
            if (offset > 0) {
                channel.position(offset);
            }
            int read = channel.read(buffer);
            while (read > 0) {
                Truth.assertWithMessage((String)"Bytes read mismatch").that(Long.valueOf(totalRead += (long)read)).isAtMost((Comparable)Long.valueOf(expectedBytesTotalLength));
                buffer.flip();
                byte[] bytesRead = Arrays.copyOf(buffer.array(), buffer.limit());
                byte[] expectedBytesRead = GoogleCloudStorageTestHelper.getExpectedBytesRead(expectedBytes, totalRead, read);
                GoogleCloudStorageTestHelper.assertByteArrayEquals(expectedBytesRead, bytesRead);
                buffer.clear();
                read = channel.read(buffer);
            }
        }
        Truth.assertWithMessage((String)"Bytes read mismatch").that(Long.valueOf(totalRead)).isEqualTo((Object)expectedBytesTotalLength);
    }

    public static void assertObjectContent(GoogleCloudStorage gcs, StorageResourceId id, GoogleCloudStorageReadOptions readOptions, byte[] expectedBytes, int expectedBytesCount) throws IOException {
        GoogleCloudStorageTestHelper.assertObjectContent(gcs, id, readOptions, expectedBytes, expectedBytesCount, 0);
    }

    public static void assertObjectContent(GoogleCloudStorage gcs, StorageResourceId id, byte[] expectedBytes, int expectedBytesCount) throws IOException {
        GoogleCloudStorageTestHelper.assertObjectContent(gcs, id, GoogleCloudStorageReadOptions.DEFAULT, expectedBytes, expectedBytesCount);
    }

    private static byte[] getExpectedBytesRead(byte[] expectedBytes, long totalRead, int read) {
        int expectedBytesLength = expectedBytes.length;
        int expectedBytesStart = (int)((totalRead - (long)read) % (long)expectedBytesLength);
        int expectedBytesEnd = (int)(totalRead % (long)expectedBytesLength);
        if (expectedBytesStart < expectedBytesEnd) {
            return Arrays.copyOfRange(expectedBytes, expectedBytesStart, expectedBytesEnd);
        }
        byte[] expectedBytesRead = new byte[read];
        int firstPartSize = expectedBytesLength - expectedBytesStart;
        System.arraycopy(expectedBytes, expectedBytesStart, expectedBytesRead, 0, firstPartSize);
        System.arraycopy(expectedBytes, 0, expectedBytesRead, firstPartSize, expectedBytesEnd);
        return expectedBytesRead;
    }

    public static void fillBytes(byte[] bytes) {
        new Random().nextBytes(bytes);
    }

    public static byte[] writeObject(GoogleCloudStorage gcs, StorageResourceId resourceId, int objectSize) throws IOException {
        return GoogleCloudStorageTestHelper.writeObject(gcs, resourceId, objectSize, 1);
    }

    public static byte[] writeObject(GoogleCloudStorage gcs, StorageResourceId resourceId, int partitionSize, int partitionsCount) throws IOException {
        return GoogleCloudStorageTestHelper.writeObject(gcs.create(resourceId), partitionSize, partitionsCount);
    }

    public static byte[] writeObject(WritableByteChannel channel, int partitionSize, int partitionsCount) throws IOException {
        Preconditions.checkArgument((partitionsCount > 0 ? 1 : 0) != 0, (Object)"partitionsCount should be greater than 0");
        byte[] partition = new byte[partitionSize];
        GoogleCloudStorageTestHelper.fillBytes(partition);
        long startTime = System.currentTimeMillis();
        try (WritableByteChannel ignore = channel;){
            for (int i = 0; i < partitionsCount; ++i) {
                channel.write(ByteBuffer.wrap(partition));
            }
        }
        long endTime = System.currentTimeMillis();
        ((GoogleLogger.Api)logger.atInfo()).log("Took %sms to write %sB", endTime - startTime, (long)partitionsCount * (long)partitionSize);
        return partition;
    }

    public static class TrackingStorageWrapper<T> {
        public final TrackingHttpRequestInitializer requestsTracker;
        public final T delegate;

        public TrackingStorageWrapper(GoogleCloudStorageOptions options, CheckedFunction<TrackingHttpRequestInitializer, T, IOException> delegateStorageFn) throws IOException {
            this.requestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)new RetryHttpInitializer(GoogleCloudStorageTestHelper.getCredential(), options.toRetryHttpInitializerOptions()));
            this.delegate = delegateStorageFn.apply((Object)this.requestsTracker);
        }
    }

    public static class TestBucketHelper {
        private static final int MAX_CLEANUP_BUCKETS = 250;
        private static final String DELIMITER = "_";
        private static final long LEAKED_BUCKETS_CUTOFF_TIME = Instant.now().minus(Duration.ofHours(6L)).toEpochMilli();
        private final String bucketPrefix;
        private final String uniqueBucketPrefix;

        public TestBucketHelper(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix + DELIMITER;
            this.uniqueBucketPrefix = TestBucketHelper.makeBucketName(bucketPrefix);
            Preconditions.checkState((boolean)this.uniqueBucketPrefix.startsWith(this.bucketPrefix), (Object)"uniqueBucketPrefix should start with bucketPrefix");
        }

        private static String makeBucketName(String prefix) {
            String username = System.getProperty("user.name", "unknown").replace("-", "");
            username = username.substring(0, Math.min(username.length(), 10));
            String uuidSuffix = UUID.randomUUID().toString().substring(0, 8);
            return prefix + DELIMITER + username + DELIMITER + uuidSuffix;
        }

        public String getUniqueBucketName(String suffix) {
            return this.uniqueBucketPrefix + DELIMITER + suffix;
        }

        public String getUniqueBucketPrefix() {
            return this.uniqueBucketPrefix;
        }

        public void cleanup(GoogleCloudStorage storage) throws IOException {
            Stopwatch storageStopwatch = Stopwatch.createStarted();
            ((GoogleLogger.Api)logger.atInfo()).log("Cleaning up GCS buckets that start with %s prefix or leaked", (Object)this.uniqueBucketPrefix);
            List<String> bucketsToDelete = new ArrayList<String>();
            for (GoogleCloudStorageItemInfo bucketInfo : storage.listBucketInfo()) {
                String bucketName = bucketInfo.getBucketName();
                if (!bucketName.startsWith(this.bucketPrefix) || !bucketName.startsWith(this.uniqueBucketPrefix) && bucketInfo.getCreationTime() >= LEAKED_BUCKETS_CUTOFF_TIME) continue;
                bucketsToDelete.add(bucketName);
            }
            Collections.shuffle(bucketsToDelete);
            if (bucketsToDelete.size() > 250) {
                ((GoogleLogger.Api)logger.atInfo()).log("GCS has %s buckets to cleanup. It's too many, will cleanup only %s buckets: %s", (Object)bucketsToDelete.size(), (Object)250, bucketsToDelete);
                bucketsToDelete = bucketsToDelete.subList(0, 250);
            } else {
                ((GoogleLogger.Api)logger.atInfo()).log("GCS has %s buckets to cleanup: %s", bucketsToDelete.size(), bucketsToDelete);
            }
            List objectsToDelete = (List)bucketsToDelete.parallelStream().flatMap(bucket -> {
                try {
                    return storage.listObjectInfo(bucket, null, ListObjectOptions.DEFAULT_FLAT_LIST).stream();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).collect(ImmutableList.toImmutableList());
            ((GoogleLogger.Api)logger.atInfo()).log("GCS has %s objects to cleanup: %s", objectsToDelete.size(), (Object)objectsToDelete);
            try {
                storage.deleteObjects(Lists.transform((List)objectsToDelete, GoogleCloudStorageItemInfo::getResourceId));
                storage.deleteBuckets(bucketsToDelete);
            }
            catch (IOException ioe) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause((Throwable)ioe)).log("Caught exception during GCS (%s) buckets cleanup", (Object)storage);
            }
            ((GoogleLogger.Api)logger.atInfo()).log("GCS cleaned up in %s seconds", storageStopwatch.elapsed().getSeconds());
        }
    }
}

