/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio.integration;

import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.PerformanceCachingGoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.PerformanceCachingGoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.integration.GoogleCloudStorageTest;
import com.google.cloud.hadoop.gcsio.integration.GoogleCloudStorageTestHelper;
import com.google.cloud.hadoop.util.HttpTransportFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GoogleCloudStorageIntegrationTest
extends GoogleCloudStorageTest {
    @Parameterized.Parameters
    public static Collection<Object[]> getConstructorArguments() throws IOException {
        return Arrays.asList({GoogleCloudStorageIntegrationTest.getGoogleCloudStorage()}, {GoogleCloudStorageIntegrationTest.getApacheGoogleCloudStorage()}, {GoogleCloudStorageIntegrationTest.getPerformanceCachingGoogleCloudStorage()});
    }

    private static GoogleCloudStorage getApacheGoogleCloudStorage() throws IOException {
        return GoogleCloudStorageIntegrationTest.getGoogleCloudStorage(GoogleCloudStorageTestHelper.getStandardOptionBuilder().setTransportType(HttpTransportFactory.HttpTransportType.APACHE));
    }

    private static GoogleCloudStorage getPerformanceCachingGoogleCloudStorage() throws IOException {
        return new PerformanceCachingGoogleCloudStorage(GoogleCloudStorageIntegrationTest.getGoogleCloudStorage(GoogleCloudStorageTestHelper.getStandardOptionBuilder()), PerformanceCachingGoogleCloudStorageOptions.DEFAULT);
    }

    private static GoogleCloudStorage getGoogleCloudStorage() throws IOException {
        return GoogleCloudStorageIntegrationTest.getGoogleCloudStorage(GoogleCloudStorageTestHelper.getStandardOptionBuilder());
    }

    private static GoogleCloudStorage getGoogleCloudStorage(GoogleCloudStorageOptions.Builder optionsBuilder) throws IOException {
        return new GoogleCloudStorageImpl(optionsBuilder.build(), GoogleCloudStorageTestHelper.getCredential());
    }

    public GoogleCloudStorageIntegrationTest(GoogleCloudStorage gcs) {
        super(gcs);
    }
}

