/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio.integration;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.hadoop.gcsio.CreateBucketOptions;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.TrackingHttpRequestInitializer;
import com.google.cloud.hadoop.gcsio.integration.GoogleCloudStorageTestHelper;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GoogleCloudStorageImplTest {
    private static final GoogleCloudStorageTestHelper.TestBucketHelper BUCKET_HELPER = new GoogleCloudStorageTestHelper.TestBucketHelper("gcs-impl");
    private static final String TEST_BUCKET = BUCKET_HELPER.getUniqueBucketPrefix();
    private static final GoogleCloudStorageOptions GCS_OPTIONS = GoogleCloudStorageTestHelper.getStandardOptionBuilder().build();
    private static GoogleCloudStorage helperGcs;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeAll() throws IOException {
        helperGcs = GoogleCloudStorageTestHelper.createGoogleCloudStorage();
        helperGcs.createBucket(TEST_BUCKET);
    }

    @AfterClass
    public static void afterAll() throws IOException {
        try {
            BUCKET_HELPER.cleanup(helperGcs);
        }
        finally {
            helperGcs.close();
        }
    }

    @Test
    public void open_lazyInit_whenFastFailOnNotFound_isFalse() throws IOException {
        int expectedSize = 0x500000;
        StorageResourceId resourceId = new StorageResourceId(TEST_BUCKET, this.name.getMethodName());
        GoogleCloudStorageTestHelper.writeObject(helperGcs, resourceId, expectedSize, 1);
        GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorageImpl> trackingGcs = GoogleCloudStorageImplTest.newTrackingGoogleCloudStorage(GCS_OPTIONS);
        GoogleCloudStorageReadOptions readOptions = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFound(false).build();
        try (SeekableByteChannel readChannel = ((GoogleCloudStorageImpl)trackingGcs.delegate).open(resourceId, readOptions);){
            Truth.assertThat((Long)readChannel.size()).isEqualTo((Object)expectedSize);
        }
        Truth.assertThat(trackingGcs.requestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(resourceId.getBucketName(), resourceId.getObjectName(), "contentEncoding,generation,size")});
    }

    @Test
    public void writeLargeObject_withSmallUploadChunk() throws IOException {
        StorageResourceId resourceId = new StorageResourceId(TEST_BUCKET, this.name.getMethodName());
        int uploadChunkSize = 0x100000;
        GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorageImpl> trackingGcs = GoogleCloudStorageImplTest.newTrackingGoogleCloudStorage(GoogleCloudStorageImplTest.getOptionsWithUploadChunk(uploadChunkSize));
        int partitionsCount = 32;
        byte[] partition = GoogleCloudStorageTestHelper.writeObject((GoogleCloudStorage)trackingGcs.delegate, resourceId, 0x500000, partitionsCount);
        GoogleCloudStorageTestHelper.assertObjectContent(helperGcs, resourceId, partition, partitionsCount);
        Truth.assertThat(trackingGcs.requestsTracker.getAllRequestStrings()).containsExactlyElementsIn(GoogleCloudStorageImplTest.getExpectedRequestsForCreateObject(resourceId, uploadChunkSize, partitionsCount, partition)).inOrder();
    }

    @Test
    public void writeObject_withNonAlignedUploadChunk() throws IOException {
        StorageResourceId resourceId = new StorageResourceId(TEST_BUCKET, this.name.getMethodName());
        int uploadChunkSize = 0x300000;
        GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorageImpl> trackingGcs = GoogleCloudStorageImplTest.newTrackingGoogleCloudStorage(GoogleCloudStorageImplTest.getOptionsWithUploadChunk(uploadChunkSize));
        int partitionsCount = 17;
        byte[] partition = GoogleCloudStorageTestHelper.writeObject((GoogleCloudStorage)trackingGcs.delegate, resourceId, 0x100000, partitionsCount);
        GoogleCloudStorageTestHelper.assertObjectContent(helperGcs, resourceId, partition, partitionsCount);
        Truth.assertThat(trackingGcs.requestsTracker.getAllRequestStrings()).containsExactlyElementsIn(GoogleCloudStorageImplTest.getExpectedRequestsForCreateObject(resourceId, uploadChunkSize, partitionsCount, partition)).inOrder();
    }

    @Test
    public void conflictingWrites_noOverwrite_lastFails() throws IOException {
        StorageResourceId resourceId = new StorageResourceId(TEST_BUCKET, this.name.getMethodName());
        GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorageImpl> trackingGcs = GoogleCloudStorageImplTest.newTrackingGoogleCloudStorage(GCS_OPTIONS);
        byte[] bytesToWrite = new byte[1024];
        GoogleCloudStorageTestHelper.fillBytes(bytesToWrite);
        WritableByteChannel channel1 = ((GoogleCloudStorageImpl)trackingGcs.delegate).create(resourceId, CreateObjectOptions.DEFAULT_NO_OVERWRITE);
        channel1.write(ByteBuffer.wrap(bytesToWrite));
        WritableByteChannel channel2 = ((GoogleCloudStorageImpl)trackingGcs.delegate).create(resourceId, CreateObjectOptions.DEFAULT_NO_OVERWRITE);
        channel1.close();
        Throwable thrown = Assert.assertThrows(Throwable.class, channel2::close);
        Truth.assertThat((Throwable)thrown).hasCauseThat().hasMessageThat().contains((CharSequence)"412 Precondition Failed");
        GoogleCloudStorageTestHelper.assertObjectContent(helperGcs, resourceId, bytesToWrite, 1);
        Truth.assertThat(trackingGcs.requestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(resourceId.getBucketName(), resourceId.getObjectName()), TrackingHttpRequestInitializer.getRequestString(resourceId.getBucketName(), resourceId.getObjectName()), TrackingHttpRequestInitializer.resumableUploadRequestString(resourceId.getBucketName(), resourceId.getObjectName(), 1, true), TrackingHttpRequestInitializer.resumableUploadRequestString(resourceId.getBucketName(), resourceId.getObjectName(), 2, true), TrackingHttpRequestInitializer.resumableUploadChunkRequestString(resourceId.getBucketName(), resourceId.getObjectName(), 3, 1), TrackingHttpRequestInitializer.resumableUploadChunkRequestString(resourceId.getBucketName(), resourceId.getObjectName(), 4, 2)});
    }

    @Test
    public void create_doesNotRepairImplicitDirectories() throws IOException {
        String testDirectory = this.name.getMethodName();
        StorageResourceId resourceId = new StorageResourceId(TEST_BUCKET, testDirectory + "/obj");
        GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorageImpl> trackingGcs = GoogleCloudStorageImplTest.newTrackingGoogleCloudStorage(GCS_OPTIONS);
        ((GoogleCloudStorageImpl)trackingGcs.delegate).createEmptyObject(resourceId);
        GoogleCloudStorageItemInfo itemInfo = helperGcs.getItemInfo(new StorageResourceId(TEST_BUCKET, testDirectory + "/"));
        Truth.assertThat((Boolean)itemInfo.exists()).isFalse();
        List listedItems = helperGcs.listObjectInfo(TEST_BUCKET, testDirectory + "/");
        Truth.assertThat((Object[])listedItems.stream().map(GoogleCloudStorageItemInfo::getResourceId).toArray()).asList().containsExactly(new Object[]{resourceId});
        Truth.assertThat(trackingGcs.requestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.uploadRequestString(resourceId.getBucketName(), resourceId.getObjectName(), null)});
    }

    @Test
    public void create_correctlySetsContentType() throws IOException {
        StorageResourceId resourceId1 = new StorageResourceId(TEST_BUCKET, this.name.getMethodName() + "_obj1");
        StorageResourceId resourceId2 = new StorageResourceId(TEST_BUCKET, this.name.getMethodName() + "_obj2");
        StorageResourceId resourceId3 = new StorageResourceId(TEST_BUCKET, this.name.getMethodName() + "obj3");
        GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorageImpl> trackingGcs = GoogleCloudStorageImplTest.newTrackingGoogleCloudStorage(GCS_OPTIONS);
        ((GoogleCloudStorageImpl)trackingGcs.delegate).createEmptyObject(resourceId1, CreateObjectOptions.builder().setContentType("text/plain").build());
        ((GoogleCloudStorageImpl)trackingGcs.delegate).create(resourceId2, CreateObjectOptions.builder().setContentType("image/png").build()).close();
        ((GoogleCloudStorageImpl)trackingGcs.delegate).create(resourceId3).close();
        Truth.assertThat((Object[])helperGcs.getItemInfos((List)ImmutableList.of((Object)resourceId1, (Object)resourceId2, (Object)resourceId3)).stream().map(GoogleCloudStorageItemInfo::getContentType).toArray()).asList().containsExactly(new Object[]{"text/plain", "image/png", "application/octet-stream"}).inOrder();
        Truth.assertThat(trackingGcs.requestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.uploadRequestString(resourceId1.getBucketName(), resourceId1.getObjectName(), 1), TrackingHttpRequestInitializer.getRequestString(resourceId2.getBucketName(), resourceId2.getObjectName()), TrackingHttpRequestInitializer.resumableUploadRequestString(resourceId2.getBucketName(), resourceId2.getObjectName(), 2, true), TrackingHttpRequestInitializer.resumableUploadChunkRequestString(resourceId2.getBucketName(), resourceId2.getObjectName(), 3, 1), TrackingHttpRequestInitializer.getRequestString(resourceId3.getBucketName(), resourceId3.getObjectName()), TrackingHttpRequestInitializer.resumableUploadRequestString(resourceId3.getBucketName(), resourceId3.getObjectName(), 4, true), TrackingHttpRequestInitializer.resumableUploadChunkRequestString(resourceId3.getBucketName(), resourceId3.getObjectName(), 5, 2)});
    }

    @Test
    public void copy_withRewrite_multipleRequests() throws IOException {
        int maxBytesRewrittenPerCall = 0x10000000;
        GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorageImpl> trackingGcs = GoogleCloudStorageImplTest.newTrackingGoogleCloudStorage(GoogleCloudStorageTestHelper.getStandardOptionBuilder().setCopyWithRewriteEnabled(true).setMaxBytesRewrittenPerCall((long)maxBytesRewrittenPerCall).build());
        String srcBucketName = TEST_BUCKET;
        StorageResourceId resourceId = new StorageResourceId(srcBucketName, this.name.getMethodName() + "_src");
        String dstBucketName = BUCKET_HELPER.getUniqueBucketName("copy-with-rewrite-dst");
        helperGcs.createBucket(dstBucketName, CreateBucketOptions.builder().setStorageClass("nearline").build());
        StorageResourceId copiedResourceId = new StorageResourceId(dstBucketName, this.name.getMethodName() + "_dst");
        int partitionsCount = 10;
        byte[] partition = GoogleCloudStorageTestHelper.writeObject(helperGcs, resourceId, 0x4000000, partitionsCount);
        ((GoogleCloudStorageImpl)trackingGcs.delegate).copy(srcBucketName, (List)ImmutableList.of((Object)resourceId.getObjectName()), dstBucketName, (List)ImmutableList.of((Object)copiedResourceId.getObjectName()));
        GoogleCloudStorageTestHelper.assertObjectContent(helperGcs, copiedResourceId, partition, partitionsCount);
        Truth.assertThat(trackingGcs.requestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getBucketRequestString(resourceId.getBucketName()), TrackingHttpRequestInitializer.getBucketRequestString(copiedResourceId.getBucketName()), TrackingHttpRequestInitializer.rewriteRequestString(resourceId.getBucketName(), resourceId.getObjectName(), copiedResourceId.getBucketName(), copiedResourceId.getObjectName(), maxBytesRewrittenPerCall, null), TrackingHttpRequestInitializer.rewriteRequestString(resourceId.getBucketName(), resourceId.getObjectName(), copiedResourceId.getBucketName(), copiedResourceId.getObjectName(), maxBytesRewrittenPerCall, 1), TrackingHttpRequestInitializer.rewriteRequestString(resourceId.getBucketName(), resourceId.getObjectName(), copiedResourceId.getBucketName(), copiedResourceId.getObjectName(), maxBytesRewrittenPerCall, 2)});
    }

    @Test
    public void create_gcsItemInfo_metadataEquals() throws IOException {
        StorageResourceId resourceId = new StorageResourceId(TEST_BUCKET, this.name.getMethodName());
        GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorageImpl> trackingGcs = GoogleCloudStorageImplTest.newTrackingGoogleCloudStorage(GCS_OPTIONS);
        ImmutableMap expectedMetadata = ImmutableMap.of((Object)"key1", (Object)"value1".getBytes(StandardCharsets.UTF_8), (Object)"key2", (Object)"value2".getBytes(StandardCharsets.UTF_8));
        ImmutableMap wrongMetadata = ImmutableMap.of((Object)"key", (Object)"value1".getBytes(StandardCharsets.UTF_8), (Object)"key2", (Object)"value2".getBytes(StandardCharsets.UTF_8));
        ((GoogleCloudStorageImpl)trackingGcs.delegate).createEmptyObject(resourceId, CreateObjectOptions.builder().setMetadata((Map)expectedMetadata).build());
        GoogleCloudStorageItemInfo itemInfo = helperGcs.getItemInfo(resourceId);
        Truth.assertThat((Boolean)itemInfo.metadataEquals((Map)expectedMetadata)).isTrue();
        Truth.assertThat((Boolean)itemInfo.metadataEquals(itemInfo.getMetadata())).isTrue();
        Truth.assertThat((Boolean)itemInfo.metadataEquals((Map)wrongMetadata)).isFalse();
        Truth.assertThat(trackingGcs.requestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.uploadRequestString(resourceId.getBucketName(), resourceId.getObjectName(), 1)});
    }

    private static GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorageImpl> newTrackingGoogleCloudStorage(GoogleCloudStorageOptions options) throws IOException {
        return new GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorageImpl>(options, httpRequestInitializer -> new GoogleCloudStorageImpl(options, (HttpRequestInitializer)httpRequestInitializer));
    }

    private static GoogleCloudStorageOptions getOptionsWithUploadChunk(int uploadChunk) {
        return GoogleCloudStorageTestHelper.getStandardOptionBuilder().setWriteChannelOptions(AsyncWriteChannelOptions.builder().setUploadChunkSize(uploadChunk).build()).build();
    }

    private static List<String> getExpectedRequestsForCreateObject(StorageResourceId resourceId, int uploadChunkSize, int partitionsCount, byte[] partition) {
        return ImmutableList.builder().add((Object)TrackingHttpRequestInitializer.getRequestString(resourceId.getBucketName(), resourceId.getObjectName())).add((Object)TrackingHttpRequestInitializer.resumableUploadRequestString(resourceId.getBucketName(), resourceId.getObjectName(), 1, true)).addAll((Iterable)IntStream.rangeClosed(1, (int)Math.ceil((double)partition.length * (double)partitionsCount / (double)uploadChunkSize)).mapToObj(i -> TrackingHttpRequestInitializer.resumableUploadChunkRequestString(resourceId.getBucketName(), resourceId.getObjectName(), i + 1, i)).collect(Collectors.toList())).build();
    }
}

