/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio.integration;

import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.integration.GoogleCloudStorageTestHelper;
import com.google.cloud.hadoop.util.RedactedString;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CsekEncryptionIntegrationTest {
    private static final GoogleCloudStorageTestHelper.TestBucketHelper BUCKET_HELPER = new GoogleCloudStorageTestHelper.TestBucketHelper("gcs-csek-encryption");

    @AfterClass
    public static void afterAll() throws IOException {
        BUCKET_HELPER.cleanup((GoogleCloudStorage)CsekEncryptionIntegrationTest.makeStorage(GoogleCloudStorageTestHelper.getStandardOptionBuilder().build()));
    }

    @Test
    public void uploadAndGetObject() throws IOException {
        GoogleCloudStorageImpl gcs = CsekEncryptionIntegrationTest.makeStorage(CsekEncryptionIntegrationTest.getCsekStorageOptions().build());
        String bucketName = BUCKET_HELPER.getUniqueBucketName("upload-and-get");
        StorageResourceId resourceId = new StorageResourceId(bucketName, "obj");
        gcs.createBucket(bucketName);
        gcs.createEmptyObject(resourceId, CreateObjectOptions.builder().setContentType("text/plain").build());
        Truth.assertThat((String)gcs.getItemInfo(resourceId).getContentType()).isEqualTo((Object)"text/plain");
    }

    @Test
    public void rewriteObject() throws IOException {
        GoogleCloudStorageImpl gcs = CsekEncryptionIntegrationTest.makeStorage(CsekEncryptionIntegrationTest.getCsekStorageOptions().setCopyWithRewriteEnabled(true).setMaxBytesRewrittenPerCall(0x20000000L).build());
        String srcBucketName = BUCKET_HELPER.getUniqueBucketName("rewrite-src");
        gcs.createBucket(srcBucketName);
        String dstBucketName = BUCKET_HELPER.getUniqueBucketName("rewrite-dst");
        gcs.createBucket(dstBucketName);
        StorageResourceId srcResourceId = new StorageResourceId(srcBucketName, "encryptedObject");
        int partitionsCount = 32;
        byte[] partition = GoogleCloudStorageTestHelper.writeObject((GoogleCloudStorage)gcs, srcResourceId, 0x4000000, partitionsCount);
        StorageResourceId dstResourceId = new StorageResourceId(dstBucketName, "encryptedObject");
        gcs.copy(srcBucketName, (List)ImmutableList.of((Object)srcResourceId.getObjectName()), dstBucketName, (List)ImmutableList.of((Object)dstResourceId.getObjectName()));
        GoogleCloudStorageTestHelper.assertObjectContent((GoogleCloudStorage)gcs, dstResourceId, partition, partitionsCount);
    }

    private static GoogleCloudStorageImpl makeStorage(GoogleCloudStorageOptions options) throws IOException {
        return new GoogleCloudStorageImpl(options, GoogleCloudStorageTestHelper.getCredential());
    }

    private static GoogleCloudStorageOptions.Builder getCsekStorageOptions() {
        return GoogleCloudStorageTestHelper.getStandardOptionBuilder().setEncryptionAlgorithm("AES256").setEncryptionKey(RedactedString.create((String)"CSX19s0epGWZP3h271Idu8xma2WhMuKT8ZisYfcjLM8=")).setEncryptionKeyHash(RedactedString.create((String)"LpH4y6Bki5zIhYrjGo1J4BuSt12G/1B+n3FwORpdoyQ="));
    }
}

