/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.http.InputStreamContent;
import com.google.api.services.storage.Storage;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageTestUtils;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageWriteChannel;
import com.google.cloud.hadoop.gcsio.ObjectWriteConditions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.ClientRequestHelper;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GoogleCloudStorageWriteChannelTest {
    @Test
    public void createRequest_shouldSetKmsKeyName() throws IOException {
        String kmsKeyName = "testKmsKey";
        GoogleCloudStorageWriteChannel writeChannel = new GoogleCloudStorageWriteChannel(new Storage(GoogleCloudStorageTestUtils.HTTP_TRANSPORT, GoogleCloudStorageTestUtils.JSON_FACTORY, r -> {}), new ClientRequestHelper(), (ExecutorService)MoreExecutors.newDirectExecutorService(), AsyncWriteChannelOptions.DEFAULT, new StorageResourceId("foo-bucket", "bar-object"), CreateObjectOptions.DEFAULT_NO_OVERWRITE.toBuilder().setKmsKeyName(kmsKeyName).build(), ObjectWriteConditions.NONE);
        Storage.Objects.Insert request = writeChannel.createRequest(new InputStreamContent("plain/text", (InputStream)new ByteArrayInputStream(new byte[0])));
        Truth.assertThat((String)request.getKmsKeyName()).isEqualTo((Object)kmsKeyName);
    }
}

