/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadChannel;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.google.cloud.hadoop.util.ClientRequestHelper;
import java.io.IOException;
import java.util.UUID;

public final class GoogleCloudStorageTestUtils {
    public static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    public static final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
    static final String GOOGLEAPIS_ENDPOINT = "https://storage.googleapis.com";
    private static final String RESUMABLE_UPLOAD_LOCATION_FORMAT = "https://storage.googleapis.com/upload/storage/v1/b/%s/o?name=%s&uploadType=resumable&upload_id=%s";
    static final String BUCKET_NAME = "foo-bucket";
    static final String OBJECT_NAME = "bar-object";
    private static final ApiErrorExtractor ERROR_EXTRACTOR = ApiErrorExtractor.INSTANCE;
    private static final ClientRequestHelper<StorageObject> REQUEST_HELPER = new ClientRequestHelper();

    private GoogleCloudStorageTestUtils() {
    }

    public static GoogleCloudStorageReadChannel createReadChannel(Storage storage, GoogleCloudStorageReadOptions options) throws IOException {
        return new GoogleCloudStorageReadChannel(storage, new StorageResourceId(BUCKET_NAME, OBJECT_NAME), ERROR_EXTRACTOR, REQUEST_HELPER, options);
    }

    public static GoogleCloudStorageReadChannel createReadChannel(Storage storage, GoogleCloudStorageReadOptions options, long generation) throws IOException {
        return new GoogleCloudStorageReadChannel(storage, new StorageResourceId(BUCKET_NAME, OBJECT_NAME, generation), ERROR_EXTRACTOR, REQUEST_HELPER, options);
    }

    public static MockLowLevelHttpResponse resumableUploadResponse(String bucket, String object) {
        String uploadId = UUID.randomUUID().toString();
        return new MockLowLevelHttpResponse().addHeader("location", String.format(RESUMABLE_UPLOAD_LOCATION_FORMAT, bucket, object, uploadId));
    }
}

