/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.GoogleCloudStorageStrings;
import com.google.cloud.hadoop.gcsio.ListObjectOptions;
import com.google.common.truth.Truth;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GoogleCloudStorageStringsTest {
    @Test
    public void testConstructorForLineCoverage() {
        new GoogleCloudStorageStrings();
    }

    @Test
    public void testMatchListPrefixIllegalArguments() {
        String[][] invalidArgs;
        for (String[] args : invalidArgs = new String[][]{{"my-prefix", null}, {"my-prefix", ""}, {null, null}, {null, ""}}) {
            IllegalArgumentException iae = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> GoogleCloudStorageStrings.matchListPrefix((String)args[0], (String)args[1], (ListObjectOptions)ListObjectOptions.DEFAULT));
            Truth.assertThat((Throwable)iae).hasMessageThat().matches(".*objectName.*");
        }
    }

    private void verifyExpectations(MatchResultExpectation[] expectations) {
        for (MatchResultExpectation expectation : expectations) {
            String actualReturn = GoogleCloudStorageStrings.matchListPrefix((String)expectation.objectNamePrefix, (String)expectation.objectName, (ListObjectOptions)ListObjectOptions.DEFAULT.toBuilder().setDelimiter(expectation.delimiter).build());
            Truth.assertWithMessage((String)String.format("Got returnValue '%s' for expectation: %s", actualReturn, expectation)).that(actualReturn).isEqualTo((Object)expectation.returnValue);
        }
    }

    @Test
    public void testMatchListPrefixNoPrefixNoDelimiter() {
        MatchResultExpectation[] expectations = new MatchResultExpectation[]{new MatchResultExpectation(null, null, "/").willReturn("/"), new MatchResultExpectation(null, null, "foo/bar").willReturn("foo/bar"), new MatchResultExpectation(null, "", "foo/bar").willReturn("foo/bar"), new MatchResultExpectation("", "", "foo/bar").willReturn("foo/bar")};
        this.verifyExpectations(expectations);
    }

    @Test
    public void testMatchListPrefixNoDelimiter() {
        MatchResultExpectation[] expectations = new MatchResultExpectation[]{new MatchResultExpectation("foo/bar/baz", null, "foo/bar/baz123").willReturn("foo/bar/baz123"), new MatchResultExpectation("foo/bar/baz", null, "foo/bar/baz").willReturn("foo/bar/baz"), new MatchResultExpectation("foo/bar/baz", null, "foo/bar/ba").willReturn(null), new MatchResultExpectation("foo/bar/baz", null, "foo/bar/baz/sub").willReturn("foo/bar/baz/sub"), new MatchResultExpectation("foo/bar/baz", null, "foo/bar/baz/").willReturn("foo/bar/baz/"), new MatchResultExpectation("foo/bar/baz/", null, "foo/bar/baz/").willReturn(null)};
        this.verifyExpectations(expectations);
    }

    @Test
    public void testMatchListPrefixNoPrefix() {
        MatchResultExpectation[] expectations = new MatchResultExpectation[]{new MatchResultExpectation(null, "/", "/").willReturn("/"), new MatchResultExpectation(null, "/", "foo/bar").willReturn("foo/"), new MatchResultExpectation(null, "/", "foo/bar/").willReturn("foo/"), new MatchResultExpectation(null, "/", "foo/").willReturn("foo/"), new MatchResultExpectation(null, "/", "foo").willReturn("foo"), new MatchResultExpectation(null, "/", "/foo/bar").willReturn("/")};
        this.verifyExpectations(expectations);
    }

    @Test
    public void testMatchListPrefixWithPrefixAndDelimiter() {
        MatchResultExpectation[] expectations = new MatchResultExpectation[]{new MatchResultExpectation("foo/bar", "/", "foo/bar/baz").willReturn("foo/bar/"), new MatchResultExpectation("foo/bar", "/", "foo/bar123/baz").willReturn("foo/bar123/"), new MatchResultExpectation("foo/bar", "/", "foo/bar").willReturn("foo/bar"), new MatchResultExpectation("foo/bar/", "/", "foo/bar/").willReturn(null), new MatchResultExpectation("foo/bar/", "/", "foo/bar/baz").willReturn("foo/bar/baz"), new MatchResultExpectation("foo/bar/", "/", "foo/bar/baz/bat").willReturn("foo/bar/baz/"), new MatchResultExpectation("foo$$bar", "$$", "foo$$bar$$baz").willReturn("foo$$bar$$"), new MatchResultExpectation("foo$$bar$$", "$$", "foo$$bar$$baz").willReturn("foo$$bar$$baz"), new MatchResultExpectation("foo$$bar$$", "$$", "foo$$bar$$baz$$bat").willReturn("foo$$bar$$baz$$")};
        this.verifyExpectations(expectations);
    }

    private static class MatchResultExpectation {
        public final String objectNamePrefix;
        public final String delimiter;
        public final String objectName;
        public String returnValue;

        public MatchResultExpectation(String objectNamePrefix, String delimiter, String objectName) {
            this.objectNamePrefix = objectNamePrefix;
            this.delimiter = delimiter;
            this.objectName = objectName;
        }

        public MatchResultExpectation willReturn(String returnValue) {
            this.returnValue = returnValue;
            return this;
        }

        public String toString() {
            return String.format("Expect '%s' for args (%s, %s, %s)", this.returnValue, this.objectNamePrefix, this.delimiter, this.objectName);
        }
    }
}

