/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.googleapis.batch.json.JsonBatchCallback;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.DateTime;
import com.google.api.client.util.NanoClock;
import com.google.api.client.util.Sleeper;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.StorageRequest;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.gcsio.BatchHelper;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadChannel;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageTest;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.google.cloud.hadoop.util.ClientRequestHelper;
import com.google.cloud.hadoop.util.testing.MockHttpTransportHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class GoogleCloudStorageMockitoTest {
    private static final String APP_NAME = "GCS-Unit-Test";
    private static final String PROJECT_ID = "google.com:foo-project";
    private static final String BUCKET_NAME = "foo-bucket";
    private static final String OBJECT_NAME = "bar-object";
    private static final String OBJECT_FIELDS = "bucket,name,timeCreated,updated,generation,metageneration,size,contentType,contentEncoding,md5Hash,crc32c,metadata";
    private ExecutorService executorService;
    @Mock
    private Storage mockStorage;
    @Mock
    private Storage.Objects mockStorageObjects;
    @Mock
    private Storage.Objects.Insert mockStorageObjectsInsert;
    @Mock
    private Storage.Objects.Delete mockStorageObjectsDelete;
    @Mock
    private Storage.Objects.Get mockStorageObjectsGet;
    @Mock
    private Storage.Objects.Copy mockStorageObjectsCopy;
    @Mock
    private Storage.Objects.Compose mockStorageObjectsCompose;
    @Mock
    private Storage.Objects.List mockStorageObjectsList;
    @Mock
    private Storage.Buckets mockStorageBuckets;
    @Mock
    private Storage.Buckets.Insert mockStorageBucketsInsert;
    @Mock
    private Storage.Buckets.Delete mockStorageBucketsDelete;
    @Mock
    private Storage.Buckets.Get mockStorageBucketsGet;
    @Mock
    private Storage.Buckets.Get mockStorageBucketsGet2;
    @Mock
    private Storage.Buckets.List mockStorageBucketsList;
    @Mock
    private ApiErrorExtractor mockErrorExtractor;
    @Mock
    private BatchHelper.Factory mockBatchFactory;
    @Mock
    private BatchHelper mockBatchHelper;
    @Mock
    private HttpHeaders mockHeaders;
    @Mock
    private ClientRequestHelper<StorageObject> mockClientRequestHelper;
    @Mock
    private Sleeper mockSleeper;
    @Mock
    private NanoClock mockClock;
    @Mock
    private BackOff mockBackOff;
    @Mock
    private BackOff mockReadBackOff;
    @Mock
    private GoogleCloudStorageImpl.BackOffFactory mockBackOffFactory;
    private GoogleCloudStorage gcs;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.executorService = Executors.newCachedThreadPool();
        this.gcs = this.createTestInstance();
    }

    protected GoogleCloudStorageOptions.Builder createDefaultCloudStorageOptionsBuilder() {
        return GoogleCloudStorageOptions.builder().setAppName(APP_NAME).setProjectId(PROJECT_ID);
    }

    protected GoogleCloudStorage createTestInstance() {
        return this.createTestInstance(this.createDefaultCloudStorageOptionsBuilder().build());
    }

    protected GoogleCloudStorage createTestInstance(GoogleCloudStorageOptions options) {
        GoogleCloudStorageImpl gcsTestInstance = new GoogleCloudStorageImpl(options, this.mockStorage);
        gcsTestInstance.setBackgroundTasksThreadPool(this.executorService);
        gcsTestInstance.setErrorExtractor(this.mockErrorExtractor);
        gcsTestInstance.setClientRequestHelper(this.mockClientRequestHelper);
        gcsTestInstance.setBatchFactory(this.mockBatchFactory);
        gcsTestInstance.setSleeper(this.mockSleeper);
        gcsTestInstance.setBackOffFactory(this.mockBackOffFactory);
        return gcsTestInstance;
    }

    protected void setupNonConflictedWrite(Throwable t) throws IOException {
        this.setupNonConflictedWrite((Answer<StorageObject>)((Answer)invocation -> {
            throw t;
        }));
    }

    protected void setupNonConflictedWrite(Answer<StorageObject> answer) throws IOException {
        Mockito.when((Object)this.mockStorageObjects.get(BUCKET_NAME, OBJECT_NAME)).thenReturn((Object)this.mockStorageObjectsGet);
        Mockito.when((Object)this.mockStorageObjectsGet.setFields(ArgumentMatchers.anyString())).thenReturn((Object)this.mockStorageObjectsGet);
        Mockito.when((Object)this.mockStorageObjectsGet.execute()).thenThrow(new Throwable[]{new IOException("NotFound")});
        Mockito.when((Object)this.mockErrorExtractor.itemNotFound((IOException)ArgumentMatchers.any(IOException.class))).thenReturn((Object)true);
        Mockito.when((Object)this.mockStorageObjectsInsert.execute()).thenAnswer(answer);
    }

    @After
    public void tearDown() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorage});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorageObjects});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorageObjectsInsert});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorageObjectsDelete});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorageObjectsGet});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorageObjectsCopy});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorageObjectsCompose});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorageObjectsList});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorageBuckets});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorageBucketsInsert});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorageBucketsDelete});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorageBucketsGet});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorageBucketsGet2});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStorageBucketsList});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockErrorExtractor});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockBatchFactory});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockBatchHelper});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockHeaders});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockClientRequestHelper});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockSleeper});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockClock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockBackOff});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockReadBackOff});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockBackOffFactory});
    }

    @Test
    public void testCreateObjectApiInterruptedException() throws Exception {
        Mockito.when((Object)this.mockStorage.objects()).thenReturn((Object)this.mockStorageObjects);
        Mockito.when((Object)this.mockStorageObjects.insert((String)ArgumentMatchers.eq((Object)BUCKET_NAME), (StorageObject)ArgumentMatchers.any(StorageObject.class), (AbstractInputStreamContent)ArgumentMatchers.any(AbstractInputStreamContent.class))).thenReturn((Object)this.mockStorageObjectsInsert);
        Mockito.when((Object)this.mockStorageObjectsInsert.setName((String)ArgumentMatchers.eq((Object)OBJECT_NAME))).thenReturn((Object)this.mockStorageObjectsInsert);
        Mockito.when((Object)this.mockStorageObjectsInsert.setKmsKeyName((String)ArgumentMatchers.any())).thenReturn((Object)this.mockStorageObjectsInsert);
        CountDownLatch waitForEverLatch = new CountDownLatch(1);
        CountDownLatch writeStartedLatch = new CountDownLatch(2);
        CountDownLatch threadsDoneLatch = new CountDownLatch(2);
        this.setupNonConflictedWrite((Answer<StorageObject>)((Answer)unused -> {
            try {
                writeStartedLatch.countDown();
                waitForEverLatch.await();
                Assert.fail((String)"Unexpected to get here.");
                StorageObject storageObject = null;
                return storageObject;
            }
            finally {
                threadsDoneLatch.countDown();
            }
        }));
        WritableByteChannel writeChannel = this.gcs.create(new StorageResourceId(BUCKET_NAME, OBJECT_NAME));
        Truth.assertThat((Boolean)writeChannel.isOpen()).isTrue();
        Future<?> write = this.executorService.submit(() -> {
            writeStartedLatch.countDown();
            try {
                IOException ioe = (IOException)Assert.assertThrows(IOException.class, writeChannel::close);
                Truth.assertThat((Throwable)ioe).isInstanceOf(ClosedByInterruptException.class);
            }
            finally {
                threadsDoneLatch.countDown();
            }
        });
        Truth.assertWithMessage((String)"Neither thread started.").that(Boolean.valueOf(writeStartedLatch.await(5000L, TimeUnit.MILLISECONDS))).isTrue();
        write.cancel(true);
        Truth.assertWithMessage((String)"Failed to wait for tasks to get interrupted.").that(Boolean.valueOf(threadsDoneLatch.await(5000L, TimeUnit.MILLISECONDS))).isTrue();
        ((Storage)Mockito.verify((Object)this.mockStorage, (VerificationMode)Mockito.times((int)2))).objects();
        ((Storage.Objects)Mockito.verify((Object)this.mockStorageObjects)).insert((String)ArgumentMatchers.eq((Object)BUCKET_NAME), (StorageObject)ArgumentMatchers.any(StorageObject.class), (AbstractInputStreamContent)ArgumentMatchers.any(AbstractInputStreamContent.class));
        ((Storage.Objects.Insert)Mockito.verify((Object)this.mockStorageObjectsInsert)).setName((String)ArgumentMatchers.eq((Object)OBJECT_NAME));
        ((Storage.Objects.Insert)Mockito.verify((Object)this.mockStorageObjectsInsert)).setKmsKeyName((String)ArgumentMatchers.any());
        ((Storage.Objects.Insert)Mockito.verify((Object)this.mockStorageObjectsInsert)).setDisableGZipContent(ArgumentMatchers.eq((boolean)true));
        ((ClientRequestHelper)Mockito.verify(this.mockClientRequestHelper)).setChunkSize((AbstractGoogleClientRequest)ArgumentMatchers.any(Storage.Objects.Insert.class), ArgumentMatchers.anyInt());
        ((Storage.Objects.Insert)Mockito.verify((Object)this.mockStorageObjectsInsert)).setIfGenerationMatch(Long.valueOf(ArgumentMatchers.eq((long)0L)));
        ((Storage.Objects)Mockito.verify((Object)this.mockStorageObjects)).get((String)ArgumentMatchers.eq((Object)BUCKET_NAME), (String)ArgumentMatchers.eq((Object)OBJECT_NAME));
        ((Storage.Objects.Get)Mockito.verify((Object)this.mockStorageObjectsGet)).setFields((String)ArgumentMatchers.eq((Object)OBJECT_FIELDS));
        ((Storage.Objects.Get)Mockito.verify((Object)this.mockStorageObjectsGet)).execute();
        ((ApiErrorExtractor)Mockito.verify((Object)this.mockErrorExtractor)).itemNotFound((IOException)ArgumentMatchers.any(IOException.class));
        ((Storage.Objects.Insert)Mockito.verify((Object)this.mockStorageObjectsInsert)).execute();
    }

    @Test
    public void testCreateObjectApiRuntimeException() throws IOException {
        Mockito.when((Object)this.mockStorage.objects()).thenReturn((Object)this.mockStorageObjects);
        Mockito.when((Object)this.mockStorageObjects.insert((String)ArgumentMatchers.eq((Object)BUCKET_NAME), (StorageObject)ArgumentMatchers.any(StorageObject.class), (AbstractInputStreamContent)ArgumentMatchers.any(AbstractInputStreamContent.class))).thenReturn((Object)this.mockStorageObjectsInsert);
        Mockito.when((Object)this.mockStorageObjectsInsert.setName((String)ArgumentMatchers.eq((Object)OBJECT_NAME))).thenReturn((Object)this.mockStorageObjectsInsert);
        Mockito.when((Object)this.mockStorageObjectsInsert.setKmsKeyName((String)ArgumentMatchers.any())).thenReturn((Object)this.mockStorageObjectsInsert);
        RuntimeException fakeException = new RuntimeException("Fake exception");
        this.setupNonConflictedWrite(fakeException);
        WritableByteChannel writeChannel = this.gcs.create(new StorageResourceId(BUCKET_NAME, OBJECT_NAME));
        Truth.assertThat((Boolean)writeChannel.isOpen()).isTrue();
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, writeChannel::close);
        Truth.assertThat((Throwable)thrown).hasCauseThat().isEqualTo((Object)fakeException);
        ((Storage.Objects.Insert)Mockito.verify((Object)this.mockStorageObjectsInsert)).execute();
        ((Storage)Mockito.verify((Object)this.mockStorage, (VerificationMode)Mockito.times((int)2))).objects();
        ((Storage.Objects)Mockito.verify((Object)this.mockStorageObjects)).insert((String)ArgumentMatchers.eq((Object)BUCKET_NAME), (StorageObject)ArgumentMatchers.any(StorageObject.class), (AbstractInputStreamContent)ArgumentMatchers.any(AbstractInputStreamContent.class));
        ((Storage.Objects)Mockito.verify((Object)this.mockStorageObjects)).get((String)ArgumentMatchers.eq((Object)BUCKET_NAME), (String)ArgumentMatchers.eq((Object)OBJECT_NAME));
        ((ApiErrorExtractor)Mockito.verify((Object)this.mockErrorExtractor, (VerificationMode)Mockito.atLeastOnce())).itemNotFound((IOException)ArgumentMatchers.any(IOException.class));
        ((Storage.Objects.Get)Mockito.verify((Object)this.mockStorageObjectsGet)).execute();
        ((Storage.Objects.Insert)Mockito.verify((Object)this.mockStorageObjectsInsert)).setName((String)ArgumentMatchers.eq((Object)OBJECT_NAME));
        ((Storage.Objects.Insert)Mockito.verify((Object)this.mockStorageObjectsInsert)).setKmsKeyName((String)ArgumentMatchers.any());
        ((Storage.Objects.Insert)Mockito.verify((Object)this.mockStorageObjectsInsert)).setDisableGZipContent(ArgumentMatchers.eq((boolean)true));
        ((Storage.Objects)Mockito.verify((Object)this.mockStorageObjects)).get(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        ((Storage.Objects.Get)Mockito.verify((Object)this.mockStorageObjectsGet)).setFields((String)ArgumentMatchers.eq((Object)OBJECT_FIELDS));
        ((ClientRequestHelper)Mockito.verify(this.mockClientRequestHelper)).setChunkSize((AbstractGoogleClientRequest)ArgumentMatchers.any(Storage.Objects.Insert.class), ArgumentMatchers.anyInt());
        ((Storage.Objects.Insert)Mockito.verify((Object)this.mockStorageObjectsInsert)).setIfGenerationMatch(Long.valueOf(ArgumentMatchers.anyLong()));
    }

    @Test
    public void testCreateObjectApiError() throws IOException {
        Mockito.when((Object)this.mockStorage.objects()).thenReturn((Object)this.mockStorageObjects);
        Error fakeError = new Error("Fake error");
        this.setupNonConflictedWrite(fakeError);
        Mockito.when((Object)this.mockStorageObjects.insert((String)ArgumentMatchers.eq((Object)BUCKET_NAME), (StorageObject)ArgumentMatchers.any(StorageObject.class), (AbstractInputStreamContent)ArgumentMatchers.any(AbstractInputStreamContent.class))).thenReturn((Object)this.mockStorageObjectsInsert);
        Mockito.when((Object)this.mockStorageObjectsInsert.setName((String)ArgumentMatchers.eq((Object)OBJECT_NAME))).thenReturn((Object)this.mockStorageObjectsInsert);
        Mockito.when((Object)this.mockStorageObjectsInsert.setKmsKeyName((String)ArgumentMatchers.any())).thenReturn((Object)this.mockStorageObjectsInsert);
        WritableByteChannel writeChannel = this.gcs.create(new StorageResourceId(BUCKET_NAME, OBJECT_NAME));
        Truth.assertThat((Boolean)writeChannel.isOpen()).isTrue();
        Error thrown = (Error)Assert.assertThrows(Error.class, writeChannel::close);
        Truth.assertThat((Throwable)thrown).isEqualTo((Object)fakeError);
        ((Storage)Mockito.verify((Object)this.mockStorage, (VerificationMode)Mockito.times((int)2))).objects();
        ((Storage.Objects)Mockito.verify((Object)this.mockStorageObjects)).insert((String)ArgumentMatchers.eq((Object)BUCKET_NAME), (StorageObject)ArgumentMatchers.any(StorageObject.class), (AbstractInputStreamContent)ArgumentMatchers.any(AbstractInputStreamContent.class));
        ((Storage.Objects)Mockito.verify((Object)this.mockStorageObjects)).get(BUCKET_NAME, OBJECT_NAME);
        ((Storage.Objects.Get)Mockito.verify((Object)this.mockStorageObjectsGet)).setFields((String)ArgumentMatchers.eq((Object)OBJECT_FIELDS));
        ((Storage.Objects.Get)Mockito.verify((Object)this.mockStorageObjectsGet)).execute();
        ((Storage.Objects.Insert)Mockito.verify((Object)this.mockStorageObjectsInsert)).setName((String)ArgumentMatchers.eq((Object)OBJECT_NAME));
        ((Storage.Objects.Insert)Mockito.verify((Object)this.mockStorageObjectsInsert)).setKmsKeyName((String)ArgumentMatchers.any());
        ((Storage.Objects.Insert)Mockito.verify((Object)this.mockStorageObjectsInsert)).setDisableGZipContent(ArgumentMatchers.eq((boolean)true));
        ((Storage.Objects.Insert)Mockito.verify((Object)this.mockStorageObjectsInsert)).setIfGenerationMatch(Long.valueOf(ArgumentMatchers.eq((long)0L)));
        ((ApiErrorExtractor)Mockito.verify((Object)this.mockErrorExtractor)).itemNotFound((IOException)ArgumentMatchers.any(IOException.class));
        ((ClientRequestHelper)Mockito.verify(this.mockClientRequestHelper)).setChunkSize((AbstractGoogleClientRequest)ArgumentMatchers.any(Storage.Objects.Insert.class), ArgumentMatchers.anyInt());
        ((Storage.Objects.Insert)Mockito.verify((Object)this.mockStorageObjectsInsert)).execute();
    }

    private void setUpBasicMockBehaviorForOpeningReadChannel(long size) throws IOException {
        this.setUpBasicMockBehaviorForOpeningReadChannel(size, null);
    }

    private void setUpBasicMockBehaviorForOpeningReadChannel(long size, String encoding) throws IOException {
        Mockito.when((Object)this.mockStorage.objects()).thenReturn((Object)this.mockStorageObjects);
        Mockito.when((Object)this.mockStorageObjects.get((String)ArgumentMatchers.eq((Object)BUCKET_NAME), (String)ArgumentMatchers.eq((Object)OBJECT_NAME))).thenReturn((Object)this.mockStorageObjectsGet);
        Mockito.when((Object)this.mockStorageObjectsGet.setFields(ArgumentMatchers.anyString())).thenReturn((Object)this.mockStorageObjectsGet);
        Mockito.when((Object)this.mockClientRequestHelper.getRequestHeaders((AbstractGoogleClientRequest)ArgumentMatchers.eq((Object)this.mockStorageObjectsGet))).thenReturn((Object)this.mockHeaders);
        Mockito.when((Object)this.mockStorageObjectsGet.execute()).thenReturn((Object)new StorageObject().setBucket(BUCKET_NAME).setName(OBJECT_NAME).setTimeCreated(new DateTime(11L)).setUpdated(new DateTime(12L)).setSize(BigInteger.valueOf(size)).setContentEncoding(encoding).setGeneration(Long.valueOf(1L)).setMetageneration(Long.valueOf(1L)));
    }

    private void setUpAndValidateReadChannelMocksAndSetMaxRetries(GoogleCloudStorageReadChannel readChannel, int maxRetries) throws IOException {
        readChannel.setSleeper(this.mockSleeper);
        readChannel.setNanoClock(this.mockClock);
        readChannel.setReadBackOff(this.mockReadBackOff);
        readChannel.setMaxRetries(maxRetries);
        Truth.assertThat((Boolean)readChannel.isOpen()).isTrue();
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)0);
    }

    @Test
    public void testDeleteObjectApiException() throws IOException {
        Mockito.when((Object)this.mockBatchFactory.newBatchHelper((HttpRequestInitializer)ArgumentMatchers.any(), (Storage)ArgumentMatchers.any(Storage.class), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt())).thenReturn((Object)this.mockBatchHelper);
        Mockito.when((Object)this.mockStorage.objects()).thenReturn((Object)this.mockStorageObjects);
        Mockito.when((Object)this.mockStorageObjects.delete((String)ArgumentMatchers.eq((Object)BUCKET_NAME), (String)ArgumentMatchers.eq((Object)OBJECT_NAME))).thenReturn((Object)this.mockStorageObjectsDelete);
        Mockito.when((Object)this.mockStorageObjects.get((String)ArgumentMatchers.eq((Object)BUCKET_NAME), (String)ArgumentMatchers.eq((Object)OBJECT_NAME))).thenReturn((Object)this.mockStorageObjectsGet);
        GoogleJsonError notFoundError = new GoogleJsonError();
        notFoundError.setMessage("Fake not-found exception");
        GoogleJsonError unexpectedError = new GoogleJsonError();
        unexpectedError.setMessage("Other API exception");
        ((BatchHelper)Mockito.doAnswer(invocation -> {
            JsonBatchCallback getCallback = (JsonBatchCallback)invocation.getArguments()[1];
            getCallback.onSuccess((Object)GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME).setGeneration(Long.valueOf(1L)), new HttpHeaders());
            return null;
        }).doAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            JsonBatchCallback callback = (JsonBatchCallback)args[1];
            try {
                callback.onFailure(notFoundError, new HttpHeaders());
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.toString());
            }
            return null;
        }).doAnswer(invocation -> {
            JsonBatchCallback getCallback = (JsonBatchCallback)invocation.getArguments()[1];
            getCallback.onSuccess((Object)GoogleCloudStorageTest.newStorageObject(BUCKET_NAME, OBJECT_NAME).setGeneration(Long.valueOf(1L)), new HttpHeaders());
            return null;
        }).doAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            JsonBatchCallback callback = (JsonBatchCallback)args[1];
            try {
                callback.onFailure(unexpectedError, new HttpHeaders());
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.toString());
            }
            return null;
        }).when((Object)this.mockBatchHelper)).queue((StorageRequest)ArgumentMatchers.any(), (JsonBatchCallback)ArgumentMatchers.any());
        ((ApiErrorExtractor)Mockito.doReturn((Object)true).doReturn((Object)false).when((Object)this.mockErrorExtractor)).itemNotFound((IOException)ArgumentMatchers.any(IOException.class));
        Mockito.when((Object)this.mockErrorExtractor.preconditionNotMet((IOException)ArgumentMatchers.any(IOException.class))).thenReturn((Object)false);
        try {
            this.gcs.deleteObjects((List)Lists.newArrayList((Object[])new StorageResourceId[]{new StorageResourceId(BUCKET_NAME, OBJECT_NAME)}));
        }
        catch (Exception e) {
            Assert.fail((String)("Expected no exception when mocking itemNotFound error from API call, got " + e));
        }
        Assert.assertThrows(IOException.class, () -> this.gcs.deleteObjects((List)Lists.newArrayList((Object[])new StorageResourceId[]{new StorageResourceId(BUCKET_NAME, OBJECT_NAME)})));
        ((BatchHelper.Factory)Mockito.verify((Object)this.mockBatchFactory, (VerificationMode)Mockito.times((int)2))).newBatchHelper((HttpRequestInitializer)ArgumentMatchers.any(), (Storage)ArgumentMatchers.eq((Object)this.mockStorage), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt());
        ((Storage)Mockito.verify((Object)this.mockStorage, (VerificationMode)Mockito.times((int)4))).objects();
        ((Storage.Objects)Mockito.verify((Object)this.mockStorageObjects, (VerificationMode)Mockito.times((int)2))).delete((String)ArgumentMatchers.eq((Object)BUCKET_NAME), (String)ArgumentMatchers.eq((Object)OBJECT_NAME));
        ((Storage.Objects)Mockito.verify((Object)this.mockStorageObjects, (VerificationMode)Mockito.times((int)2))).get((String)ArgumentMatchers.eq((Object)BUCKET_NAME), (String)ArgumentMatchers.eq((Object)OBJECT_NAME));
        ((Storage.Objects.Get)Mockito.verify((Object)this.mockStorageObjectsGet, (VerificationMode)Mockito.times((int)2))).setFields((String)ArgumentMatchers.eq((Object)"generation"));
        ((Storage.Objects.Delete)Mockito.verify((Object)this.mockStorageObjectsDelete, (VerificationMode)Mockito.times((int)2))).setIfGenerationMatch(Long.valueOf(ArgumentMatchers.eq((long)1L)));
        ((BatchHelper)Mockito.verify((Object)this.mockBatchHelper, (VerificationMode)Mockito.times((int)4))).queue((StorageRequest)ArgumentMatchers.any(), (JsonBatchCallback)ArgumentMatchers.any());
        ((ApiErrorExtractor)Mockito.verify((Object)this.mockErrorExtractor, (VerificationMode)Mockito.times((int)2))).itemNotFound((IOException)ArgumentMatchers.any(IOException.class));
        ((ApiErrorExtractor)Mockito.verify((Object)this.mockErrorExtractor)).preconditionNotMet((IOException)ArgumentMatchers.any(IOException.class));
        ((BatchHelper)Mockito.verify((Object)this.mockBatchHelper, (VerificationMode)Mockito.times((int)2))).flush();
    }

    @Test
    public void testCopyObjectsApiExceptionSameBucket() throws IOException {
        String dstObjectName = "bar-object-copy";
        Mockito.when((Object)this.mockBatchFactory.newBatchHelper((HttpRequestInitializer)ArgumentMatchers.any(), (Storage)ArgumentMatchers.any(Storage.class), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt())).thenReturn((Object)this.mockBatchHelper);
        Mockito.when((Object)this.mockStorage.objects()).thenReturn((Object)this.mockStorageObjects);
        Mockito.when((Object)this.mockStorageObjects.copy((String)ArgumentMatchers.eq((Object)BUCKET_NAME), (String)ArgumentMatchers.eq((Object)OBJECT_NAME), (String)ArgumentMatchers.eq((Object)BUCKET_NAME), (String)ArgumentMatchers.eq((Object)dstObjectName), (StorageObject)ArgumentMatchers.isNull())).thenReturn((Object)this.mockStorageObjectsCopy);
        GoogleJsonError notFoundError = new GoogleJsonError();
        notFoundError.setMessage("Fake not-found exception");
        GoogleJsonError unexpectedError = new GoogleJsonError();
        unexpectedError.setMessage("Other API exception");
        ((BatchHelper)Mockito.doAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            JsonBatchCallback callback = (JsonBatchCallback)args[1];
            try {
                callback.onFailure(notFoundError, new HttpHeaders());
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.toString());
            }
            return null;
        }).doAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            JsonBatchCallback callback = (JsonBatchCallback)args[1];
            try {
                callback.onFailure(unexpectedError, new HttpHeaders());
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.toString());
            }
            return null;
        }).when((Object)this.mockBatchHelper)).queue((StorageRequest)ArgumentMatchers.eq((Object)this.mockStorageObjectsCopy), (JsonBatchCallback)ArgumentMatchers.any());
        ((ApiErrorExtractor)Mockito.doReturn((Object)true).doReturn((Object)false).when((Object)this.mockErrorExtractor)).itemNotFound((IOException)ArgumentMatchers.any(IOException.class));
        Assert.assertThrows(FileNotFoundException.class, () -> this.gcs.copy(BUCKET_NAME, (List)ImmutableList.of((Object)OBJECT_NAME), BUCKET_NAME, (List)ImmutableList.of((Object)dstObjectName)));
        Assert.assertThrows(IOException.class, () -> this.gcs.copy(BUCKET_NAME, (List)ImmutableList.of((Object)OBJECT_NAME), BUCKET_NAME, (List)ImmutableList.of((Object)dstObjectName)));
        ((BatchHelper.Factory)Mockito.verify((Object)this.mockBatchFactory, (VerificationMode)Mockito.times((int)2))).newBatchHelper((HttpRequestInitializer)ArgumentMatchers.any(), (Storage)ArgumentMatchers.eq((Object)this.mockStorage), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt());
        ((Storage)Mockito.verify((Object)this.mockStorage, (VerificationMode)Mockito.times((int)2))).objects();
        ((Storage.Objects)Mockito.verify((Object)this.mockStorageObjects, (VerificationMode)Mockito.times((int)2))).copy((String)ArgumentMatchers.eq((Object)BUCKET_NAME), (String)ArgumentMatchers.eq((Object)OBJECT_NAME), (String)ArgumentMatchers.eq((Object)BUCKET_NAME), (String)ArgumentMatchers.eq((Object)dstObjectName), (StorageObject)ArgumentMatchers.isNull());
        ((BatchHelper)Mockito.verify((Object)this.mockBatchHelper, (VerificationMode)Mockito.times((int)2))).queue((StorageRequest)ArgumentMatchers.eq((Object)this.mockStorageObjectsCopy), (JsonBatchCallback)ArgumentMatchers.any());
        ((ApiErrorExtractor)Mockito.verify((Object)this.mockErrorExtractor, (VerificationMode)Mockito.times((int)2))).itemNotFound((IOException)ArgumentMatchers.any(IOException.class));
        ((BatchHelper)Mockito.verify((Object)this.mockBatchHelper, (VerificationMode)Mockito.times((int)2))).flush();
    }

    @Test
    public void testGetItemInfosApiException() throws IOException {
        Mockito.when((Object)this.mockBatchFactory.newBatchHelper((HttpRequestInitializer)ArgumentMatchers.any(), (Storage)ArgumentMatchers.any(Storage.class), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt())).thenReturn((Object)this.mockBatchHelper);
        Mockito.when((Object)this.mockStorage.buckets()).thenReturn((Object)this.mockStorageBuckets);
        Mockito.when((Object)this.mockStorageBuckets.get((String)ArgumentMatchers.eq((Object)BUCKET_NAME))).thenReturn((Object)this.mockStorageBucketsGet);
        GoogleJsonError unexpectedError = new GoogleJsonError();
        unexpectedError.setMessage("Unexpected API exception ");
        ((BatchHelper)Mockito.doAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            JsonBatchCallback callback = (JsonBatchCallback)args[1];
            try {
                callback.onFailure(unexpectedError, new HttpHeaders());
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.toString());
            }
            return null;
        }).when((Object)this.mockBatchHelper)).queue((StorageRequest)ArgumentMatchers.eq((Object)this.mockStorageBucketsGet), (JsonBatchCallback)ArgumentMatchers.any());
        Mockito.when((Object)this.mockStorage.objects()).thenReturn((Object)this.mockStorageObjects);
        Mockito.when((Object)this.mockStorageObjects.get((String)ArgumentMatchers.eq((Object)BUCKET_NAME), (String)ArgumentMatchers.eq((Object)OBJECT_NAME))).thenReturn((Object)this.mockStorageObjectsGet);
        Mockito.when((Object)this.mockStorageObjectsGet.setFields(ArgumentMatchers.anyString())).thenReturn((Object)this.mockStorageObjectsGet);
        ((BatchHelper)Mockito.doAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            JsonBatchCallback callback = (JsonBatchCallback)args[1];
            try {
                callback.onFailure(unexpectedError, new HttpHeaders());
            }
            catch (IOException ioe) {
                Assert.fail((String)ioe.toString());
            }
            return null;
        }).when((Object)this.mockBatchHelper)).queue((StorageRequest)ArgumentMatchers.eq((Object)this.mockStorageObjectsGet), (JsonBatchCallback)ArgumentMatchers.any());
        Mockito.when((Object)this.mockErrorExtractor.itemNotFound((IOException)ArgumentMatchers.any(IOException.class))).thenReturn((Object)false);
        IOException ioe = (IOException)Assert.assertThrows(IOException.class, () -> this.gcs.getItemInfos((List)ImmutableList.of((Object)new StorageResourceId(BUCKET_NAME, OBJECT_NAME), (Object)StorageResourceId.ROOT, (Object)new StorageResourceId(BUCKET_NAME))));
        Truth.assertThat((Object[])ioe.getSuppressed()).isNotNull();
        Truth.assertThat((Object[])ioe.getSuppressed()).hasLength(2);
        ((BatchHelper.Factory)Mockito.verify((Object)this.mockBatchFactory)).newBatchHelper((HttpRequestInitializer)ArgumentMatchers.any(), (Storage)ArgumentMatchers.eq((Object)this.mockStorage), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyInt());
        ((Storage)Mockito.verify((Object)this.mockStorage)).buckets();
        ((Storage.Buckets)Mockito.verify((Object)this.mockStorageBuckets)).get((String)ArgumentMatchers.eq((Object)BUCKET_NAME));
        ((BatchHelper)Mockito.verify((Object)this.mockBatchHelper)).queue((StorageRequest)ArgumentMatchers.eq((Object)this.mockStorageBucketsGet), (JsonBatchCallback)ArgumentMatchers.any());
        ((Storage)Mockito.verify((Object)this.mockStorage)).objects();
        ((Storage.Objects)Mockito.verify((Object)this.mockStorageObjects)).get((String)ArgumentMatchers.eq((Object)BUCKET_NAME), (String)ArgumentMatchers.eq((Object)OBJECT_NAME));
        ((Storage.Objects.Get)Mockito.verify((Object)this.mockStorageObjectsGet)).setFields((String)ArgumentMatchers.eq((Object)OBJECT_FIELDS));
        ((BatchHelper)Mockito.verify((Object)this.mockBatchHelper)).queue((StorageRequest)ArgumentMatchers.eq((Object)this.mockStorageObjectsGet), (JsonBatchCallback)ArgumentMatchers.any());
        ((ApiErrorExtractor)Mockito.verify((Object)this.mockErrorExtractor, (VerificationMode)Mockito.times((int)2))).itemNotFound((IOException)ArgumentMatchers.any(IOException.class));
        ((BatchHelper)Mockito.verify((Object)this.mockBatchHelper)).flush();
    }

    @Test
    public void testReadWithFailedInplaceSeekSucceeds() throws IOException {
        byte[] testData = new byte[]{1, 2, 3, 5, 8};
        byte[] testData2 = Arrays.copyOfRange(testData, 3, testData.length);
        this.setUpBasicMockBehaviorForOpeningReadChannel(testData.length);
        InputStream mockExceptionStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)mockExceptionStream.read((byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)1))).thenReturn((Object)1);
        Mockito.when((Object)mockExceptionStream.read((byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)2))).thenThrow(new Throwable[]{new IOException("In-place seek IOException")});
        Mockito.when((Object)this.mockStorageObjectsGet.executeMedia()).thenReturn((Object)MockHttpTransportHelper.fakeResponse((String)"Content-Length", (Object)testData.length, (InputStream)mockExceptionStream)).thenReturn((Object)MockHttpTransportHelper.fakeResponse((String)"Content-Length", (Object)testData2.length, (InputStream)new ByteArrayInputStream(testData2)));
        GoogleCloudStorageReadChannel readChannel = (GoogleCloudStorageReadChannel)this.gcs.open(new StorageResourceId(BUCKET_NAME, OBJECT_NAME), GoogleCloudStorageReadOptions.builder().setInplaceSeekLimit(3L).build());
        this.setUpAndValidateReadChannelMocksAndSetMaxRetries(readChannel, 3);
        Truth.assertThat((Integer)readChannel.read(ByteBuffer.wrap(new byte[1]))).isEqualTo((Object)1);
        readChannel.position(3L);
        byte[] byte3 = new byte[1];
        Truth.assertThat((Integer)readChannel.read(ByteBuffer.wrap(byte3))).isEqualTo((Object)1);
        Truth.assertThat((byte[])byte3).isEqualTo((Object)new byte[]{testData[3]});
        ((Storage)Mockito.verify((Object)this.mockStorage, (VerificationMode)Mockito.times((int)3))).objects();
        ((Storage.Objects)Mockito.verify((Object)this.mockStorageObjects, (VerificationMode)Mockito.times((int)3))).get((String)ArgumentMatchers.eq((Object)BUCKET_NAME), (String)ArgumentMatchers.eq((Object)OBJECT_NAME));
        ((ClientRequestHelper)Mockito.verify(this.mockClientRequestHelper, (VerificationMode)Mockito.times((int)2))).getRequestHeaders((AbstractGoogleClientRequest)ArgumentMatchers.any(Storage.Objects.Get.class));
        ((HttpHeaders)Mockito.verify((Object)this.mockHeaders, (VerificationMode)Mockito.times((int)2))).setAcceptEncoding((String)ArgumentMatchers.eq((Object)"gzip"));
        ((HttpHeaders)Mockito.verify((Object)this.mockHeaders)).setRange((String)ArgumentMatchers.eq((Object)"bytes=0-"));
        ((HttpHeaders)Mockito.verify((Object)this.mockHeaders)).setRange((String)ArgumentMatchers.eq((Object)"bytes=3-"));
        ((Storage.Objects.Get)Mockito.verify((Object)this.mockStorageObjectsGet, (VerificationMode)Mockito.times((int)2))).setGeneration((Long)ArgumentMatchers.any());
        ((Storage.Objects.Get)Mockito.verify((Object)this.mockStorageObjectsGet)).setFields((String)ArgumentMatchers.eq((Object)OBJECT_FIELDS));
        ((Storage.Objects.Get)Mockito.verify((Object)this.mockStorageObjectsGet)).execute();
        ((Storage.Objects.Get)Mockito.verify((Object)this.mockStorageObjectsGet, (VerificationMode)Mockito.times((int)2))).executeMedia();
        ((InputStream)Mockito.verify((Object)mockExceptionStream, (VerificationMode)Mockito.times((int)2))).read((byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.eq((int)0), ArgumentMatchers.anyInt());
    }
}

