/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.VerificationAttributes;
import com.google.common.collect.ImmutableMap;
import com.google.common.testing.EqualsTester;
import java.util.Map;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GoogleCloudStorageItemInfoTest {
    @Test
    public void testEquals() throws Exception {
        StorageResourceId testBucket = StorageResourceId.fromStringPath((String)"gs://test-bucket");
        StorageResourceId testObject = StorageResourceId.fromStringPath((String)"gs://test-bucket/dir/object");
        StorageResourceId testDirectory = StorageResourceId.fromStringPath((String)"gs://test-bucket/dir/subdir/");
        new EqualsTester().addEqualityGroup(new Object[]{GoogleCloudStorageItemInfo.ROOT_INFO, GoogleCloudStorageItemInfo.ROOT_INFO}).addEqualityGroup(new Object[]{GoogleCloudStorageItemInfo.createBucket((StorageResourceId)testBucket, (long)1000L, (long)1200L, (String)"US", (String)"standard"), GoogleCloudStorageItemInfo.createBucket((StorageResourceId)testBucket, (long)1000L, (long)1200L, (String)"US", (String)"standard")}).addEqualityGroup(new Object[]{GoogleCloudStorageItemInfo.createBucket((StorageResourceId)testBucket, (long)100L, (long)1200L, (String)"US", (String)"standard")}).addEqualityGroup(new Object[]{GoogleCloudStorageItemInfo.createBucket((StorageResourceId)StorageResourceId.fromStringPath((String)"gs://test-bucket-other"), (long)100L, (long)1200L, (String)"US", (String)"standard")}).addEqualityGroup(new Object[]{GoogleCloudStorageItemInfo.createObject((StorageResourceId)testObject, (long)100L, (long)1000L, (long)324L, (String)"text", (String)"gzip", (Map)ImmutableMap.of((Object)"mkey", (Object)new byte[]{1, 6}), (long)122L, (long)3L, null)}).addEqualityGroup(new Object[]{GoogleCloudStorageItemInfo.createObject((StorageResourceId)testObject, (long)100L, (long)1000L, (long)324L, (String)"text", (String)"gzip", (Map)ImmutableMap.of((Object)"mkey", (Object)new byte[]{1, 6}), (long)122L, (long)3L, (VerificationAttributes)new VerificationAttributes(null, null))}).addEqualityGroup(new Object[]{GoogleCloudStorageItemInfo.createObject((StorageResourceId)testObject, (long)100L, (long)1000L, (long)324L, (String)"text", (String)"gzip", (Map)ImmutableMap.of((Object)"mkey", (Object)new byte[]{1, 6}), (long)122L, (long)3L, (VerificationAttributes)new VerificationAttributes(new byte[]{1, 6}, new byte[]{10}))}).addEqualityGroup(new Object[]{GoogleCloudStorageItemInfo.createObject((StorageResourceId)testObject, (long)100L, (long)1000L, (long)324L, (String)"text", (String)"gzip", (Map)ImmutableMap.of((Object)"mkey", (Object)new byte[]{1, 6}, (Object)"akey", (Object)new byte[]{9}), (long)122L, (long)3L, (VerificationAttributes)new VerificationAttributes(new byte[]{1, 6}, new byte[]{11})), GoogleCloudStorageItemInfo.createObject((StorageResourceId)testObject, (long)100L, (long)1000L, (long)324L, (String)"text", (String)"gzip", (Map)ImmutableMap.of((Object)"akey", (Object)new byte[]{9}, (Object)"mkey", (Object)new byte[]{1, 6}), (long)122L, (long)3L, (VerificationAttributes)new VerificationAttributes(new byte[]{1, 6}, new byte[]{11}))}).addEqualityGroup(new Object[]{GoogleCloudStorageItemInfo.createInferredDirectory((StorageResourceId)testDirectory)}).addEqualityGroup(new Object[]{GoogleCloudStorageItemInfo.createNotFound((StorageResourceId)testBucket)}).addEqualityGroup(new Object[]{GoogleCloudStorageItemInfo.createNotFound((StorageResourceId)testObject)}).addEqualityGroup(new Object[]{GoogleCloudStorageItemInfo.createNotFound((StorageResourceId)testDirectory)}).testEquals();
    }
}

