/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.util.BackOff;
import com.google.auth.Credentials;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageGrpcReadChannel;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.StorageStubProvider;
import com.google.common.hash.Hashing;
import com.google.common.truth.Truth;
import com.google.google.storage.v1.ChecksummedData;
import com.google.google.storage.v1.GetObjectMediaRequest;
import com.google.google.storage.v1.GetObjectMediaResponse;
import com.google.google.storage.v1.GetObjectRequest;
import com.google.google.storage.v1.StorageGrpc;
import com.google.protobuf.ByteString;
import com.google.protobuf.UInt32Value;
import io.grpc.BindableService;
import io.grpc.Channel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Status;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.StreamObserver;
import io.grpc.testing.GrpcCleanupRule;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public final class GoogleCloudStorageGrpcReadChannelTest {
    private static final String BUCKET_NAME = "bucket-name";
    private static final String OBJECT_NAME = "object-name";
    private static final long OBJECT_GENERATION = 7L;
    private static final int OBJECT_SIZE = 0x20000A;
    private static final int DEFAULT_OBJECT_CRC32C = 185327488;
    private static com.google.google.storage.v1.Object DEFAULT_OBJECT = com.google.google.storage.v1.Object.newBuilder().setBucket("bucket-name").setName("object-name").setSize(0x20000AL).setCrc32C(UInt32Value.newBuilder().setValue(185327488)).setGeneration(7L).build();
    private static GetObjectRequest GET_OBJECT_REQUEST = GetObjectRequest.newBuilder().setBucket("bucket-name").setObject("object-name").build();
    private static GetObjectMediaRequest GET_OBJECT_MEDIA_REQUEST = GetObjectMediaRequest.newBuilder().setBucket("bucket-name").setObject("object-name").setGeneration(7L).build();
    @Rule
    public final GrpcCleanupRule grpcCleanup = new GrpcCleanupRule();
    private StorageGrpc.StorageBlockingStub stub;
    private FakeService fakeService;
    @Mock
    private Credentials mockCredentials;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.fakeService = (FakeService)((Object)Mockito.spy((Object)((Object)new FakeService())));
        String serverName = InProcessServerBuilder.generateName();
        this.grpcCleanup.register(((InProcessServerBuilder)((InProcessServerBuilder)InProcessServerBuilder.forName((String)serverName).directExecutor()).addService((BindableService)this.fakeService)).build().start());
        this.stub = StorageGrpc.newBlockingStub((Channel)this.grpcCleanup.register(((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)serverName).directExecutor()).build()));
    }

    @Test
    public void readSingleChunkSucceeds() throws Exception {
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize(100L).build());
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        ByteBuffer buffer = ByteBuffer.allocate(100);
        readChannel.read(buffer);
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).getObject((GetObjectRequest)Mockito.eq((Object)GET_OBJECT_REQUEST), (StreamObserver<com.google.google.storage.v1.Object>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).getObjectMedia((GetObjectMediaRequest)Mockito.eq((Object)GET_OBJECT_MEDIA_REQUEST), (StreamObserver<GetObjectMediaResponse>)((StreamObserver)Mockito.any()));
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(0, 100).toByteArray(), (byte[])buffer.array());
    }

    @Test
    public void readMultipleChunksSucceeds() throws Exception {
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize(4096L).build());
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        readChannel.read(buffer);
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).getObject((GetObjectRequest)Mockito.eq((Object)GET_OBJECT_REQUEST), (StreamObserver<com.google.google.storage.v1.Object>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).getObjectMedia((GetObjectMediaRequest)Mockito.eq((Object)GET_OBJECT_MEDIA_REQUEST), (StreamObserver<GetObjectMediaResponse>)((StreamObserver)Mockito.any()));
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(0, 4096).toByteArray(), (byte[])buffer.array());
    }

    @Test
    public void readAfterRepositioningAfterSkippingSucceeds() throws Exception {
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize(100L).build());
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setInplaceSeekLimit(10L).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer bufferAtBeginning = ByteBuffer.allocate(20);
        readChannel.read(bufferAtBeginning);
        readChannel.position(25L);
        ByteBuffer bufferFromSkippedSection1 = ByteBuffer.allocate(5);
        readChannel.read(bufferFromSkippedSection1);
        readChannel.position(35L);
        ByteBuffer bufferFromSkippedSection2 = ByteBuffer.allocate(10);
        readChannel.read(bufferFromSkippedSection2);
        ByteBuffer bufferFromReposition = ByteBuffer.allocate(10);
        readChannel.position(1L);
        readChannel.read(bufferFromReposition);
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).getObject((GetObjectRequest)Mockito.eq((Object)GET_OBJECT_REQUEST), (StreamObserver<com.google.google.storage.v1.Object>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).getObjectMedia((GetObjectMediaRequest)Mockito.eq((Object)GET_OBJECT_MEDIA_REQUEST), (StreamObserver<GetObjectMediaResponse>)((StreamObserver)Mockito.any()));
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(0, 20).toByteArray(), (byte[])bufferAtBeginning.array());
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(25, 30).toByteArray(), (byte[])bufferFromSkippedSection1.array());
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(40, 50).toByteArray(), (byte[])bufferFromSkippedSection2.array());
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(1, 11).toByteArray(), (byte[])bufferFromReposition.array());
    }

    @Test
    public void multipleSequentialReads() throws Exception {
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize(100L).build());
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        ByteBuffer first_buffer = ByteBuffer.allocate(10);
        ByteBuffer second_buffer = ByteBuffer.allocate(20);
        readChannel.read(first_buffer);
        readChannel.read(second_buffer);
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).getObject((GetObjectRequest)Mockito.eq((Object)GET_OBJECT_REQUEST), (StreamObserver<com.google.google.storage.v1.Object>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).getObjectMedia((GetObjectMediaRequest)Mockito.eq((Object)GET_OBJECT_MEDIA_REQUEST), (StreamObserver<GetObjectMediaResponse>)((StreamObserver)Mockito.any()));
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(0, 10).toByteArray(), (byte[])first_buffer.array());
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(10, 30).toByteArray(), (byte[])second_buffer.array());
    }

    @Test
    public void randomReadRequestsExactBytes() throws Exception {
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFadvise(GoogleCloudStorageReadOptions.Fadvise.RANDOM).setGrpcChecksumsEnabled(true).setInplaceSeekLimit(5L).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(50);
        readChannel.position(10L);
        readChannel.read(buffer);
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).getObject((GetObjectRequest)Mockito.eq((Object)GET_OBJECT_REQUEST), (StreamObserver<com.google.google.storage.v1.Object>)((StreamObserver)Mockito.any()));
        GetObjectMediaRequest expectedRequest = GetObjectMediaRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadLimit(0x200000L).setReadOffset(10L).build();
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).getObjectMedia((GetObjectMediaRequest)Mockito.eq((Object)expectedRequest), (StreamObserver<GetObjectMediaResponse>)((StreamObserver)Mockito.any()));
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(10, 60).toByteArray(), (byte[])buffer.array());
    }

    @Test
    public void repeatedRandomReadsWorkAsExpected() throws Exception {
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFadvise(GoogleCloudStorageReadOptions.Fadvise.RANDOM).setGrpcChecksumsEnabled(true).setInplaceSeekLimit(5L).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(50);
        readChannel.position(10L);
        readChannel.read(buffer);
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(10, 60).toByteArray(), (byte[])buffer.array());
        buffer = ByteBuffer.allocate(25);
        readChannel.position(20L);
        readChannel.read(buffer);
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(20, 45).toByteArray(), (byte[])buffer.array());
        GetObjectMediaRequest firstExpectedRequest = GetObjectMediaRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadLimit(0x200000L).setReadOffset(10L).build();
        GetObjectMediaRequest secondExpectedRequest = GetObjectMediaRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadLimit(0x200000L).setReadOffset(20L).build();
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).getObject((GetObjectRequest)Mockito.eq((Object)GET_OBJECT_REQUEST), (StreamObserver<com.google.google.storage.v1.Object>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).getObjectMedia((GetObjectMediaRequest)Mockito.eq((Object)firstExpectedRequest), (StreamObserver<GetObjectMediaResponse>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).getObjectMedia((GetObjectMediaRequest)Mockito.eq((Object)secondExpectedRequest), (StreamObserver<GetObjectMediaResponse>)((StreamObserver)Mockito.any()));
    }

    @Test
    public void randomReadRequestsExpectedBytes() throws Exception {
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFadvise(GoogleCloudStorageReadOptions.Fadvise.RANDOM).setGrpcChecksumsEnabled(true).setInplaceSeekLimit(5L).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(50);
        readChannel.position(10L);
        readChannel.read(buffer);
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(10, 60).toByteArray(), (byte[])buffer.array());
        buffer = ByteBuffer.allocate(0x200001);
        readChannel.position(0L);
        readChannel.read(buffer);
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(0, 0x200001).toByteArray(), (byte[])buffer.array());
        GetObjectMediaRequest firstExpectedRequest = GetObjectMediaRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadLimit(0x200000L).setReadOffset(10L).build();
        GetObjectMediaRequest secondExpectedRequest = GetObjectMediaRequest.newBuilder().setBucket(BUCKET_NAME).setObject(OBJECT_NAME).setGeneration(7L).setReadLimit(0x200001L).setReadOffset(0L).build();
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).getObject((GetObjectRequest)Mockito.eq((Object)GET_OBJECT_REQUEST), (StreamObserver<com.google.google.storage.v1.Object>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).getObjectMedia((GetObjectMediaRequest)Mockito.eq((Object)firstExpectedRequest), (StreamObserver<GetObjectMediaResponse>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).getObjectMedia((GetObjectMediaRequest)Mockito.eq((Object)secondExpectedRequest), (StreamObserver<GetObjectMediaResponse>)((StreamObserver)Mockito.any()));
    }

    @Test
    public void readToBufferWithArrayOffset() throws Exception {
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize(100L).build());
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        byte[] array = new byte[200];
        ByteBuffer buffer = ByteBuffer.wrap(array, 50, 150).slice();
        readChannel.read(buffer);
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).getObject((GetObjectRequest)Mockito.eq((Object)GET_OBJECT_REQUEST), (StreamObserver<com.google.google.storage.v1.Object>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).getObjectMedia((GetObjectMediaRequest)Mockito.eq((Object)GET_OBJECT_MEDIA_REQUEST), (StreamObserver<GetObjectMediaResponse>)((StreamObserver)Mockito.any()));
        byte[] expected = ByteString.copyFrom((byte[])array, (int)50, (int)100).toByteArray();
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(0, 100).toByteArray(), (byte[])expected);
    }

    @Test
    public void readSucceedsAfterSeek() throws Exception {
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize(100L).build());
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setInplaceSeekLimit(10L).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(10);
        readChannel.position(50L);
        readChannel.read(buffer);
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).getObject((GetObjectRequest)Mockito.eq((Object)GET_OBJECT_REQUEST), (StreamObserver<com.google.google.storage.v1.Object>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).getObjectMedia((GetObjectMediaRequest)Mockito.eq((Object)GET_OBJECT_MEDIA_REQUEST.toBuilder().setReadOffset(50L).build()), (StreamObserver<GetObjectMediaResponse>)((StreamObserver)Mockito.any()));
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(50, 60).toByteArray(), (byte[])buffer.array());
    }

    @Test
    public void singleReadSucceedsWithValidObjectChecksum() throws Exception {
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setCrc32C(UInt32Value.newBuilder().setValue(185327488)).build());
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setGrpcChecksumsEnabled(true).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(0x20000A);
        readChannel.read(buffer);
        Assert.assertArrayEquals((byte[])this.fakeService.data.toByteArray(), (byte[])buffer.array());
    }

    @Test
    public void partialReadSucceedsWithInvalidObjectChecksum() throws Exception {
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setCrc32C(UInt32Value.newBuilder().setValue(0)).build());
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setGrpcChecksumsEnabled(true).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(0x200000);
        readChannel.read(buffer);
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(0, 0x200000).toByteArray(), (byte[])buffer.array());
    }

    @Test
    public void multipleSequentialsReadsSucceedWithValidObjectChecksum() throws Exception {
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setCrc32C(UInt32Value.newBuilder().setValue(185327488)).build());
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setGrpcChecksumsEnabled(true).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer firstBuffer = ByteBuffer.allocate(100);
        ByteBuffer secondBuffer = ByteBuffer.allocate(2097062);
        readChannel.read(firstBuffer);
        readChannel.read(secondBuffer);
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(0, 100).toByteArray(), (byte[])firstBuffer.array());
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(100).toByteArray(), (byte[])secondBuffer.array());
    }

    @Test
    public void readFailsWithInvalidMessageChecksum() throws Exception {
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setGrpcChecksumsEnabled(true).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        this.fakeService.setReturnIncorrectMessageChecksum();
        ByteBuffer buffer = ByteBuffer.allocate(10);
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> readChannel.read(buffer));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"checksum");
    }

    @Test
    public void readToBufferWithArrayOffsetSucceeds() throws Exception {
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setGrpcChecksumsEnabled(true).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        byte[] array = new byte[2097262];
        ByteBuffer buffer = ByteBuffer.wrap(array, 50, 0x20000A).slice();
        readChannel.read(buffer);
        byte[] expected = ByteString.copyFrom((byte[])array, (int)50, (int)0x20000A).toByteArray();
        Assert.assertArrayEquals((byte[])this.fakeService.data.toByteArray(), (byte[])expected);
    }

    @Test
    public void readToBufferWithArrayOffsetFailsWithInvalidMessageChecksum() throws Exception {
        this.fakeService.setReturnIncorrectMessageChecksum();
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setGrpcChecksumsEnabled(true).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        byte[] array = new byte[2097262];
        ByteBuffer buffer = ByteBuffer.wrap(array, 50, 0x20000A).slice();
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> readChannel.read(buffer));
        Assert.assertTrue((String)(thrown.getMessage() + " should have contained 'checksum'"), (boolean)thrown.getMessage().contains("checksum"));
    }

    @Test
    public void multipleReadsIgnoreObjectChecksumForLatestGenerationReads() throws Exception {
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setCrc32C(UInt32Value.newBuilder().setValue(0)).build());
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setGrpcChecksumsEnabled(true).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer firstBuffer = ByteBuffer.allocate(100);
        ByteBuffer secondBuffer = ByteBuffer.allocate(2097062);
        readChannel.read(firstBuffer);
        readChannel.read(secondBuffer);
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(0, 100).toByteArray(), (byte[])firstBuffer.array());
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(100).toByteArray(), (byte[])secondBuffer.array());
    }

    @Test
    public void readHandlesGetError() {
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFound(false).build();
        this.fakeService.setGetException((Throwable)Status.fromCode((Status.Code)Status.Code.INTERNAL).withDescription("Custom error message.").asException());
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> this.newReadChannel(options));
        Truth.assertThat((Throwable)thrown).hasCauseThat().hasCauseThat().hasMessageThat().contains((CharSequence)"Custom error message.");
    }

    @Test
    public void readHandlesGetMediaError() throws Exception {
        this.fakeService.setGetMediaException((Throwable)Status.fromCode((Status.Code)Status.Code.INTERNAL).withDescription("Custom error message.").asException());
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        ByteBuffer buffer = ByteBuffer.allocate(10);
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> readChannel.read(buffer));
        Truth.assertThat((Throwable)thrown).hasCauseThat().hasCauseThat().hasMessageThat().contains((CharSequence)"Custom error message.");
    }

    @Test
    public void retryGetMediaError() throws Exception {
        this.fakeService.setGetMediaException((Throwable)Status.fromCode((Status.Code)Status.Code.INTERNAL).withDescription("Custom error message.").asException());
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        ByteBuffer buffer = ByteBuffer.allocate(10);
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> readChannel.read(buffer));
        Truth.assertThat((Throwable)thrown).hasCauseThat().hasCauseThat().hasMessageThat().contains((CharSequence)"Custom error message");
    }

    @Test
    public void readFailsOnClosedChannel() throws Exception {
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        readChannel.close();
        ByteBuffer buffer = ByteBuffer.allocate(10);
        Assert.assertThrows(ClosedChannelException.class, () -> readChannel.read(buffer));
    }

    @Test
    public void readWithStrictGenerationReadConsistencySucceeds() throws Exception {
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize(100L).setGeneration(1L).build());
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(10);
        readChannel.read(buffer);
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize(100L).setGeneration(2L).build());
        readChannel.position(0L);
        buffer.clear();
        readChannel.read(buffer);
        List<GetObjectMediaRequest> expectedRequests = Arrays.asList(GET_OBJECT_MEDIA_REQUEST, GET_OBJECT_MEDIA_REQUEST.toBuilder().setReadOffset(10L).setReadLimit(20L).setGeneration(1L).build());
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(GetObjectMediaRequest.class);
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).getObject((GetObjectRequest)Mockito.eq((Object)GET_OBJECT_REQUEST), (StreamObserver<com.google.google.storage.v1.Object>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)2)))).getObjectMedia((GetObjectMediaRequest)requestCaptor.capture(), (StreamObserver<GetObjectMediaResponse>)((StreamObserver)Mockito.any()));
    }

    @Test
    public void readWithLatestGenerationReadConsistencySucceeds() throws Exception {
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize(100L).setGeneration(1L).build());
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(10);
        readChannel.read(buffer);
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize(100L).setGeneration(2L).build());
        readChannel.position(0L);
        buffer.clear();
        readChannel.read(buffer);
        List<GetObjectMediaRequest> expectedRequests = Arrays.asList(GET_OBJECT_MEDIA_REQUEST, GET_OBJECT_MEDIA_REQUEST.toBuilder().setReadOffset(10L).setReadLimit(20L).build());
        ArgumentCaptor requestCaptor = ArgumentCaptor.forClass(GetObjectMediaRequest.class);
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).getObject((GetObjectRequest)Mockito.eq((Object)GET_OBJECT_REQUEST), (StreamObserver<com.google.google.storage.v1.Object>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)2)))).getObjectMedia((GetObjectMediaRequest)requestCaptor.capture(), (StreamObserver<GetObjectMediaResponse>)((StreamObserver)Mockito.any()));
    }

    @Test
    public void seekUnderInplaceSeekLimitReadsCorrectBufferedData() throws Exception {
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize(100L).build());
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setInplaceSeekLimit(10L).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(20);
        readChannel.read(buffer);
        readChannel.position(25L);
        buffer.clear();
        readChannel.read(buffer);
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).getObject((GetObjectRequest)Mockito.eq((Object)GET_OBJECT_REQUEST), (StreamObserver<com.google.google.storage.v1.Object>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).getObjectMedia((GetObjectMediaRequest)Mockito.eq((Object)GET_OBJECT_MEDIA_REQUEST), (StreamObserver<GetObjectMediaResponse>)((StreamObserver)Mockito.any()));
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(25, 45).toByteArray(), (byte[])buffer.array());
    }

    @Test
    public void seekUnderInplaceSeekLimitReadsCorrectDataWithSomeBuffered() throws Exception {
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize(8192L).build());
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setInplaceSeekLimit(10L).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(20);
        readChannel.read(buffer);
        readChannel.position(50L);
        buffer.clear();
        buffer = ByteBuffer.allocate(6151);
        readChannel.read(buffer);
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(50, 6201).toByteArray(), (byte[])buffer.array());
    }

    @Test
    public void seekBeyondInplaceSeekLimitReadsNoBufferedData() throws Exception {
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize(100L).build());
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setInplaceSeekLimit(10L).setFadvise(GoogleCloudStorageReadOptions.Fadvise.AUTO).build();
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel(options);
        ByteBuffer buffer = ByteBuffer.allocate(20);
        readChannel.read(buffer);
        readChannel.position(35L);
        buffer.clear();
        readChannel.read(buffer);
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).getObject((GetObjectRequest)Mockito.eq((Object)GET_OBJECT_REQUEST), (StreamObserver<com.google.google.storage.v1.Object>)((StreamObserver)Mockito.any()));
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).getObjectMedia((GetObjectMediaRequest)Mockito.eq((Object)GET_OBJECT_MEDIA_REQUEST), (StreamObserver<GetObjectMediaResponse>)((StreamObserver)Mockito.any()));
        Assert.assertArrayEquals((byte[])this.fakeService.data.substring(35, 55).toByteArray(), (byte[])buffer.array());
    }

    @Test
    public void seekFailsOnNegative() throws Exception {
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        Assert.assertThrows(IllegalArgumentException.class, () -> readChannel.position(-1L));
    }

    @Test
    public void seekFailsOnClosedChannel() throws Exception {
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        readChannel.close();
        Assert.assertThrows(ClosedChannelException.class, () -> readChannel.position(2L));
    }

    @Test
    public void positionUpdatesOnRead() throws Exception {
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize(100L).build());
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        ByteBuffer buffer = ByteBuffer.allocate(50);
        readChannel.read(buffer);
        Assert.assertEquals((long)50L, (long)readChannel.position());
    }

    @Test
    public void positionUpdatesOnSeek() throws Exception {
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        readChannel.position(50L);
        Assert.assertEquals((long)50L, (long)readChannel.position());
    }

    @Test
    public void positionFailsOnClosedChannel() throws Exception {
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        readChannel.close();
        Assert.assertThrows(ClosedChannelException.class, () -> ((GoogleCloudStorageGrpcReadChannel)readChannel).position());
    }

    @Test
    public void fastFailOnNotFoundFailsOnCreateWhenEnabled() {
        this.fakeService.setGetException((Throwable)Status.NOT_FOUND.asException());
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFound(true).build();
        Throwable throwable = Assert.assertThrows(IOException.class, () -> this.newReadChannel(options));
        Truth.assertThat((Throwable)throwable).hasCauseThat().hasMessageThat().contains((CharSequence)"Item not found");
    }

    @Test
    public void fastFailOnNotFoundFailsByReadWhenDisabled() {
        this.fakeService.setGetException((Throwable)Status.NOT_FOUND.asException());
        GoogleCloudStorageReadOptions options = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFound(false).build();
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> this.newReadChannel(options));
        Truth.assertThat((Throwable)thrown).hasCauseThat().hasMessageThat().contains((CharSequence)"Item not found");
    }

    @Test
    public void sizeReturnsObjectSize() throws Exception {
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize(1234L).build());
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        Assert.assertEquals((long)1234L, (long)readChannel.size());
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).getObject((GetObjectRequest)Mockito.eq((Object)GET_OBJECT_REQUEST), (StreamObserver<com.google.google.storage.v1.Object>)((StreamObserver)Mockito.any()));
    }

    @Test
    public void sizeFailsOnClosedChannel() throws Exception {
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        readChannel.close();
        Assert.assertThrows(ClosedChannelException.class, () -> ((GoogleCloudStorageGrpcReadChannel)readChannel).size());
    }

    @Test
    public void sizeIsCached() throws Exception {
        this.fakeService.setObject(DEFAULT_OBJECT.toBuilder().setSize(1234L).build());
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        Assert.assertEquals((long)1234L, (long)readChannel.size());
        Assert.assertEquals((long)1234L, (long)readChannel.size());
        ((FakeService)((Object)Mockito.verify((Object)((Object)this.fakeService), (VerificationMode)Mockito.times((int)1)))).getObject((GetObjectRequest)Mockito.eq((Object)GET_OBJECT_REQUEST), (StreamObserver<com.google.google.storage.v1.Object>)((StreamObserver)Mockito.any()));
    }

    @Test
    public void isOpenReturnsTrueOnCreate() throws Exception {
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        Assert.assertTrue((boolean)readChannel.isOpen());
    }

    @Test
    public void isOpenReturnsFalseAfterClose() throws Exception {
        GoogleCloudStorageGrpcReadChannel readChannel = this.newReadChannel();
        readChannel.close();
        Assert.assertFalse((boolean)readChannel.isOpen());
    }

    private GoogleCloudStorageGrpcReadChannel newReadChannel() throws IOException {
        return this.newReadChannel(GoogleCloudStorageReadOptions.DEFAULT);
    }

    private GoogleCloudStorageGrpcReadChannel newReadChannel(GoogleCloudStorageReadOptions options) throws IOException {
        return GoogleCloudStorageGrpcReadChannel.open((StorageStubProvider)new FakeStubProvider(this.mockCredentials), (StorageResourceId)new StorageResourceId(BUCKET_NAME, OBJECT_NAME), (GoogleCloudStorageReadOptions)options, () -> BackOff.STOP_BACKOFF);
    }

    private static class FakeService
    extends StorageGrpc.StorageImplBase {
        private static final int CHUNK_SIZE = 2048;
        ByteString data;
        private com.google.google.storage.v1.Object object;
        private Throwable getException;
        private Throwable getMediaException;
        private boolean alterMessageChecksum = false;

        public FakeService() {
            this.setObject(DEFAULT_OBJECT);
        }

        private static ByteString createTestData(int numBytes) {
            byte[] result = new byte[numBytes];
            for (int i = 0; i < numBytes; ++i) {
                result[i] = (byte)i;
            }
            return ByteString.copyFrom((byte[])result);
        }

        public void getObject(GetObjectRequest request, StreamObserver<com.google.google.storage.v1.Object> responseObserver) {
            if (this.getException != null) {
                responseObserver.onError(this.getException);
            } else {
                responseObserver.onNext((Object)this.object);
                responseObserver.onCompleted();
            }
        }

        public void getObjectMedia(GetObjectMediaRequest request, StreamObserver<GetObjectMediaResponse> responseObserver) {
            if (this.getMediaException != null) {
                responseObserver.onError(this.getMediaException);
            } else {
                int readStart = (int)request.getReadOffset();
                int readEnd = request.getReadLimit() > 0L ? (int)Math.min(this.object.getSize(), (long)readStart + request.getReadLimit()) : (int)this.object.getSize();
                for (int position = readStart; position < readEnd; position += 2048) {
                    ByteString messageData = this.data.substring(position, Math.min((int)this.object.getSize(), position + 2048));
                    int crc32c = Hashing.crc32c().hashBytes(messageData.toByteArray()).asInt();
                    if (this.alterMessageChecksum) {
                        ++crc32c;
                    }
                    GetObjectMediaResponse response = GetObjectMediaResponse.newBuilder().setChecksummedData(ChecksummedData.newBuilder().setContent(messageData).setCrc32C(UInt32Value.newBuilder().setValue(crc32c))).build();
                    responseObserver.onNext((Object)response);
                }
                responseObserver.onCompleted();
            }
        }

        public void setObject(com.google.google.storage.v1.Object object) {
            this.object = object;
            this.data = FakeService.createTestData((int)object.getSize());
        }

        void setGetException(Throwable t) {
            this.getException = t;
        }

        void setGetMediaException(Throwable t) {
            this.getMediaException = t;
        }

        void setReturnIncorrectMessageChecksum() {
            this.alterMessageChecksum = true;
        }
    }

    private class FakeStubProvider
    extends StorageStubProvider {
        FakeStubProvider(Credentials credentials) {
            super(GoogleCloudStorageOptions.DEFAULT, null, (StorageStubProvider.GrpcDecorator)new FakeGrpcDecorator());
        }

        public StorageGrpc.StorageBlockingStub newBlockingStub() {
            return GoogleCloudStorageGrpcReadChannelTest.this.stub;
        }
    }

    private static class FakeGrpcDecorator
    implements StorageStubProvider.GrpcDecorator {
        private FakeGrpcDecorator() {
        }

        public ManagedChannelBuilder<?> createChannelBuilder(String target) {
            return null;
        }

        public AbstractStub<?> applyCallOption(AbstractStub<?> stub) {
            return null;
        }
    }
}

