/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.hadoop.gcsio.FileInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.PerformanceCachingGoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.PerformanceCachingGoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.TrackingHttpRequestInitializer;
import com.google.cloud.hadoop.gcsio.UriPaths;
import com.google.cloud.hadoop.gcsio.integration.GoogleCloudStorageTestHelper;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.net.URI;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GoogleCloudStorageFileSystemPerformanceCacheIntegrationTest {
    private static final GoogleCloudStorageTestHelper.TestBucketHelper BUCKET_HELPER = new GoogleCloudStorageTestHelper.TestBucketHelper("gcs-fs-perf-cache");
    private static final String TEST_BUCKET = BUCKET_HELPER.getUniqueBucketPrefix();
    private static final GoogleCloudStorageFileSystemOptions GCSFS_OPTIONS = GoogleCloudStorageFileSystemOptions.builder().setCloudStorageOptions(GoogleCloudStorageTestHelper.getStandardOptionBuilder().build()).build();
    private static final PerformanceCachingGoogleCloudStorageOptions PERF_CACHE_GCS_OPTIONS = PerformanceCachingGoogleCloudStorageOptions.DEFAULT.toBuilder().setMaxEntryAgeMillis(10000L).build();
    private static GoogleCloudStorage helperGcs;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeAll() throws IOException {
        helperGcs = GoogleCloudStorageTestHelper.createGoogleCloudStorage();
        helperGcs.createBucket(TEST_BUCKET);
    }

    @AfterClass
    public static void afterAll() throws IOException {
        try {
            BUCKET_HELPER.cleanup(helperGcs);
        }
        finally {
            helperGcs.close();
        }
    }

    @Test
    public void getFileInfo_parallel_notFound() throws Exception {
        String parentDir = this.name.getMethodName();
        String file = parentDir + "/file";
        URI fileUri = UriPaths.fromStringPathComponents((String)TEST_BUCKET, (String)file, (boolean)false);
        GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorageFileSystem> trackingGcsfs = GoogleCloudStorageFileSystemPerformanceCacheIntegrationTest.newTrackingGoogleCloudStorageFileSystem(GCSFS_OPTIONS);
        FileInfo dirInfo1 = ((GoogleCloudStorageFileSystem)trackingGcsfs.delegate).getFileInfo(fileUri);
        FileInfo dirInfo2 = ((GoogleCloudStorageFileSystem)trackingGcsfs.delegate).getFileInfo(fileUri);
        FileInfo dirInfo3 = ((GoogleCloudStorageFileSystem)trackingGcsfs.delegate).getFileInfo(fileUri);
        Truth.assertThat((Boolean)dirInfo1.exists()).isFalse();
        Truth.assertThat((Comparable)dirInfo1.getPath()).isEqualTo((Object)fileUri);
        Truth.assertThat((Object)dirInfo1).isEqualTo((Object)dirInfo2);
        Truth.assertThat((Object)dirInfo1).isEqualTo((Object)dirInfo3);
        Truth.assertThat(trackingGcsfs.requestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(TEST_BUCKET, file), TrackingHttpRequestInitializer.getRequestString(TEST_BUCKET, file), TrackingHttpRequestInitializer.getRequestString(TEST_BUCKET, file), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(TEST_BUCKET, file + "/", 1, null), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(TEST_BUCKET, file + "/", 1, null), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(TEST_BUCKET, file + "/", 1, null)});
    }

    @Test
    public void getFileInfo_parallel_notFound_parentExists() throws Exception {
        String parentDir = this.name.getMethodName();
        String file = parentDir + "/file";
        URI fileUri = UriPaths.fromStringPathComponents((String)TEST_BUCKET, (String)file, (boolean)false);
        GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorageFileSystem> trackingGcsfs = GoogleCloudStorageFileSystemPerformanceCacheIntegrationTest.newTrackingGoogleCloudStorageFileSystem(GCSFS_OPTIONS);
        helperGcs.createEmptyObject(new StorageResourceId(TEST_BUCKET, parentDir + "/"));
        FileInfo dirInfo1 = ((GoogleCloudStorageFileSystem)trackingGcsfs.delegate).getFileInfo(fileUri);
        FileInfo dirInfo2 = ((GoogleCloudStorageFileSystem)trackingGcsfs.delegate).getFileInfo(fileUri);
        FileInfo dirInfo3 = ((GoogleCloudStorageFileSystem)trackingGcsfs.delegate).getFileInfo(fileUri);
        Truth.assertThat((Boolean)dirInfo1.exists()).isFalse();
        Truth.assertThat((Comparable)dirInfo1.getPath()).isEqualTo((Object)fileUri);
        Truth.assertThat((Object)dirInfo1).isEqualTo((Object)dirInfo2);
        Truth.assertThat((Object)dirInfo1).isEqualTo((Object)dirInfo3);
        Truth.assertThat(trackingGcsfs.requestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(TEST_BUCKET, file), TrackingHttpRequestInitializer.getRequestString(TEST_BUCKET, file), TrackingHttpRequestInitializer.getRequestString(TEST_BUCKET, file), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(TEST_BUCKET, file + "/", 1, null), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(TEST_BUCKET, file + "/", 1, null), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(TEST_BUCKET, file + "/", 1, null)});
    }

    @Test
    public void getFileInfo_parallel_notFound_siblingExists() throws Exception {
        String parentDir = this.name.getMethodName();
        String file = parentDir + "/file";
        URI fileUri = UriPaths.fromStringPathComponents((String)TEST_BUCKET, (String)file, (boolean)false);
        GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorageFileSystem> trackingGcsfs = GoogleCloudStorageFileSystemPerformanceCacheIntegrationTest.newTrackingGoogleCloudStorageFileSystem(GCSFS_OPTIONS);
        helperGcs.createEmptyObject(new StorageResourceId(TEST_BUCKET, file + "_sibling"));
        FileInfo dirInfo1 = ((GoogleCloudStorageFileSystem)trackingGcsfs.delegate).getFileInfo(fileUri);
        FileInfo dirInfo2 = ((GoogleCloudStorageFileSystem)trackingGcsfs.delegate).getFileInfo(fileUri);
        FileInfo dirInfo3 = ((GoogleCloudStorageFileSystem)trackingGcsfs.delegate).getFileInfo(fileUri);
        Truth.assertThat((Boolean)dirInfo1.exists()).isFalse();
        Truth.assertThat((Comparable)dirInfo1.getPath()).isEqualTo((Object)fileUri);
        Truth.assertThat((Object)dirInfo1).isEqualTo((Object)dirInfo2);
        Truth.assertThat((Object)dirInfo1).isEqualTo((Object)dirInfo3);
        Truth.assertThat(trackingGcsfs.requestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(TEST_BUCKET, file), TrackingHttpRequestInitializer.getRequestString(TEST_BUCKET, file), TrackingHttpRequestInitializer.getRequestString(TEST_BUCKET, file), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(TEST_BUCKET, file + "/", 1, null), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(TEST_BUCKET, file + "/", 1, null), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(TEST_BUCKET, file + "/", 1, null)});
    }

    @Test
    public void getFileInfo_parallel_multipleRequests() throws Exception {
        String parentDir = this.name.getMethodName();
        String file = parentDir + "/file";
        URI fileUri = UriPaths.fromStringPathComponents((String)TEST_BUCKET, (String)file, (boolean)false);
        GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorageFileSystem> trackingGcsfs = GoogleCloudStorageFileSystemPerformanceCacheIntegrationTest.newTrackingGoogleCloudStorageFileSystem(GCSFS_OPTIONS);
        helperGcs.createEmptyObject(new StorageResourceId(TEST_BUCKET, file));
        FileInfo fileInfo1 = ((GoogleCloudStorageFileSystem)trackingGcsfs.delegate).getFileInfo(fileUri);
        FileInfo fileInfo2 = ((GoogleCloudStorageFileSystem)trackingGcsfs.delegate).getFileInfo(fileUri);
        FileInfo fileInfo3 = ((GoogleCloudStorageFileSystem)trackingGcsfs.delegate).getFileInfo(fileUri);
        Truth.assertThat((Boolean)fileInfo1.exists()).isTrue();
        Truth.assertThat((Comparable)fileInfo1.getPath()).isEqualTo((Object)fileUri);
        Truth.assertThat((Object)fileInfo1).isEqualTo((Object)fileInfo2);
        Truth.assertThat((Object)fileInfo1.getItemInfo()).isSameInstanceAs((Object)fileInfo2.getItemInfo());
        Truth.assertThat((Object)fileInfo1).isEqualTo((Object)fileInfo3);
        Truth.assertThat((Object)fileInfo1.getItemInfo()).isSameInstanceAs((Object)fileInfo3.getItemInfo());
        Truth.assertThat(trackingGcsfs.requestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(TEST_BUCKET, file), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(TEST_BUCKET, file + "/", 1, null)});
    }

    @Test
    public void getDirInfo_parallel_notFound() throws Exception {
        String parentDir = this.name.getMethodName();
        String dir = parentDir + "/dir/";
        URI dirUri = UriPaths.fromStringPathComponents((String)TEST_BUCKET, (String)dir, (boolean)false);
        GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorageFileSystem> trackingGcsfs = GoogleCloudStorageFileSystemPerformanceCacheIntegrationTest.newTrackingGoogleCloudStorageFileSystem(GCSFS_OPTIONS);
        FileInfo dirInfo1 = ((GoogleCloudStorageFileSystem)trackingGcsfs.delegate).getFileInfo(dirUri);
        FileInfo dirInfo2 = ((GoogleCloudStorageFileSystem)trackingGcsfs.delegate).getFileInfo(dirUri);
        FileInfo dirInfo3 = ((GoogleCloudStorageFileSystem)trackingGcsfs.delegate).getFileInfo(dirUri);
        Truth.assertThat((Boolean)dirInfo1.exists()).isFalse();
        Truth.assertThat((Comparable)dirInfo1.getPath()).isEqualTo((Object)dirUri);
        Truth.assertThat((Object)dirInfo1).isEqualTo((Object)dirInfo2);
        Truth.assertThat((Object)dirInfo1).isEqualTo((Object)dirInfo3);
        Truth.assertThat(trackingGcsfs.requestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(TEST_BUCKET, dir, 1, null), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(TEST_BUCKET, dir, 1, null), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(TEST_BUCKET, dir, 1, null)});
    }

    @Test
    public void getDirInfo_parallel_multipleRequests() throws Exception {
        this.getDirInfo_parallel_multipleRequests(false);
    }

    @Test
    public void getDirInfo_implicit_parallel_multipleRequests() throws Exception {
        this.getDirInfo_parallel_multipleRequests(true);
    }

    private void getDirInfo_parallel_multipleRequests(boolean testImplicitDirectories) throws Exception {
        String parentDir = this.name.getMethodName();
        String dir = parentDir + "/dir";
        URI dirUri = UriPaths.fromStringPathComponents((String)TEST_BUCKET, (String)dir, (boolean)false);
        GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorageFileSystem> trackingGcsfs = GoogleCloudStorageFileSystemPerformanceCacheIntegrationTest.newTrackingGoogleCloudStorageFileSystem(GCSFS_OPTIONS);
        if (!testImplicitDirectories) {
            helperGcs.createEmptyObject(new StorageResourceId(TEST_BUCKET, dir + "/"));
        }
        helperGcs.createEmptyObject(new StorageResourceId(TEST_BUCKET, dir + "/file1"));
        helperGcs.createEmptyObject(new StorageResourceId(TEST_BUCKET, dir + "/file2"));
        FileInfo dirInfo1 = ((GoogleCloudStorageFileSystem)trackingGcsfs.delegate).getFileInfo(dirUri);
        FileInfo dirInfo2 = ((GoogleCloudStorageFileSystem)trackingGcsfs.delegate).getFileInfo(dirUri);
        FileInfo dirInfo3 = ((GoogleCloudStorageFileSystem)trackingGcsfs.delegate).getFileInfo(dirUri);
        Truth.assertThat((Boolean)dirInfo1.exists()).isTrue();
        Truth.assertThat((String)dirInfo1.getPath().toString()).isEqualTo((Object)(dirUri + "/"));
        Truth.assertThat((Object)dirInfo1).isEqualTo((Object)dirInfo2);
        Truth.assertThat((Object)dirInfo1).isEqualTo((Object)dirInfo3);
        Truth.assertThat((Object)dirInfo2.getItemInfo()).isSameInstanceAs((Object)dirInfo3.getItemInfo());
        Truth.assertThat(trackingGcsfs.requestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(TEST_BUCKET, dir), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(TEST_BUCKET, dir + "/", 1, null)});
    }

    private static GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorageFileSystem> newTrackingGoogleCloudStorageFileSystem(GoogleCloudStorageFileSystemOptions gcsfsOptions) throws IOException {
        return new GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorageFileSystem>(gcsfsOptions.getCloudStorageOptions(), httpRequestInitializer -> new GoogleCloudStorageFileSystem(gcsOptions -> new PerformanceCachingGoogleCloudStorage((GoogleCloudStorage)new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)httpRequestInitializer), PERF_CACHE_GCS_OPTIONS), gcsfsOptions));
    }
}

