/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.hadoop.gcsio.FileInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemIntegrationHelper;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.ListFileOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.TrackingHttpRequestInitializer;
import com.google.cloud.hadoop.gcsio.VerificationAttributes;
import com.google.cloud.hadoop.gcsio.integration.GoogleCloudStorageTestHelper;
import com.google.cloud.hadoop.util.RetryHttpInitializer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GoogleCloudStorageFileSystemNewIntegrationTest {
    private static GoogleCloudStorageOptions gcsOptions;
    private static RetryHttpInitializer httpRequestsInitializer;
    private static GoogleCloudStorageFileSystemIntegrationHelper gcsfsIHelper;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void before() throws Throwable {
        Credential credential = (Credential)Preconditions.checkNotNull((Object)GoogleCloudStorageTestHelper.getCredential(), (Object)"credential must not be null");
        gcsOptions = GoogleCloudStorageTestHelper.getStandardOptionBuilder().build();
        httpRequestsInitializer = new RetryHttpInitializer(credential, gcsOptions.toRetryHttpInitializerOptions());
        GoogleCloudStorageFileSystem gcsfs = new GoogleCloudStorageFileSystem(credential, GoogleCloudStorageFileSystemOptions.builder().setBucketDeleteEnabled(true).setCloudStorageOptions(gcsOptions).build());
        gcsfsIHelper = new GoogleCloudStorageFileSystemIntegrationHelper(gcsfs);
        gcsfsIHelper.beforeAllTests();
    }

    @AfterClass
    public static void afterClass() throws Throwable {
        gcsfsIHelper.afterAllTests();
        GoogleCloudStorageFileSystem gcsfs = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.gcsfs;
        Truth.assertThat((Boolean)gcsfs.exists(new URI("gs://" + GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1))).isFalse();
        Truth.assertThat((Boolean)gcsfs.exists(new URI("gs://" + GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName2))).isFalse();
    }

    @Test
    public void mkdir_shouldCreateNewDirectory() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().build(), gcsRequestsTracker);
        String bucketName = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1;
        String dirObject = this.getTestResource();
        URI dirObjectUri = new URI("gs://" + bucketName).resolve(dirObject);
        gcsFs.mkdir(dirObjectUri);
        Truth.assertThat(gcsRequestsTracker.getAllRawRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.uploadRequestString(bucketName, dirObject + "/", 0, false)});
        Truth.assertThat((Boolean)gcsFs.exists(dirObjectUri)).isTrue();
        Truth.assertThat((Boolean)gcsFs.getFileInfo(dirObjectUri).isDirectory()).isTrue();
    }

    @Test
    public void mkdir_shouldFailSilentlyIfDirectoryExists() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().build(), gcsRequestsTracker);
        String bucketName = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1;
        String dirObject = this.getTestResource();
        URI dirObjectUri = new URI("gs://" + bucketName).resolve(dirObject);
        gcsfsIHelper.mkdir(bucketName, dirObject);
        gcsFs.mkdir(dirObjectUri);
        Truth.assertThat(gcsRequestsTracker.getAllRawRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.uploadRequestString(bucketName, dirObject + "/", 0, false), TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject + "/")});
        Truth.assertThat((Boolean)gcsFs.exists(dirObjectUri)).isTrue();
        Truth.assertThat((Boolean)gcsFs.getFileInfo(dirObjectUri).isDirectory()).isTrue();
    }

    @Test
    public void mkdirs_shouldCreateNewDirectory() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().build(), gcsRequestsTracker);
        String bucketName = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1;
        String dirObject = this.getTestResource();
        URI dirObjectUri = new URI("gs://" + bucketName).resolve(dirObject + "/d1/");
        gcsFs.mkdirs(dirObjectUri);
        Truth.assertThat(gcsRequestsTracker.getAllRawRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.batchRequestString(), TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject), TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject + "/d1"), TrackingHttpRequestInitializer.uploadRequestString(bucketName, dirObject + "/d1/", 0, false)});
        Truth.assertThat((Boolean)gcsFs.exists(dirObjectUri)).isTrue();
        Truth.assertThat((Boolean)gcsFs.getFileInfo(dirObjectUri).isDirectory()).isTrue();
    }

    @Test
    public void mkdirs_shouldFailSilentlyIfDirectoryExists() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().build(), gcsRequestsTracker);
        String bucketName = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1;
        String dirObject = this.getTestResource();
        URI dirObjectUri = new URI("gs://" + bucketName).resolve(dirObject + "/d1/");
        gcsfsIHelper.mkdirs(dirObjectUri);
        gcsFs.mkdirs(dirObjectUri);
        Truth.assertThat(gcsRequestsTracker.getAllRawRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.batchRequestString(), TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject), TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject + "/d1"), TrackingHttpRequestInitializer.uploadRequestString(bucketName, dirObject + "/d1/", 0, false), TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject + "/d1/")});
        Truth.assertThat((Boolean)gcsFs.exists(dirObjectUri)).isTrue();
        Truth.assertThat((Boolean)gcsFs.getFileInfo(dirObjectUri).isDirectory()).isTrue();
    }

    @Test
    public void getFileInfo_sequential() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().setStatusParallelEnabled(false).build(), gcsRequestsTracker);
        String bucketName = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1;
        String dirObject = this.getTestResource();
        URI dirObjectUri = new URI("gs://" + bucketName).resolve("/" + dirObject);
        gcsfsIHelper.createObjectsWithSubdirs(bucketName, dirObject + "/file1", dirObject + "/file2", dirObject + "/file3");
        FileInfo dirInfo = gcsFs.getFileInfo(dirObjectUri);
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, dirObject + "/", 1, null)}).inOrder();
        Truth.assertThat((Boolean)dirInfo.exists()).isTrue();
        Truth.assertThat((String)dirInfo.getPath().toString()).isEqualTo((Object)(dirObjectUri + "/"));
    }

    @Test
    public void getFileInfo_parallel() throws Exception {
        GoogleCloudStorageFileSystemOptions gcsFsOptions = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().setStatusParallelEnabled(true).build();
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(gcsFsOptions, gcsRequestsTracker);
        String bucketName = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1;
        String dirObject = this.getTestResource();
        URI dirObjectUri = new URI("gs://" + bucketName).resolve("/" + dirObject);
        gcsfsIHelper.createObjectsWithSubdirs(bucketName, dirObject + "/file1", dirObject + "/file2", dirObject + "/file3");
        FileInfo dirInfo = gcsFs.getFileInfo(dirObjectUri);
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, dirObject + "/", 1, null)});
        Truth.assertThat((Boolean)dirInfo.exists()).isTrue();
        Truth.assertThat((String)dirInfo.getPath().toString()).isEqualTo((Object)(dirObjectUri + "/"));
    }

    @Test
    public void getFileInfo_single_file_sequential() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().setStatusParallelEnabled(false).build(), gcsRequestsTracker);
        String bucketName = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1;
        String fileObject = this.getTestResource() + "/f1";
        URI fileObjectUri = new URI("gs://" + bucketName).resolve("/" + fileObject);
        gcsfsIHelper.createObjectsWithSubdirs(bucketName, fileObject);
        FileInfo fileInfo = gcsFs.getFileInfo(fileObjectUri);
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(bucketName, fileObject)});
        Truth.assertThat((Boolean)fileInfo.exists()).isTrue();
        Truth.assertThat((Comparable)fileInfo.getPath()).isEqualTo((Object)fileObjectUri);
    }

    @Test
    public void getDirInfo_sequential() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().setStatusParallelEnabled(false).build(), gcsRequestsTracker);
        String bucketName = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1;
        String dirObject = this.getTestResource();
        URI dirObjectUri = new URI("gs://" + bucketName).resolve("/" + dirObject);
        gcsfsIHelper.createObjectsWithSubdirs(bucketName, dirObject + "/file1", dirObject + "/file2", dirObject + "/file3");
        FileInfo dirInfo = gcsFs.getFileInfo(new URI("gs://" + bucketName).resolve(dirObject + "/"));
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, dirObject + "/", 1, null)});
        Truth.assertThat((Boolean)dirInfo.exists()).isTrue();
        Truth.assertThat((String)dirInfo.getPath().toString()).isEqualTo((Object)(dirObjectUri + "/"));
    }

    @Test
    public void getDirInfo_parallel() throws Exception {
        GoogleCloudStorageFileSystemOptions gcsFsOptions = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().setStatusParallelEnabled(true).build();
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(gcsFsOptions, gcsRequestsTracker);
        String bucketName = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1;
        String dirObject = this.getTestResource();
        URI dirObjectUri = new URI("gs://" + bucketName).resolve("/" + dirObject);
        gcsfsIHelper.createObjectsWithSubdirs(bucketName, dirObject + "/file1", dirObject + "/file2", dirObject + "/file3");
        FileInfo dirInfo = gcsFs.getFileInfo(new URI("gs://" + bucketName).resolve(dirObject + "/"));
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, dirObject + "/", 1, null)});
        Truth.assertThat((Boolean)dirInfo.exists()).isTrue();
        Truth.assertThat((String)dirInfo.getPath().toString()).isEqualTo((Object)(dirObjectUri + "/"));
    }

    @Test
    public void getFileInfos_sequential() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().setStatusParallelEnabled(false).build(), gcsRequestsTracker);
        String bucketName = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1;
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String dirObject = this.getTestResource();
        gcsfsIHelper.createObjectsWithSubdirs(bucketName, dirObject + "/f1", dirObject + "/f2", dirObject + "/subdir/f3");
        List fileInfos = gcsFs.getFileInfos((List)ImmutableList.of((Object)bucketUri.resolve(dirObject + "/f1"), (Object)bucketUri.resolve(dirObject + "/f2"), (Object)bucketUri.resolve(dirObject + "/subdir/f3")));
        Truth.assertThat((Iterable)fileInfos.stream().map(FileInfo::exists).collect(Collectors.toList())).containsExactly(new Object[]{true, true, true});
        Truth.assertThat((Iterable)fileInfos.stream().map(FileInfo::getPath).collect(Collectors.toList())).containsExactly(new Object[]{bucketUri.resolve(dirObject + "/f1"), bucketUri.resolve(dirObject + "/f2"), bucketUri.resolve(dirObject + "/subdir/f3")}).inOrder();
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject + "/f1"), TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject + "/f2"), TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject + "/subdir/f3")}).inOrder();
    }

    @Test
    public void getFileInfos_parallel() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().setStatusParallelEnabled(true).build(), gcsRequestsTracker);
        String bucketName = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1;
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String dirObject = this.getTestResource();
        gcsfsIHelper.createObjectsWithSubdirs(bucketName, dirObject + "/f1", dirObject + "/f2", dirObject + "/subdir/f3");
        List fileInfos = gcsFs.getFileInfos((List)ImmutableList.of((Object)bucketUri.resolve(dirObject + "/f1"), (Object)bucketUri.resolve(dirObject + "/f2"), (Object)bucketUri.resolve(dirObject + "/subdir/f3")));
        Truth.assertThat((Iterable)fileInfos.stream().map(FileInfo::exists).collect(Collectors.toList())).containsExactly(new Object[]{true, true, true});
        Truth.assertThat((Iterable)fileInfos.stream().map(FileInfo::getPath).collect(Collectors.toList())).containsExactly(new Object[]{bucketUri.resolve(dirObject + "/f1"), bucketUri.resolve(dirObject + "/f2"), bucketUri.resolve(dirObject + "/subdir/f3")});
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, dirObject + "/f1/", 1, null), TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject + "/f1"), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, dirObject + "/f2/", 1, null), TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject + "/f2"), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, dirObject + "/subdir/f3/", 1, null), TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject + "/subdir/f3")});
    }

    @Test
    public void listFileInfo_file() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().build(), gcsRequestsTracker);
        String bucketName = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1;
        String fileObject = this.getTestResource();
        URI fileObjectUri = new URI("gs://" + bucketName + "/").resolve(fileObject);
        gcsfsIHelper.createObjectsWithSubdirs(bucketName, fileObject);
        List fileInfos = gcsFs.listFileInfo(fileObjectUri);
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(bucketName, fileObject), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, fileObject + "/", 1024, null)});
        Truth.assertThat((Iterable)fileInfos).hasSize(1);
        FileInfo fileInfo = (FileInfo)fileInfos.get(0);
        Truth.assertThat((Boolean)fileInfo.exists()).isTrue();
        Truth.assertThat((Comparable)fileInfo.getPath()).isEqualTo((Object)fileObjectUri);
    }

    @Test
    public void listFileInfo_file_directoryPath() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().build(), gcsRequestsTracker);
        String bucketName = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1;
        String fileObject = this.getTestResource();
        URI bucketUri = new URI("gs://" + bucketName + "/");
        gcsfsIHelper.createObjectsWithSubdirs(bucketName, fileObject);
        Assert.assertThrows(FileNotFoundException.class, () -> gcsFs.listFileInfo(bucketUri.resolve(fileObject + "/")));
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, fileObject + "/", 1024, null)});
    }

    @Test
    public void listFileInfo_directory() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().build(), gcsRequestsTracker);
        String bucketName = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1;
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String dirObject = this.getTestResource();
        gcsfsIHelper.createObjectsWithSubdirs(bucketName, dirObject + "/file1", dirObject + "/file2");
        List fileInfos = gcsFs.listFileInfo(bucketUri.resolve(dirObject));
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, dirObject + "/", 1024, null)});
        Truth.assertThat((Iterable)fileInfos.stream().map(FileInfo::exists).collect(Collectors.toList())).containsExactly(new Object[]{true, true});
        Truth.assertThat((Iterable)fileInfos.stream().map(FileInfo::getPath).collect(Collectors.toList())).containsExactly(new Object[]{bucketUri.resolve(dirObject + "/file1"), bucketUri.resolve(dirObject + "/file2")});
    }

    @Test
    public void listFileInfo_directory_directoryPath() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().build(), gcsRequestsTracker);
        String bucketName = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1;
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String dirObject = this.getTestResource();
        gcsfsIHelper.createObjectsWithSubdirs(bucketName, dirObject + "/file1", dirObject + "/file2");
        List fileInfos = gcsFs.listFileInfo(bucketUri.resolve(dirObject + "/"));
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, dirObject + "/", 1024, null)});
        Truth.assertThat((Iterable)fileInfos.stream().map(FileInfo::exists).collect(Collectors.toList())).containsExactly(new Object[]{true, true});
        Truth.assertThat((Iterable)fileInfos.stream().map(FileInfo::getPath).collect(Collectors.toList())).containsExactly(new Object[]{bucketUri.resolve(dirObject + "/file1"), bucketUri.resolve(dirObject + "/file2")});
    }

    @Test
    public void listFileInfo_implicitDirectory() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().build(), gcsRequestsTracker);
        String bucketName = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1;
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String dirObject = this.getTestResource();
        gcsfsIHelper.createObjects(bucketName, dirObject + "/subdir/file");
        List fileInfos = gcsFs.listFileInfo(bucketUri.resolve(dirObject));
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, dirObject + "/", 1024, null)});
        Truth.assertThat((Iterable)fileInfos.stream().map(FileInfo::exists).collect(Collectors.toList())).containsExactly(new Object[]{true});
        Truth.assertThat((Iterable)fileInfos.stream().map(FileInfo::getPath).collect(Collectors.toList())).containsExactly(new Object[]{bucketUri.resolve(dirObject + "/subdir/")});
    }

    @Test
    public void listFileInfo_emptyDirectoryObject() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().build(), gcsRequestsTracker);
        String bucketName = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1;
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String dirObject = this.getTestResource();
        gcsfsIHelper.createObjectsWithSubdirs(bucketName, dirObject + "/");
        List fileInfos = gcsFs.listFileInfo(bucketUri.resolve(dirObject));
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, dirObject + "/", 1024, null)});
        Truth.assertThat((Iterable)fileInfos).isEmpty();
    }

    @Test
    public void listFileInfo_notFound() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().build(), gcsRequestsTracker);
        String bucketName = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1;
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String dirObject = this.getTestResource();
        Assert.assertThrows(FileNotFoundException.class, () -> gcsFs.listFileInfo(bucketUri.resolve(dirObject)));
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, dirObject + "/", 1024, null)});
    }

    @Test
    public void listFileInfo_customFields_required() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().build(), gcsRequestsTracker);
        String bucketName = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1;
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String dirObject = this.getTestResource();
        gcsfsIHelper.createObjectsWithSubdirs(bucketName, dirObject + "/object");
        List fileInfos = gcsFs.listFileInfo(bucketUri.resolve(dirObject), ListFileOptions.DEFAULT.toBuilder().setFields("bucket,name").build());
        FileInfo expectedFileInfo = FileInfo.fromItemInfo((GoogleCloudStorageItemInfo)GoogleCloudStorageItemInfo.createObject((StorageResourceId)StorageResourceId.fromUriPath((URI)bucketUri.resolve(dirObject + "/object"), (boolean)false), (long)0L, (long)0L, (long)0L, null, null, null, (long)0L, (long)0L, (VerificationAttributes)new VerificationAttributes(null, null)));
        Truth.assertThat((Iterable)fileInfos).containsExactly(new Object[]{expectedFileInfo});
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, dirObject + "/", "bucket,name", 1024, null)});
    }

    @Test
    public void listFileInfo_customFields_some() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().build(), gcsRequestsTracker);
        String bucketName = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1;
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String dirObject = this.getTestResource();
        gcsfsIHelper.createObjectsWithSubdirs(bucketName, dirObject + "/object");
        List fileInfos = gcsFs.listFileInfo(bucketUri.resolve(dirObject), ListFileOptions.DEFAULT.toBuilder().setFields("bucket,name,contentType").build());
        FileInfo expectedFileInfo = FileInfo.fromItemInfo((GoogleCloudStorageItemInfo)GoogleCloudStorageItemInfo.createObject((StorageResourceId)StorageResourceId.fromUriPath((URI)bucketUri.resolve(dirObject + "/object"), (boolean)false), (long)0L, (long)0L, (long)0L, (String)"application/octet-stream", null, null, (long)0L, (long)0L, (VerificationAttributes)new VerificationAttributes(null, null)));
        Truth.assertThat((Iterable)fileInfos).containsExactly(new Object[]{expectedFileInfo});
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, dirObject + "/", "bucket,name,contentType", 1024, null)});
    }

    @Test
    public void listFileInfo_customFields_fails() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().build(), gcsRequestsTracker);
        String bucketName = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1;
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String dirObject = this.getTestResource();
        gcsfsIHelper.createObjectsWithSubdirs(bucketName, dirObject + "/object");
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> gcsFs.listFileInfo(bucketUri.resolve(dirObject), ListFileOptions.DEFAULT.toBuilder().setFields("bucket").build()));
        Truth.assertThat((Throwable)thrown).hasCauseThat().hasCauseThat().isInstanceOf(NullPointerException.class);
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, dirObject + "/", "bucket", 1024, null)});
    }

    @Test
    public void delete_file_sequential() throws Exception {
        GoogleCloudStorageFileSystemOptions gcsFsOptions = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().setStatusParallelEnabled(false).build();
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(gcsFsOptions, gcsRequestsTracker);
        String bucketName = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1;
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String dirObject = this.getTestResource();
        gcsfsIHelper.createObjectsWithSubdirs(bucketName, dirObject + "/f1");
        gcsFs.delete(bucketUri.resolve(dirObject + "/f1"), false);
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject + "/f1"), TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject + "/"), TrackingHttpRequestInitializer.deleteRequestString(bucketName, dirObject + "/f1", 1L)});
        Truth.assertThat((Boolean)gcsFs.exists(bucketUri.resolve(dirObject + "/f1"))).isFalse();
    }

    @Test
    public void delete_file_parallel() throws Exception {
        GoogleCloudStorageFileSystemOptions gcsFsOptions = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().setStatusParallelEnabled(true).build();
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(gcsFsOptions, gcsRequestsTracker);
        String bucketName = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1;
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String dirObject = this.getTestResource();
        gcsfsIHelper.createObjectsWithSubdirs(bucketName, dirObject + "/f1");
        gcsFs.delete(bucketUri.resolve(dirObject + "/f1"), false);
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject + "/"), TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject + "/f1"), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, dirObject + "/f1/", 1, null), TrackingHttpRequestInitializer.deleteRequestString(bucketName, dirObject + "/f1", 1L)});
        Truth.assertThat((Boolean)gcsFs.exists(bucketUri.resolve(dirObject + "/f1"))).isFalse();
    }

    @Test
    public void delete_directory_sequential() throws Exception {
        this.delete_directory(false);
    }

    @Test
    public void delete_directory_parallel() throws Exception {
        this.delete_directory(true);
    }

    private void delete_directory(boolean parallelStatus) throws Exception {
        GoogleCloudStorageFileSystemOptions gcsFsOptions = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().setStatusParallelEnabled(parallelStatus).build();
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(gcsFsOptions, gcsRequestsTracker);
        String bucketName = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1;
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String dirObject = this.getTestResource();
        gcsfsIHelper.createObjectsWithSubdirs(bucketName, dirObject + "/d1/");
        gcsFs.delete(bucketUri.resolve(dirObject + "/d1/"), false);
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject + "/"), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, dirObject + "/d1/", 1, null), TrackingHttpRequestInitializer.listRequestString(bucketName, true, null, dirObject + "/d1/", "bucket,name,generation", 1024, null), TrackingHttpRequestInitializer.deleteRequestString(bucketName, dirObject + "/d1/", 1L)});
        Truth.assertThat((Boolean)gcsFs.exists(bucketUri.resolve(dirObject + "/d1"))).isFalse();
    }

    @Test
    public void delete_inferredDirectory() throws Exception {
        GoogleCloudStorageFileSystemOptions gcsFsOptions = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().setStatusParallelEnabled(false).build();
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(gcsFsOptions, gcsRequestsTracker);
        String bucketName = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1;
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String dirObject = this.getTestResource();
        gcsfsIHelper.createObjects(bucketName, dirObject + "/");
        gcsfsIHelper.createObjects(bucketName, dirObject + "/d1/f1");
        gcsFs.delete(bucketUri.resolve(dirObject + "/d1/"), true);
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, dirObject + "/d1/", 1, null), TrackingHttpRequestInitializer.listRequestString(bucketName, true, null, dirObject + "/d1/", "bucket,name,generation", 1024, null), TrackingHttpRequestInitializer.deleteRequestString(bucketName, dirObject + "/d1/f1", 1L), TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject + "/")});
        Truth.assertThat((Boolean)gcsFs.exists(bucketUri.resolve(dirObject + "/d1/"))).isFalse();
        Truth.assertThat((Boolean)gcsFs.exists(bucketUri.resolve(dirObject + "/d1/f1"))).isFalse();
    }

    @Test
    public void rename_file_sequential() throws Exception {
        GoogleCloudStorageFileSystemOptions gcsFsOptions = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().setStatusParallelEnabled(false).build();
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(gcsFsOptions, gcsRequestsTracker);
        String bucketName = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1;
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String dirObject = this.getTestResource();
        gcsfsIHelper.createObjectsWithSubdirs(bucketName, dirObject + "/f1");
        gcsFs.rename(bucketUri.resolve(dirObject + "/f1"), bucketUri.resolve(dirObject + "/f2"));
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject + "/f1"), TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject + "/f2"), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, dirObject + "/f2/", 1, null), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, dirObject + "/", 1, null), TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject + "/"), TrackingHttpRequestInitializer.copyRequestString(bucketName, dirObject + "/f1", bucketName, dirObject + "/f2", "copyTo"), TrackingHttpRequestInitializer.deleteRequestString(bucketName, dirObject + "/f1", 1L)});
        Truth.assertThat((Boolean)gcsFs.exists(bucketUri.resolve(dirObject + "/f1"))).isFalse();
        Truth.assertThat((Boolean)gcsFs.exists(bucketUri.resolve(dirObject + "/f2"))).isTrue();
    }

    @Test
    public void rename_file_parallel() throws Exception {
        GoogleCloudStorageFileSystemOptions gcsFsOptions = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().setStatusParallelEnabled(true).build();
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(gcsFsOptions, gcsRequestsTracker);
        String bucketName = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1;
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String dirObject = this.getTestResource();
        gcsfsIHelper.createObjectsWithSubdirs(bucketName, dirObject + "/f1");
        gcsFs.rename(bucketUri.resolve(dirObject + "/f1"), bucketUri.resolve(dirObject + "/f2"));
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject + "/f1"), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, dirObject + "/f1/", 1, null), TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject + "/f2"), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, dirObject + "/f2/", 1, null), TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject + "/"), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, dirObject + "/", 1, null), TrackingHttpRequestInitializer.copyRequestString(bucketName, dirObject + "/f1", bucketName, dirObject + "/f2", "copyTo"), TrackingHttpRequestInitializer.deleteRequestString(bucketName, dirObject + "/f1", 1L)});
        Truth.assertThat((Boolean)gcsFs.exists(bucketUri.resolve(dirObject + "/f1"))).isFalse();
        Truth.assertThat((Boolean)gcsFs.exists(bucketUri.resolve(dirObject + "/f2"))).isTrue();
    }

    @Test
    public void rename_directory_sequential() throws Exception {
        GoogleCloudStorageFileSystemOptions gcsFsOptions = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().setStatusParallelEnabled(false).build();
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(gcsFsOptions, gcsRequestsTracker);
        String bucketName = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1;
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String dirObject = this.getTestResource();
        gcsfsIHelper.createObjectsWithSubdirs(bucketName, dirObject + "/srcParent/srcDir/f", dirObject + "/dstParent/");
        gcsFs.rename(bucketUri.resolve(dirObject + "/srcParent/srcDir"), bucketUri.resolve(dirObject + "/dstParent/dstDir"));
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject + "/srcParent/srcDir"), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, dirObject + "/srcParent/srcDir/", 1, null), TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject + "/dstParent/dstDir"), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, dirObject + "/dstParent/dstDir/", 1, null), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, dirObject + "/dstParent/", 1, null), TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject + "/srcParent/"), TrackingHttpRequestInitializer.listRequestString(bucketName, true, null, dirObject + "/srcParent/srcDir/", "bucket,name,generation", 1024, null), TrackingHttpRequestInitializer.copyRequestString(bucketName, dirObject + "/srcParent/srcDir/f", bucketName, dirObject + "/dstParent/dstDir/f", "copyTo"), TrackingHttpRequestInitializer.batchRequestString(), TrackingHttpRequestInitializer.deleteRequestString(bucketName, dirObject + "/srcParent/srcDir/f", 1L), TrackingHttpRequestInitializer.deleteRequestString(bucketName, dirObject + "/srcParent/srcDir/", 2L)});
        Truth.assertThat((Boolean)gcsFs.exists(bucketUri.resolve(dirObject + "/srcParent/srcDir/f"))).isFalse();
        Truth.assertThat((Boolean)gcsFs.exists(bucketUri.resolve(dirObject + "/srcParent/srcDir"))).isFalse();
        Truth.assertThat((Boolean)gcsFs.exists(bucketUri.resolve(dirObject + "/srcParent"))).isTrue();
        Truth.assertThat((Boolean)gcsFs.exists(bucketUri.resolve(dirObject + "/dstParent/dstDir/f"))).isTrue();
        Truth.assertThat((Boolean)gcsFs.exists(bucketUri.resolve(dirObject + "/dstParent/dstDir"))).isTrue();
    }

    @Test
    public void rename_directory_parallel() throws Exception {
        GoogleCloudStorageFileSystemOptions gcsFsOptions = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().setStatusParallelEnabled(true).build();
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(gcsFsOptions, gcsRequestsTracker);
        String bucketName = GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1;
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String dirObject = this.getTestResource();
        gcsfsIHelper.createObjectsWithSubdirs(bucketName, dirObject + "/srcParent/srcDir/f", dirObject + "/dstParent/");
        gcsFs.rename(bucketUri.resolve(dirObject + "/srcParent/srcDir"), bucketUri.resolve(dirObject + "/dstParent/dstDir"));
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject + "/srcParent/srcDir"), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, dirObject + "/srcParent/srcDir/", 1, null), TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject + "/dstParent/dstDir"), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, dirObject + "/dstParent/dstDir/", 1, null), TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucketName, dirObject + "/dstParent/", 1, null), TrackingHttpRequestInitializer.getRequestString(bucketName, dirObject + "/srcParent/"), TrackingHttpRequestInitializer.listRequestString(bucketName, true, null, dirObject + "/srcParent/srcDir/", "bucket,name,generation", 1024, null), TrackingHttpRequestInitializer.copyRequestString(bucketName, dirObject + "/srcParent/srcDir/f", bucketName, dirObject + "/dstParent/dstDir/f", "copyTo"), TrackingHttpRequestInitializer.batchRequestString(), TrackingHttpRequestInitializer.deleteRequestString(bucketName, dirObject + "/srcParent/srcDir/f", 1L), TrackingHttpRequestInitializer.deleteRequestString(bucketName, dirObject + "/srcParent/srcDir/", 2L)});
        Truth.assertThat((Boolean)gcsFs.exists(bucketUri.resolve(dirObject + "/srcParent/srcDir/f"))).isFalse();
        Truth.assertThat((Boolean)gcsFs.exists(bucketUri.resolve(dirObject + "/srcParent/srcDir"))).isFalse();
        Truth.assertThat((Boolean)gcsFs.exists(bucketUri.resolve(dirObject + "/srcParent"))).isTrue();
        Truth.assertThat((Boolean)gcsFs.exists(bucketUri.resolve(dirObject + "/dstParent/dstDir/f"))).isTrue();
        Truth.assertThat((Boolean)gcsFs.exists(bucketUri.resolve(dirObject + "/dstParent/dstDir"))).isTrue();
    }

    @Test
    public void concurrentCreation_newObjet_overwrite_oneSucceeds() throws Exception {
        this.concurrentCreate_oneSucceeds(false);
    }

    @Test
    public void concurrentCreate_existingObject_overwrite_oneSucceeds() throws Exception {
        this.concurrentCreate_oneSucceeds(true);
    }

    private void concurrentCreate_oneSucceeds(boolean overwriteExisting) throws Exception {
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFs(GoogleCloudStorageFileSystemNewIntegrationTest.newGcsFsOptions().build(), new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer));
        GoogleCloudStorageFileSystemIntegrationHelper testHelper = new GoogleCloudStorageFileSystemIntegrationHelper(gcsFs);
        URI path = new URI("gs://" + GoogleCloudStorageFileSystemNewIntegrationTest.gcsfsIHelper.sharedBucketName1 + "/" + this.getTestResource());
        Truth.assertThat((Boolean)gcsFs.getFileInfo(path).exists()).isFalse();
        if (overwriteExisting) {
            String text = "Hello World! Existing";
            int numBytesWritten = gcsfsIHelper.writeFile(path, text, 1, false);
            Truth.assertThat((Integer)numBytesWritten).isEqualTo((Object)text.getBytes(StandardCharsets.UTF_8).length);
        }
        ImmutableList texts = ImmutableList.of((Object)"Hello World!", (Object)"World Hello! Long");
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        List futures = executorService.invokeAll(ImmutableList.of(() -> GoogleCloudStorageFileSystemNewIntegrationTest.lambda$concurrentCreate_oneSucceeds$3(testHelper, path, (List)texts), () -> GoogleCloudStorageFileSystemNewIntegrationTest.lambda$concurrentCreate_oneSucceeds$4(testHelper, path, (List)texts)));
        executorService.shutdown();
        Truth.assertThat((Boolean)executorService.awaitTermination(1L, TimeUnit.MINUTES)).isTrue();
        String readText = testHelper.readTextFile(path);
        Truth.assertThat((Iterable)ImmutableList.of((Object)readText)).containsAnyIn((Iterable)texts);
        for (int i = 0; i < futures.size(); ++i) {
            Future future = futures.get(i);
            String text = (String)texts.get(i);
            if (readText.equals(text)) {
                Truth.assertThat((Integer)((Integer)future.get())).isEqualTo((Object)text.length());
                continue;
            }
            Assert.assertThrows(ExecutionException.class, future::get);
        }
    }

    private String getTestResource() {
        return this.name.getMethodName() + "_" + UUID.randomUUID();
    }

    private static GoogleCloudStorageFileSystemOptions.Builder newGcsFsOptions() {
        return GoogleCloudStorageFileSystemOptions.builder().setCloudStorageOptions(gcsOptions);
    }

    private static GoogleCloudStorageFileSystem newGcsFs(GoogleCloudStorageFileSystemOptions gcsfsOptions, TrackingHttpRequestInitializer gcsRequestsTracker) throws IOException {
        return new GoogleCloudStorageFileSystem(o -> new GoogleCloudStorageImpl(o, (HttpRequestInitializer)gcsRequestsTracker), gcsfsOptions);
    }

    private static /* synthetic */ Integer lambda$concurrentCreate_oneSucceeds$4(GoogleCloudStorageFileSystemIntegrationHelper testHelper, URI path, List texts) throws Exception {
        return testHelper.writeFile(path, (String)texts.get(1), 1, true);
    }

    private static /* synthetic */ Integer lambda$concurrentCreate_oneSucceeds$3(GoogleCloudStorageFileSystemIntegrationHelper testHelper, URI path, List texts) throws Exception {
        return testHelper.writeFile(path, (String)texts.get(0), 1, true);
    }
}

