/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.FileInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.common.collect.ImmutableMap;
import com.google.common.testing.EqualsTester;
import com.google.common.truth.Correspondence;
import com.google.common.truth.Truth;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FileInfoTest {
    @Test
    public void fromItemInfo() throws Exception {
        GoogleCloudStorageItemInfo itemInfo = GoogleCloudStorageItemInfo.createObject((StorageResourceId)new StorageResourceId("foo-test-bucket", "bar/test/object"), (long)10L, (long)15L, (long)200L, (String)"text/plain", (String)"lzma", (Map)ImmutableMap.of((Object)"foo-meta", (Object)new byte[]{5, 66, 56}), (long)312432L, (long)2L, null);
        FileInfo fileInfo = FileInfo.fromItemInfo((GoogleCloudStorageItemInfo)itemInfo);
        Truth.assertThat((Comparable)fileInfo.getPath()).isEqualTo((Object)new URI("gs://foo-test-bucket/bar/test/object"));
        Truth.assertThat((Long)fileInfo.getCreationTime()).isEqualTo((Object)10L);
        Truth.assertThat((Long)fileInfo.getModificationTime()).isEqualTo((Object)15L);
        Truth.assertThat((Long)fileInfo.getSize()).isEqualTo((Object)200);
        Truth.assertThat((Map)fileInfo.getAttributes()).comparingValuesUsing(Correspondence.from(Arrays::equals, (String)"Arrays.equals")).containsExactly((Object)"foo-meta", (Object)new byte[]{5, 66, 56}, new Object[0]);
        Truth.assertThat((Object)fileInfo.getItemInfo()).isEqualTo((Object)itemInfo);
    }

    @Test
    public void testEquals() {
        StorageResourceId testObject = StorageResourceId.fromStringPath((String)"gs://test-bucket/dir/object");
        new EqualsTester().addEqualityGroup(new Object[]{FileInfo.fromItemInfo((GoogleCloudStorageItemInfo)GoogleCloudStorageItemInfo.ROOT_INFO), FileInfo.fromItemInfo((GoogleCloudStorageItemInfo)GoogleCloudStorageItemInfo.ROOT_INFO)}).addEqualityGroup(new Object[]{FileInfo.fromItemInfo((GoogleCloudStorageItemInfo)GoogleCloudStorageItemInfo.createObject((StorageResourceId)testObject, (long)100L, (long)1000L, (long)324L, (String)"text", (String)"gzip", (Map)ImmutableMap.of((Object)"mkey", (Object)new byte[]{1, 6}), (long)122L, (long)3L, null))}).addEqualityGroup(new Object[]{FileInfo.fromItemInfo((GoogleCloudStorageItemInfo)GoogleCloudStorageItemInfo.createObject((StorageResourceId)testObject, (long)100L, (long)1000L, (long)324L, (String)"text", (String)"gzip", (Map)ImmutableMap.of((Object)"mky", (Object)new byte[]{1, 6}), (long)122L, (long)3L, null)), FileInfo.fromItemInfo((GoogleCloudStorageItemInfo)GoogleCloudStorageItemInfo.createObject((StorageResourceId)testObject, (long)100L, (long)1000L, (long)324L, (String)"text", (String)"gzip", (Map)ImmutableMap.of((Object)"mky", (Object)new byte[]{1, 6}), (long)122L, (long)3L, null))}).testEquals();
    }
}

