/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.PathCodec;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LegacyPathCodec
implements PathCodec {
    public static final Logger LOG = LoggerFactory.getLogger(LegacyPathCodec.class);

    LegacyPathCodec() {
    }

    @Override
    public StorageResourceId validatePathAndGetId(URI path, boolean allowEmptyObjectName) {
        LOG.debug("validatePathAndGetId('{}', {})", (Object)path, (Object)allowEmptyObjectName);
        Preconditions.checkNotNull((Object)path);
        if (!"gs".equals(path.getScheme())) {
            String string = String.valueOf("Google Cloud Storage path supports only 'gs' scheme, instead got '");
            String string2 = String.valueOf(path.getScheme());
            String string3 = String.valueOf(path);
            throw new IllegalArgumentException(new StringBuilder(10 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(string2).append("' from '").append(string3).append("'.").toString());
        }
        if (path.equals(GoogleCloudStorageFileSystem.GCS_ROOT)) {
            return StorageResourceId.ROOT;
        }
        String bucketName = path.getAuthority();
        String schemeSpecificPart = path.getRawSchemeSpecificPart();
        String string = String.valueOf(bucketName);
        Preconditions.checkState((boolean)schemeSpecificPart.startsWith(string.length() != 0 ? "//".concat(string) : new String("//")), (String)"Expected schemeSpecificStart to start with '//%s', instead got '%s'", (Object[])new Object[]{bucketName, schemeSpecificPart});
        String objectName = schemeSpecificPart.substring(2 + bucketName.length());
        bucketName = GoogleCloudStorageFileSystem.validateBucketName(bucketName);
        objectName = GoogleCloudStorageFileSystem.validateObjectName(objectName, allowEmptyObjectName);
        if (Strings.isNullOrEmpty((String)objectName)) {
            return new StorageResourceId(bucketName);
        }
        return new StorageResourceId(bucketName, objectName);
    }

    @Override
    public URI getPath(String bucketName, String objectName, boolean allowEmptyObjectName) {
        if (allowEmptyObjectName && bucketName == null && objectName == null) {
            return GoogleCloudStorageFileSystem.GCS_ROOT;
        }
        bucketName = GoogleCloudStorageFileSystem.validateBucketName(bucketName);
        objectName = GoogleCloudStorageFileSystem.validateObjectName(objectName, allowEmptyObjectName);
        URI pathUri = null;
        String string = String.valueOf("gs://");
        String string2 = bucketName;
        String string3 = String.valueOf("/");
        String string4 = objectName;
        String path = new StringBuilder(0 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string).append(string2).append(string3).append(string4).toString();
        try {
            pathUri = new URI(path);
        }
        catch (URISyntaxException e) {
            String msg = String.format("Invalid bucket name (%s) or object name (%s)", bucketName, objectName);
            LOG.error(msg, (Throwable)e);
            throw new IllegalArgumentException(msg, e);
        }
        return pathUri;
    }
}

