/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;

public class GoogleCloudStorageExceptions {
    public static FileNotFoundException getFileNotFoundException(String bucketName, String objectName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucketName) ? 1 : 0) != 0, (Object)"bucketName must not be null or empty");
        if (objectName == null) {
            objectName = "";
        }
        return new FileNotFoundException(String.format("Item not found: %s/%s", bucketName, objectName));
    }

    public static IOException createCompositeException(List<IOException> innerExceptions) {
        Preconditions.checkArgument((innerExceptions != null ? 1 : 0) != 0, (Object)"innerExceptions must not be null");
        Preconditions.checkArgument((innerExceptions.size() > 0 ? 1 : 0) != 0, (Object)"innerExceptions must contain at least one element");
        if (innerExceptions.size() == 1) {
            return innerExceptions.get(0);
        }
        IOException combined = new IOException("Multiple IOExceptions.");
        for (IOException inner : innerExceptions) {
            combined.addSuppressed(inner);
        }
        return combined;
    }

    public static IOException wrapException(IOException e, String message, String bucketName, String objectName) {
        String name;
        String string = String.valueOf(bucketName);
        String string2 = name = string.length() != 0 ? "bucket: ".concat(string) : new String("bucket: ");
        if (!Strings.isNullOrEmpty((String)objectName)) {
            String string3 = String.valueOf(name);
            name = new StringBuilder(10 + String.valueOf(string3).length() + String.valueOf(objectName).length()).append(string3).append(", object: ").append(objectName).toString();
        }
        String fullMessage = String.format("%s: %s", message, name);
        return new IOException(fullMessage, e);
    }
}

