/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.CacheEntry;
import com.google.cloud.hadoop.gcsio.CreateBucketOptions;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.DirectoryListCache;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.UpdatableItemInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheSupplementedGoogleCloudStorage
implements GoogleCloudStorage {
    private static final Logger LOG = LoggerFactory.getLogger(CacheSupplementedGoogleCloudStorage.class);
    private final GoogleCloudStorage gcsDelegate;
    private DirectoryListCache resourceCache;

    public CacheSupplementedGoogleCloudStorage(GoogleCloudStorage gcsDelegate, DirectoryListCache resourceCache) {
        Preconditions.checkArgument((gcsDelegate != null ? 1 : 0) != 0, (Object)"gcsDelegate must not be null");
        Preconditions.checkArgument((resourceCache != null ? 1 : 0) != 0, (Object)"resourceCache must not be null");
        this.gcsDelegate = gcsDelegate;
        this.resourceCache = resourceCache;
    }

    @Override
    public GoogleCloudStorageOptions getOptions() {
        return this.gcsDelegate.getOptions();
    }

    @Override
    public WritableByteChannel create(StorageResourceId resourceId) throws IOException {
        LOG.debug("create({})", (Object)resourceId);
        return this.create(resourceId, CreateObjectOptions.DEFAULT);
    }

    @Override
    public WritableByteChannel create(final StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        LOG.debug("create({}, {})", (Object)resourceId, (Object)options);
        final WritableByteChannel innerChannel = this.gcsDelegate.create(resourceId, options);
        return new WritableByteChannel(){

            @Override
            public int write(ByteBuffer buffer) throws IOException {
                return innerChannel.write(buffer);
            }

            @Override
            public boolean isOpen() {
                return innerChannel.isOpen();
            }

            @Override
            public void close() throws IOException {
                innerChannel.close();
                CacheSupplementedGoogleCloudStorage.this.resourceCache.putResourceId(resourceId);
            }
        };
    }

    @Override
    public void createEmptyObject(StorageResourceId resourceId) throws IOException {
        LOG.debug("createEmptyObject({})", (Object)resourceId);
        this.gcsDelegate.createEmptyObject(resourceId);
        this.resourceCache.putResourceId(resourceId);
    }

    @Override
    public void createEmptyObject(StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        LOG.debug("createEmptyObject({}, {})", (Object)resourceId, (Object)options);
        this.gcsDelegate.createEmptyObject(resourceId, options);
        this.resourceCache.putResourceId(resourceId);
    }

    @Override
    public void createEmptyObjects(List<StorageResourceId> resourceIds) throws IOException {
        LOG.debug("createEmptyObjects({})", resourceIds);
        this.gcsDelegate.createEmptyObjects(resourceIds);
        for (StorageResourceId resourceId : resourceIds) {
            this.resourceCache.putResourceId(resourceId);
        }
    }

    @Override
    public void createEmptyObjects(List<StorageResourceId> resourceIds, CreateObjectOptions options) throws IOException {
        LOG.debug("createEmptyObjects({}, {})", resourceIds, (Object)options);
        this.gcsDelegate.createEmptyObjects(resourceIds, options);
        for (StorageResourceId resourceId : resourceIds) {
            this.resourceCache.putResourceId(resourceId);
        }
    }

    @Override
    public SeekableByteChannel open(StorageResourceId resourceId) throws IOException {
        LOG.debug("open({})", (Object)resourceId);
        return this.gcsDelegate.open(resourceId);
    }

    @Override
    public void create(String bucketName) throws IOException {
        LOG.debug("create({})", (Object)bucketName);
        this.gcsDelegate.create(bucketName);
        this.resourceCache.putResourceId(new StorageResourceId(bucketName));
    }

    @Override
    public void create(String bucketName, CreateBucketOptions options) throws IOException {
        LOG.debug("create({})", (Object)bucketName);
        this.gcsDelegate.create(bucketName, options);
        this.resourceCache.putResourceId(new StorageResourceId(bucketName));
    }

    @Override
    public void deleteBuckets(List<String> bucketNames) throws IOException {
        LOG.debug("deleteBuckets({})", bucketNames);
        this.gcsDelegate.deleteBuckets(bucketNames);
        for (String bucketName : bucketNames) {
            this.resourceCache.removeResourceId(new StorageResourceId(bucketName));
        }
    }

    @Override
    public void deleteObjects(List<StorageResourceId> fullObjectNames) throws IOException {
        LOG.debug("deleteObjects({})", fullObjectNames);
        this.gcsDelegate.deleteObjects(fullObjectNames);
        for (StorageResourceId resourceId : fullObjectNames) {
            this.resourceCache.removeResourceId(resourceId);
        }
    }

    @Override
    public void copy(String srcBucketName, List<String> srcObjectNames, String dstBucketName, List<String> dstObjectNames) throws IOException {
        this.gcsDelegate.copy(srcBucketName, srcObjectNames, dstBucketName, dstObjectNames);
        for (String dstObjectName : dstObjectNames) {
            this.resourceCache.putResourceId(new StorageResourceId(dstBucketName, dstObjectName));
        }
    }

    @Override
    public void compose(String bucketName, List<String> sources, String destination, String contentType) throws IOException {
        this.gcsDelegate.compose(bucketName, sources, destination, contentType);
        this.resourceCache.putResourceId(new StorageResourceId(bucketName, destination));
    }

    private List<CacheEntry> getSupplementalEntries(Set<StorageResourceId> originalIds, List<CacheEntry> candidateEntries) {
        ArrayList<CacheEntry> supplementalEntries = new ArrayList<CacheEntry>();
        for (CacheEntry entry : candidateEntries) {
            StorageResourceId entryId = entry.getResourceId();
            if (originalIds.contains(entryId)) continue;
            supplementalEntries.add(entry);
            originalIds.add(entryId);
        }
        return supplementalEntries;
    }

    private List<GoogleCloudStorageItemInfo> extractOrRevalidateItemInfos(List<CacheEntry> cacheEntries) throws IOException {
        ArrayList<GoogleCloudStorageItemInfo> supplementalInfos = new ArrayList<GoogleCloudStorageItemInfo>();
        for (CacheEntry entry : cacheEntries) {
            GoogleCloudStorageItemInfo itemInfo = entry.getItemInfo();
            if (itemInfo != null) {
                LOG.info("Supplementing missing itemInfo with already-cached info: {}", (Object)itemInfo);
                supplementalInfos.add(itemInfo);
                continue;
            }
            LOG.info("Populating missing itemInfo on-demand for entry: {}", (Object)entry.getResourceId());
            itemInfo = this.gcsDelegate.getItemInfo(entry.getResourceId());
            if (!itemInfo.exists()) {
                LOG.warn("Possible stale CacheEntry; failed to fetch item info for: {} - removing from cache", (Object)entry.getResourceId());
                this.resourceCache.removeResourceId(entry.getResourceId());
                continue;
            }
            entry.setItemInfo(itemInfo);
            supplementalInfos.add(itemInfo);
        }
        return supplementalInfos;
    }

    @Override
    public List<String> listBucketNames() throws IOException {
        LOG.debug("listBucketNames()");
        List<String> allBucketNames = this.gcsDelegate.listBucketNames();
        List<CacheEntry> cachedBuckets = this.resourceCache.getBucketList();
        if (cachedBuckets.isEmpty()) {
            return allBucketNames;
        }
        allBucketNames = new ArrayList<String>(allBucketNames);
        HashSet<StorageResourceId> bucketIds = new HashSet<StorageResourceId>();
        for (String bucketName : allBucketNames) {
            bucketIds.add(new StorageResourceId(bucketName));
        }
        List<CacheEntry> missingCachedBuckets = this.getSupplementalEntries(bucketIds, cachedBuckets);
        for (CacheEntry supplement : missingCachedBuckets) {
            LOG.info("Supplementing missing matched StorageResourceId: {}", (Object)supplement.getResourceId());
            allBucketNames.add(supplement.getResourceId().getBucketName());
        }
        return allBucketNames;
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listBucketInfo() throws IOException {
        LOG.debug("listBucketInfo()");
        List<GoogleCloudStorageItemInfo> allBucketInfos = this.gcsDelegate.listBucketInfo();
        List<CacheEntry> cachedBuckets = this.resourceCache.getBucketList();
        if (cachedBuckets.isEmpty()) {
            return allBucketInfos;
        }
        allBucketInfos = new ArrayList<GoogleCloudStorageItemInfo>(allBucketInfos);
        HashSet<StorageResourceId> bucketIdsSet = new HashSet<StorageResourceId>();
        for (GoogleCloudStorageItemInfo itemInfo : allBucketInfos) {
            bucketIdsSet.add(itemInfo.getResourceId());
        }
        List<CacheEntry> missingCachedBuckets = this.getSupplementalEntries(bucketIdsSet, cachedBuckets);
        List<GoogleCloudStorageItemInfo> supplementalInfos = this.extractOrRevalidateItemInfos(missingCachedBuckets);
        allBucketInfos.addAll(supplementalInfos);
        return allBucketInfos;
    }

    @Override
    public List<String> listObjectNames(String bucketName, String objectNamePrefix, String delimiter) throws IOException {
        return this.listObjectNames(bucketName, objectNamePrefix, delimiter, -1L);
    }

    @Override
    public List<String> listObjectNames(String bucketName, String objectNamePrefix, String delimiter, long maxResults) throws IOException {
        LOG.debug("listObjectNames({}, {}, {}, {})", new Object[]{bucketName, objectNamePrefix, delimiter, maxResults});
        List<String> allObjectNames = this.gcsDelegate.listObjectNames(bucketName, objectNamePrefix, delimiter, maxResults);
        if (maxResults > 0L && (long)allObjectNames.size() >= maxResults) {
            return allObjectNames;
        }
        List<CacheEntry> cachedObjects = this.resourceCache.getObjectList(bucketName, objectNamePrefix, delimiter, null);
        if (cachedObjects == null || cachedObjects.isEmpty()) {
            return allObjectNames;
        }
        allObjectNames = new ArrayList<String>(allObjectNames);
        HashSet<StorageResourceId> objectIds = new HashSet<StorageResourceId>();
        for (String objectName : allObjectNames) {
            objectIds.add(new StorageResourceId(bucketName, objectName));
        }
        List<CacheEntry> missingCachedObjects = this.getSupplementalEntries(objectIds, cachedObjects);
        List<GoogleCloudStorageItemInfo> supplementalInfos = this.extractOrRevalidateItemInfos(missingCachedObjects);
        for (GoogleCloudStorageItemInfo item : supplementalInfos) {
            LOG.info("Supplementing missing matched StorageResourceId: {}", (Object)item.getResourceId());
            allObjectNames.add(item.getResourceId().getObjectName());
            if (maxResults <= 0L || (long)allObjectNames.size() < maxResults) continue;
            break;
        }
        return allObjectNames;
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listObjectInfo(String bucketName, String objectNamePrefix, String delimiter) throws IOException {
        return this.listObjectInfo(bucketName, objectNamePrefix, delimiter, -1L);
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listObjectInfo(String bucketName, String objectNamePrefix, String delimiter, long maxResults) throws IOException {
        LOG.debug("listObjectInfo({}, {}, {}, {})", new Object[]{bucketName, objectNamePrefix, delimiter, maxResults});
        List<GoogleCloudStorageItemInfo> allObjectInfos = this.gcsDelegate.listObjectInfo(bucketName, objectNamePrefix, delimiter, maxResults);
        if (maxResults > 0L && (long)allObjectInfos.size() >= maxResults) {
            return allObjectInfos;
        }
        List<CacheEntry> cachedObjects = this.resourceCache.getObjectList(bucketName, objectNamePrefix, delimiter, null);
        if (cachedObjects == null || cachedObjects.isEmpty()) {
            return allObjectInfos;
        }
        allObjectInfos = new ArrayList<GoogleCloudStorageItemInfo>(allObjectInfos);
        HashSet<StorageResourceId> objectIdsSet = new HashSet<StorageResourceId>();
        for (GoogleCloudStorageItemInfo itemInfo : allObjectInfos) {
            objectIdsSet.add(itemInfo.getResourceId());
        }
        List<CacheEntry> missingCachedObjects = this.getSupplementalEntries(objectIdsSet, cachedObjects);
        List<GoogleCloudStorageItemInfo> supplementalInfos = this.extractOrRevalidateItemInfos(missingCachedObjects);
        if (maxResults <= 0L || (long)(allObjectInfos.size() + supplementalInfos.size()) <= maxResults) {
            allObjectInfos.addAll(supplementalInfos);
        } else {
            for (GoogleCloudStorageItemInfo item : supplementalInfos) {
                allObjectInfos.add(item);
                if ((long)allObjectInfos.size() < maxResults) continue;
                break;
            }
        }
        return allObjectInfos;
    }

    @Override
    public List<GoogleCloudStorageItemInfo> getItemInfos(List<StorageResourceId> resourceIds) throws IOException {
        LOG.debug("getItemInfos({})", (Object)resourceIds.toString());
        return this.gcsDelegate.getItemInfos(resourceIds);
    }

    @Override
    public List<GoogleCloudStorageItemInfo> updateItems(List<UpdatableItemInfo> itemInfoList) throws IOException {
        LOG.debug("updateItems({})", itemInfoList);
        return this.gcsDelegate.updateItems(itemInfoList);
    }

    @Override
    public GoogleCloudStorageItemInfo getItemInfo(StorageResourceId resourceId) throws IOException {
        LOG.debug("getItemInfo({})", (Object)resourceId);
        return this.gcsDelegate.getItemInfo(resourceId);
    }

    @Override
    public void close() {
        this.gcsDelegate.close();
    }

    @Override
    public void waitForBucketEmpty(String bucketName) throws IOException {
        this.gcsDelegate.waitForBucketEmpty(bucketName);
    }

    @VisibleForTesting
    DirectoryListCache getResourceCache() {
        return this.resourceCache;
    }
}

