/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.auth.oauth2;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class AccessToken
implements Serializable {
    private static final long serialVersionUID = -8514239465808977353L;
    private final String tokenValue;
    private final Long expirationTimeMillis;
    private final List<String> scopes;

    public AccessToken(String tokenValue, Date expirationTime) {
        this.tokenValue = tokenValue;
        this.expirationTimeMillis = expirationTime == null ? null : Long.valueOf(expirationTime.getTime());
        this.scopes = new ArrayList<String>();
    }

    private AccessToken(Builder builder) {
        this.tokenValue = builder.getTokenValue();
        Date expirationTime = builder.getExpirationTime();
        this.expirationTimeMillis = expirationTime == null ? null : Long.valueOf(expirationTime.getTime());
        this.scopes = builder.getScopes();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public String getTokenValue() {
        return this.tokenValue;
    }

    public Date getExpirationTime() {
        if (this.expirationTimeMillis == null) {
            return null;
        }
        return new Date(this.expirationTimeMillis);
    }

    Long getExpirationTimeMillis() {
        return this.expirationTimeMillis;
    }

    public int hashCode() {
        return Objects.hash(this.tokenValue, this.expirationTimeMillis, this.scopes);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("tokenValue", this.tokenValue).add("expirationTimeMillis", this.expirationTimeMillis).add("scopes", this.scopes).toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AccessToken)) {
            return false;
        }
        AccessToken other = (AccessToken)obj;
        return Objects.equals(this.tokenValue, other.tokenValue) && Objects.equals(this.expirationTimeMillis, other.expirationTimeMillis) && Objects.equals(this.scopes, other.scopes);
    }

    public static class Builder {
        private String tokenValue;
        private Date expirationTime;
        private List<String> scopes = new ArrayList<String>();

        protected Builder() {
        }

        protected Builder(AccessToken accessToken) {
            this.tokenValue = accessToken.getTokenValue();
            this.expirationTime = accessToken.getExpirationTime();
            this.scopes = accessToken.getScopes();
        }

        public String getTokenValue() {
            return this.tokenValue;
        }

        public List<String> getScopes() {
            return this.scopes;
        }

        public Date getExpirationTime() {
            return this.expirationTime;
        }

        @CanIgnoreReturnValue
        public Builder setTokenValue(String tokenValue) {
            this.tokenValue = tokenValue;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setScopes(String scopes) {
            if (scopes != null && scopes.trim().length() > 0) {
                this.scopes = Arrays.asList(scopes.split(" "));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setScopes(List<String> scopes) {
            this.scopes = scopes == null ? new ArrayList<String>() : scopes;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setExpirationTime(Date expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public AccessToken build() {
            return new AccessToken(this);
        }
    }
}

