/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.opencensus.contrib.resource.util;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.MoreObjects;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.io.opencensus.resource.Resource;
import java.util.LinkedHashMap;

public class ContainerResource {
    public static final String TYPE = "container";
    public static final String NAME_KEY = "container.name";
    public static final String IMAGE_NAME_KEY = "container.image.name";
    public static final String IMAGE_TAG_KEY = "container.image.tag";

    public static Resource create(String name, String imageName, String imageTag) {
        LinkedHashMap<String, String> labels = new LinkedHashMap<String, String>();
        labels.put(NAME_KEY, Preconditions.checkNotNull(name, "name"));
        labels.put(IMAGE_NAME_KEY, Preconditions.checkNotNull(imageName, "imageName"));
        labels.put(IMAGE_TAG_KEY, Preconditions.checkNotNull(imageTag, "imageTag"));
        return Resource.create(TYPE, labels);
    }

    static Resource detect() {
        return ContainerResource.create(MoreObjects.firstNonNull(System.getenv("CONTAINER_NAME"), ""), "", "");
    }

    private ContainerResource() {
    }
}

