/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.orca;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Context;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Contexts;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ExperimentalApi;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ForwardingServerCall;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Metadata;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ServerCall;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ServerCallHandler;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ServerInterceptor;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.protobuf.ProtoUtils;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.services.CallMetricRecorder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.services.InternalCallMetricRecorder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.services.MetricReport;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.shaded.com.github.xds.data.orca.v3.OrcaLoadReport;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/9127")
public final class OrcaMetricReportingServerInterceptor
implements ServerInterceptor {
    private static final OrcaMetricReportingServerInterceptor INSTANCE = new OrcaMetricReportingServerInterceptor();
    @VisibleForTesting
    static final Metadata.Key<OrcaLoadReport> ORCA_ENDPOINT_LOAD_METRICS_KEY = Metadata.Key.of("endpoint-load-metrics-bin", ProtoUtils.metadataMarshaller(OrcaLoadReport.getDefaultInstance()));

    @VisibleForTesting
    OrcaMetricReportingServerInterceptor() {
    }

    public static OrcaMetricReportingServerInterceptor getInstance() {
        return INSTANCE;
    }

    @Override
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        Context ctx = Context.current();
        CallMetricRecorder callMetricRecorder = InternalCallMetricRecorder.CONTEXT_KEY.get(ctx);
        if (callMetricRecorder == null) {
            callMetricRecorder = InternalCallMetricRecorder.newCallMetricRecorder();
            ctx = ctx.withValue(InternalCallMetricRecorder.CONTEXT_KEY, callMetricRecorder);
        }
        final CallMetricRecorder finalCallMetricRecorder = callMetricRecorder;
        ForwardingServerCall.SimpleForwardingServerCall trailerAttachingCall = new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

            @Override
            public void close(Status status, Metadata trailers) {
                OrcaLoadReport report = OrcaMetricReportingServerInterceptor.fromInternalReport(InternalCallMetricRecorder.finalizeAndDump2(finalCallMetricRecorder));
                if (!report.equals(OrcaLoadReport.getDefaultInstance())) {
                    trailers.put(ORCA_ENDPOINT_LOAD_METRICS_KEY, report);
                }
                super.close(status, trailers);
            }
        };
        return Contexts.interceptCall(ctx, trailerAttachingCall, headers, next);
    }

    private static OrcaLoadReport fromInternalReport(MetricReport internalReport) {
        return OrcaLoadReport.newBuilder().setCpuUtilization(internalReport.getCpuUtilization()).setMemUtilization(internalReport.getMemoryUtilization()).putAllUtilization(internalReport.getUtilizationMetrics()).putAllRequestCost(internalReport.getRequestCostMetrics()).build();
    }
}

