/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.RestorableState;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Blob;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BlobId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BlobInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Conversions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.CopyWriter;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.HttpStorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Retrying;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Storage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.spi.v1.StorageRpc;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class HttpCopyWriter
extends CopyWriter {
    private final HttpStorageOptions serviceOptions;
    private final StorageRpc storageRpc;
    private StorageRpc.RewriteResponse rewriteResponse;

    HttpCopyWriter(HttpStorageOptions serviceOptions, StorageRpc.RewriteResponse rewriteResponse) {
        this.serviceOptions = serviceOptions;
        this.rewriteResponse = rewriteResponse;
        this.storageRpc = serviceOptions.getStorageRpcV1();
    }

    @Override
    public Blob getResult() {
        while (!this.isDone()) {
            this.copyChunk();
        }
        BlobInfo info = (BlobInfo)Conversions.apiary().blobInfo().decode(this.rewriteResponse.result);
        return info.asBlob((Storage)this.serviceOptions.getService());
    }

    @Override
    public long getBlobSize() {
        return this.rewriteResponse.blobSize;
    }

    @Override
    public boolean isDone() {
        return this.rewriteResponse.isDone;
    }

    @Override
    public long getTotalBytesCopied() {
        return this.rewriteResponse.totalBytesRewritten;
    }

    @Override
    public void copyChunk() {
        if (!this.isDone()) {
            StorageRpc.RewriteRequest rewriteRequest = this.rewriteResponse.rewriteRequest;
            this.rewriteResponse = (StorageRpc.RewriteResponse)Retrying.run(this.serviceOptions, this.serviceOptions.getRetryAlgorithmManager().getForObjectsRewrite(rewriteRequest), () -> this.storageRpc.continueRewrite(this.rewriteResponse), Function.identity());
        }
    }

    @Override
    public RestorableState<CopyWriter> capture() {
        return StateImpl.newBuilder(this.serviceOptions, (BlobId)Conversions.apiary().blobId().decode(this.rewriteResponse.rewriteRequest.source), this.rewriteResponse.rewriteRequest.sourceOptions, this.rewriteResponse.rewriteRequest.overrideInfo, (BlobInfo)Conversions.apiary().blobInfo().decode(this.rewriteResponse.rewriteRequest.target), this.rewriteResponse.rewriteRequest.targetOptions).setResult(this.rewriteResponse.result != null ? (BlobInfo)Conversions.apiary().blobInfo().decode(this.rewriteResponse.result) : null).setBlobSize(this.getBlobSize()).setIsDone(this.isDone()).setMegabytesCopiedPerChunk(this.rewriteResponse.rewriteRequest.megabytesRewrittenPerCall).setRewriteToken(this.rewriteResponse.rewriteToken).setTotalBytesRewritten(this.getTotalBytesCopied()).build();
    }

    static class StateImpl
    implements RestorableState<CopyWriter>,
    Serializable {
        private static final long serialVersionUID = 1843004265650868946L;
        private final HttpStorageOptions serviceOptions;
        private final BlobId source;
        private final Map<StorageRpc.Option, ?> sourceOptions;
        private final boolean overrideInfo;
        private final BlobInfo target;
        private final Map<StorageRpc.Option, ?> targetOptions;
        private final BlobInfo result;
        private final long blobSize;
        private final boolean isDone;
        private final String rewriteToken;
        private final long totalBytesCopied;
        private final Long megabytesCopiedPerChunk;

        StateImpl(Builder builder) {
            this.serviceOptions = builder.serviceOptions;
            this.source = builder.source;
            this.sourceOptions = builder.sourceOptions;
            this.overrideInfo = builder.overrideInfo;
            this.target = builder.target;
            this.targetOptions = builder.targetOptions;
            this.result = builder.result;
            this.blobSize = builder.blobSize;
            this.isDone = builder.isDone;
            this.rewriteToken = builder.rewriteToken;
            this.totalBytesCopied = builder.totalBytesCopied;
            this.megabytesCopiedPerChunk = builder.megabytesCopiedPerChunk;
        }

        static Builder newBuilder(HttpStorageOptions options, BlobId source, Map<StorageRpc.Option, ?> sourceOptions, boolean overrideInfo, BlobInfo target, Map<StorageRpc.Option, ?> targetOptions) {
            return new Builder(options, source, sourceOptions, overrideInfo, target, targetOptions);
        }

        @Override
        public CopyWriter restore() {
            StorageRpc.RewriteRequest rewriteRequest = new StorageRpc.RewriteRequest((StorageObject)Conversions.apiary().blobId().encode(this.source), this.sourceOptions, this.overrideInfo, (StorageObject)Conversions.apiary().blobInfo().encode(this.target), this.targetOptions, this.megabytesCopiedPerChunk);
            StorageRpc.RewriteResponse rewriteResponse = new StorageRpc.RewriteResponse(rewriteRequest, this.result != null ? (StorageObject)Conversions.apiary().blobInfo().encode(this.result) : null, this.blobSize, this.isDone, this.rewriteToken, this.totalBytesCopied);
            return new HttpCopyWriter(this.serviceOptions, rewriteResponse);
        }

        public int hashCode() {
            return Objects.hash(this.serviceOptions, this.source, this.sourceOptions, this.overrideInfo, this.target, this.targetOptions, this.result, this.blobSize, this.isDone, this.megabytesCopiedPerChunk, this.rewriteToken, this.totalBytesCopied);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof StateImpl)) {
                return false;
            }
            StateImpl other = (StateImpl)obj;
            return Objects.equals(this.serviceOptions, other.serviceOptions) && Objects.equals(this.source, other.source) && Objects.equals(this.sourceOptions, other.sourceOptions) && Objects.equals(this.overrideInfo, other.overrideInfo) && Objects.equals(this.target, other.target) && Objects.equals(this.targetOptions, other.targetOptions) && Objects.equals(this.result, other.result) && Objects.equals(this.rewriteToken, other.rewriteToken) && Objects.equals(this.megabytesCopiedPerChunk, other.megabytesCopiedPerChunk) && this.blobSize == other.blobSize && this.isDone == other.isDone && this.totalBytesCopied == other.totalBytesCopied;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("source", this.source).add("overrideInfo", this.overrideInfo).add("target", this.target).add("result", this.result).add("blobSize", this.blobSize).add("isDone", this.isDone).add("rewriteToken", this.rewriteToken).add("totalBytesCopied", this.totalBytesCopied).add("megabytesCopiedPerChunk", this.megabytesCopiedPerChunk).toString();
        }

        static class Builder {
            private final HttpStorageOptions serviceOptions;
            private final BlobId source;
            private final Map<StorageRpc.Option, ?> sourceOptions;
            private final boolean overrideInfo;
            private final BlobInfo target;
            private final Map<StorageRpc.Option, ?> targetOptions;
            private BlobInfo result;
            private long blobSize;
            private boolean isDone;
            private String rewriteToken;
            private long totalBytesCopied;
            private Long megabytesCopiedPerChunk;

            private Builder(HttpStorageOptions options, BlobId source, Map<StorageRpc.Option, ?> sourceOptions, boolean overrideInfo, BlobInfo target, Map<StorageRpc.Option, ?> targetOptions) {
                this.serviceOptions = options;
                this.source = source;
                this.sourceOptions = sourceOptions;
                this.overrideInfo = overrideInfo;
                this.target = target;
                this.targetOptions = targetOptions;
            }

            Builder setResult(BlobInfo result) {
                this.result = result;
                return this;
            }

            Builder setBlobSize(long blobSize) {
                this.blobSize = blobSize;
                return this;
            }

            Builder setIsDone(boolean isDone) {
                this.isDone = isDone;
                return this;
            }

            Builder setRewriteToken(String rewriteToken) {
                this.rewriteToken = rewriteToken;
                return this;
            }

            Builder setTotalBytesRewritten(long totalBytesRewritten) {
                this.totalBytesCopied = totalBytesRewritten;
                return this;
            }

            Builder setMegabytesCopiedPerChunk(Long megabytesCopiedPerChunk) {
                this.megabytesCopiedPerChunk = megabytesCopiedPerChunk;
                return this;
            }

            RestorableState<CopyWriter> build() {
                return new StateImpl(this);
            }
        }
    }
}

