/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.core.ApiFuture;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.RestorableState;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.WriteChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BufferHandle;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BufferedWritableByteChannelSession;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Buffers;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ByteStringStrategy;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.GrpcStorageImpl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Hasher;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ResumableMedia;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ResumableWrite;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Retrying;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Suppliers;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.WriteObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.WriteObjectResponse;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Supplier;

final class GrpcBlobWriteChannel
implements WriteChannel {
    private final LazyWriteChannel lazyWriteChannel = new LazyWriteChannel(Suppliers.memoize(() -> ResumableMedia.gapic().write().byteChannel(write).setHasher(hasher).setByteStringStrategy(ByteStringStrategy.copy()).resumable().withRetryConfig(deps, alg).buffered(BufferHandle.allocate(Buffers.alignSize(this.chunkSize, 262144))).setStartAsync((ApiFuture)start.get()).build()));
    private int chunkSize = 0x1000000;
    private boolean writeCalledAtLeastOnce = false;

    GrpcBlobWriteChannel(ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write, Retrying.RetryingDependencies deps, ResultRetryAlgorithm<?> alg, Supplier<ApiFuture<ResumableWrite>> start, Hasher hasher) {
    }

    @Override
    public void setChunkSize(int chunkSize) {
        Preconditions.checkState(!this.lazyWriteChannel.isOpened(), "Unable to change chunkSize after write");
        this.chunkSize = chunkSize;
    }

    @Override
    public RestorableState<WriteChannel> capture() {
        return (RestorableState)GrpcStorageImpl.throwHttpJsonOnly(WriteChannel.class, "capture");
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        this.writeCalledAtLeastOnce = true;
        return this.lazyWriteChannel.getChannel().write(src);
    }

    @Override
    public boolean isOpen() {
        return this.lazyWriteChannel.isOpened() && this.lazyWriteChannel.getChannel().isOpen();
    }

    @Override
    public void close() throws IOException {
        if (!this.writeCalledAtLeastOnce) {
            this.lazyWriteChannel.getChannel().write(ByteBuffer.allocate(0));
        }
        if (this.isOpen()) {
            this.lazyWriteChannel.getChannel().close();
        }
    }

    ApiFuture<WriteObjectResponse> getResults() {
        return ((BufferedWritableByteChannelSession)this.lazyWriteChannel.session.get()).getResult();
    }

    private static final class LazyWriteChannel {
        private final Supplier<BufferedWritableByteChannelSession<WriteObjectResponse>> session;
        private final Supplier<BufferedWritableByteChannelSession.BufferedWritableByteChannel> channel;
        private boolean opened = false;

        public LazyWriteChannel(Supplier<BufferedWritableByteChannelSession<WriteObjectResponse>> session) {
            this.session = session;
            this.channel = Suppliers.memoize(() -> {
                this.opened = true;
                return (BufferedWritableByteChannelSession.BufferedWritableByteChannel)((BufferedWritableByteChannelSession)session.get()).open();
            });
        }

        public BufferedWritableByteChannelSession.BufferedWritableByteChannel getChannel() {
            return this.channel.get();
        }

        public boolean isOpened() {
            return this.opened;
        }
    }
}

