/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.ReadChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.RestorableState;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BaseStorageReadChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.BufferHandle;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ByteRangeSpec;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Conversions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.GapicDownloadSessionBuilder;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.GrpcStorageImpl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.Hasher;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.LazyReadChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ReadableByteChannelSession;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.storage.ResumableMedia;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ReadObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.ReadObjectResponse;
import org.checkerframework.checker.nullness.qual.NonNull;

final class GrpcBlobReadChannel
extends BaseStorageReadChannel<com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.Object> {
    private final ServerStreamingCallable<ReadObjectRequest, ReadObjectResponse> read;
    private final ReadObjectRequest request;
    private final boolean autoGzipDecompression;

    GrpcBlobReadChannel(ServerStreamingCallable<ReadObjectRequest, ReadObjectResponse> read, ReadObjectRequest request, boolean autoGzipDecompression) {
        super(Conversions.grpc().blobInfo());
        this.read = read;
        this.request = request;
        this.autoGzipDecompression = autoGzipDecompression;
    }

    @Override
    public RestorableState<ReadChannel> capture() {
        return (RestorableState)GrpcStorageImpl.throwHttpJsonOnly(ReadChannel.class, "capture");
    }

    @Override
    protected LazyReadChannel<?, com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.Object> newLazyReadChannel() {
        return new LazyReadChannel(() -> {
            GapicDownloadSessionBuilder.ReadableByteChannelSessionBuilder b = ResumableMedia.gapic().read().byteChannel(this.read).setHasher(Hasher.noop()).setAutoGzipDecompression(this.autoGzipDecompression);
            BufferHandle bufferHandle = this.getBufferHandle();
            ReadableByteChannelSession session = bufferHandle.capacity() > 0 ? b.buffered(this.getBufferHandle()).setReadObjectRequest(this.getReadObjectRequest()).build() : b.unbuffered().setReadObjectRequest(this.getReadObjectRequest()).build();
            return session;
        });
    }

    private @NonNull ReadObjectRequest getReadObjectRequest() {
        com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.Object resolvedObject;
        ByteRangeSpec rangeSpec = this.getByteRangeSpec();
        ReadObjectRequest.Builder b = this.request.toBuilder();
        if (this.request.getGeneration() == 0L && (resolvedObject = (com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.Object)this.getResolvedObject()) != null) {
            b.setGeneration(resolvedObject.getGeneration());
        }
        return rangeSpec.seekReadObjectRequest(b).build();
    }
}

