/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.auth.oauth2.Credential;
import com.google.cloud.hadoop.repackaged.gcs.com.google.auth.Credentials;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.CredentialAdapter;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableSet;
import com.google.cloud.hadoop.repackaged.gcs.com.google.storage.v2.StorageGrpc;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Grpc;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ManagedChannel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ManagedChannelBuilder;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Metadata;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.GoogleDefaultChannelCredentials;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.auth.MoreCallCredentials;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.stub.AbstractStub;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.stub.MetadataUtils;
import java.util.Map;
import java.util.concurrent.ExecutorService;

class StorageStubProvider {
    static final Metadata.Key<String> GOOG_REQUEST_PARAMS = Metadata.Key.of("x-goog-request-params", Metadata.ASCII_STRING_MARSHALLER);
    private static final double GRPC_MAX_RETRY_ATTEMPTS = 10.0;
    private static final ImmutableSet<Status.Code> STUB_BROKEN_ERROR_CODES = ImmutableSet.of(Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE);
    private final GoogleCloudStorageOptions options;
    private final String userAgent;
    private final ExecutorService backgroundTasksThreadPool;
    private final GrpcDecorator grpcDecorator;
    private ManagedChannel channel;

    @VisibleForTesting
    GrpcDecorator getGrpcDecorator() {
        return this.grpcDecorator;
    }

    StorageStubProvider(GoogleCloudStorageOptions options, ExecutorService backgroundTasksThreadPool, GrpcDecorator grpcDecorator) {
        this.options = options;
        this.userAgent = options.getAppName();
        this.backgroundTasksThreadPool = backgroundTasksThreadPool;
        this.grpcDecorator = Preconditions.checkNotNull(grpcDecorator, "grpcDecorator cannot be null");
    }

    private ManagedChannel buildManagedChannel() {
        String target = this.options.getGrpcServerAddress();
        ManagedChannel channel = ((ManagedChannelBuilder)((ManagedChannelBuilder)this.grpcDecorator.createChannelBuilder(target).enableRetry()).userAgent(this.userAgent)).build();
        return channel;
    }

    public static boolean isStubBroken(Status.Code statusCode) {
        return STUB_BROKEN_ERROR_CODES.contains((Object)statusCode);
    }

    public final StorageGrpc.StorageBlockingStub newBlockingStub(String bucketName) {
        return (StorageGrpc.StorageBlockingStub)this.newBlockingStubInternal().withInterceptors(MetadataUtils.newAttachHeadersInterceptor(StorageStubProvider.getRequestHeaderMetadata(bucketName)));
    }

    public final StorageGrpc.StorageStub newAsyncStub(String bucketName) {
        return (StorageGrpc.StorageStub)this.newAsyncStubInternal().withInterceptors(MetadataUtils.newAttachHeadersInterceptor(StorageStubProvider.getRequestHeaderMetadata(bucketName)));
    }

    protected StorageGrpc.StorageBlockingStub newBlockingStubInternal() {
        StorageGrpc.StorageBlockingStub stub = StorageGrpc.newBlockingStub(this.getManagedChannel());
        return (StorageGrpc.StorageBlockingStub)this.grpcDecorator.applyCallOption(stub);
    }

    protected StorageGrpc.StorageStub newAsyncStubInternal() {
        StorageGrpc.StorageStub stub = (StorageGrpc.StorageStub)StorageGrpc.newStub(this.getManagedChannel()).withExecutor(this.backgroundTasksThreadPool);
        return (StorageGrpc.StorageStub)this.grpcDecorator.applyCallOption(stub);
    }

    private static Metadata getRequestHeaderMetadata(String bucketName) {
        Metadata metadata = new Metadata();
        metadata.put(GOOG_REQUEST_PARAMS, String.format("bucket=%s", bucketName));
        return metadata;
    }

    private synchronized ManagedChannel getManagedChannel() {
        if (this.channel == null) {
            this.channel = this.buildManagedChannel();
        }
        return this.channel;
    }

    public void shutdown() {
        if (this.channel != null) {
            this.channel.shutdown();
        }
    }

    public static StorageStubProvider newInstance(GoogleCloudStorageOptions options, ExecutorService backgroundTasksThreadPool, Credential credential) {
        CredentialAdapter credentials = new CredentialAdapter(credential);
        GrpcDecorator decorator = options.isTrafficDirectorEnabled() ? new TrafficDirectorGrpcDecorator(credentials) : (options.isDirectPathPreferred() ? new DirectPathGrpcDecorator(credentials) : new CloudPathGrpcDecorator(credentials));
        return new StorageStubProvider(options, backgroundTasksThreadPool, decorator);
    }

    public static StorageStubProvider newInstance(GoogleCloudStorageOptions options, ExecutorService backgroundTasksThreadPool, Credentials credentials) {
        GrpcDecorator decorator = options.isTrafficDirectorEnabled() ? new TrafficDirectorGrpcDecorator(credentials) : (options.isDirectPathPreferred() ? new DirectPathGrpcDecorator(credentials) : new CloudPathGrpcDecorator(credentials));
        return new StorageStubProvider(options, backgroundTasksThreadPool, decorator);
    }

    static class TrafficDirectorGrpcDecorator
    implements GrpcDecorator {
        private final Credentials credentials;

        TrafficDirectorGrpcDecorator(Credentials credentials) {
            this.credentials = credentials;
        }

        @Override
        public ManagedChannelBuilder<?> createChannelBuilder(String target) {
            GoogleDefaultChannelCredentials.Builder credentialsBuilder = GoogleDefaultChannelCredentials.newBuilder();
            if (credentialsBuilder != null) {
                credentialsBuilder.callCredentials(MoreCallCredentials.from(this.credentials));
            }
            return Grpc.newChannelBuilder("google-c2p-experimental:///" + target, credentialsBuilder.build());
        }

        @Override
        public AbstractStub<?> applyCallOption(AbstractStub<?> stub) {
            return stub;
        }
    }

    static class DirectPathGrpcDecorator
    implements GrpcDecorator {
        private final Credentials credentials;

        DirectPathGrpcDecorator(Credentials credentials) {
            this.credentials = credentials;
        }

        @Override
        public ManagedChannelBuilder<?> createChannelBuilder(String target) {
            GoogleDefaultChannelCredentials.Builder credentialsBuilder = GoogleDefaultChannelCredentials.newBuilder();
            if (this.credentials != null) {
                credentialsBuilder.callCredentials(MoreCallCredentials.from(this.credentials));
            }
            return Grpc.newChannelBuilder(target, credentialsBuilder.build()).defaultServiceConfig(this.getGrpcServiceConfig());
        }

        @Override
        public AbstractStub<?> applyCallOption(AbstractStub<?> stub) {
            return stub;
        }

        private Map<String, Object> getGrpcServiceConfig() {
            ImmutableMap childLbStrategy = ImmutableMap.of("round_robin", ImmutableMap.of());
            ImmutableMap childPolicy = ImmutableMap.of("childPolicy", ImmutableList.of(childLbStrategy));
            ImmutableMap grpcLbPolicy = ImmutableMap.of("grpclb", childPolicy);
            return ImmutableMap.of("loadBalancingConfig", ImmutableList.of(grpcLbPolicy));
        }
    }

    static class CloudPathGrpcDecorator
    implements GrpcDecorator {
        private final Credentials credentials;

        CloudPathGrpcDecorator(Credentials credentials) {
            this.credentials = credentials;
        }

        @Override
        public ManagedChannelBuilder<?> createChannelBuilder(String target) {
            return ManagedChannelBuilder.forTarget(target);
        }

        @Override
        public AbstractStub<?> applyCallOption(AbstractStub<?> stub) {
            return stub.withCallCredentials(MoreCallCredentials.from(this.credentials));
        }
    }

    static interface GrpcDecorator {
        public ManagedChannelBuilder<?> createChannelBuilder(String var1);

        public AbstractStub<?> applyCallOption(AbstractStub<?> var1);
    }
}

