/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpHeaders;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Stopwatch;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableSet;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.MapMaker;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.LazyArgs;
import com.google.cloud.hadoop.repackaged.gcs.com.google.gson.Gson;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

@VisibleForTesting
public class EventLoggingHttpRequestInitializer
implements HttpRequestInitializer {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final Gson gson = new Gson();
    private static final ImmutableSet<String> REDACTED_REQUEST_HEADERS = Stream.of("Authorization", "Cookie", "Proxy-Authorization").map(header -> header.toLowerCase(Locale.US)).collect(ImmutableSet.toImmutableSet());
    private static final ImmutableSet<String> REDACTED_RESPONSE_HEADERS = ImmutableSet.of("Set-Cookie".toLowerCase(Locale.US));
    private final ConcurrentMap<HttpRequest, HttpRequestResponseTimeTracker> requestTracker = new MapMaker().weakKeys().makeMap();

    @Override
    public void initialize(HttpRequest request) throws IOException {
        request.setInterceptor(httpRequest -> this.requestTracker.put(httpRequest, new HttpRequestResponseTimeTracker()));
        request.setResponseInterceptor(this::logAndRemoveRequestFromTracking);
    }

    @VisibleForTesting
    void logAndRemoveRequestFromTracking(HttpResponse httpResponse) {
        HttpRequest request = httpResponse.getRequest();
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("request_method", request.getRequestMethod());
        jsonMap.put("request_url", request.getUrl().toString());
        jsonMap.put("request_headers", EventLoggingHttpRequestInitializer.filterMap(request.getHeaders(), REDACTED_REQUEST_HEADERS));
        jsonMap.put("response_headers", EventLoggingHttpRequestInitializer.filterMap(httpResponse.getHeaders(), REDACTED_RESPONSE_HEADERS));
        jsonMap.put("response_status_code", httpResponse.getStatusCode());
        jsonMap.put("response_status_message", httpResponse.getStatusMessage());
        jsonMap.put("thread_name", Thread.currentThread().getName());
        HttpRequestResponseTimeTracker tracker = (HttpRequestResponseTimeTracker)this.requestTracker.remove(request);
        if (tracker != null) {
            jsonMap.put("response_time", tracker.getResponseTime());
            jsonMap.put("request_start_time_utc", tracker.getStartTimeUtc());
            jsonMap.put("request_finish_time_utc", tracker.getCurrentTimeUtc());
        } else {
            jsonMap.put("response_time", Integer.MAX_VALUE);
            jsonMap.put("unexpected_error", "Unknown request. This is unexpected.");
        }
        this.logDetails(jsonMap);
    }

    private void logDetails(Map<String, Object> jsonMap) {
        ((GoogleLogger.Api)logger.atInfo()).log("%s", LazyArgs.lazy(() -> this.gson.toJson(jsonMap)));
    }

    private static ImmutableMap<String, Object> filterMap(HttpHeaders httpHeaders, Set<String> filterSet) {
        return httpHeaders.entrySet().stream().filter(e -> !filterSet.contains(((String)e.getKey()).toLowerCase(Locale.US))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static class HttpRequestResponseTimeTracker {
        private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").withZone(ZoneOffset.UTC);
        private final Stopwatch stopwatch = Stopwatch.createStarted();
        private final Instant startTime = Instant.now();

        private HttpRequestResponseTimeTracker() {
        }

        long getResponseTime() {
            return this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
        }

        String getStartTimeUtc() {
            return dateTimeFormatter.format(this.startTime);
        }

        String getCurrentTimeUtc() {
            return dateTimeFormatter.format(Instant.now());
        }
    }
}

