/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs.contract;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemConfiguration;
import com.google.cloud.hadoop.gcsio.integration.GoogleCloudStorageTestHelper;
import com.google.cloud.hadoop.gcsio.testing.TestConfiguration;
import com.google.cloud.hadoop.util.HadoopCredentialConfiguration;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractBondedFSContract;

public class GoogleContract
extends AbstractBondedFSContract {
    public static final String TEST_BUCKET_NAME_PREFIX = "ghfs-contract-test";
    private static final String CONTRACT_XML = "contract/gs.xml";

    public GoogleContract(Configuration conf, GoogleCloudStorageTestHelper.TestBucketHelper bucketHelper) {
        super(conf);
        this.addConfResource(CONTRACT_XML);
        conf.set("fs.contract.test.fs.gs", "gs://" + bucketHelper.getUniqueBucketPrefix());
        TestConfiguration testConf = TestConfiguration.getInstance();
        if (testConf.getProjectId() != null) {
            conf.set(GoogleHadoopFileSystemConfiguration.GCS_PROJECT_ID.getKey(), testConf.getProjectId());
        }
        if (testConf.getServiceAccount() != null && testConf.getPrivateKeyFile() != null) {
            conf.setBoolean("fs.gs" + HadoopCredentialConfiguration.ENABLE_SERVICE_ACCOUNTS_SUFFIX.getKey(), true);
            conf.set("fs.gs" + HadoopCredentialConfiguration.SERVICE_ACCOUNT_EMAIL_SUFFIX.getKey(), testConf.getServiceAccount());
            conf.set("fs.gs" + HadoopCredentialConfiguration.SERVICE_ACCOUNT_KEYFILE_SUFFIX.getKey(), testConf.getPrivateKeyFile());
        }
    }

    public void init() throws IOException {
        super.init();
        FileSystem testFs = this.getTestFileSystem();
        testFs.mkdirs(new Path(testFs.getUri()));
    }

    public String getScheme() {
        return "gs";
    }
}

