/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs.auth;

import com.google.cloud.hadoop.fs.gcs.auth.AbstractDelegationTokenBinding;
import com.google.cloud.hadoop.fs.gcs.auth.TestTokenIdentifierImpl;
import com.google.cloud.hadoop.util.AccessTokenProvider;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;

public class TestDelegationTokenBindingImpl
extends AbstractDelegationTokenBinding {
    public TestDelegationTokenBindingImpl() {
        super(TestTokenIdentifierImpl.KIND);
    }

    public AccessTokenProvider deployUnbonded() throws IOException {
        return new TestAccessTokenProviderImpl();
    }

    public AccessTokenProvider bindToTokenIdentifier(DelegationTokenIdentifier retrievedIdentifier) throws IOException {
        return this.deployUnbonded();
    }

    public DelegationTokenIdentifier createTokenIdentifier(Text renewer) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        String user = ugi.getUserName();
        Text owner = new Text(user);
        Text realUser = null;
        if (ugi.getRealUser() != null) {
            realUser = new Text(ugi.getRealUser().getUserName());
        }
        return new TestTokenIdentifierImpl(owner, renewer, realUser, this.getService());
    }

    public DelegationTokenIdentifier createTokenIdentifier() throws IOException {
        return this.createEmptyIdentifier();
    }

    public DelegationTokenIdentifier createEmptyIdentifier() {
        return new TestTokenIdentifierImpl();
    }

    public static class TestAccessTokenProviderImpl
    implements AccessTokenProvider {
        public static final String TOKEN_CONFIG_PROPERTY_NAME = "test.token.value";
        private Configuration config = null;

        public AccessTokenProvider.AccessToken getAccessToken() {
            return new AccessTokenProvider.AccessToken(this.config.get(TOKEN_CONFIG_PROPERTY_NAME), Long.valueOf(System.currentTimeMillis() + 60000L));
        }

        public void refresh() throws IOException {
        }

        public void setConf(Configuration configuration) {
            this.config = configuration;
        }

        public Configuration getConf() {
            return this.config;
        }
    }
}

