/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemConfiguration;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemTestHelper;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopSyncableOutputStream;
import com.google.cloud.hadoop.fs.gcs.SyncableOutputStreamOptions;
import com.google.cloud.hadoop.gcsio.CreateFileOptions;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.Futures;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.time.Duration;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class GoogleHadoopSyncableOutputStreamTest {
    @Mock
    private ExecutorService mockExecutorService;
    private GoogleHadoopFileSystemBase ghfs;

    @Before
    public void setUp() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        this.ghfs = GoogleHadoopFileSystemTestHelper.createInMemoryGoogleHadoopFileSystem();
        this.ghfs.getConf().setEnum(GoogleHadoopFileSystemConfiguration.GCS_OUTPUT_STREAM_TYPE.getKey(), (Enum)GoogleHadoopFileSystemBase.OutputStreamType.SYNCABLE_COMPOSITE);
    }

    @After
    public void tearDown() throws IOException {
        this.ghfs.close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockExecutorService});
    }

    @Test
    public void testEndToEndHsync() throws Exception {
        Path objectPath = new Path(this.ghfs.getFileSystemRoot(), "dir/object.txt");
        FSDataOutputStream fout = this.ghfs.create(objectPath);
        byte[] data1 = new byte[]{15, 14, 14, 13};
        byte[] data2 = new byte[]{11, 14, 14, 15};
        byte[] data3 = new byte[]{4, 2};
        byte[] data1Read = new byte[4];
        byte[] data2Read = new byte[4];
        byte[] data3Read = new byte[2];
        fout.write(data1, 0, data1.length);
        fout.hsync();
        Truth.assertThat((Long)this.ghfs.getFileStatus(objectPath).getLen()).isEqualTo((Object)4);
        FSDataInputStream fin = this.ghfs.open(objectPath);
        fin.read(data1Read);
        fin.close();
        Truth.assertThat((byte[])data1Read).isEqualTo((Object)data1);
        fout.write(data2, 0, data2.length);
        fout.hsync();
        Truth.assertThat((Long)this.ghfs.getFileStatus(objectPath).getLen()).isEqualTo((Object)8);
        fin = this.ghfs.open(objectPath);
        fin.read(data1Read);
        fin.read(data2Read);
        fin.close();
        Truth.assertThat((byte[])data1Read).isEqualTo((Object)data1);
        Truth.assertThat((byte[])data2Read).isEqualTo((Object)data2);
        fout.write(data3, 0, data3.length);
        fout.close();
        Truth.assertThat((Long)this.ghfs.getFileStatus(objectPath).getLen()).isEqualTo((Object)10);
        fin = this.ghfs.open(objectPath);
        fin.read(data1Read);
        fin.read(data2Read);
        fin.read(data3Read);
        fin.close();
        Truth.assertThat((byte[])data1Read).isEqualTo((Object)data1);
        Truth.assertThat((byte[])data2Read).isEqualTo((Object)data2);
        Truth.assertThat((byte[])data3Read).isEqualTo((Object)data3);
    }

    @Test
    public void testExceptionOnDelete() throws IOException {
        Path objectPath = new Path(this.ghfs.getFileSystemRoot(), "dir/object2.txt");
        GoogleHadoopSyncableOutputStream fout = new GoogleHadoopSyncableOutputStream(this.ghfs, this.ghfs.getGcsPath(objectPath), new FileSystem.Statistics(this.ghfs.getScheme()), CreateFileOptions.DEFAULT_OVERWRITE, SyncableOutputStreamOptions.DEFAULT, this.mockExecutorService);
        IOException fakeIoException = new IOException("fake io exception");
        Mockito.when(this.mockExecutorService.submit((Callable)ArgumentMatchers.any(Callable.class))).thenReturn((Object)Futures.immediateFailedFuture((Throwable)new ExecutionException(fakeIoException)));
        byte[] data1 = new byte[]{15, 14, 14, 13};
        byte[] data2 = new byte[]{11, 14, 14, 15};
        fout.write(data1, 0, data1.length);
        fout.sync();
        fout.write(data2, 0, data2.length);
        fout.sync();
        ((ExecutorService)Mockito.verify((Object)this.mockExecutorService)).submit((Callable)ArgumentMatchers.any(Callable.class));
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> ((GoogleHadoopSyncableOutputStream)fout).close());
        Truth.assertThat((Throwable)thrown).hasCauseThat().hasMessageThat().contains((CharSequence)fakeIoException.getMessage());
        ((ExecutorService)Mockito.verify((Object)this.mockExecutorService, (VerificationMode)Mockito.times((int)2))).submit((Callable)ArgumentMatchers.any(Callable.class));
    }

    @Test
    public void testCloseTwice() throws IOException {
        Path objectPath = new Path(this.ghfs.getFileSystemRoot(), "dir/object.txt");
        FSDataOutputStream fout = this.ghfs.create(objectPath);
        fout.close();
        fout.close();
    }

    @Test
    public void testWrite1AfterClose() throws IOException {
        Path objectPath = new Path(this.ghfs.getFileSystemRoot(), "dir/object.txt");
        FSDataOutputStream fout = this.ghfs.create(objectPath);
        fout.close();
        Assert.assertThrows(ClosedChannelException.class, () -> fout.write(42));
    }

    @Test
    public void testWriteAfterClose() throws IOException {
        Path objectPath = new Path(this.ghfs.getFileSystemRoot(), "dir/object.txt");
        FSDataOutputStream fout = this.ghfs.create(objectPath);
        fout.close();
        Assert.assertThrows(ClosedChannelException.class, () -> fout.write(new byte[]{1}, 0, 1));
    }

    @Test
    public void testSyncAfterClose() throws IOException {
        Path objectPath = new Path(this.ghfs.getFileSystemRoot(), "dir/object.txt");
        FSDataOutputStream fout = this.ghfs.create(objectPath);
        fout.close();
        Assert.assertThrows(ClosedChannelException.class, () -> ((FSDataOutputStream)fout).hsync());
    }

    @Test
    public void testSyncComposite_withLargeNumberOfComposeComponents() throws Exception {
        Path objectPath = new Path(this.ghfs.getFileSystemRoot(), "dir/object.txt");
        byte[] expected = new byte[1536];
        new Random().nextBytes(expected);
        try (FSDataOutputStream fout = this.ghfs.create(objectPath);){
            for (int i = 0; i < expected.length; ++i) {
                fout.write(expected, i, 1);
                fout.hsync();
            }
        }
        Truth.assertThat((byte[])this.readFile(objectPath)).isEqualTo((Object)expected);
    }

    @Test
    public void hflush_rateLimited_writesEverything() throws Exception {
        this.ghfs.getConf().setEnum(GoogleHadoopFileSystemConfiguration.GCS_OUTPUT_STREAM_TYPE.getKey(), (Enum)GoogleHadoopFileSystemBase.OutputStreamType.FLUSHABLE_COMPOSITE);
        this.ghfs.getConf().setLong(GoogleHadoopFileSystemConfiguration.GCS_OUTPUT_STREAM_SYNC_MIN_INTERVAL_MS.getKey(), Duration.ofDays(1L).toMillis());
        Path objectPath = new Path(this.ghfs.getFileSystemRoot(), "hflush_rateLimited_writesEverything.bin");
        byte[] testData = new byte[100];
        new Random().nextBytes(testData);
        try (FSDataOutputStream out = this.ghfs.create(objectPath);){
            for (byte testDataByte : testData) {
                out.write((int)testDataByte);
                out.hflush();
                Truth.assertThat((Long)this.ghfs.getFileStatus(objectPath).getLen()).isEqualTo((Object)1);
                Truth.assertThat((byte[])this.readFile(objectPath)).isEqualTo((Object)new byte[]{testData[0]});
            }
        }
        Truth.assertThat((Long)this.ghfs.getFileStatus(objectPath).getLen()).isEqualTo((Object)testData.length);
        Truth.assertThat((byte[])this.readFile(objectPath)).isEqualTo((Object)testData);
    }

    @Test
    public void testWriteStatistics() throws IOException {
        Path objectPath = new Path(this.ghfs.getFileSystemRoot(), "dir/object2.txt");
        FileSystem.Statistics statistics = new FileSystem.Statistics(this.ghfs.getScheme());
        GoogleHadoopSyncableOutputStream fout = new GoogleHadoopSyncableOutputStream(this.ghfs, this.ghfs.getGcsPath(objectPath), statistics, CreateFileOptions.DEFAULT_OVERWRITE, SyncableOutputStreamOptions.DEFAULT, this.mockExecutorService);
        byte[] data1 = new byte[]{15, 14, 14, 13};
        byte[] data2 = new byte[]{11, 13, 14, 14, 15};
        fout.write(data1, 0, data1.length);
        fout.sync();
        Truth.assertThat((Long)statistics.getBytesWritten()).isEqualTo((Object)4);
        Truth.assertThat((Integer)statistics.getWriteOps()).isEqualTo((Object)1);
        fout.write(data2, 0, data2.length);
        fout.sync();
        Truth.assertThat((Long)statistics.getBytesWritten()).isEqualTo((Object)9);
        Truth.assertThat((Integer)statistics.getWriteOps()).isEqualTo((Object)2);
        ((ExecutorService)Mockito.verify((Object)this.mockExecutorService)).submit((Callable)ArgumentMatchers.any(Callable.class));
    }

    private byte[] readFile(Path objectPath) throws IOException {
        FileStatus status = this.ghfs.getFileStatus(objectPath);
        ByteArrayOutputStream allReadBytes = new ByteArrayOutputStream(Math.toIntExact(status.getLen()));
        byte[] readBuffer = new byte[0x100000];
        try (FSDataInputStream in = this.ghfs.open(objectPath);){
            int readBytes;
            while ((readBytes = in.read(readBuffer)) > 0) {
                allReadBytes.write(readBuffer, 0, readBytes);
            }
        }
        return allReadBytes.toByteArray();
    }
}

