/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.gcsio.testing.InMemoryGoogleCloudStorage;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class GoogleHadoopFileSystemTestHelper {
    public static final String IN_MEMORY_TEST_BUCKET = "gs://fake-in-memory-test-bucket";

    public static GoogleHadoopFileSystem createInMemoryGoogleHadoopFileSystem() throws IOException {
        GoogleCloudStorageFileSystem memoryGcsFs = new GoogleCloudStorageFileSystem(InMemoryGoogleCloudStorage::new, GoogleCloudStorageFileSystemOptions.builder().setCloudStorageOptions(InMemoryGoogleCloudStorage.getInMemoryGoogleCloudStorageOptions()).build());
        GoogleHadoopFileSystem ghfs = new GoogleHadoopFileSystem(memoryGcsFs);
        GoogleHadoopFileSystemTestHelper.initializeInMemoryFileSystem((FileSystem)ghfs, IN_MEMORY_TEST_BUCKET);
        return ghfs;
    }

    private static void initializeInMemoryFileSystem(FileSystem ghfs, String initUriString) throws IOException {
        URI initUri;
        try {
            initUri = new URI(initUriString);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        Configuration config = new Configuration();
        ghfs.initialize(initUri, config);
        ghfs.mkdirs(new Path(initUriString));
    }
}

