/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemConfiguration;
import com.google.cloud.hadoop.fs.gcs.HadoopFileSystemTestBase;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemIntegrationTest;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.testing.TestConfiguration;
import com.google.cloud.hadoop.util.HadoopCredentialConfiguration;
import com.google.cloud.hadoop.util.testing.TestingAccessTokenProvider;
import com.google.common.base.Charsets;
import com.google.common.truth.Truth;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public abstract class GoogleHadoopFileSystemTestBase
extends HadoopFileSystemTestBase {
    @ClassRule
    public static GoogleCloudStorageFileSystemIntegrationTest.NotInheritableExternalResource storageResource = new GoogleCloudStorageFileSystemIntegrationTest.NotInheritableExternalResource(GoogleHadoopFileSystemTestBase.class){

        public void after() {
            HadoopFileSystemTestBase.storageResource.after();
        }
    };

    protected static Configuration loadConfig() {
        TestConfiguration testConf = TestConfiguration.getInstance();
        return GoogleHadoopFileSystemTestBase.loadConfig(testConf.getProjectId(), testConf.getServiceAccount(), testConf.getPrivateKeyFile());
    }

    protected static Configuration loadConfig(String projectId, String serviceAccount, String privateKeyFile) {
        Truth.assertWithMessage((String)"Expected value for env var %s", (Object[])new Object[]{"GCS_TEST_PROJECT_ID"}).that(projectId).isNotNull();
        Configuration config = new Configuration();
        config.set(GoogleHadoopFileSystemConfiguration.GCS_PROJECT_ID.getKey(), projectId);
        if (serviceAccount != null && privateKeyFile != null) {
            config.set("fs.gs" + HadoopCredentialConfiguration.SERVICE_ACCOUNT_EMAIL_SUFFIX.getKey(), serviceAccount);
            config.set("fs.gs" + HadoopCredentialConfiguration.SERVICE_ACCOUNT_KEYFILE_SUFFIX.getKey(), privateKeyFile);
        }
        config.setBoolean(GoogleHadoopFileSystemConfiguration.GCS_REPAIR_IMPLICIT_DIRECTORIES_ENABLE.getKey(), true);
        config.setBoolean(GoogleHadoopFileSystemConfiguration.GCE_BUCKET_DELETE_ENABLE.getKey(), true);
        return config;
    }

    @Test
    public abstract void testCheckPathSuccess();

    @Test
    public abstract void testCheckPathFailure();

    @Test
    public abstract void testInitializeSuccess() throws IOException, URISyntaxException;

    @Test
    public abstract void testInitializeWithWorkingDirectory() throws Exception;

    @Test
    public abstract void testConfigureBucketsSuccess() throws URISyntaxException, IOException;

    @Test
    public abstract void testConfigureBucketsWithRootBucketButNoSystemBucket() throws IOException;

    @Test
    public abstract void testConfigureBucketsWithNeitherRootBucketNorSystemBucket() throws IOException;

    @Test
    public void testGetGcsPath() throws URISyntaxException {
        GoogleHadoopFileSystemBase myghfs = (GoogleHadoopFileSystemBase)ghfs;
        URI gcsPath = new URI("gs://" + myghfs.getUri().getAuthority() + "/dir/obj");
        Truth.assertThat((Comparable)myghfs.getGcsPath(new Path(gcsPath))).isEqualTo((Object)gcsPath);
        Truth.assertThat((Comparable)myghfs.getGcsPath(new Path("/buck^et", "object"))).isEqualTo((Object)new URI("gs://" + myghfs.getUri().getAuthority() + "/buck%5Eet/object"));
    }

    @Test
    public void testConfig() {
        GoogleHadoopFileSystemBase myghfs = (GoogleHadoopFileSystemBase)ghfs;
        GoogleCloudStorageOptions cloudStorageOptions = myghfs.getGcsFs().getOptions().getCloudStorageOptions();
        Truth.assertThat((Long)cloudStorageOptions.getReadChannelOptions().getInplaceSeekLimit()).isEqualTo(GoogleHadoopFileSystemConfiguration.GCS_INPUT_STREAM_INPLACE_SEEK_LIMIT.getDefault());
        Truth.assertThat((Long)myghfs.getDefaultBlockSize()).isEqualTo(GoogleHadoopFileSystemConfiguration.BLOCK_SIZE.getDefault());
    }

    @Test
    public void testGetCanonicalServiceName() {
        Truth.assertThat((String)ghfs.getCanonicalServiceName()).isNull();
    }

    @Test
    public void testImplicitDirectory() throws IOException {
        String bucketName = sharedBucketName1;
        GoogleHadoopFileSystemBase myghfs = (GoogleHadoopFileSystemBase)ghfs;
        GoogleCloudStorageFileSystem gcsfs = myghfs.getGcsFs();
        URI seedUri = GoogleCloudStorageFileSystemIntegrationTest.getTempFilePath();
        Path parentPath = ghfsHelper.castAsHadoopPath(seedUri);
        URI parentUri = myghfs.getGcsPath(parentPath);
        Path subdirPath = new Path(parentPath, "foo-subdir");
        URI subdirUri = myghfs.getGcsPath(subdirPath);
        Path leafPath = new Path(subdirPath, "bar-subdir");
        URI leafUri = myghfs.getGcsPath(leafPath);
        gcsfs.mkdir(leafUri);
        GoogleHadoopFileSystemTestBase.assertDirectory(gcsfs, leafUri, true);
        GoogleHadoopFileSystemTestBase.assertDirectory(gcsfs, subdirUri, true);
        GoogleHadoopFileSystemTestBase.assertDirectory(gcsfs, parentUri, true);
        ghfsHelper.clearBucket(bucketName);
    }

    @Test
    public void testRepairDirectory_afterFileDelete() throws IOException {
        GoogleHadoopFileSystemBase myghfs = (GoogleHadoopFileSystemBase)ghfs;
        GoogleCloudStorageFileSystem gcsfs = myghfs.getGcsFs();
        GoogleCloudStorage gcs = gcsfs.getGcs();
        URI seedUri = GoogleCloudStorageFileSystemIntegrationTest.getTempFilePath();
        Path dirPath = ghfsHelper.castAsHadoopPath(seedUri);
        URI dirUri = myghfs.getGcsPath(dirPath);
        Path emptyObject = new Path(dirPath, "empty-object");
        URI objUri = myghfs.getGcsPath(emptyObject);
        StorageResourceId resource = StorageResourceId.fromUriPath((URI)objUri, (boolean)false);
        gcs.createEmptyObject(resource);
        boolean autoRepairImplicitDirectories = gcsfs.getOptions().getCloudStorageOptions().isAutoRepairImplicitDirectoriesEnabled();
        GoogleHadoopFileSystemTestBase.assertDirectory(gcsfs, dirUri, true);
        gcsfs.delete(objUri, false);
        GoogleHadoopFileSystemTestBase.assertDirectory(gcsfs, dirUri, autoRepairImplicitDirectories);
        ghfsHelper.clearBucket(resource.getBucketName());
    }

    @Test
    public void testRepairDirectory_afterSubdirectoryDelete() throws IOException {
        GoogleHadoopFileSystemBase myghfs = (GoogleHadoopFileSystemBase)ghfs;
        GoogleCloudStorageFileSystem gcsfs = myghfs.getGcsFs();
        GoogleCloudStorage gcs = gcsfs.getGcs();
        URI seedUri = GoogleCloudStorageFileSystemIntegrationTest.getTempFilePath();
        Path dirPath = ghfsHelper.castAsHadoopPath(seedUri);
        URI dirUri = myghfs.getGcsPath(dirPath);
        Path subDir = new Path(dirPath, "subdir");
        URI subdirUri = myghfs.getGcsPath(subDir);
        Path emptyObject = new Path(subDir, "empty-object");
        URI objUri = myghfs.getGcsPath(emptyObject);
        StorageResourceId resource = StorageResourceId.fromUriPath((URI)objUri, (boolean)false);
        gcs.createEmptyObject(resource);
        boolean autoRepairImplicitDirectories = gcsfs.getOptions().getCloudStorageOptions().isAutoRepairImplicitDirectoriesEnabled();
        GoogleHadoopFileSystemTestBase.assertDirectory(gcsfs, dirUri, true);
        GoogleHadoopFileSystemTestBase.assertDirectory(gcsfs, subdirUri, true);
        gcsfs.delete(subdirUri, true);
        GoogleHadoopFileSystemTestBase.assertDirectory(gcsfs, dirUri, autoRepairImplicitDirectories);
        ghfsHelper.clearBucket(resource.getBucketName());
    }

    @Test
    public void testRepairDirectory_afterFileRename() throws IOException {
        GoogleHadoopFileSystemBase myghfs = (GoogleHadoopFileSystemBase)ghfs;
        GoogleCloudStorageFileSystem gcsfs = myghfs.getGcsFs();
        GoogleCloudStorage gcs = gcsfs.getGcs();
        URI seedUri = GoogleCloudStorageFileSystemIntegrationTest.getTempFilePath();
        Path dirPath = ghfsHelper.castAsHadoopPath(seedUri);
        URI dirUri = myghfs.getGcsPath(dirPath);
        Path emptyObject = new Path(dirPath, "empty-object");
        URI objUri = myghfs.getGcsPath(emptyObject);
        StorageResourceId resource = StorageResourceId.fromUriPath((URI)objUri, (boolean)false);
        gcs.createEmptyObject(resource);
        boolean autoRepairImplicitDirectories = gcsfs.getOptions().getCloudStorageOptions().isAutoRepairImplicitDirectoriesEnabled();
        GoogleHadoopFileSystemTestBase.assertDirectory(gcsfs, dirUri, true);
        gcsfs.rename(objUri, objUri.resolve(".."));
        GoogleHadoopFileSystemTestBase.assertDirectory(gcsfs, dirUri, autoRepairImplicitDirectories);
        ghfsHelper.clearBucket(resource.getBucketName());
    }

    @Test
    public void testRepairDirectory_afterSubdirectoryRename() throws IOException {
        String bucketName = sharedBucketName1;
        GoogleHadoopFileSystemBase myghfs = (GoogleHadoopFileSystemBase)ghfs;
        GoogleCloudStorageFileSystem gcsfs = myghfs.getGcsFs();
        GoogleCloudStorage gcs = gcsfs.getGcs();
        Path dirPath = ghfsHelper.castAsHadoopPath(GoogleCloudStorageFileSystemIntegrationTest.getTempFilePath());
        URI dirUri = myghfs.getGcsPath(dirPath);
        Path subDir = new Path(dirPath, "subdir");
        URI subdirUri = myghfs.getGcsPath(subDir);
        Path emptyObject = new Path(subDir, "empty-object");
        URI objUri = myghfs.getGcsPath(emptyObject);
        StorageResourceId resource = StorageResourceId.fromUriPath((URI)objUri, (boolean)false);
        gcs.createEmptyObject(resource);
        boolean autoRepairImplicitDirectories = gcsfs.getOptions().getCloudStorageOptions().isAutoRepairImplicitDirectoriesEnabled();
        GoogleHadoopFileSystemTestBase.assertDirectory(gcsfs, dirUri, true);
        GoogleHadoopFileSystemTestBase.assertDirectory(gcsfs, subdirUri, true);
        gcsfs.rename(subdirUri, dirUri.resolve("."));
        GoogleHadoopFileSystemTestBase.assertDirectory(gcsfs, dirUri, autoRepairImplicitDirectories);
        ghfsHelper.clearBucket(bucketName);
    }

    private static void assertDirectory(GoogleCloudStorageFileSystem gcsfs, URI path, boolean exists) throws IOException {
        Truth.assertWithMessage((String)"Expected to %s: %s", (Object[])new Object[]{exists ? "exist" : "not exist", path}).that(Boolean.valueOf(gcsfs.exists(path))).isEqualTo((Object)exists);
        if (exists) {
            Truth.assertWithMessage((String)"Expected to be a directory: %s", (Object[])new Object[]{path}).that(Boolean.valueOf(gcsfs.getFileInfo(path).isDirectory())).isTrue();
        } else {
            Truth.assertWithMessage((String)"Expected to have requested ID: %s", (Object[])new Object[]{path}).that((Comparable)gcsfs.getFileInfo(path).getPath()).isEqualTo((Object)path);
        }
    }

    @Test
    public void testMakeQualifiedNotRoot() {
        GoogleHadoopFileSystemBase myGhfs = (GoogleHadoopFileSystemBase)ghfs;
        Path fsRootPath = myGhfs.getFileSystemRoot();
        URI fsRootUri = fsRootPath.toUri();
        String fsRoot = fsRootPath.toString();
        String workingParent = fsRoot + "working/";
        String workingDir = workingParent + "dir";
        myGhfs.setWorkingDirectory(new Path(workingDir));
        HashMap<String, String> qualifiedPaths = new HashMap<String, String>();
        qualifiedPaths.put("/", fsRoot);
        qualifiedPaths.put("/foo", fsRoot + "foo");
        qualifiedPaths.put("/foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put(".", workingDir);
        qualifiedPaths.put("foo", workingDir + "/foo");
        qualifiedPaths.put("foo/bar", workingDir + "/foo/bar");
        qualifiedPaths.put(fsRoot, fsRoot);
        qualifiedPaths.put(fsRoot + "foo", fsRoot + "foo");
        qualifiedPaths.put(fsRoot + "foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put("/foo/../foo", fsRoot + "foo");
        qualifiedPaths.put("/foo/bar/../../foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put("foo/../foo", workingDir + "/foo");
        qualifiedPaths.put("foo/bar/../../foo/bar", workingDir + "/foo/bar");
        qualifiedPaths.put(fsRoot + "foo/../foo", fsRoot + "foo");
        qualifiedPaths.put(fsRoot + "foo/bar/../../foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put("..", workingParent);
        qualifiedPaths.put("../..", fsRoot);
        qualifiedPaths.put("../foo", workingParent + "/foo");
        qualifiedPaths.put("../foo/bar", workingParent + "/foo/bar");
        qualifiedPaths.put("../foo/../foo", workingParent + "/foo");
        qualifiedPaths.put("../foo/bar/../../foo/bar", workingParent + "/foo/bar");
        qualifiedPaths.put(workingDir + "/../foo/../foo", workingParent + "/foo");
        qualifiedPaths.put(workingDir + "/../foo/bar/../../foo/bar", workingParent + "/foo/bar");
        qualifiedPaths.put(fsRoot + "..foo/bar", fsRoot + "..foo/bar");
        qualifiedPaths.put("..foo/bar", workingDir + "/..foo/bar");
        qualifiedPaths.put("/..", fsRoot);
        qualifiedPaths.put("/../../..", fsRoot);
        qualifiedPaths.put("/../foo/", fsRoot + "foo");
        qualifiedPaths.put("/../../../foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put("../../..", fsRoot);
        qualifiedPaths.put(fsRoot + "..", fsRoot);
        qualifiedPaths.put(fsRoot + "../foo", fsRoot + "foo");
        qualifiedPaths.put(fsRoot + "../foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put("../../../foo/../foo", fsRoot + "foo");
        qualifiedPaths.put("../../../foo/bar/../../foo/bar", fsRoot + "foo/bar");
        if (fsRootUri.getAuthority() != null) {
            qualifiedPaths.put(fsRoot.substring(0, fsRoot.length() - 1), fsRoot);
        }
        for (String unqualifiedString : qualifiedPaths.keySet()) {
            Path unqualifiedPath = new Path(unqualifiedString);
            Path qualifiedPath = new Path((String)qualifiedPaths.get(unqualifiedString));
            Truth.assertThat((Comparable)qualifiedPath).isEqualTo((Object)myGhfs.makeQualified(unqualifiedPath));
        }
    }

    @Test
    public void testMakeQualifiedRoot() {
        GoogleHadoopFileSystemBase myGhfs = (GoogleHadoopFileSystemBase)ghfs;
        myGhfs.setWorkingDirectory(myGhfs.getFileSystemRoot());
        Path fsRootPath = myGhfs.getFileSystemRoot();
        URI fsRootUri = fsRootPath.toUri();
        String fsRoot = fsRootPath.toString();
        HashMap<String, String> qualifiedPaths = new HashMap<String, String>();
        qualifiedPaths.put("/", fsRoot);
        qualifiedPaths.put("/foo", fsRoot + "foo");
        qualifiedPaths.put("/foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put(".", fsRoot);
        qualifiedPaths.put("foo", fsRoot + "foo");
        qualifiedPaths.put("foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put(fsRoot, fsRoot);
        qualifiedPaths.put(fsRoot + "foo", fsRoot + "foo");
        qualifiedPaths.put(fsRoot + "foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put("/foo/../foo", fsRoot + "foo");
        qualifiedPaths.put("/foo/bar/../../foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put("foo/../foo", fsRoot + "foo");
        qualifiedPaths.put("foo/bar/../../foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put(fsRoot + "foo/../foo", fsRoot + "foo");
        qualifiedPaths.put(fsRoot + "foo/bar/../../foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put(fsRoot + "..foo/bar", fsRoot + "..foo/bar");
        qualifiedPaths.put("..foo/bar", fsRoot + "..foo/bar");
        qualifiedPaths.put("/..", fsRoot);
        qualifiedPaths.put("/../../..", fsRoot);
        qualifiedPaths.put("/../foo/", fsRoot + "foo");
        qualifiedPaths.put("/../../../foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put("..", fsRoot);
        qualifiedPaths.put("../..", fsRoot);
        qualifiedPaths.put("../foo", fsRoot + "foo");
        qualifiedPaths.put("../foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put(fsRoot + "..", fsRoot);
        qualifiedPaths.put(fsRoot + "../foo", fsRoot + "foo");
        qualifiedPaths.put(fsRoot + "../foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put("../../../foo/bar/../../foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put("../foo/../foo", fsRoot + "foo");
        qualifiedPaths.put("../foo/bar/../../foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put(fsRoot + "../foo/../foo", fsRoot + "foo");
        qualifiedPaths.put(fsRoot + "../foo/bar/../../foo/bar", fsRoot + "foo/bar");
        qualifiedPaths.put(fsRoot + "foo/../../../../foo", fsRoot + "foo");
        qualifiedPaths.put(fsRoot + "foo/bar/../../../../../foo/bar", fsRoot + "foo/bar");
        if (fsRootUri.getAuthority() != null) {
            qualifiedPaths.put(fsRoot.substring(0, fsRoot.length() - 1), fsRoot);
        }
        for (String unqualifiedString : qualifiedPaths.keySet()) {
            Path unqualifiedPath = new Path(unqualifiedString);
            Path qualifiedPath = new Path((String)qualifiedPaths.get(unqualifiedString));
            Truth.assertThat((Comparable)qualifiedPath).isEqualTo((Object)myGhfs.makeQualified(unqualifiedPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void provideCoverageForUnmodifiedMethods() throws IOException {
        URI tempFileUri = GoogleCloudStorageFileSystemIntegrationTest.getTempFilePath();
        Path tempFilePath = ghfsHelper.castAsHadoopPath(tempFileUri);
        Path tempDirPath = tempFilePath.getParent();
        String text = "Hello World!";
        ghfsHelper.writeFile(tempFilePath, text, 1, false);
        URI tempFileUri2 = GoogleCloudStorageFileSystemIntegrationTest.getTempFilePath();
        Path tempFilePath2 = ghfsHelper.castAsHadoopPath(tempFileUri2);
        File localTempFile = File.createTempFile("ghfs-test-", null);
        Path localTempFilePath = new Path(localTempFile.getPath());
        Path localTempDirPath = localTempFilePath.getParent();
        try {
            ghfs.deleteOnExit(tempFilePath);
            ghfs.getContentSummary(tempFilePath);
            ghfs.getDelegationToken("foo");
            ghfs.copyFromLocalFile(false, true, localTempFilePath, tempDirPath);
            ghfs.copyFromLocalFile(false, true, new Path[]{localTempFilePath}, tempDirPath);
            localTempFile.delete();
            ghfs.copyToLocalFile(true, tempFilePath, localTempDirPath);
            File localCopiedFile = new File(localTempDirPath.toString(), tempFilePath.getName());
            localCopiedFile.delete();
            Path localOutputPath = ghfs.startLocalOutput(tempFilePath2, localTempFilePath);
            try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(localOutputPath.toString(), new String[0]), Charsets.UTF_8, new OpenOption[0]);){
                writer.write(text);
            }
            ghfs.completeLocalOutput(tempFilePath2, localOutputPath);
            ghfs.getUsed();
            ghfs.setVerifyChecksum(false);
            ghfs.getFileChecksum(tempFilePath2);
            ghfs.setPermission(tempFilePath2, FsPermission.getDefault());
            try {
                ghfs.setOwner(tempFilePath2, "foo-user", "foo-group");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ghfs.setTimes(tempFilePath2, 0L, 0L);
        }
        finally {
            if (localTempFile.exists()) {
                localTempFile.delete();
            }
        }
    }

    @Test
    public void testInvalidCredentialFromAccessTokenProvider() throws Exception {
        Configuration config = new Configuration();
        config.set("fs.gs.auth.access.token.provider.impl", TestingAccessTokenProvider.class.getName());
        URI gsUri = new URI("gs://foobar/");
        GoogleHadoopFileSystem ghfs = new GoogleHadoopFileSystem();
        ghfs.initialize(gsUri, config);
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> ghfs.exists(new Path("gs://")));
        Truth.assertThat((Throwable)thrown).hasCauseThat().hasMessageThat().contains((CharSequence)"Invalid Credentials");
    }
}

