/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.cloud.hadoop.fs.gcs.FileSystemDescriptor;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemConfiguration;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemIntegrationTest;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemTestHelper;
import com.google.cloud.hadoop.fs.gcs.HadoopFileSystemTestBase;
import com.google.cloud.hadoop.fs.gcs.HdfsBehavior;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemIntegrationTest;
import com.google.cloud.hadoop.gcsio.MethodOutcome;
import com.google.cloud.hadoop.util.AccessTokenProvider;
import com.google.cloud.hadoop.util.HadoopCredentialConfiguration;
import com.google.cloud.hadoop.util.testing.TestingAccessTokenProvider;
import com.google.common.truth.Truth;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GoogleHadoopFileSystemTest
extends GoogleHadoopFileSystemIntegrationTest {
    @ClassRule
    public static GoogleCloudStorageFileSystemIntegrationTest.NotInheritableExternalResource storageResource = new GoogleCloudStorageFileSystemIntegrationTest.NotInheritableExternalResource(GoogleHadoopFileSystemTest.class){

        public void before() throws Throwable {
            Logger.getLogger("").setLevel(Level.OFF);
            HadoopFileSystemTestBase.ghfs = GoogleHadoopFileSystemTestHelper.createInMemoryGoogleHadoopFileSystem();
            HadoopFileSystemTestBase.ghfsFileSystemDescriptor = (FileSystemDescriptor)HadoopFileSystemTestBase.ghfs;
            GoogleHadoopFileSystemIntegrationTest.postCreateInit();
        }

        public void after() {
            GoogleHadoopFileSystemIntegrationTest.storageResource.after();
        }
    };

    @Test
    public void testVersionString() {
        Truth.assertThat((String)GoogleHadoopFileSystemBase.VERSION).isNotNull();
        Truth.assertThat((Boolean)"0.0.0".equals(GoogleHadoopFileSystemBase.VERSION)).isFalse();
    }

    @Test
    public void lazyInitialization_succeeds_withInvalidCredentialsConfiguration() throws Exception {
        new GoogleHadoopFileSystem();
        Configuration lazyConf = new Configuration();
        lazyConf.setBoolean(GoogleHadoopFileSystemConfiguration.GCS_LAZY_INITIALIZATION_ENABLE.getKey(), true);
        lazyConf.set("fs.gs" + HadoopCredentialConfiguration.SERVICE_ACCOUNT_JSON_KEYFILE_SUFFIX.getKey(), "non-existent.json");
        GoogleHadoopFileSystem lazyFs = new GoogleHadoopFileSystem();
        lazyFs.initialize(new URI("gs://test-non-existent/"), lazyConf);
        lazyFs.close();
    }

    @Test
    public void lazyInitialization_deleteCall_fails_withInvalidCredentialsConfiguration() throws Exception {
        Configuration lazyConf = new Configuration();
        lazyConf.setBoolean(GoogleHadoopFileSystemConfiguration.GCS_LAZY_INITIALIZATION_ENABLE.getKey(), true);
        lazyConf.set("fs.gs" + HadoopCredentialConfiguration.SERVICE_ACCOUNT_JSON_KEYFILE_SUFFIX.getKey(), "non-existent.json");
        GoogleHadoopFileSystem lazyFs = new GoogleHadoopFileSystem();
        lazyFs.initialize(new URI("gs://test-non-existent"), lazyConf);
        RuntimeException exception = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> lazyFs.delete(new Path("gs://test-non-existent/dir"), false));
        Truth.assertThat((Throwable)exception).hasMessageThat().isEqualTo((Object)"Failed to create GCS FS");
        Truth.assertThat((Throwable)exception).hasCauseThat().isInstanceOf(FileNotFoundException.class);
        Truth.assertThat((Throwable)exception).hasCauseThat().hasMessageThat().isAnyOf((Object)"non-existent.json (No such file or directory)", (Object)"non-existent.json (The system cannot find the file specified)", new Object[0]);
        lazyFs.close();
    }

    @Test
    public void eagerInitialization_fails_withInvalidCredentialsConfiguration() {
        new GoogleHadoopFileSystem();
        Configuration eagerConf = new Configuration();
        eagerConf.setBoolean(GoogleHadoopFileSystemConfiguration.GCS_LAZY_INITIALIZATION_ENABLE.getKey(), false);
        eagerConf.set("fs.gs" + HadoopCredentialConfiguration.SERVICE_ACCOUNT_JSON_KEYFILE_SUFFIX.getKey(), "non-existent.json");
        GoogleHadoopFileSystem eagerFs = new GoogleHadoopFileSystem();
        FileNotFoundException exception = (FileNotFoundException)Assert.assertThrows(FileNotFoundException.class, () -> GoogleHadoopFileSystemTest.lambda$eagerInitialization_fails_withInvalidCredentialsConfiguration$1((FileSystem)eagerFs, eagerConf));
        Truth.assertThat((Throwable)exception).hasMessageThat().isAnyOf((Object)"non-existent.json (No such file or directory)", (Object)"non-existent.json (The system cannot find the file specified)", new Object[0]);
    }

    @Override
    @Test
    public void testRename() throws Exception {
        this.renameHelper(new HdfsBehavior(){

            @Override
            public MethodOutcome renameFileIntoRootOutcome() {
                return new MethodOutcome(MethodOutcome.Type.RETURNS_TRUE);
            }
        });
    }

    @Test
    public void testCouldUseFlatGlob() throws IOException, URISyntaxException {
        Configuration lazyConf = new Configuration();
        lazyConf.setBoolean(GoogleHadoopFileSystemConfiguration.GCS_LAZY_INITIALIZATION_ENABLE.getKey(), true);
        try (GoogleHadoopFileSystem lazyFs = new GoogleHadoopFileSystem();){
            Truth.assertThat((Boolean)lazyFs.couldUseFlatGlob(new Path(new URI("gs://**/test/")))).isFalse();
        }
    }

    @Test
    public void testTrimToPrefixWithoutGlob() {
        GoogleHadoopFileSystem lazyFs = new GoogleHadoopFileSystem();
        lazyFs.trimToPrefixWithoutGlob("gs://**/test");
        Truth.assertThat((String)lazyFs.trimToPrefixWithoutGlob("gs://**/test")).isEqualTo((Object)"gs://");
    }

    @Override
    @Test
    public void testGetGcsPath() throws URISyntaxException {
        GoogleHadoopFileSystem myghfs = (GoogleHadoopFileSystem)ghfs;
        URI gcsPath = new URI("gs://" + myghfs.getUri().getAuthority() + "/dir/obj");
        Truth.assertThat((Comparable)myghfs.getGcsPath(new Path(gcsPath))).isEqualTo((Object)gcsPath);
    }

    @Test
    public void testGetDefaultPortIndicatesPortsAreNotUsed() throws Exception {
        Configuration config = new Configuration();
        config.set("fs.gs.auth.access.token.provider.impl", TestingAccessTokenProvider.class.getName());
        URI gsUri = new URI("gs://foobar/");
        GoogleHadoopFileSystem ghfs = new GoogleHadoopFileSystem();
        ghfs.initialize(gsUri, config);
        Truth.assertThat((Integer)ghfs.getDefaultPort()).isEqualTo((Object)-1);
    }

    @Test
    public void testImpsersonationServiceAccountUsed() throws Exception {
        Configuration config = new Configuration();
        config.setClass("fs.gs.auth.access.token.provider.impl", TestingAccessTokenProvider.class, AccessTokenProvider.class);
        config.set("fs.gs" + HadoopCredentialConfiguration.IMPERSONATION_SERVICE_ACCOUNT_SUFFIX.getKey(), "test-service-account");
        URI gsUri = new URI("gs://foobar/");
        GoogleHadoopFileSystem ghfs = new GoogleHadoopFileSystem();
        Exception exception = (Exception)Assert.assertThrows(GoogleJsonResponseException.class, () -> ghfs.initialize(gsUri, config));
        Truth.assertThat((Throwable)exception).hasMessageThat().startsWith("401 Unauthorized");
    }

    @Test
    public void testImpsersonationUserNameIdentifierUsed() throws Exception {
        Configuration config = new Configuration();
        config.setClass("fs.gs.auth.access.token.provider.impl", TestingAccessTokenProvider.class, AccessTokenProvider.class);
        config.set("fs.gs" + HadoopCredentialConfiguration.USER_IMPERSONATION_SERVICE_ACCOUNT_SUFFIX.getKey() + UserGroupInformation.getCurrentUser().getShortUserName(), "test-service-account");
        URI gsUri = new URI("gs://foobar/");
        GoogleHadoopFileSystem ghfs = new GoogleHadoopFileSystem();
        Exception exception = (Exception)Assert.assertThrows(GoogleJsonResponseException.class, () -> ghfs.initialize(gsUri, config));
        Truth.assertThat((Throwable)exception).hasMessageThat().startsWith("401 Unauthorized");
    }

    @Test
    public void testImpsersonationGroupNameIdentifierUsed() throws Exception {
        Configuration config = new Configuration();
        config.setClass("fs.gs.auth.access.token.provider.impl", TestingAccessTokenProvider.class, AccessTokenProvider.class);
        config.set("fs.gs" + HadoopCredentialConfiguration.GROUP_IMPERSONATION_SERVICE_ACCOUNT_SUFFIX.getKey() + UserGroupInformation.getCurrentUser().getGroupNames()[0], "test-service-account");
        URI gsUri = new URI("gs://foobar/");
        GoogleHadoopFileSystem ghfs = new GoogleHadoopFileSystem();
        Exception exception = (Exception)Assert.assertThrows(GoogleJsonResponseException.class, () -> ghfs.initialize(gsUri, config));
        Truth.assertThat((Throwable)exception).hasMessageThat().startsWith("401 Unauthorized");
    }

    @Test
    public void testImpsersonationUserAndGroupNameIdentifiersUsed() throws Exception {
        Configuration config = new Configuration();
        config.setClass("fs.gs.auth.access.token.provider.impl", TestingAccessTokenProvider.class, AccessTokenProvider.class);
        config.set("fs.gs" + HadoopCredentialConfiguration.USER_IMPERSONATION_SERVICE_ACCOUNT_SUFFIX.getKey() + UserGroupInformation.getCurrentUser().getShortUserName(), "test-service-account1");
        config.set("fs.gs" + HadoopCredentialConfiguration.GROUP_IMPERSONATION_SERVICE_ACCOUNT_SUFFIX.getKey() + UserGroupInformation.getCurrentUser().getGroupNames()[0], "test-service-account2");
        URI gsUri = new URI("gs://foobar/");
        GoogleHadoopFileSystem ghfs = new GoogleHadoopFileSystem();
        Exception exception = (Exception)Assert.assertThrows(GoogleJsonResponseException.class, () -> ghfs.initialize(gsUri, config));
        Truth.assertThat((Throwable)exception).hasMessageThat().startsWith("401 Unauthorized");
    }

    @Test
    public void testImpsersonationServiceAccountAndUserAndGroupNameIdentifierUsed() throws Exception {
        Configuration config = new Configuration();
        config.setClass("fs.gs.auth.access.token.provider.impl", TestingAccessTokenProvider.class, AccessTokenProvider.class);
        config.set("fs.gs" + HadoopCredentialConfiguration.IMPERSONATION_SERVICE_ACCOUNT_SUFFIX.getKey(), "test-service-account1");
        config.set("fs.gs" + HadoopCredentialConfiguration.USER_IMPERSONATION_SERVICE_ACCOUNT_SUFFIX.getKey() + UserGroupInformation.getCurrentUser().getShortUserName(), "test-service-account2");
        config.set("fs.gs" + HadoopCredentialConfiguration.GROUP_IMPERSONATION_SERVICE_ACCOUNT_SUFFIX.getKey() + UserGroupInformation.getCurrentUser().getGroupNames()[0], "test-service-account3");
        URI gsUri = new URI("gs://foobar/");
        GoogleHadoopFileSystem ghfs = new GoogleHadoopFileSystem();
        Exception exception = (Exception)Assert.assertThrows(GoogleJsonResponseException.class, () -> ghfs.initialize(gsUri, config));
        Truth.assertThat((Throwable)exception).hasMessageThat().startsWith("401 Unauthorized");
    }

    @Test
    public void testImpsersonationInvalidUserNameIdentifierUsed() throws Exception {
        Configuration config = new Configuration();
        config.setClass("fs.gs.auth.access.token.provider.impl", TestingAccessTokenProvider.class, AccessTokenProvider.class);
        config.set("fs.gs" + HadoopCredentialConfiguration.USER_IMPERSONATION_SERVICE_ACCOUNT_SUFFIX.getKey() + "invalid-user", "test-service-account");
        URI gsUri = new URI("gs://foobar/");
        GoogleHadoopFileSystem ghfs = new GoogleHadoopFileSystem();
        ghfs.initialize(gsUri, config);
    }

    @Override
    public void testInitializeSuccess() {
    }

    @Override
    public void testInitializeSucceedsWhenNoProjectIdConfigured() {
    }

    @Override
    public void testInitializeWithWorkingDirectory() {
    }

    @Override
    public void testIOExceptionIsThrowAfterClose() {
    }

    @Override
    public void testFileSystemIsRemovedFromCacheOnClose() {
    }

    @Override
    public void testConfigurablePermissions() {
    }

    @Override
    public void testFileStatusUser() {
    }

    @Override
    public void testCrc32cFileChecksum() {
    }

    @Override
    public void testMd5FileChecksum() {
    }

    @Override
    public void testConcurrentCreationWithoutOverwrite_onlyOneSucceeds() {
    }

    private static /* synthetic */ void lambda$eagerInitialization_fails_withInvalidCredentialsConfiguration$1(FileSystem eagerFs, Configuration eagerConf) throws Throwable {
        eagerFs.initialize(new URI("gs://test-non-existent"), eagerConf);
    }
}

