/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemConfiguration;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemTestBase;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemTestHelper;
import com.google.cloud.hadoop.fs.gcs.HadoopFileSystemIntegrationHelper;
import com.google.cloud.hadoop.fs.gcs.HadoopFileSystemTestBase;
import com.google.cloud.hadoop.fs.gcs.HdfsBehavior;
import com.google.cloud.hadoop.fs.gcs.auth.TestDelegationTokenBindingImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemIntegrationTest;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.MethodOutcome;
import com.google.cloud.hadoop.gcsio.testing.InMemoryGoogleCloudStorage;
import com.google.cloud.hadoop.util.HadoopCredentialConfiguration;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Ints;
import com.google.common.truth.Truth;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.Service;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GoogleHadoopFileSystemIntegrationTest
extends GoogleHadoopFileSystemTestBase {
    @ClassRule
    public static GoogleCloudStorageFileSystemIntegrationTest.NotInheritableExternalResource storageResource = new GoogleCloudStorageFileSystemIntegrationTest.NotInheritableExternalResource(GoogleHadoopFileSystemIntegrationTest.class){

        public void before() throws Throwable {
            GoogleHadoopFileSystem testInstance = new GoogleHadoopFileSystem();
            HadoopFileSystemTestBase.ghfs = testInstance;
            HadoopFileSystemTestBase.ghfsFileSystemDescriptor = testInstance;
            HadoopFileSystemTestBase.ghfsHelper = new HadoopFileSystemIntegrationHelper(HadoopFileSystemTestBase.ghfs, HadoopFileSystemTestBase.ghfsFileSystemDescriptor);
            URI initUri = new URI("gs://" + HadoopFileSystemTestBase.ghfsHelper.getUniqueBucketName("init"));
            HadoopFileSystemTestBase.ghfs.initialize(initUri, GoogleHadoopFileSystemTestBase.loadConfig());
            if (((Boolean)GoogleHadoopFileSystemConfiguration.GCS_LAZY_INITIALIZATION_ENABLE.get(HadoopFileSystemTestBase.ghfs.getConf(), (arg_0, arg_1) -> ((Configuration)HadoopFileSystemTestBase.ghfs.getConf()).getBoolean(arg_0, arg_1))).booleanValue()) {
                testInstance.getGcsFs();
            }
            HadoopFileSystemTestBase.postCreateInit();
        }

        public void after() {
            GoogleHadoopFileSystemTestBase.storageResource.after();
        }
    };

    @Before
    public void clearFileSystemCache() throws IOException {
        FileSystem.closeAll();
    }

    @Override
    @Test
    public void testRename() throws Exception {
        this.renameHelper(new HdfsBehavior(){

            @Override
            public MethodOutcome renameFileIntoRootOutcome() {
                return new MethodOutcome(MethodOutcome.Type.RETURNS_TRUE);
            }
        });
    }

    @Test
    public void testInitializePath_success() throws Exception {
        List<String> validPaths = Arrays.asList("gs://foo", "gs://foo/bar");
        for (String path : validPaths) {
            GoogleHadoopFileSystem testGhfs = GoogleHadoopFileSystemTestHelper.createInMemoryGoogleHadoopFileSystem();
            Throwable throwable = null;
            try {
                testGhfs.initialize(new URI(path), new Configuration());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (testGhfs == null) continue;
                if (throwable != null) {
                    try {
                        testGhfs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                testGhfs.close();
            }
        }
    }

    @Test
    public void testInitializePath_failure_notSupportedSchema() throws Exception {
        List<String> invalidPaths = Arrays.asList("http://foo", "gsg://foo", "hdfs:/", "hdfs:/foo", "hdfs://foo");
        for (String path : invalidPaths) {
            URI uri = new URI(path);
            GoogleHadoopFileSystem testGhfs = GoogleHadoopFileSystemTestHelper.createInMemoryGoogleHadoopFileSystem();
            Throwable throwable = null;
            try {
                IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows((String)("Path '" + path + "' should be invalid"), IllegalArgumentException.class, () -> testGhfs.initialize(uri, new Configuration()));
                Truth.assertThat((Throwable)e).hasMessageThat().startsWith("URI scheme not supported:");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (testGhfs == null) continue;
                if (throwable != null) {
                    try {
                        testGhfs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                testGhfs.close();
            }
        }
    }

    @Test
    public void testInitializePath_failure_bucketNotSpecified() throws Exception {
        List<String> invalidPaths = Arrays.asList("gs:/", "gs:/foo", "gs:/foo/bar", "gs:///");
        for (String path : invalidPaths) {
            URI uri = new URI(path);
            GoogleHadoopFileSystem testGhfs = GoogleHadoopFileSystemTestHelper.createInMemoryGoogleHadoopFileSystem();
            Throwable throwable = null;
            try {
                IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows((String)("Path '" + path + "' should be invalid"), IllegalArgumentException.class, () -> testGhfs.initialize(uri, new Configuration()));
                Truth.assertThat((Throwable)e).hasMessageThat().startsWith("No bucket specified in GCS URI:");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (testGhfs == null) continue;
                if (throwable != null) {
                    try {
                        testGhfs.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                testGhfs.close();
            }
        }
    }

    @Test
    public void initialize_throwsExceptionWhenPathNull() throws Exception {
        GoogleHadoopFileSystem myGhfs = GoogleHadoopFileSystemTestHelper.createInMemoryGoogleHadoopFileSystem();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> myGhfs.initialize(null, new Configuration()));
        Truth.assertThat((Throwable)exception).hasMessageThat().startsWith("path must not be null");
    }

    @Test
    public void initialize_throwsExceptionWhenConfigNull() throws Exception {
        GoogleHadoopFileSystem myGhfs = GoogleHadoopFileSystemTestHelper.createInMemoryGoogleHadoopFileSystem();
        URI correctUri = new URI("s:/foo/bar");
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> myGhfs.initialize(correctUri, null));
        Truth.assertThat((Throwable)exception).hasMessageThat().startsWith("config must not be null");
    }

    @Test
    public void initialize_throwsExceptionWhenPathSchemeNull() throws Exception {
        GoogleHadoopFileSystem myGhfs = GoogleHadoopFileSystemTestHelper.createInMemoryGoogleHadoopFileSystem();
        URI incorrectUri = new URI("foo/bar");
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> myGhfs.initialize(incorrectUri, new Configuration()));
        Truth.assertThat((Throwable)exception).hasMessageThat().startsWith("scheme of path must not be null");
    }

    @Test
    public void initialize_delegationTokensServiceLifecycle() throws Exception {
        Configuration config = new Configuration();
        config.set(GoogleHadoopFileSystemConfiguration.DELEGATION_TOKEN_BINDING_CLASS.getKey(), TestDelegationTokenBindingImpl.class.getName());
        config.set("test.token.value", "qWDAWFA3WWFAWFAWFAW3FAWF3AWF3WFAF33GR5G5");
        GoogleHadoopFileSystem fs = new GoogleHadoopFileSystem();
        fs.initialize(fs.getUri(), config);
        Truth.assertThat((Comparable)Service.STATE.STARTED).isEqualTo((Object)fs.delegationTokens.getServiceState());
        fs.close();
        Truth.assertThat((Comparable)Service.STATE.STOPPED).isEqualTo((Object)fs.delegationTokens.getServiceState());
    }

    @Test
    public void getDefaultPort() throws IOException {
        GoogleHadoopFileSystem myGhfs = GoogleHadoopFileSystemTestHelper.createInMemoryGoogleHadoopFileSystem();
        Truth.assertThat((Integer)myGhfs.getDefaultPort()).isEqualTo((Object)-1);
    }

    @Test
    public void getCanonicalServiceName_delegationTokensNotNull() throws Exception {
        Configuration config = new Configuration();
        config.set(GoogleHadoopFileSystemConfiguration.DELEGATION_TOKEN_BINDING_CLASS.getKey(), TestDelegationTokenBindingImpl.class.getName());
        config.set("test.token.value", "qWDAWFA3WWFAWFAWFAW3FAWF3AWF3WFAF33GR5G5");
        GoogleHadoopFileSystem fs = new GoogleHadoopFileSystem();
        fs.initialize(fs.getUri(), config);
        Truth.assertThat((String)fs.getCanonicalServiceName()).isEqualTo((Object)fs.delegationTokens.getService().toString());
    }

    @Test
    public void open_throwsExceptionWhenHadoopPathNull() {
        GoogleHadoopFileSystem myGhfs = new GoogleHadoopFileSystem();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> myGhfs.open((Path)null, 1));
        Truth.assertThat((Throwable)exception).hasMessageThat().startsWith("hadoopPath must not be null");
    }

    @Test
    public void create_throwsExceptionWhenHadoopPathIsNull() throws Exception {
        GoogleHadoopFileSystem myGhfs = GoogleHadoopFileSystemTestHelper.createInMemoryGoogleHadoopFileSystem();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> myGhfs.create(null, true, 1));
        Truth.assertThat((Throwable)exception).hasMessageThat().startsWith("hadoopPath must not be null");
    }

    @Test
    public void create_throwsExceptionWhenReplicationIsNotPositiveInteger() throws Exception {
        GoogleHadoopFileSystem myGhfs = GoogleHadoopFileSystemTestHelper.createInMemoryGoogleHadoopFileSystem();
        URI fileUri = GoogleCloudStorageFileSystemIntegrationTest.getTempFilePath();
        Path filePath = ghfsHelper.castAsHadoopPath(fileUri);
        short replicationSmallerThanZero = -1;
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> myGhfs.create(filePath, true, 1, replicationSmallerThanZero, 1L));
        Truth.assertThat((Throwable)exception).hasMessageThat().startsWith("replication must be a positive integer");
    }

    @Test
    public void create_throwsExceptionWhenBlockSizeIsNotPositiveInteger() throws Exception {
        GoogleHadoopFileSystem myGhfs = GoogleHadoopFileSystemTestHelper.createInMemoryGoogleHadoopFileSystem();
        URI fileUri = GoogleCloudStorageFileSystemIntegrationTest.getTempFilePath();
        Path filePath = ghfsHelper.castAsHadoopPath(fileUri);
        long blockSizeSmallerThanZero = -1L;
        IllegalArgumentException blockSmallerThanZeroException = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> myGhfs.create(filePath, true, 1, (short)1, blockSizeSmallerThanZero));
        Truth.assertThat((Throwable)blockSmallerThanZeroException).hasMessageThat().startsWith("blockSize must be a positive integer");
    }

    @Test
    public void createNonRecursive_throwsExceptionWhenHadoopPathNull() throws IOException {
        GoogleHadoopFileSystem myGhfs = GoogleHadoopFileSystemTestHelper.createInMemoryGoogleHadoopFileSystem();
        NullPointerException exception = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> myGhfs.createNonRecursive(null, true, 1, (short)1, 1L, () -> {}));
        Truth.assertThat((Throwable)exception).hasMessageThat().startsWith("hadoopPath must not be null");
    }

    @Test
    public void createNonRecursive() throws IOException {
        GoogleHadoopFileSystem myGhfs = (GoogleHadoopFileSystem)ghfs;
        URI fileUri = GoogleCloudStorageFileSystemIntegrationTest.getTempFilePath();
        Path filePath = ghfsHelper.castAsHadoopPath(fileUri);
        try (FSDataOutputStream createNonRecursiveOutputStream = myGhfs.createNonRecursive(filePath, true, 1, (short)1, 1L, () -> {});){
            createNonRecursiveOutputStream.write(1);
            Truth.assertThat((Integer)createNonRecursiveOutputStream.size()).isEqualTo((Object)1);
            Truth.assertThat((Long)createNonRecursiveOutputStream.getPos()).isEqualTo((Object)1);
        }
    }

    @Test
    public void createNonRecursive_throwsExceptionWhenParentFolderNoExists() {
        GoogleHadoopFileSystem myGhfs = (GoogleHadoopFileSystem)ghfs;
        Path filePath = new Path("bad/path");
        FileNotFoundException exception = (FileNotFoundException)Assert.assertThrows(FileNotFoundException.class, () -> myGhfs.createNonRecursive(filePath, true, 1, (short)1, 1L, () -> {}));
        Truth.assertThat((Throwable)exception).hasMessageThat().startsWith("Can not create");
    }

    @Test
    public void delete_throwsExceptionWhenHadoopPathNull() throws IOException {
        GoogleHadoopFileSystem myGhfs = GoogleHadoopFileSystemTestHelper.createInMemoryGoogleHadoopFileSystem();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> myGhfs.delete(null, true));
        Truth.assertThat((Throwable)exception).hasMessageThat().startsWith("hadoopPath must not be null");
    }

    @Test
    public void listStatus_throwsExceptionWhenHadoopPathNull() throws IOException {
        GoogleHadoopFileSystem myGhfs = GoogleHadoopFileSystemTestHelper.createInMemoryGoogleHadoopFileSystem();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> myGhfs.listStatus((Path)null));
        Truth.assertThat((Throwable)exception).hasMessageThat().startsWith("hadoopPath must not be null");
    }

    @Test
    public void setWorkingDirectory_throwsExceptionWhenHadoopPathNull() throws IOException {
        GoogleHadoopFileSystem myGhfs = GoogleHadoopFileSystemTestHelper.createInMemoryGoogleHadoopFileSystem();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> myGhfs.setWorkingDirectory(null));
        Truth.assertThat((Throwable)exception).hasMessageThat().startsWith("hadoopPath must not be null");
    }

    @Test
    public void mkdirs_throwsExceptionWhenHadoopPathNull() throws IOException {
        GoogleHadoopFileSystem myGhfs = GoogleHadoopFileSystemTestHelper.createInMemoryGoogleHadoopFileSystem();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> myGhfs.mkdirs(null));
        Truth.assertThat((Throwable)exception).hasMessageThat().startsWith("hadoopPath must not be null");
    }

    @Override
    @Test
    public void testCheckPathSuccess() {
        GoogleHadoopFileSystem myGhfs = (GoogleHadoopFileSystem)ghfs;
        String rootBucket = myGhfs.getRootBucketName();
        ArrayList<String> validPaths = new ArrayList<String>();
        validPaths.add("/");
        validPaths.add("/foo");
        validPaths.add("/foo/bar");
        validPaths.add("gs:/");
        validPaths.add("gs:/foo");
        validPaths.add("gs:/foo/bar");
        validPaths.add("gs://");
        validPaths.add("gs://" + rootBucket);
        validPaths.add("gs://" + rootBucket + "/bar");
        for (String validPath : validPaths) {
            Path path = new Path(validPath);
            myGhfs.checkPath(path);
        }
    }

    @Override
    @Test
    public void testCheckPathFailure() {
        GoogleHadoopFileSystem myGhfs = (GoogleHadoopFileSystem)ghfs;
        ArrayList<String> invalidSchemePaths = new ArrayList<String>();
        String rootBucket = myGhfs.getRootBucketName();
        invalidSchemePaths.add("gsg:/");
        invalidSchemePaths.add("hdfs:/");
        invalidSchemePaths.add("gsg:/foo/bar");
        invalidSchemePaths.add("hdfs:/foo/bar");
        invalidSchemePaths.add("gsg://");
        invalidSchemePaths.add("hdfs://");
        invalidSchemePaths.add("gsg://" + rootBucket);
        invalidSchemePaths.add("gsg://" + rootBucket + "/bar");
        for (String invalidPath : invalidSchemePaths) {
            Path path = new Path(invalidPath);
            IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows((String)("Path '" + path + "' should be invalid"), IllegalArgumentException.class, () -> myGhfs.checkPath(path));
            Truth.assertThat((String)e.getLocalizedMessage()).startsWith("Wrong FS scheme:");
        }
        ArrayList<String> invalidBucketPaths = new ArrayList<String>();
        String notRootBucket = "not-" + rootBucket;
        invalidBucketPaths.add("gs://" + notRootBucket);
        invalidBucketPaths.add("gs://" + notRootBucket + "/bar");
        for (String invalidPath : invalidBucketPaths) {
            Path path = new Path(invalidPath);
            IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> myGhfs.checkPath(path));
            Truth.assertThat((String)e.getLocalizedMessage()).startsWith("Wrong bucket:");
        }
    }

    @Test
    public void testDefaultConstructor() {
        new GoogleHadoopFileSystem();
    }

    @Test
    public void testGetHomeDirectory() {
        URI homeDir = ghfs.getHomeDirectory().toUri();
        String scheme = homeDir.getScheme();
        String bucket = homeDir.getAuthority();
        String path = homeDir.getPath();
        Truth.assertWithMessage((String)("Unexpected home directory scheme: " + scheme)).that(scheme).isEqualTo((Object)"gs");
        Truth.assertWithMessage((String)("Unexpected home directory bucket: " + bucket)).that(bucket).isEqualTo((Object)((GoogleHadoopFileSystem)ghfs).getRootBucketName());
        Truth.assertWithMessage((String)("Unexpected home directory path: " + path)).that(Boolean.valueOf(path.startsWith("/user/"))).isTrue();
    }

    @Test
    public void testGetHadoopPathInvalidArgs() throws URISyntaxException {
        IllegalArgumentException expected = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> ((GoogleHadoopFileSystem)ghfs).getHadoopPath(new URI("gs://foobucket/bar")));
        Truth.assertThat((Throwable)expected).hasMessageThat().startsWith("Authority of URI");
    }

    @Test
    public void testBuildOptionsFromConfig() {
        Configuration config = GoogleHadoopFileSystemIntegrationTest.loadConfig("projectId", "serviceAccount", "priveKeyFile");
        GoogleCloudStorageFileSystemOptions.Builder optionsBuilder = GoogleHadoopFileSystemConfiguration.getGcsFsOptionsBuilder((Configuration)config);
        GoogleCloudStorageFileSystemOptions options = optionsBuilder.build();
        GoogleCloudStorageOptions gcsOptions = options.getCloudStorageOptions();
        Truth.assertThat((Boolean)gcsOptions.isAutoRepairImplicitDirectoriesEnabled()).isTrue();
        config.setBoolean(GoogleHadoopFileSystemConfiguration.GCS_REPAIR_IMPLICIT_DIRECTORIES_ENABLE.getKey(), false);
        optionsBuilder = GoogleHadoopFileSystemConfiguration.getGcsFsOptionsBuilder((Configuration)config);
        options = optionsBuilder.build();
        gcsOptions = options.getCloudStorageOptions();
        Truth.assertThat((Boolean)gcsOptions.isAutoRepairImplicitDirectoriesEnabled()).isFalse();
    }

    @Override
    @Test
    public void testInitializeSuccess() throws IOException {
        Configuration config = GoogleHadoopFileSystemIntegrationTest.loadConfig();
        long blockSize = 1024L;
        config.setLong(GoogleHadoopFileSystemConfiguration.BLOCK_SIZE.getKey(), blockSize);
        String rootBucketName = ghfsHelper.getUniqueBucketName("initialize-root");
        URI initUri = new Path("gs://" + rootBucketName).toUri();
        GoogleHadoopFileSystem fs = new GoogleHadoopFileSystem();
        fs.initialize(initUri, config);
        GoogleCloudStorageOptions cloudStorageOptions = fs.getGcsFs().getOptions().getCloudStorageOptions();
        Truth.assertThat((Long)fs.getDefaultBlockSize()).isEqualTo((Object)blockSize);
        Truth.assertThat((Comparable)fs.initUri).isEqualTo((Object)initUri);
        Truth.assertThat((String)fs.getRootBucketName()).isEqualTo((Object)rootBucketName);
    }

    @Test
    public void testInitializeSucceedsWhenNoProjectIdConfigured() throws URISyntaxException, IOException {
        Configuration config = GoogleHadoopFileSystemIntegrationTest.loadConfig();
        config.unset(GoogleHadoopFileSystemConfiguration.GCS_PROJECT_ID.getKey());
        URI gsUri = new Path("gs://foo").toUri();
        new GoogleHadoopFileSystem().initialize(gsUri, config);
    }

    @Test
    public void testInitializeThrowsWhenWrongSchemeConfigured() throws URISyntaxException, IOException {
        URI wrongScheme = new URI("http://foo/bar");
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> new GoogleHadoopFileSystem().initialize(wrongScheme, new Configuration()));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"URI scheme not supported");
    }

    @Test
    public void testInitializeThrowsWhenCredentialsNotFound() throws URISyntaxException, IOException {
        IllegalArgumentException thrown;
        URI gsUri = new URI("gs://foobar/");
        String fakeProjectId = "123456";
        Configuration config = new Configuration();
        config.setBoolean("fs.gs" + HadoopCredentialConfiguration.ENABLE_SERVICE_ACCOUNTS_SUFFIX.getKey(), false);
        config.set(GoogleHadoopFileSystemConfiguration.GCS_PROJECT_ID.getKey(), fakeProjectId);
        GoogleHadoopFileSystem ghfs = new GoogleHadoopFileSystem();
        if (((Boolean)GoogleHadoopFileSystemConfiguration.GCS_LAZY_INITIALIZATION_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).booleanValue()) {
            ghfs.initialize(gsUri, config);
            thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> ((GoogleHadoopFileSystem)ghfs).getGcsFs());
        } else {
            thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> ghfs.initialize(gsUri, config));
        }
        Truth.assertThat((Throwable)thrown).hasMessageThat().startsWith("No valid credential configuration discovered:");
    }

    @Override
    @Test
    public void testInitializeWithWorkingDirectory() throws Exception {
        GoogleHadoopFileSystem myGhfs = (GoogleHadoopFileSystem)ghfs;
        Configuration config = GoogleHadoopFileSystemIntegrationTest.loadConfig();
        ghfs.initialize(myGhfs.initUri, config);
        List<HadoopFileSystemTestBase.WorkingDirData> wddList = this.setUpWorkingDirectoryTest();
        String rootBucketName = myGhfs.getRootBucketName();
        for (HadoopFileSystemTestBase.WorkingDirData wdd : wddList) {
            Path path = wdd.path;
            Path expectedWorkingDir = wdd.expectedPath;
            Path currentWorkingDir = ghfs.getWorkingDirectory();
            config.set(GoogleHadoopFileSystemConfiguration.GCS_WORKING_DIRECTORY.getKey(), path.toString());
            ghfs.initialize(myGhfs.initUri, config);
            Path newWorkingDir = ghfs.getWorkingDirectory();
            if (expectedWorkingDir != null) {
                Truth.assertThat((Comparable)newWorkingDir).isEqualTo((Object)expectedWorkingDir);
                continue;
            }
            Truth.assertThat((Comparable)newWorkingDir).isEqualTo((Object)currentWorkingDir);
        }
        Truth.assertThat((String)ghfs.getHomeDirectory().toString()).startsWith("gs://" + rootBucketName);
    }

    @Override
    @Test
    public void testConfigureBucketsSuccess() throws IOException {
        String rootBucketName = "gs://" + ghfsHelper.getUniqueBucketName("configure-root");
        URI initUri = new Path(rootBucketName).toUri();
        GoogleCloudStorageFileSystem fakeGcsFs = new GoogleCloudStorageFileSystem(InMemoryGoogleCloudStorage::new, GoogleCloudStorageFileSystemOptions.builder().setCloudStorageOptions(InMemoryGoogleCloudStorage.getInMemoryGoogleCloudStorageOptions()).build());
        GoogleHadoopFileSystem fs = new GoogleHadoopFileSystem(fakeGcsFs);
        fs.initUri = initUri;
        fs.configureBuckets(fakeGcsFs);
        Truth.assertThat((Comparable)fs.initUri).isEqualTo((Object)initUri);
        initUri = new Path("gs://" + GoogleHadoopFileSystemIntegrationTest.ghfsHelper.sharedBucketName1 + "/foo").toUri();
        fs = new GoogleHadoopFileSystem(fakeGcsFs);
        fs.initUri = initUri;
        fs.configureBuckets(fakeGcsFs);
        Truth.assertThat((Comparable)fs.initUri).isEqualTo((Object)initUri);
        Truth.assertThat((String)fs.getRootBucketName()).isEqualTo((Object)initUri.getAuthority());
    }

    @Override
    @Test
    public void testConfigureBucketsWithRootBucketButNoSystemBucket() throws IOException {
        String rootBucketName = ghfsHelper.getUniqueBucketName("configure-root");
        URI initUri = new Path("gs://" + rootBucketName).toUri();
        GoogleCloudStorageFileSystem fakeGcsFs = new GoogleCloudStorageFileSystem(InMemoryGoogleCloudStorage::new, GoogleCloudStorageFileSystemOptions.builder().setCloudStorageOptions(InMemoryGoogleCloudStorage.getInMemoryGoogleCloudStorageOptions()).build());
        GoogleHadoopFileSystem fs = new GoogleHadoopFileSystem(fakeGcsFs);
        fs.initUri = initUri;
        fs.configureBuckets(fakeGcsFs);
        Truth.assertThat((Comparable)fs.initUri).isEqualTo((Object)initUri);
    }

    @Override
    @Test
    public void testConfigureBucketsWithNeitherRootBucketNorSystemBucket() throws IOException {
        URI initUri = new Path("gs://").toUri();
        GoogleCloudStorageFileSystem fakeGcsFs = new GoogleCloudStorageFileSystem(InMemoryGoogleCloudStorage::new, GoogleCloudStorageFileSystemOptions.builder().setCloudStorageOptions(InMemoryGoogleCloudStorage.getInMemoryGoogleCloudStorageOptions()).build());
        GoogleHadoopFileSystem fs = new GoogleHadoopFileSystem(fakeGcsFs);
        fs.initUri = initUri;
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> fs.configureBuckets(fakeGcsFs));
        Truth.assertThat((Throwable)thrown).hasMessageThat().isEqualTo((Object)"No bucket specified in GCS URI: gs:/");
    }

    private static Configuration getConfigurationWithImplementation() {
        Configuration conf = GoogleHadoopFileSystemIntegrationTest.loadConfig();
        conf.set("fs.gs.impl", GoogleHadoopFileSystem.class.getCanonicalName());
        return conf;
    }

    @Test
    public void testFileSystemIsRemovedFromCacheOnClose() throws IOException, URISyntaxException {
        Configuration conf = GoogleHadoopFileSystemIntegrationTest.getConfigurationWithImplementation();
        URI fsUri = new URI(String.format("gs://%s/", sharedBucketName1));
        FileSystem fs1 = FileSystem.get((URI)fsUri, (Configuration)conf);
        FileSystem fs2 = FileSystem.get((URI)fsUri, (Configuration)conf);
        Truth.assertThat((Object)fs2).isSameInstanceAs((Object)fs1);
        fs1.close();
        FileSystem fs3 = FileSystem.get((URI)fsUri, (Configuration)conf);
        Truth.assertThat((Object)fs3).isNotSameInstanceAs((Object)fs1);
        fs3.close();
    }

    @Test
    public void testIOExceptionIsThrowAfterClose() throws IOException, URISyntaxException {
        Configuration conf = GoogleHadoopFileSystemIntegrationTest.getConfigurationWithImplementation();
        URI fsUri = new URI(String.format("gs://%s/", sharedBucketName1));
        FileSystem fs1 = FileSystem.get((URI)fsUri, (Configuration)conf);
        FileSystem fs2 = FileSystem.get((URI)fsUri, (Configuration)conf);
        Truth.assertThat((Object)fs2).isSameInstanceAs((Object)fs1);
        fs1.close();
        Assert.assertThrows(IOException.class, () -> fs2.exists(new Path("/SomePath/That/Doesnt/Matter")));
    }

    public void createFile(Path filePath, byte[] data) throws IOException {
        try (FSDataOutputStream output = ghfs.create(filePath);){
            output.write(data);
        }
    }

    @Test
    public void testGlobStatusPathExpansionAndFilter() throws IOException {
        Path testRoot = new Path(ghfs.getWorkingDirectory(), "testGlobStatusPathExpansionAndFilter");
        byte[] data = "testGlobStatusPathExpansionAndFilter_data".getBytes(StandardCharsets.UTF_8);
        this.createFile(testRoot.suffix("/date/2020/07/17/0/file1.xml"), data);
        this.createFile(testRoot.suffix("/date/2020/07/17/0/file1.json"), data);
        this.createFile(testRoot.suffix("/date/2020/07/18/0/file2.xml"), data);
        this.createFile(testRoot.suffix("/date/2020/07/18/0/file2.json"), data);
        this.createFile(testRoot.suffix("/date/2020/07/19/0/file3.xml"), data);
        this.createFile(testRoot.suffix("/date/2020/07/19/0/file3.json"), data);
        this.createFile(testRoot.suffix("/date/2020/07/20/0/file4.xml"), data);
        this.createFile(testRoot.suffix("/date/2020/07/20/0/file4.json"), data);
        FileStatus[] files = ghfs.globStatus(testRoot.suffix("/*/{2020/07/17,2020/07/18,2020/07/19}/*/*"), path -> path.getName().endsWith(".json"));
        Path workingDirRoot = new Path(ghfs.getWorkingDirectory(), testRoot);
        Truth.assertThat((Iterable)((Iterable)Arrays.stream(files).map(FileStatus::getPath).collect(ImmutableList.toImmutableList()))).containsExactly(new Object[]{workingDirRoot.suffix("/date/2020/07/17/0/file1.json"), workingDirRoot.suffix("/date/2020/07/18/0/file2.json"), workingDirRoot.suffix("/date/2020/07/19/0/file3.json")});
        Truth.assertThat((Boolean)ghfs.delete(testRoot, true)).isTrue();
    }

    @Test
    public void testGlobStatus() throws IOException {
        Path testRoot = new Path("/directory1/");
        ghfs.mkdirs(testRoot);
        ghfs.mkdirs(new Path("/directory1/subdirectory1"));
        ghfs.mkdirs(new Path("/directory1/subdirectory2"));
        byte[] data = "data".getBytes(StandardCharsets.UTF_8);
        this.createFile(new Path("/directory1/subdirectory1/file1"), data);
        this.createFile(new Path("/directory1/subdirectory1/file2"), data);
        this.createFile(new Path("/directory1/subdirectory2/file1"), data);
        this.createFile(new Path("/directory1/subdirectory2/file2"), data);
        Object[] rootDirectories = ghfs.globStatus(new Path("/d*"));
        Truth.assertThat((Object[])rootDirectories).hasLength(1);
        Truth.assertThat((String)rootDirectories[0].getPath().getName()).isEqualTo((Object)"directory1");
        Object[] subDirectories = ghfs.globStatus(new Path("/directory1/s*"));
        Truth.assertThat((Object[])subDirectories).hasLength(2);
        Object[] subDirectory1Files = ghfs.globStatus(new Path("/directory1/subdirectory1/*"));
        Truth.assertThat((Object[])subDirectory1Files).hasLength(2);
        Truth.assertThat((String)subDirectory1Files[0].getPath().getName()).isEqualTo((Object)"file1");
        Truth.assertThat((String)subDirectory1Files[1].getPath().getName()).isEqualTo((Object)"file2");
        Object[] subDirectory2Files = ghfs.globStatus(new Path("/directory1/subdirectory2/f*"));
        Truth.assertThat((Object[])subDirectory2Files).hasLength(2);
        Truth.assertThat((String)subDirectory2Files[0].getPath().getName()).isEqualTo((Object)"file1");
        Truth.assertThat((String)subDirectory2Files[1].getPath().getName()).isEqualTo((Object)"file2");
        Object[] subDirectory2Files2 = ghfs.globStatus(new Path("/directory1/subdirectory2/file?"));
        Truth.assertThat((Object[])subDirectory2Files2).hasLength(2);
        Truth.assertThat((String)subDirectory2Files2[0].getPath().getName()).isEqualTo((Object)"file1");
        Truth.assertThat((String)subDirectory2Files2[1].getPath().getName()).isEqualTo((Object)"file2");
        Object[] subDirectory2Files3 = ghfs.globStatus(new Path("/directory1/subdirectory2/file[0-9]"));
        Truth.assertThat((Object[])subDirectory2Files3).hasLength(2);
        Truth.assertThat((String)subDirectory2Files3[0].getPath().getName()).isEqualTo((Object)"file1");
        Truth.assertThat((String)subDirectory2Files3[1].getPath().getName()).isEqualTo((Object)"file2");
        Object[] subDirectory2Files4 = ghfs.globStatus(new Path("/directory1/subdirectory2/file[^1]"));
        Truth.assertThat((Object[])subDirectory2Files4).hasLength(1);
        Truth.assertThat((String)subDirectory2Files4[0].getPath().getName()).isEqualTo((Object)"file2");
        Object[] subDirectory2Files5 = ghfs.globStatus(new Path("/directory1/subdirectory2/file{1,2}"));
        Truth.assertThat((Object[])subDirectory2Files5).hasLength(2);
        Truth.assertThat((String)subDirectory2Files5[0].getPath().getName()).isEqualTo((Object)"file1");
        Truth.assertThat((String)subDirectory2Files5[1].getPath().getName()).isEqualTo((Object)"file2");
        Truth.assertThat((Boolean)ghfs.delete(testRoot, true)).isTrue();
    }

    @Test
    public void getFileStatus_throwsExceptionWhenHadoopPathNull() {
        GoogleHadoopFileSystem myGhfs = new GoogleHadoopFileSystem();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> myGhfs.getFileStatus(null));
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)"hadoopPath must not be null");
    }

    @Test
    public void getFileStatus_throwsExceptionWhenFileInfoDontExists() throws IOException {
        URI fileUri = GoogleCloudStorageFileSystemIntegrationTest.getTempFilePath();
        Path filePath = ghfsHelper.castAsHadoopPath(fileUri);
        FileNotFoundException e = (FileNotFoundException)Assert.assertThrows(FileNotFoundException.class, () -> ghfs.getFileStatus(filePath));
        Truth.assertThat((Throwable)e).hasMessageThat().startsWith("File not found");
    }

    @Test
    public void testConfigurablePermissions() throws IOException {
        String testPermissions = "777";
        Configuration conf = GoogleHadoopFileSystemIntegrationTest.getConfigurationWithImplementation();
        conf.set(GoogleHadoopFileSystemConfiguration.PERMISSIONS_TO_REPORT.getKey(), testPermissions);
        GoogleHadoopFileSystem myGhfs = new GoogleHadoopFileSystem();
        myGhfs.initialize(ghfs.getUri(), conf);
        URI fileUri = GoogleCloudStorageFileSystemIntegrationTest.getTempFilePath();
        Path filePath = ghfsHelper.castAsHadoopPath(fileUri);
        ghfsHelper.writeFile(filePath, "foo", 1, true);
        FileStatus status = myGhfs.getFileStatus(filePath);
        Truth.assertThat((Object)status.getPermission()).isEqualTo((Object)new FsPermission(testPermissions));
        Truth.assertThat((Boolean)ghfs.delete(filePath, true)).isTrue();
    }

    @Test
    public void testFileStatusUser() throws Exception {
        String ugiUser = UUID.randomUUID().toString();
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)ugiUser);
        Configuration conf = GoogleHadoopFileSystemIntegrationTest.getConfigurationWithImplementation();
        GoogleHadoopFileSystem myGhfs = new GoogleHadoopFileSystem();
        myGhfs.initialize(ghfs.getUri(), conf);
        URI fileUri = GoogleCloudStorageFileSystemIntegrationTest.getTempFilePath();
        Path filePath = ghfsHelper.castAsHadoopPath(fileUri);
        ghfsHelper.writeFile(filePath, "foo", 1, true);
        FileStatus status = (FileStatus)ugi.doAs(() -> myGhfs.getFileStatus(filePath));
        Truth.assertThat((String)status.getOwner()).isEqualTo((Object)ugiUser);
        Truth.assertThat((String)status.getGroup()).isEqualTo((Object)ugiUser);
        Truth.assertThat((Boolean)ghfs.delete(filePath, true)).isTrue();
    }

    @Test
    public void append_throwsExceptionWhenHadooptPathNull() {
        GoogleHadoopFileSystem myGhfs = new GoogleHadoopFileSystem();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> myGhfs.append(null, ((Integer)GoogleHadoopFileSystemConfiguration.GCS_OUTPUT_STREAM_BUFFER_SIZE.getDefault()).intValue(), () -> {}));
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)"hadoopPath must not be null");
    }

    @Test
    public void testConcat() throws IOException {
        Path directory = new Path(ghfs.getWorkingDirectory(), "testConcat");
        long expectedLength = 0L;
        ArrayList<Path> files = new ArrayList<Path>();
        for (int i = 0; i < 3; ++i) {
            Path file = new Path(directory, String.format("file-%s", UUID.randomUUID()));
            ghfsHelper.writeFile(file, "data_" + file, 1, false);
            files.add(file);
            expectedLength += ghfs.getFileStatus(file).getLen();
        }
        Path target = new Path(directory, "target");
        ghfsHelper.writeFile(target, new byte[0], 1, false);
        ghfs.concat(target, files.toArray(new Path[0]));
        Truth.assertThat((Long)ghfs.getFileStatus(target).getLen()).isEqualTo((Object)expectedLength);
        Truth.assertThat((Boolean)ghfs.delete(directory, true)).isTrue();
    }

    @Test
    public void concat_throwsExceptionWhenSourceAreEmpty() {
        GoogleHadoopFileSystem myGhfs = new GoogleHadoopFileSystem();
        Path directory = new Path(String.format("gs://%s/testConcat_exception/", myGhfs.getRootBucketName()));
        Path target = new Path(directory, "target");
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> myGhfs.concat(target, new Path[0]));
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)"srcs must have at least one source");
    }

    @Test
    public void concat_throwsExceptionWhenTargetDirectoryInSources() throws IOException {
        GoogleHadoopFileSystem myGhfs = GoogleHadoopFileSystemTestHelper.createInMemoryGoogleHadoopFileSystem();
        Path directory = new Path(String.format("gs://%s/testConcat_exception/", myGhfs.getRootBucketName()));
        Path target = new Path(directory, "target");
        Path[] srcsWithTarget = new Path[]{target};
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> myGhfs.concat(target, srcsWithTarget));
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)"target must not be contained in sources");
    }

    @Test
    public void rename_throwExceptionWhenDstNul() {
        GoogleHadoopFileSystem myGhfs = new GoogleHadoopFileSystem();
        Path directory = new Path(String.format("gs://%s/testRename/", myGhfs.getRootBucketName()));
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> myGhfs.rename(directory, null));
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)"dst must not be null");
    }

    @Test
    public void rename_throwExceptionWhenSrcNull() {
        GoogleHadoopFileSystem myGhfs = new GoogleHadoopFileSystem();
        Path directory = new Path(String.format("gs://%s/testRename/", myGhfs.getRootBucketName()));
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> myGhfs.rename(null, directory));
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)"src must not be null");
    }

    @Test
    public void fileChecksum_throwsExceptionWHenHadoopPathAsNull() {
        GoogleHadoopFileSystem myGhfs = new GoogleHadoopFileSystem();
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> myGhfs.getFileChecksum(null));
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)"hadoopPath must not be null");
    }

    @Test
    public void fileChecksum_throwsExceptionWhenFileNotFound() throws Exception {
        URI fileUri = GoogleCloudStorageFileSystemIntegrationTest.getTempFilePath();
        Path filePath = ghfsHelper.castAsHadoopPath(fileUri);
        FileNotFoundException e = (FileNotFoundException)Assert.assertThrows(FileNotFoundException.class, () -> ghfs.getFileChecksum(filePath));
        Truth.assertThat((Throwable)e).hasMessageThat().startsWith("File not found");
    }

    @Test
    public void testCrc32cFileChecksum() throws Exception {
        GoogleHadoopFileSystemIntegrationTest.testFileChecksum(GoogleHadoopFileSystemBase.GcsFileChecksumType.CRC32C, content -> Ints.toByteArray((int)Hashing.crc32c().hashString((CharSequence)content, StandardCharsets.UTF_8).asInt()));
    }

    @Test
    public void testMd5FileChecksum() throws Exception {
        GoogleHadoopFileSystemIntegrationTest.testFileChecksum(GoogleHadoopFileSystemBase.GcsFileChecksumType.MD5, content -> Hashing.md5().hashString((CharSequence)content, StandardCharsets.UTF_8).asBytes());
    }

    private static void testFileChecksum(GoogleHadoopFileSystemBase.GcsFileChecksumType checksumType, Function<String, byte[]> checksumFn) throws Exception {
        Configuration config = GoogleHadoopFileSystemIntegrationTest.getConfigurationWithImplementation();
        config.set("fs.gs.checksum.type", checksumType.name());
        GoogleHadoopFileSystem myGhfs = new GoogleHadoopFileSystem();
        myGhfs.initialize(ghfs.getUri(), config);
        URI fileUri = GoogleCloudStorageFileSystemIntegrationTest.getTempFilePath();
        Path filePath = ghfsHelper.castAsHadoopPath(fileUri);
        String fileContent = "foo-testFileChecksum-" + checksumType;
        ghfsHelper.writeFile(filePath, fileContent, 1, true);
        FileChecksum fileChecksum = myGhfs.getFileChecksum(filePath);
        Truth.assertThat((String)fileChecksum.getAlgorithmName()).isEqualTo((Object)checksumType.getAlgorithmName());
        Truth.assertThat((Integer)fileChecksum.getLength()).isEqualTo((Object)checksumType.getByteLength());
        Truth.assertThat((byte[])fileChecksum.getBytes()).isEqualTo((Object)checksumFn.apply(fileContent));
        Truth.assertThat((String)fileChecksum.toString()).contains((CharSequence)String.format("%s: ", checksumType.getAlgorithmName()));
        Truth.assertThat((Boolean)ghfs.delete(filePath, true)).isTrue();
    }

    @Test
    public void testInitializeWithEmptyWorkingDirectory_shouldHaveUserSpecificWorkingDirectory() throws IOException {
        GoogleHadoopFileSystem myGhfs = (GoogleHadoopFileSystem)ghfs;
        Configuration config = myGhfs.getConf();
        config.unset(GoogleHadoopFileSystemConfiguration.GCS_WORKING_DIRECTORY.getKey());
        ghfs.initialize(myGhfs.initUri, config);
        String expectedHomeDir = String.format("gs://%s/user/%s", myGhfs.getRootBucketName(), StandardSystemProperty.USER_NAME.value());
        Truth.assertThat((String)ghfs.getHomeDirectory().toString()).startsWith(expectedHomeDir);
    }

    @Test
    public void testGlobStatusOptions_directoriesNamesShouldBeConsistent() throws IOException {
        this.testGlobStatusFlatConcurrent(GoogleHadoopFileSystemBase.GlobAlgorithm.CONCURRENT);
        this.testGlobStatusFlatConcurrent(GoogleHadoopFileSystemBase.GlobAlgorithm.DEFAULT);
        this.testGlobStatusFlatConcurrent(GoogleHadoopFileSystemBase.GlobAlgorithm.FLAT);
    }

    private void testGlobStatusFlatConcurrent(GoogleHadoopFileSystemBase.GlobAlgorithm globAlgorithm) throws IOException {
        Configuration configuration = ghfs.getConf();
        configuration.setEnum(GoogleHadoopFileSystemConfiguration.GCS_GLOB_ALGORITHM.getKey(), (Enum)globAlgorithm);
        ghfs.initialize(ghfs.getUri(), configuration);
        Path testRoot = new Path("/directory1/");
        ghfs.mkdirs(testRoot);
        ghfs.mkdirs(new Path("/directory1/subdirectory1"));
        this.createFile(new Path("/directory1/subdirectory1/file1"), "data".getBytes(StandardCharsets.UTF_8));
        FileStatus[] rootDirStatuses = ghfs.globStatus(new Path("/d*"));
        List rootDirs = (List)Arrays.stream(rootDirStatuses).map(d -> d.getPath().toString()).collect(ImmutableList.toImmutableList());
        Truth.assertThat((Iterable)rootDirs).containsExactly(new Object[]{ghfs.getWorkingDirectory() + "directory1"});
        Truth.assertThat((Boolean)ghfs.delete(testRoot, true)).isTrue();
    }

    @Test
    public void testCreateFSDataOutputStream() {
        Assert.assertThrows((String)"hadoopPath must not be null", IllegalArgumentException.class, () -> ghfs.create(null));
        Assert.assertThrows((String)"replication must be a positive integer: -1", IllegalArgumentException.class, () -> ghfs.create(new Path("/directory1/"), (short)-1));
        Assert.assertThrows((String)"blockSize must be a positive integer: -1", IllegalArgumentException.class, () -> ghfs.create(new Path("/directory1/"), true, -1, (short)1, -1L));
    }

    @Test
    public void testRenameNullFile() {
        Path path = new Path("/directory1/");
        Assert.assertThrows((String)"src must not be null", IllegalArgumentException.class, () -> ghfs.rename(null, path));
        Assert.assertThrows((String)"dst must not be null", IllegalArgumentException.class, () -> ghfs.rename(path, null));
    }

    @Test
    public void testListStatusNull() {
        Assert.assertThrows((String)"hadoopPath must not be null", IllegalArgumentException.class, () -> ghfs.listStatus((Path)null));
    }

    @Test
    public void testSetWorkingDirectoryNull() {
        Assert.assertThrows((String)"hadoopPath must not be null", IllegalArgumentException.class, () -> ghfs.setWorkingDirectory(null));
    }

    @Test
    public void testGlobStatusWithNewUriScheme() throws IOException {
        Path globRoot = new Path("/newuriencoding_globs/");
        ghfs.mkdirs(globRoot);
        ghfs.mkdirs(new Path("/newuriencoding_globs/subdirectory1"));
        ghfs.mkdirs(new Path("/newuriencoding_globs/#this#is#a&subdir/"));
        byte[] data = new byte[10];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)i;
        }
        this.createFile(new Path("/newuriencoding_globs/subdirectory1/file1"), data);
        this.createFile(new Path("/newuriencoding_globs/subdirectory1/file2"), data);
        this.createFile(new Path("/newuriencoding_globs/#this#is#a&subdir/file1"), data);
        this.createFile(new Path("/newuriencoding_globs/#this#is#a&subdir/file2"), data);
        this.createFile(new Path("/newuriencoding_globs/#this#is#a&subdir/file2"), data);
        Object[] rootDirectories = ghfs.globStatus(new Path("/new*"));
        Truth.assertThat((Object[])rootDirectories).hasLength(1);
        Truth.assertThat((String)rootDirectories[0].getPath().getName()).isEqualTo((Object)"newuriencoding_globs");
        Object[] subDirectories = ghfs.globStatus(new Path("/newuriencoding_globs/s*"));
        Truth.assertThat((Object[])subDirectories).hasLength(1);
        Truth.assertThat((String)subDirectories[0].getPath().getName()).isEqualTo((Object)"subdirectory1");
        Object[] subDirectories2 = ghfs.globStatus(new Path("/newuriencoding_globs/#this*"));
        Truth.assertThat((Object[])subDirectories2).hasLength(1);
        Truth.assertThat((String)subDirectories2[0].getPath().getName()).isEqualTo((Object)"#this#is#a&subdir");
        Object[] subDirectories3 = ghfs.globStatus(new Path("/newuriencoding_globs/#this?is?a&*"));
        Truth.assertThat((Object[])subDirectories3).hasLength(1);
        Truth.assertThat((String)subDirectories3[0].getPath().getName()).isEqualTo((Object)"#this#is#a&subdir");
        Object[] subDirectory1Files = ghfs.globStatus(new Path("/newuriencoding_globs/subdirectory1/*"));
        Truth.assertThat((Object[])subDirectory1Files).hasLength(2);
        Truth.assertThat((String)subDirectory1Files[0].getPath().getName()).isEqualTo((Object)"file1");
        Truth.assertThat((String)subDirectory1Files[1].getPath().getName()).isEqualTo((Object)"file2");
        Object[] subDirectory2Files = ghfs.globStatus(new Path("/newuriencoding_globs/#this#is#a&subdir/f*"));
        Truth.assertThat((Object[])subDirectory2Files).hasLength(2);
        Truth.assertThat((String)subDirectory2Files[0].getPath().getName()).isEqualTo((Object)"file1");
        Truth.assertThat((String)subDirectory2Files[1].getPath().getName()).isEqualTo((Object)"file2");
        Object[] subDirectory2Files2 = ghfs.globStatus(new Path("/newuriencoding_globs/#this#is#a&subdir/file?"));
        Truth.assertThat((Object[])subDirectory2Files2).hasLength(2);
        Truth.assertThat((String)subDirectory2Files2[0].getPath().getName()).isEqualTo((Object)"file1");
        Truth.assertThat((String)subDirectory2Files2[1].getPath().getName()).isEqualTo((Object)"file2");
        Object[] subDirectory2Files3 = ghfs.globStatus(new Path("/newuriencoding_globs/#this#is#a&subdir/file[0-9]"));
        Truth.assertThat((Object[])subDirectory2Files3).hasLength(2);
        Truth.assertThat((String)subDirectory2Files3[0].getPath().getName()).isEqualTo((Object)"file1");
        Truth.assertThat((String)subDirectory2Files3[1].getPath().getName()).isEqualTo((Object)"file2");
        Object[] subDirectory2Files4 = ghfs.globStatus(new Path("/newuriencoding_globs/#this#is#a&subdir/file[^1]"));
        Truth.assertThat((Object[])subDirectory2Files4).hasLength(1);
        Truth.assertThat((String)subDirectory2Files4[0].getPath().getName()).isEqualTo((Object)"file2");
        Object[] subDirectory2Files5 = ghfs.globStatus(new Path("/newuriencoding_globs/#this#is#a&subdir/file{1,2}"));
        Truth.assertThat((Object[])subDirectory2Files5).hasLength(2);
        Truth.assertThat((String)subDirectory2Files5[0].getPath().getName()).isEqualTo((Object)"file1");
        Truth.assertThat((String)subDirectory2Files5[1].getPath().getName()).isEqualTo((Object)"file2");
        ghfs.delete(globRoot, true);
    }

    @Test
    public void testPathsOnlyValidInNewUriScheme() throws IOException {
        GoogleHadoopFileSystem typedFs = (GoogleHadoopFileSystem)ghfs;
        Path directory = new Path(String.format("gs://%s/testPathsOnlyValidInNewUriScheme/", typedFs.getRootBucketName()));
        Path p = new Path(directory, "foo#bar#baz");
        Assert.assertThrows(FileNotFoundException.class, () -> ghfs.getFileStatus(p));
        ghfsHelper.writeFile(p, "SomeText", 100, false);
        FileStatus status = ghfs.getFileStatus(p);
        Truth.assertThat((Comparable)status.getPath()).isEqualTo((Object)p);
        ghfs.delete(directory, true);
    }

    @Override
    public void testGetGcsPath() throws URISyntaxException {
        GoogleHadoopFileSystem myghfs = (GoogleHadoopFileSystem)ghfs;
        URI gcsPath = new URI("gs://" + myghfs.getRootBucketName() + "/dir/obj");
        URI convertedPath = myghfs.getGcsPath(new Path(gcsPath));
        Truth.assertThat((Comparable)convertedPath).isEqualTo((Object)gcsPath);
        myghfs.getGcsPath(new Path("/buck^et", "object"));
        Assert.assertThrows(IllegalArgumentException.class, () -> myghfs.getGcsPath(new Path("gs://buck^et/object")));
    }

    @Test
    public void unauthenticatedAccessToPublicBuckets_fsGsProperties() throws Exception {
        String publicBucket = "gs://gcp-public-data-landsat";
        Configuration config = new Configuration();
        config.setBoolean("fs.gs.auth.service.account.enable", false);
        config.setBoolean("fs.gs.auth.null.enable", true);
        FileSystem fs = FileSystem.get((URI)new URI(publicBucket), (Configuration)config);
        Object[] fileStatuses = fs.listStatus(new Path(publicBucket));
        Truth.assertThat((Object[])fileStatuses).isNotEmpty();
    }

    @Test
    public void unauthenticatedAccessToPublicBuckets_googleCloudProperties() throws Exception {
        String publicBucket = "gs://gcp-public-data-landsat";
        Configuration config = new Configuration();
        config.setBoolean("google.cloud.auth.service.account.enable", false);
        config.setBoolean("google.cloud.auth.null.enable", true);
        FileSystem fs = FileSystem.get((URI)new URI(publicBucket), (Configuration)config);
        Object[] fileStatuses = fs.listStatus(new Path(publicBucket));
        Truth.assertThat((Object[])fileStatuses).isNotEmpty();
    }
}

