/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFS;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemConfiguration;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemIntegrationHelper;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemIntegrationHelper;
import com.google.common.truth.Truth;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.DirectoryNotEmptyException;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GoogleHadoopFSIntegrationTest {
    private static GoogleCloudStorageFileSystemIntegrationHelper gcsFsIHelper;
    private static URI initUri;

    @BeforeClass
    public static void beforeClass() throws Exception {
        gcsFsIHelper = GoogleCloudStorageFileSystemIntegrationHelper.create();
        gcsFsIHelper.beforeAllTests();
        initUri = new URI("gs://" + GoogleHadoopFSIntegrationTest.gcsFsIHelper.sharedBucketName1);
    }

    @AfterClass
    public static void afterClass() {
        gcsFsIHelper.afterAllTests();
    }

    @After
    public void after() throws IOException {
        FileSystem.closeAll();
    }

    @Test
    public void testInitializationWithUriAndConf_shouldGiveFsStatusWithNotUsedMemory() throws IOException, URISyntaxException {
        Configuration config = GoogleHadoopFileSystemIntegrationHelper.getTestConfig();
        GoogleHadoopFS ghfs = new GoogleHadoopFS(initUri, config);
        Truth.assertThat((Long)ghfs.getFsStatus().getUsed()).isEqualTo((Object)0);
    }

    @Test
    public void testInitializationWithGhfsUriAndConf_shouldGiveFsStatusWithNotUsedMemory() throws IOException, URISyntaxException {
        Configuration config = GoogleHadoopFileSystemIntegrationHelper.getTestConfig();
        GoogleHadoopFS ghfs = new GoogleHadoopFS(new GoogleHadoopFileSystem(), initUri, config);
        Truth.assertThat((Long)ghfs.getFsStatus().getUsed()).isEqualTo((Object)0);
    }

    @Test
    public void testCreateInternal_shouldCreateParent() throws Exception {
        Configuration config = GoogleHadoopFileSystemIntegrationHelper.getTestConfig();
        GoogleHadoopFS ghfs = new GoogleHadoopFS(initUri, config);
        Path filePath = new Path(initUri.resolve("/testCreateInternal_shouldCreateParent/dir/file").toString());
        try (FSDataOutputStream stream = ghfs.createInternal(filePath, EnumSet.of(CreateFlag.CREATE), null, 128, (short)1, 32L, () -> {}, new Options.ChecksumOpt(), true);){
            stream.write(1);
            Truth.assertThat((Integer)stream.size()).isEqualTo((Object)1);
        }
        FileStatus parentStatus = ghfs.getFileStatus(filePath.getParent());
        Truth.assertThat((Long)parentStatus.getModificationTime()).isEqualTo((Object)0L);
    }

    @Test
    public void testCreateInternal_shouldNotCreateParent() throws Exception {
        Configuration config = GoogleHadoopFileSystemIntegrationHelper.getTestConfig();
        GoogleHadoopFS ghfs = new GoogleHadoopFS(initUri, config);
        Path filePath = new Path(initUri.resolve("/testCreateInternal_shouldNotCreateParent/dir/file").toString());
        try (FSDataOutputStream stream = ghfs.createInternal(filePath, EnumSet.of(CreateFlag.CREATE), null, 128, (short)1, 32L, () -> {}, new Options.ChecksumOpt(), false);){
            stream.write(1);
            Truth.assertThat((Integer)stream.size()).isEqualTo((Object)1);
        }
        FileStatus parentStatus = ghfs.getFileStatus(filePath.getParent().getParent());
        Truth.assertThat((Long)parentStatus.getModificationTime()).isEqualTo((Object)0);
    }

    @Test
    public void testGetUriDefaultPort_shouldBeEqualToGhfsDefaultPort() throws IOException, URISyntaxException {
        Configuration config = GoogleHadoopFileSystemIntegrationHelper.getTestConfig();
        GoogleHadoopFS ghfs = new GoogleHadoopFS(initUri, config);
        Truth.assertThat((Integer)ghfs.getUriDefaultPort()).isEqualTo((Object)-1);
    }

    @Test
    public void testGetUri_shouldBeEqualToGhfsUri() throws IOException, URISyntaxException {
        Configuration config = GoogleHadoopFileSystemIntegrationHelper.getTestConfig();
        GoogleHadoopFS ghfs = new GoogleHadoopFS(initUri, config);
        Truth.assertThat((Comparable)ghfs.getUri()).isEqualTo((Object)initUri.resolve("/"));
    }

    @Test
    public void testValidName_shouldNotContainPoints() throws IOException, URISyntaxException {
        Configuration config = GoogleHadoopFileSystemIntegrationHelper.getTestConfig();
        GoogleHadoopFS ghfs = new GoogleHadoopFS(initUri, config);
        Truth.assertThat((Boolean)ghfs.isValidName("gs://test//")).isTrue();
        Truth.assertThat((Boolean)ghfs.isValidName("hdfs://test//")).isTrue();
        Truth.assertThat((Boolean)ghfs.isValidName("gs//test/../")).isFalse();
        Truth.assertThat((Boolean)ghfs.isValidName("gs//test//.")).isFalse();
    }

    @Test
    public void testCheckPath_shouldThrowExceptionForMismatchingBucket() throws IOException, URISyntaxException {
        Configuration config = GoogleHadoopFileSystemIntegrationHelper.getTestConfig();
        GoogleHadoopFS ghfs = new GoogleHadoopFS(initUri, config);
        Path testPath = new Path("gs://fake/file");
        InvalidPathException e = (InvalidPathException)Assert.assertThrows(InvalidPathException.class, () -> ghfs.checkPath(testPath));
        Truth.assertThat((Throwable)e).hasMessageThat().startsWith("Invalid path");
    }

    @Test
    public void getServerDefaults_shouldReturnSpecifiedConfiguration() throws Exception {
        Configuration config = GoogleHadoopFileSystemIntegrationHelper.getTestConfig();
        config.setLong(GoogleHadoopFileSystemConfiguration.BLOCK_SIZE.getKey(), 1L);
        GoogleHadoopFS ghfs = new GoogleHadoopFS(initUri, config);
        FsServerDefaults defaults = ghfs.getServerDefaults();
        Truth.assertThat((Long)defaults.getBlockSize()).isEqualTo((Object)1);
    }

    @Test
    public void testMkdirs_shouldReturnDefaultFilePermissions() throws IOException, URISyntaxException {
        Configuration config = GoogleHadoopFileSystemIntegrationHelper.getTestConfig();
        config.set("fs.gs.reported.permissions", "357");
        GoogleHadoopFS ghfs = new GoogleHadoopFS(initUri, config);
        FsPermission permission = new FsPermission("000");
        FsPermission expectedPermission = new FsPermission("357");
        Path path = new Path(initUri.resolve("/testMkdirs_shouldRespectFilePermissions").toString());
        ghfs.mkdir(path, permission, true);
        Truth.assertThat((Object)ghfs.getFileStatus(path).getPermission()).isEqualTo((Object)expectedPermission);
    }

    @Test
    public void testDeleteRecursive_shouldDeleteAllInPath() throws IOException, URISyntaxException {
        Configuration config = GoogleHadoopFileSystemIntegrationHelper.getTestConfig();
        GoogleHadoopFS ghfs = new GoogleHadoopFS(initUri, config);
        FsPermission permission = new FsPermission("000");
        URI parentDir = initUri.resolve("/testDeleteRecursive_shouldDeleteAllInPath");
        Path testDir = new Path(parentDir.resolve("test_dir").toString());
        URI testFile = parentDir.resolve("test_file");
        Path testFilePath = new Path(testFile.toString());
        ghfs.mkdir(testDir, permission, true);
        gcsFsIHelper.writeTextFile(initUri.getAuthority(), testFile.getPath(), "file data");
        Truth.assertThat((Comparable)ghfs.getFileStatus(testDir)).isNotNull();
        Truth.assertThat((Comparable)ghfs.getFileStatus(testFilePath)).isNotNull();
        Truth.assertThat((Comparable)ghfs.getFileStatus(testDir.getParent())).isNotNull();
        ghfs.delete(testDir.getParent(), true);
        Assert.assertThrows(FileNotFoundException.class, () -> ghfs.getFileStatus(testDir));
        Assert.assertThrows(FileNotFoundException.class, () -> ghfs.getFileStatus(testFilePath));
        Assert.assertThrows(FileNotFoundException.class, () -> ghfs.getFileStatus(testDir.getParent()));
    }

    @Test
    public void testDeleteNotRecursive_shouldBeAppliedToHierarchyOfDirectories() throws IOException, URISyntaxException {
        Configuration config = GoogleHadoopFileSystemIntegrationHelper.getTestConfig();
        GoogleHadoopFS ghfs = new GoogleHadoopFS(initUri, config);
        FsPermission permission = new FsPermission("000");
        URI parentDir = initUri.resolve("/testDeleteRecursive_shouldDeleteAllInPath");
        Path testDir = new Path(parentDir.resolve("test_dir").toString());
        ghfs.mkdir(testDir, permission, true);
        Assert.assertThrows(DirectoryNotEmptyException.class, () -> ghfs.delete(testDir.getParent(), false));
    }

    @Test
    public void testGetFileStatus_shouldReturnDetails() throws IOException, URISyntaxException {
        Configuration config = GoogleHadoopFileSystemIntegrationHelper.getTestConfig();
        GoogleHadoopFS ghfs = new GoogleHadoopFS(initUri, config);
        URI testFile = initUri.resolve("/testGetFileStatus_shouldReturnDetails");
        Path testFilePath = new Path(testFile.toString());
        gcsFsIHelper.writeTextFile(testFile.getAuthority(), testFile.getPath(), "file content");
        FileStatus fileStatus = ghfs.getFileStatus(testFilePath);
        Truth.assertThat((Comparable)Short.valueOf(fileStatus.getReplication())).isEqualTo((Object)3);
    }

    @Test
    public void testGetFileBlockLocations_shouldReturnLocalhost() throws IOException, URISyntaxException {
        Configuration config = GoogleHadoopFileSystemIntegrationHelper.getTestConfig();
        GoogleHadoopFS ghfs = new GoogleHadoopFS(initUri, config);
        URI testFile = initUri.resolve("/testGetFileBlockLocations_shouldReturnLocalhost");
        Path testFilePath = new Path(testFile.toString());
        gcsFsIHelper.writeTextFile(testFile.getAuthority(), testFile.getPath(), "file content");
        Object[] fileBlockLocations = ghfs.getFileBlockLocations(testFilePath, 1L, 1L);
        Truth.assertThat((Object[])fileBlockLocations).hasLength(1);
        Truth.assertThat((Object[])fileBlockLocations[0].getHosts()).isEqualTo((Object)new String[]{"localhost"});
    }

    @Test
    public void testListStatus_shouldReturnOneStatus() throws IOException, URISyntaxException {
        Configuration config = GoogleHadoopFileSystemIntegrationHelper.getTestConfig();
        GoogleHadoopFS ghfs = new GoogleHadoopFS(initUri, config);
        URI testFile = initUri.resolve("/testListStatus_shouldReturnOneStatus");
        Path testFilePath = new Path(testFile.toString());
        Assert.assertThrows(FileNotFoundException.class, () -> ghfs.listStatus(testFilePath));
        gcsFsIHelper.writeTextFile(testFile.getAuthority(), testFile.getPath(), "file content");
        Truth.assertThat((Object[])ghfs.listStatus(testFilePath)).hasLength(1);
    }

    @Test
    public void testRenameInternal_shouldMakeOldPathNotFound() throws IOException, URISyntaxException {
        Configuration config = GoogleHadoopFileSystemIntegrationHelper.getTestConfig();
        GoogleHadoopFS ghfs = new GoogleHadoopFS(initUri, config);
        URI srcFile = initUri.resolve("/testRenameInternal_shouldMakeOldPathNotFound/src");
        Path srcPath = new Path(srcFile);
        URI dstFile = initUri.resolve("/testRenameInternal_shouldMakeOldPathNotFound/dst");
        Path dstPath = new Path(dstFile);
        gcsFsIHelper.writeTextFile(srcFile.getAuthority(), srcFile.getPath(), "file content");
        Truth.assertThat((Object[])ghfs.listStatus(srcPath)).hasLength(1);
        Assert.assertThrows(FileNotFoundException.class, () -> ghfs.listStatus(dstPath));
        ghfs.renameInternal(srcPath, dstPath);
        Assert.assertThrows(FileNotFoundException.class, () -> ghfs.listStatus(srcPath));
        Truth.assertThat((Object[])ghfs.listStatus(dstPath)).hasLength(1);
    }
}

