/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFSInputStream;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemIntegrationHelper;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemIntegrationHelper;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.common.truth.Truth;
import java.io.EOFException;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.hadoop.fs.FileSystem;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GoogleHadoopFSInputStreamIntegrationTest {
    private static GoogleCloudStorageFileSystemIntegrationHelper gcsFsIHelper;

    @BeforeClass
    public static void beforeClass() throws Exception {
        gcsFsIHelper = GoogleCloudStorageFileSystemIntegrationHelper.create();
        gcsFsIHelper.beforeAllTests();
    }

    @AfterClass
    public static void afterClass() {
        gcsFsIHelper.afterAllTests();
    }

    @Test
    public void seek_illegalArgument() throws Exception {
        URI path = gcsFsIHelper.getUniqueObjectUri(this.getClass(), "seek_illegalArgument");
        GoogleHadoopFileSystem ghfs = GoogleHadoopFileSystemIntegrationHelper.createGhfs(path, GoogleHadoopFileSystemIntegrationHelper.getTestConfig());
        String testContent = "test content";
        gcsFsIHelper.writeTextFile(path, testContent);
        GoogleHadoopFSInputStream in = GoogleHadoopFSInputStreamIntegrationTest.createGhfsInputStream(ghfs, path);
        Throwable exception = Assert.assertThrows(EOFException.class, () -> in.seek((long)testContent.length()));
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)"Invalid seek offset");
    }

    @Test
    public void read_singleBytes() throws Exception {
        URI path = gcsFsIHelper.getUniqueObjectUri(this.getClass(), "read_singleBytes");
        GoogleHadoopFileSystem ghfs = GoogleHadoopFileSystemIntegrationHelper.createGhfs(path, GoogleHadoopFileSystemIntegrationHelper.getTestConfig());
        String testContent = "test content";
        gcsFsIHelper.writeTextFile(path, testContent);
        byte[] value = new byte[2];
        byte[] expected = Arrays.copyOf(testContent.getBytes(StandardCharsets.UTF_8), 2);
        GoogleCloudStorageReadOptions options = ghfs.getGcsFs().getOptions().getCloudStorageOptions().getReadChannelOptions();
        FileSystem.Statistics statistics = new FileSystem.Statistics(ghfs.getScheme());
        try (GoogleHadoopFSInputStream in = new GoogleHadoopFSInputStream((GoogleHadoopFileSystemBase)ghfs, path, options, statistics);){
            Truth.assertThat((Integer)in.read(value, 0, 1)).isEqualTo((Object)1);
            Truth.assertThat((Integer)statistics.getReadOps()).isEqualTo((Object)1);
            Truth.assertThat((Integer)in.read(1L, value, 1, 1)).isEqualTo((Object)1);
            Truth.assertThat((Integer)statistics.getReadOps()).isEqualTo((Object)2);
        }
        Truth.assertThat((byte[])value).isEqualTo((Object)expected);
    }

    @Test
    public void testAvailable() throws Exception {
        GoogleHadoopFSInputStream in;
        URI path = gcsFsIHelper.getUniqueObjectUri(this.getClass(), "testAvailable");
        GoogleHadoopFileSystem ghfs = GoogleHadoopFileSystemIntegrationHelper.createGhfs(path, GoogleHadoopFileSystemIntegrationHelper.getTestConfig());
        String testContent = "test content";
        gcsFsIHelper.writeTextFile(path, testContent);
        try (GoogleHadoopFSInputStream ignore = in = GoogleHadoopFSInputStreamIntegrationTest.createGhfsInputStream(ghfs, path);){
            Truth.assertThat((Integer)in.available()).isEqualTo((Object)0);
        }
        Assert.assertThrows(ClosedChannelException.class, () -> ((GoogleHadoopFSInputStream)in).available());
    }

    private static GoogleHadoopFSInputStream createGhfsInputStream(GoogleHadoopFileSystem ghfs, URI path) throws IOException {
        GoogleCloudStorageReadOptions options = ghfs.getGcsFs().getOptions().getCloudStorageOptions().getReadChannelOptions();
        return new GoogleHadoopFSInputStream((GoogleHadoopFileSystemBase)ghfs, path, options, new FileSystem.Statistics(ghfs.getScheme()));
    }
}

