/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.grpclb;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Objects;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Attributes;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientStreamTracer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Metadata;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.grpclb.GrpclbConstants;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.GrpcAttributes;
import javax.annotation.Nullable;

final class TokenAttachingTracerFactory
extends ClientStreamTracer.Factory {
    private static final ClientStreamTracer NOOP_TRACER = new ClientStreamTracer(){};
    @Nullable
    private final ClientStreamTracer.Factory delegate;

    TokenAttachingTracerFactory(@Nullable ClientStreamTracer.Factory delegate) {
        this.delegate = delegate;
    }

    @Override
    public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
        Attributes transportAttrs = Preconditions.checkNotNull(info.getTransportAttrs(), "transportAttrs");
        Attributes eagAttrs = Preconditions.checkNotNull(transportAttrs.get(GrpcAttributes.ATTR_CLIENT_EAG_ATTRS), "eagAttrs");
        String token = eagAttrs.get(GrpclbConstants.TOKEN_ATTRIBUTE_KEY);
        headers.discardAll(GrpclbConstants.TOKEN_METADATA_KEY);
        if (token != null) {
            headers.put(GrpclbConstants.TOKEN_METADATA_KEY, token);
        }
        if (this.delegate != null) {
            return this.delegate.newClientStreamTracer(info, headers);
        }
        return NOOP_TRACER;
    }

    public int hashCode() {
        return Objects.hashCode(this.delegate);
    }

    public boolean equals(Object other) {
        if (!(other instanceof TokenAttachingTracerFactory)) {
            return false;
        }
        return Objects.equal(this.delegate, ((TokenAttachingTracerFactory)other).delegate);
    }
}

