/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.ObjectWriteConditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageStubProvider;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.VerificationAttributes;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.BaseAbstractGoogleAsyncWriteChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.ResilientOperation;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.RetryDeterminer;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableSet;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.hash.Hasher;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.hash.Hashing;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.io.BaseEncoding;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.io.ByteStreams;
import com.google.cloud.hadoop.repackaged.gcs.com.google.google.storage.v1.ChecksummedData;
import com.google.cloud.hadoop.repackaged.gcs.com.google.google.storage.v1.InsertObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.google.storage.v1.InsertObjectSpec;
import com.google.cloud.hadoop.repackaged.gcs.com.google.google.storage.v1.Object;
import com.google.cloud.hadoop.repackaged.gcs.com.google.google.storage.v1.ObjectChecksums;
import com.google.cloud.hadoop.repackaged.gcs.com.google.google.storage.v1.QueryWriteStatusRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.google.storage.v1.QueryWriteStatusResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.google.storage.v1.ServiceConstants;
import com.google.cloud.hadoop.repackaged.gcs.com.google.google.storage.v1.StartResumableWriteRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.google.storage.v1.StartResumableWriteResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.google.storage.v1.StorageGrpc;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.ByteString;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.Int64Value;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.UInt32Value;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.util.Timestamps;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.stub.ClientCallStreamObserver;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.stub.ClientResponseObserver;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.stub.StreamObserver;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public final class GoogleCloudStorageGrpcWriteChannel
extends BaseAbstractGoogleAsyncWriteChannel<Object>
implements GoogleCloudStorageItemInfo.Provider {
    private static final Duration START_RESUMABLE_WRITE_TIMEOUT = Duration.ofMinutes(1L);
    private static final Duration QUERY_WRITE_STATUS_TIMEOUT = Duration.ofMinutes(1L);
    private static final int NUMBER_OF_REQUESTS_TO_RETAIN = 5;
    private static final ImmutableSet<Status.Code> TRANSIENT_ERRORS = ImmutableSet.of(Status.Code.DEADLINE_EXCEEDED, Status.Code.INTERNAL, Status.Code.RESOURCE_EXHAUSTED, Status.Code.UNAVAILABLE);
    private volatile StorageGrpc.StorageStub stub;
    private final StorageStubProvider stubProvider;
    private final StorageResourceId resourceId;
    private final CreateObjectOptions createOptions;
    private final ObjectWriteConditions writeConditions;
    private final String requesterPaysProject;
    private final GoogleCloudStorageImpl.BackOffFactory backOffFactory;
    private GoogleCloudStorageItemInfo completedItemInfo = null;

    GoogleCloudStorageGrpcWriteChannel(StorageStubProvider stubProvider, ExecutorService threadPool, AsyncWriteChannelOptions channelOptions, StorageResourceId resourceId, CreateObjectOptions createOptions, ObjectWriteConditions writeConditions, String requesterPaysProject, GoogleCloudStorageImpl.BackOffFactory backOffFactory) {
        super(threadPool, channelOptions);
        this.stubProvider = stubProvider;
        this.stub = stubProvider.newAsyncStub();
        this.resourceId = resourceId;
        this.createOptions = createOptions;
        this.writeConditions = writeConditions;
        this.requesterPaysProject = requesterPaysProject;
        this.backOffFactory = backOffFactory;
    }

    @Override
    protected String getResourceString() {
        return this.resourceId.toString();
    }

    @Override
    public void handleResponse(Object response) {
        Map<String, byte[]> metadata = response.getMetadataMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> BaseEncoding.base64().decode((CharSequence)entry.getValue())));
        byte[] md5Hash = !response.getMd5Hash().isEmpty() ? BaseEncoding.base64().decode(response.getMd5Hash()) : null;
        byte[] crc32c = response.hasCrc32C() ? ByteBuffer.allocate(4).putInt(response.getCrc32C().getValue()).array() : null;
        this.completedItemInfo = GoogleCloudStorageItemInfo.createObject(this.resourceId, Timestamps.toMillis(response.getTimeCreated()), Timestamps.toMillis(response.getUpdated()), response.getSize(), response.getContentType(), response.getContentEncoding(), metadata, response.getGeneration(), response.getMetageneration(), new VerificationAttributes(md5Hash, crc32c));
    }

    @Override
    public void startUpload(InputStream pipeSource) {
        try {
            this.uploadOperation = this.threadPool.submit(new UploadOperation(pipeSource));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to start upload for '%s'", this.resourceId), e);
        }
    }

    @Override
    public GoogleCloudStorageItemInfo getItemInfo() {
        return this.completedItemInfo;
    }

    private class UploadOperation
    implements Callable<Object> {
        private final BufferedInputStream pipeSource;
        private final int MAX_BYTES_PER_MESSAGE = ServiceConstants.Values.MAX_WRITE_CHUNK_BYTES.getNumber();
        private Hasher objectHasher;
        private String uploadId;
        private long writeOffset = 0L;
        private InsertChunkResponseObserver responseObserver;
        private final TreeMap<Long, ByteString> dataChunkMap = new TreeMap();

        UploadOperation(InputStream pipeSource) {
            this.pipeSource = new BufferedInputStream(pipeSource, this.MAX_BYTES_PER_MESSAGE);
            if (GoogleCloudStorageGrpcWriteChannel.this.channelOptions.isGrpcChecksumsEnabled()) {
                this.objectHasher = Hashing.crc32c().newHasher();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Object call() throws IOException {
            this.uploadId = this.startResumableUpload();
            try (BufferedInputStream ignore = this.pipeSource;){
                Object object = ResilientOperation.retry(this::doResumableUpload, GoogleCloudStorageGrpcWriteChannel.this.backOffFactory.newBackOff(), RetryDeterminer.ALL_ERRORS, IOException.class);
                return object;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(String.format("Interrupted resumable upload failed for '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), e);
            }
        }

        private Object doResumableUpload() throws IOException {
            if (this.writeOffset > 0L) {
                this.writeOffset = this.getCommittedWriteSize(this.uploadId);
            }
            this.responseObserver = new InsertChunkResponseObserver(this.uploadId, this.writeOffset);
            StreamObserver<InsertObjectRequest> requestStreamObserver = ((StorageGrpc.StorageStub)GoogleCloudStorageGrpcWriteChannel.this.stub.withDeadlineAfter(GoogleCloudStorageGrpcWriteChannel.this.channelOptions.getGrpcWriteTimeout(), TimeUnit.MILLISECONDS)).insertObject(this.responseObserver);
            try {
                this.responseObserver.ready.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(String.format("Streaming RPC failed to become ready for resumable upload for '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), e);
            }
            boolean objectFinalized = false;
            while (!objectFinalized) {
                InsertObjectRequest insertRequest;
                if (this.dataChunkMap.size() > 0 && this.dataChunkMap.lastKey() >= this.writeOffset) {
                    insertRequest = this.buildRequestFromBufferedDataChunk(this.dataChunkMap, this.writeOffset);
                    this.writeOffset += (long)insertRequest.getChecksummedData().getContent().size();
                } else {
                    ByteString data = ByteString.readFrom(ByteStreams.limit(this.pipeSource, this.MAX_BYTES_PER_MESSAGE), this.MAX_BYTES_PER_MESSAGE);
                    this.dataChunkMap.put(this.writeOffset, data);
                    if (this.dataChunkMap.size() >= 5) {
                        this.dataChunkMap.remove(this.dataChunkMap.firstKey());
                    }
                    insertRequest = this.buildInsertRequest(this.writeOffset, data, false);
                    this.writeOffset += (long)data.size();
                }
                requestStreamObserver.onNext(insertRequest);
                objectFinalized = insertRequest.getFinishWrite();
                if (this.responseObserver.hasTransientError() || this.responseObserver.hasNonTransientError()) {
                    requestStreamObserver.onError(this.responseObserver.hasTransientError() ? this.responseObserver.transientError : this.responseObserver.nonTransientError);
                    break;
                }
                if (!objectFinalized) continue;
                requestStreamObserver.onCompleted();
            }
            try {
                this.responseObserver.done.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(String.format("Interrupted while awaiting response during upload of '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), e);
            }
            if (this.responseObserver.hasTransientError()) {
                throw new IOException(this.responseObserver.transientError);
            }
            return this.responseObserver.getResponseOrThrow();
        }

        private InsertObjectRequest buildInsertRequest(long writeOffset, ByteString dataChunk, boolean resumeFromFailedInsert) {
            InsertObjectRequest.Builder requestBuilder = InsertObjectRequest.newBuilder().setUploadId(this.uploadId).setWriteOffset(writeOffset);
            if (dataChunk.size() > 0) {
                ChecksummedData.Builder requestDataBuilder = ChecksummedData.newBuilder().setContent(dataChunk);
                if (GoogleCloudStorageGrpcWriteChannel.this.channelOptions.isGrpcChecksumsEnabled()) {
                    if (!resumeFromFailedInsert) {
                        this.updateObjectHash(dataChunk);
                    }
                    requestDataBuilder.setCrc32C(UInt32Value.newBuilder().setValue(this.getChunkHash(dataChunk)));
                }
                requestBuilder.setChecksummedData(requestDataBuilder);
            }
            if (dataChunk.size() < this.MAX_BYTES_PER_MESSAGE) {
                requestBuilder.setFinishWrite(true);
                if (GoogleCloudStorageGrpcWriteChannel.this.channelOptions.isGrpcChecksumsEnabled()) {
                    requestBuilder.setObjectChecksums(ObjectChecksums.newBuilder().setCrc32C(UInt32Value.newBuilder().setValue(this.objectHasher.hash().asInt())));
                }
            }
            return requestBuilder.build();
        }

        private int getChunkHash(ByteString dataChunk) {
            Hasher chunkHasher = Hashing.crc32c().newHasher();
            for (ByteBuffer buffer : dataChunk.asReadOnlyByteBufferList()) {
                chunkHasher.putBytes(buffer);
            }
            return chunkHasher.hash().asInt();
        }

        private void updateObjectHash(ByteString dataChunk) {
            for (ByteBuffer buffer : dataChunk.asReadOnlyByteBufferList()) {
                this.objectHasher.putBytes(buffer);
            }
        }

        private InsertObjectRequest buildRequestFromBufferedDataChunk(TreeMap<Long, ByteString> dataChunkMap, long writeOffset) throws IOException {
            InsertObjectRequest request = null;
            if (dataChunkMap.size() > 0 && dataChunkMap.firstKey() <= writeOffset) {
                for (Map.Entry<Long, ByteString> entry : dataChunkMap.entrySet()) {
                    if (entry.getKey() + (long)entry.getValue().size() <= writeOffset) continue;
                    Long writeOffsetToResume = entry.getKey();
                    ByteString chunkData = entry.getValue();
                    request = this.buildInsertRequest(writeOffsetToResume, chunkData, true);
                    break;
                }
            }
            if (request == null) {
                throw new IOException(String.format("Didn't have enough data buffered for attempt to resume upload for uploadID %s: last committed offset=%s, earliest buffered offset=%s. Upload must be restarted from the beginning.", this.uploadId, writeOffset, dataChunkMap.firstKey()));
            }
            return request;
        }

        private void recreateStub(Status.Code statusCode) {
            GoogleCloudStorageGrpcWriteChannel.this.stubProvider;
            if (StorageStubProvider.isStubBroken(statusCode)) {
                GoogleCloudStorageGrpcWriteChannel.this.stub = GoogleCloudStorageGrpcWriteChannel.this.stubProvider.newAsyncStub();
            }
        }

        private String startResumableUpload() throws IOException {
            InsertObjectSpec.Builder insertObjectSpecBuilder = InsertObjectSpec.newBuilder().setResource(Object.newBuilder().setBucket(GoogleCloudStorageGrpcWriteChannel.this.resourceId.getBucketName()).setName(GoogleCloudStorageGrpcWriteChannel.this.resourceId.getObjectName()).setContentType(GoogleCloudStorageGrpcWriteChannel.this.createOptions.getContentType()).putAllMetadata(GoogleCloudStorageImpl.encodeMetadata(GoogleCloudStorageGrpcWriteChannel.this.createOptions.getMetadata())).build());
            if (GoogleCloudStorageGrpcWriteChannel.this.writeConditions.hasContentGenerationMatch()) {
                insertObjectSpecBuilder.setIfGenerationMatch(Int64Value.newBuilder().setValue(GoogleCloudStorageGrpcWriteChannel.this.writeConditions.getContentGenerationMatch()));
            }
            if (GoogleCloudStorageGrpcWriteChannel.this.writeConditions.hasMetaGenerationMatch()) {
                insertObjectSpecBuilder.setIfMetagenerationMatch(Int64Value.newBuilder().setValue(GoogleCloudStorageGrpcWriteChannel.this.writeConditions.getMetaGenerationMatch()));
            }
            if (GoogleCloudStorageGrpcWriteChannel.this.requesterPaysProject != null) {
                insertObjectSpecBuilder.setUserProject(GoogleCloudStorageGrpcWriteChannel.this.requesterPaysProject);
            }
            StartResumableWriteRequest request = StartResumableWriteRequest.newBuilder().setInsertObjectSpec(insertObjectSpecBuilder).build();
            SimpleResponseObserver responseObserver = new SimpleResponseObserver();
            try {
                ResilientOperation.retry(() -> {
                    ((StorageGrpc.StorageStub)GoogleCloudStorageGrpcWriteChannel.this.stub.withDeadlineAfter(START_RESUMABLE_WRITE_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS)).startResumableWrite(request, responseObserver);
                    try {
                        responseObserver.done.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IOException(String.format("Interrupted while awaiting response during upload of '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), e);
                    }
                    if (responseObserver.hasError()) {
                        throw new IOException(responseObserver.getError());
                    }
                    return null;
                }, GoogleCloudStorageGrpcWriteChannel.this.backOffFactory.newBackOff(), RetryDeterminer.ALL_ERRORS, IOException.class);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(String.format("Failed to start resumable upload for '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), e);
            }
            return ((StartResumableWriteResponse)responseObserver.getResponse()).getUploadId();
        }

        private long getCommittedWriteSize(String uploadId) throws IOException {
            QueryWriteStatusRequest request = QueryWriteStatusRequest.newBuilder().setUploadId(uploadId).build();
            SimpleResponseObserver responseObserver = new SimpleResponseObserver();
            try {
                ResilientOperation.retry(() -> {
                    ((StorageGrpc.StorageStub)GoogleCloudStorageGrpcWriteChannel.this.stub.withDeadlineAfter(QUERY_WRITE_STATUS_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS)).queryWriteStatus(request, responseObserver);
                    try {
                        responseObserver.done.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IOException(String.format("Interrupted while awaiting response during upload of '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), e);
                    }
                    if (responseObserver.hasError()) {
                        throw new IOException(responseObserver.getError());
                    }
                    return null;
                }, GoogleCloudStorageGrpcWriteChannel.this.backOffFactory.newBackOff(), RetryDeterminer.ALL_ERRORS, IOException.class);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(String.format("Failed to get committed write size for '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), e);
            }
            return ((QueryWriteStatusResponse)responseObserver.getResponse()).getCommittedSize();
        }

        private class SimpleResponseObserver<T>
        implements StreamObserver<T> {
            private T response;
            private Throwable error;
            final CountDownLatch done = new CountDownLatch(1);

            private SimpleResponseObserver() {
            }

            public T getResponse() {
                return Preconditions.checkNotNull(this.response, "Response not present for '%s'", (java.lang.Object)GoogleCloudStorageGrpcWriteChannel.this.resourceId);
            }

            boolean hasError() {
                return this.error != null || this.response == null;
            }

            public Throwable getError() {
                return Preconditions.checkNotNull(this.error, "Error not present for '%s'", (java.lang.Object)GoogleCloudStorageGrpcWriteChannel.this.resourceId);
            }

            @Override
            public void onNext(T response) {
                this.response = response;
            }

            @Override
            public void onError(Throwable t) {
                UploadOperation.this.recreateStub(Status.fromThrowable(t).getCode());
                this.error = new IOException(String.format("Caught exception for '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), t);
                this.done.countDown();
            }

            @Override
            public void onCompleted() {
                this.done.countDown();
            }
        }

        private class InsertChunkResponseObserver
        implements ClientResponseObserver<InsertObjectRequest, Object> {
            private final long writeOffset;
            private final String uploadId;
            private Object response;
            public Throwable transientError = null;
            public Throwable nonTransientError = null;
            final CountDownLatch done = new CountDownLatch(1);
            final CountDownLatch ready = new CountDownLatch(1);

            InsertChunkResponseObserver(String uploadId, long writeOffset) {
                this.uploadId = uploadId;
                this.writeOffset = writeOffset;
            }

            public Object getResponseOrThrow() throws IOException {
                if (this.hasNonTransientError()) {
                    throw new IOException(String.format("Resumable upload failed for '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), this.nonTransientError);
                }
                return Preconditions.checkNotNull(this.response, "Response not present for '%s'", (java.lang.Object)GoogleCloudStorageGrpcWriteChannel.this.resourceId);
            }

            boolean hasTransientError() {
                return this.transientError != null;
            }

            boolean hasNonTransientError() {
                return this.response == null && this.nonTransientError != null;
            }

            @Override
            public void onNext(Object response) {
                this.response = response;
            }

            @Override
            public void onError(Throwable t) {
                Status status = Status.fromThrowable(t);
                Status.Code statusCode = status.getCode();
                UploadOperation.this.recreateStub(statusCode);
                if (TRANSIENT_ERRORS.contains((java.lang.Object)statusCode)) {
                    this.transientError = t;
                }
                if (this.transientError == null) {
                    this.nonTransientError = new IOException(String.format("Caught exception for '%s', while uploading to uploadId %s at writeOffset %d. Status: %s", GoogleCloudStorageGrpcWriteChannel.this.resourceId, this.uploadId, this.writeOffset, status.getDescription()), t);
                }
                this.done.countDown();
            }

            @Override
            public void onCompleted() {
                this.done.countDown();
            }

            @Override
            public void beforeStart(ClientCallStreamObserver<InsertObjectRequest> clientCallStreamObserver) {
                clientCallStreamObserver.setOnReadyHandler(this.ready::countDown);
            }
        }
    }
}

