/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageExceptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageStubProvider;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.ResilientOperation;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.RetryDeterminer;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.MoreObjects;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.hash.Hashing;
import com.google.cloud.hadoop.repackaged.gcs.com.google.google.storage.v1.GetObjectMediaRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.google.storage.v1.GetObjectMediaResponse;
import com.google.cloud.hadoop.repackaged.gcs.com.google.google.storage.v1.GetObjectRequest;
import com.google.cloud.hadoop.repackaged.gcs.com.google.google.storage.v1.Object;
import com.google.cloud.hadoop.repackaged.gcs.com.google.google.storage.v1.StorageGrpc;
import com.google.cloud.hadoop.repackaged.gcs.com.google.protobuf.ByteString;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Context;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.StatusRuntimeException;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class GoogleCloudStorageGrpcReadChannel
implements SeekableByteChannel {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private volatile StorageGrpc.StorageBlockingStub stub;
    private final StorageStubProvider stubProvider;
    private final StorageResourceId resourceId;
    private final long objectGeneration;
    private final long objectSize;
    private boolean channelIsOpen = true;
    private long position = 0L;
    private long bytesToSkipBeforeReading = 0L;
    @Nullable
    private ByteString bufferedContent = null;
    private int bufferedContentReadOffset = 0;
    @Nullable
    private Iterator<GetObjectMediaResponse> resIterator = null;
    private final GoogleCloudStorageReadOptions readOptions;
    private final GoogleCloudStorageImpl.BackOffFactory backOffFactory;
    @Nullable
    Context.CancellableContext requestContext;
    GoogleCloudStorageReadOptions.Fadvise readStrategy;

    public static GoogleCloudStorageGrpcReadChannel open(StorageStubProvider stubProvider, StorageResourceId resourceId, GoogleCloudStorageReadOptions readOptions) throws IOException {
        return GoogleCloudStorageGrpcReadChannel.open(stubProvider, resourceId, readOptions, GoogleCloudStorageImpl.BackOffFactory.DEFAULT);
    }

    @VisibleForTesting
    static GoogleCloudStorageGrpcReadChannel open(StorageStubProvider stubProvider, StorageResourceId resourceId, GoogleCloudStorageReadOptions readOptions, GoogleCloudStorageImpl.BackOffFactory backOffFactory) throws IOException {
        try {
            return ResilientOperation.retry(() -> {
                Object storageObject;
                StorageGrpc.StorageBlockingStub stub = stubProvider.newBlockingStub();
                try {
                    storageObject = ((StorageGrpc.StorageBlockingStub)stub.withDeadlineAfter(readOptions.getGrpcReadMetadataTimeoutMillis(), TimeUnit.MILLISECONDS)).getObject(GetObjectRequest.newBuilder().setBucket(resourceId.getBucketName()).setObject(resourceId.getObjectName()).build());
                }
                catch (StatusRuntimeException e) {
                    throw GoogleCloudStorageGrpcReadChannel.convertError(e, resourceId);
                }
                if (storageObject.getContentEncoding().contains("gzip")) {
                    throw new IOException("Can't read GZIP encoded files - content encoding support is disabled.");
                }
                return new GoogleCloudStorageGrpcReadChannel(stub, stubProvider, resourceId, storageObject.getGeneration(), storageObject.getSize(), readOptions, backOffFactory);
            }, backOffFactory.newBackOff(), RetryDeterminer.ALL_ERRORS, IOException.class);
        }
        catch (Exception e) {
            throw new IOException(String.format("Error reading '%s'", resourceId), e);
        }
    }

    private GoogleCloudStorageGrpcReadChannel(StorageGrpc.StorageBlockingStub gcsGrpcBlockingStub, StorageStubProvider stubProvider, StorageResourceId resourceId, long objectGeneration, long objectSize, GoogleCloudStorageReadOptions readOptions, GoogleCloudStorageImpl.BackOffFactory backOffFactory) {
        this.stub = gcsGrpcBlockingStub;
        this.stubProvider = stubProvider;
        this.resourceId = resourceId;
        this.objectGeneration = objectGeneration;
        this.objectSize = objectSize;
        this.readOptions = readOptions;
        this.backOffFactory = backOffFactory;
        this.readStrategy = readOptions.getFadvise();
    }

    private static IOException convertError(StatusRuntimeException error, StorageResourceId resourceId) {
        String msg = String.format("Error reading '%s'", resourceId);
        switch (Status.fromThrowable(error).getCode()) {
            case NOT_FOUND: {
                return GoogleCloudStorageExceptions.createFileNotFoundException(resourceId.getBucketName(), resourceId.getObjectName(), new IOException(msg, error));
            }
            case OUT_OF_RANGE: {
                return (IOException)new EOFException(msg).initCause(error);
            }
        }
        return new IOException(msg, error);
    }

    private static void put(ByteString source, int offset, int size, ByteBuffer dest) {
        ByteString croppedSource = source.substring(offset, offset + size);
        for (ByteBuffer sourcePiece : croppedSource.asReadOnlyByteBufferList()) {
            dest.put(sourcePiece);
        }
    }

    private int readBufferedContentInto(ByteBuffer byteBuffer) {
        long bufferSkip = Math.min((long)(this.bufferedContent.size() - this.bufferedContentReadOffset), this.bytesToSkipBeforeReading);
        bufferSkip = Math.max(0L, bufferSkip);
        this.bufferedContentReadOffset = (int)((long)this.bufferedContentReadOffset + bufferSkip);
        this.bytesToSkipBeforeReading -= bufferSkip;
        int remainingBufferedBytes = this.bufferedContent.size() - this.bufferedContentReadOffset;
        boolean remainingBufferedContentLargerThanByteBuffer = remainingBufferedBytes > byteBuffer.remaining();
        int bytesToWrite = remainingBufferedContentLargerThanByteBuffer ? byteBuffer.remaining() : remainingBufferedBytes;
        GoogleCloudStorageGrpcReadChannel.put(this.bufferedContent, this.bufferedContentReadOffset, bytesToWrite, byteBuffer);
        this.position += (long)bytesToWrite;
        if (remainingBufferedContentLargerThanByteBuffer) {
            this.bufferedContentReadOffset += bytesToWrite;
        } else {
            this.bufferedContent = null;
            this.bufferedContentReadOffset = 0;
        }
        return bytesToWrite;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("GCS gRPC read request for up to %d bytes at offset %d from object '%s'", byteBuffer.remaining(), this.position(), this.resourceId);
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        int bytesRead = 0;
        if (this.bufferedContent != null) {
            bytesRead += this.readBufferedContentInto(byteBuffer);
        }
        if (!byteBuffer.hasRemaining()) {
            return bytesRead;
        }
        if (this.position == this.objectSize) {
            return bytesRead > 0 ? bytesRead : -1;
        }
        if (this.resIterator == null) {
            Integer bytesToRead = this.readStrategy == GoogleCloudStorageReadOptions.Fadvise.RANDOM ? Integer.valueOf(Math.max(byteBuffer.remaining(), this.readOptions.getMinRangeRequestSize())) : null;
            this.requestObjectMedia(bytesToRead);
        }
        while (this.moreServerContent() && byteBuffer.hasRemaining()) {
            int expectedChecksum;
            int calculatedChecksum;
            GetObjectMediaResponse res = this.resIterator.next();
            ByteString content = res.getChecksummedData().getContent();
            if (this.bytesToSkipBeforeReading >= 0L && this.bytesToSkipBeforeReading < (long)content.size()) {
                content = res.getChecksummedData().getContent().substring((int)this.bytesToSkipBeforeReading);
                this.position += this.bytesToSkipBeforeReading;
                this.bytesToSkipBeforeReading = 0L;
            } else if (this.bytesToSkipBeforeReading >= (long)content.size()) {
                this.position += (long)content.size();
                this.bytesToSkipBeforeReading -= (long)content.size();
                continue;
            }
            if (this.readOptions.isGrpcChecksumsEnabled() && res.getChecksummedData().hasCrc32C() && (calculatedChecksum = Hashing.crc32c().hashBytes(res.getChecksummedData().getContent().toByteArray()).asInt()) != (expectedChecksum = res.getChecksummedData().getCrc32C().getValue())) {
                throw new IOException(String.format("Message checksum (%s) didn't match expected checksum (%s) for '%s'", expectedChecksum, calculatedChecksum, this.resourceId));
            }
            boolean responseSizeLargerThanRemainingBuffer = content.size() > byteBuffer.remaining();
            int bytesToWrite = responseSizeLargerThanRemainingBuffer ? byteBuffer.remaining() : content.size();
            GoogleCloudStorageGrpcReadChannel.put(content, 0, bytesToWrite, byteBuffer);
            bytesRead += bytesToWrite;
            this.position += (long)bytesToWrite;
            if (!responseSizeLargerThanRemainingBuffer) continue;
            this.bufferedContent = content;
            this.bufferedContentReadOffset = bytesToWrite;
        }
        return bytesRead;
    }

    private void requestObjectMedia(@Nullable Integer bytesToRead) throws IOException {
        GetObjectMediaRequest.Builder requestBuilder = GetObjectMediaRequest.newBuilder().setBucket(this.resourceId.getBucketName()).setObject(this.resourceId.getObjectName()).setGeneration(this.objectGeneration).setReadOffset(this.position);
        if (bytesToRead != null) {
            requestBuilder.setReadLimit(bytesToRead.intValue());
        }
        GetObjectMediaRequest request = requestBuilder.build();
        try {
            ResilientOperation.retry(() -> {
                try {
                    this.requestContext = Context.current().withCancellation();
                    Context toReattach = this.requestContext.attach();
                    try {
                        this.resIterator = ((StorageGrpc.StorageBlockingStub)this.stub.withDeadlineAfter(this.readOptions.getGrpcReadTimeoutMillis(), TimeUnit.MILLISECONDS)).getObjectMedia(request);
                    }
                    finally {
                        this.requestContext.detach(toReattach);
                    }
                }
                catch (StatusRuntimeException e) {
                    this.recreateStub(e);
                    throw GoogleCloudStorageGrpcReadChannel.convertError(e, this.resourceId);
                }
                return null;
            }, this.backOffFactory.newBackOff(), RetryDeterminer.ALL_ERRORS, IOException.class);
        }
        catch (Exception e) {
            throw new IOException(String.format("Error reading '%s'", this.resourceId), e);
        }
    }

    private void cancelCurrentRequest() {
        if (this.requestContext != null) {
            this.requestContext.close();
            this.requestContext = null;
        }
        if (this.resIterator != null) {
            this.resIterator = null;
        }
    }

    private boolean moreServerContent() throws IOException {
        if (this.resIterator == null || this.requestContext == null || this.requestContext.isCancelled()) {
            return false;
        }
        try {
            return ResilientOperation.retry(() -> {
                try {
                    boolean moreDataAvailable = this.resIterator.hasNext();
                    if (!moreDataAvailable) {
                        this.cancelCurrentRequest();
                    }
                    return moreDataAvailable;
                }
                catch (StatusRuntimeException e) {
                    this.recreateStub(e);
                    throw GoogleCloudStorageGrpcReadChannel.convertError(e, this.resourceId);
                }
            }, this.backOffFactory.newBackOff(), RetryDeterminer.ALL_ERRORS, IOException.class);
        }
        catch (Exception e) {
            this.cancelCurrentRequest();
            throw new IOException(String.format("Error reading '%s'", this.resourceId), e);
        }
    }

    private void recreateStub(StatusRuntimeException e) {
        if (StorageStubProvider.isStubBroken(Status.fromThrowable(e).getCode())) {
            this.stub = this.stubProvider.newBlockingStub();
        }
    }

    @Override
    public int write(ByteBuffer byteBuffer) {
        throw new UnsupportedOperationException("Cannot mutate read-only channel: " + this);
    }

    @Override
    public long position() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        return this.position + this.bytesToSkipBeforeReading;
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        Preconditions.checkArgument(newPosition >= 0L, "Read position must be non-negative, but was %s", newPosition);
        Preconditions.checkArgument(newPosition < this.size(), "Read position must be before end of file (%s), but was %s", this.size(), newPosition);
        if (newPosition == this.position) {
            return this;
        }
        long seekDistance = newPosition - this.position;
        if (seekDistance >= 0L && seekDistance <= this.readOptions.getInplaceSeekLimit()) {
            this.bytesToSkipBeforeReading = seekDistance;
            return this;
        }
        if (this.readStrategy == GoogleCloudStorageReadOptions.Fadvise.AUTO && (seekDistance < 0L || seekDistance > this.readOptions.getInplaceSeekLimit())) {
            this.readStrategy = GoogleCloudStorageReadOptions.Fadvise.RANDOM;
        }
        this.cancelCurrentRequest();
        this.bufferedContent = null;
        this.bufferedContentReadOffset = 0;
        this.bytesToSkipBeforeReading = 0L;
        this.position = newPosition;
        return this;
    }

    @Override
    public long size() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        return this.objectSize;
    }

    @Override
    public SeekableByteChannel truncate(long l) throws IOException {
        throw new UnsupportedOperationException("Cannot mutate read-only channel");
    }

    @Override
    public boolean isOpen() {
        return this.channelIsOpen;
    }

    @Override
    public void close() {
        this.cancelCurrentRequest();
        this.channelIsOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("resourceId", this.resourceId).add("generation", this.objectGeneration).toString();
    }
}

