/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopOutputStream;
import com.google.cloud.hadoop.fs.gcs.SyncableOutputStreamOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.CreateFileOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.RateLimiter;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Syncable;

public class GoogleHadoopSyncableOutputStream
extends OutputStream
implements Syncable {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final String TEMPFILE_PREFIX = "_GCS_SYNCABLE_TEMPFILE_";
    private static final CreateFileOptions TEMPFILE_CREATE_OPTIONS = CreateFileOptions.DEFAULT_NO_OVERWRITE.toBuilder().setEnsureNoDirectoryConflict(false).setOverwriteGenerationId(0L).build();
    private static final ExecutorService TEMPFILE_CLEANUP_THREADPOOL = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("gcs-syncable-output-stream-cleanup-pool-%d").setDaemon(true).build());
    private final GoogleHadoopFileSystemBase ghfs;
    private final URI finalGcsPath;
    private final FileSystem.Statistics statistics;
    private final CreateFileOptions fileOptions;
    private final List<Future<Void>> deletionFutures;
    private final SyncableOutputStreamOptions options;
    private final RateLimiter syncRateLimiter;
    private final ExecutorService cleanupThreadpool;
    private URI curGcsPath;
    private GoogleHadoopOutputStream curDelegate;
    private int curComponentIndex;
    private long curDestGenerationId;

    public GoogleHadoopSyncableOutputStream(GoogleHadoopFileSystemBase ghfs, URI gcsPath, FileSystem.Statistics statistics, CreateFileOptions createFileOptions, SyncableOutputStreamOptions options) throws IOException {
        this(ghfs, gcsPath, statistics, createFileOptions, options, TEMPFILE_CLEANUP_THREADPOOL);
    }

    @VisibleForTesting
    GoogleHadoopSyncableOutputStream(GoogleHadoopFileSystemBase ghfs, URI gcsPath, FileSystem.Statistics statistics, CreateFileOptions createFileOptions, SyncableOutputStreamOptions options, ExecutorService cleanupThreadpool) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("GoogleHadoopSyncableOutputStream(gcsPath: %s, createFileOptions:  %s, options: %s)", gcsPath, createFileOptions, options);
        this.ghfs = ghfs;
        this.finalGcsPath = gcsPath;
        this.statistics = statistics;
        this.fileOptions = createFileOptions;
        this.deletionFutures = new ArrayList<Future<Void>>();
        this.cleanupThreadpool = cleanupThreadpool;
        this.options = options;
        this.syncRateLimiter = GoogleHadoopSyncableOutputStream.createRateLimiter(options.getMinSyncInterval());
        if (options.isAppendEnabled()) {
            this.curGcsPath = this.getNextTemporaryPath();
            this.curComponentIndex = 1;
        } else {
            this.curGcsPath = gcsPath;
            this.curComponentIndex = 0;
        }
        this.curDelegate = new GoogleHadoopOutputStream(ghfs, this.curGcsPath, statistics, this.fileOptions);
        this.curDestGenerationId = -1L;
    }

    private static RateLimiter createRateLimiter(Duration minSyncInterval) {
        if (minSyncInterval.isNegative() || minSyncInterval.isZero()) {
            return null;
        }
        double permitsPerSecond = 1000.0 / (double)minSyncInterval.toMillis();
        return RateLimiter.create(permitsPerSecond);
    }

    @Override
    public void write(int b) throws IOException {
        this.throwIfNotOpen();
        this.curDelegate.write(b);
    }

    @Override
    public void write(byte[] b, int offset, int len) throws IOException {
        this.throwIfNotOpen();
        this.curDelegate.write(b, offset, len);
    }

    @Override
    public void close() throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("close(): Current tail file: %s final destination: %s", (Object)this.curGcsPath, (Object)this.finalGcsPath);
        if (!this.isOpen()) {
            ((GoogleLogger.Api)logger.atFiner()).log("close(): Ignoring; stream already closed.");
            return;
        }
        this.commitCurrentFile();
        this.curGcsPath = null;
        this.curDelegate = null;
        ((GoogleLogger.Api)logger.atFiner()).log("close(): Awaiting %s deletionFutures", this.deletionFutures.size());
        for (Future<Void> deletion : this.deletionFutures) {
            try {
                deletion.get();
            }
            catch (InterruptedException | ExecutionException e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw new IOException("Failed to delete files while closing stream", e);
            }
        }
    }

    public void sync() throws IOException {
        this.hsync();
    }

    public void hflush() throws IOException {
        long startTimeNs = System.nanoTime();
        if (!this.options.isSyncOnFlushEnabled()) {
            ((GoogleLogger.Api)logger.atWarning()).log("hflush(): No-op: readers will *not* yet see flushed data for %s", this.finalGcsPath);
            this.throwIfNotOpen();
            return;
        }
        if (this.syncRateLimiter == null || this.syncRateLimiter.tryAcquire()) {
            ((GoogleLogger.Api)logger.atFine()).log("hflush() uses hsync() for %s", this.finalGcsPath);
            this.hsyncInternal(startTimeNs);
            return;
        }
        ((GoogleLogger.Api)logger.atWarning()).log("hflush(): No-op due to rate limit (%s): readers will *not* yet see flushed data for %s", (Object)this.syncRateLimiter, (Object)this.finalGcsPath);
        this.throwIfNotOpen();
    }

    public void hsync() throws IOException {
        long startTimeNs = System.nanoTime();
        if (this.syncRateLimiter != null) {
            ((GoogleLogger.Api)logger.atFiner()).log("hsync(): Rate limited (%s) with blocking permit acquisition for %s", (Object)this.syncRateLimiter, (Object)this.finalGcsPath);
            this.syncRateLimiter.acquire();
        }
        this.hsyncInternal(startTimeNs);
    }

    private void hsyncInternal(long startTimeNs) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("hsync(): Committing tail file %s to final destination %s", (Object)this.curGcsPath, (Object)this.finalGcsPath);
        this.throwIfNotOpen();
        this.commitCurrentFile();
        ++this.curComponentIndex;
        this.curGcsPath = this.getNextTemporaryPath();
        ((GoogleLogger.Api)logger.atFiner()).log("hsync(): Opening next temporary tail file %s as component number %s", (Object)this.curGcsPath, this.curComponentIndex);
        this.curDelegate = new GoogleHadoopOutputStream(this.ghfs, this.curGcsPath, this.statistics, TEMPFILE_CREATE_OPTIONS);
        long finishTimeNs = System.nanoTime();
        ((GoogleLogger.Api)logger.atFiner()).log("Took %d ns to sync() for %s", finishTimeNs - startTimeNs, (Object)this.finalGcsPath);
    }

    private void commitCurrentFile() throws IOException {
        WritableByteChannel innerChannel = this.curDelegate.getInternalChannel();
        this.curDelegate.close();
        long generationId = -1L;
        if (innerChannel instanceof GoogleCloudStorageItemInfo.Provider) {
            generationId = ((GoogleCloudStorageItemInfo.Provider)((Object)innerChannel)).getItemInfo().getContentGeneration();
            ((GoogleLogger.Api)logger.atFiner()).log("innerChannel is GoogleCloudStorageItemInfo.Provider; closed generationId %s.", generationId);
        } else {
            ((GoogleLogger.Api)logger.atFiner()).log("innerChannel NOT instanceof provider: %s", innerChannel.getClass());
        }
        if (!this.finalGcsPath.equals(this.curGcsPath)) {
            StorageResourceId destResourceId = StorageResourceId.fromStringPath(this.finalGcsPath.toString(), this.curDestGenerationId);
            StorageResourceId tempResourceId = StorageResourceId.fromStringPath(this.curGcsPath.toString(), generationId);
            if (!destResourceId.getBucketName().equals(tempResourceId.getBucketName())) {
                throw new IllegalStateException(String.format("Destination bucket in path '%s' doesn't match temp file bucket in path '%s'", this.finalGcsPath, this.curGcsPath));
            }
            GoogleCloudStorageItemInfo composedObject = this.ghfs.getGcsFs().getGcs().composeObjects(ImmutableList.of(destResourceId, tempResourceId), destResourceId, GoogleCloudStorageFileSystem.objectOptionsFromFileOptions(this.fileOptions));
            this.curDestGenerationId = composedObject.getContentGeneration();
            this.deletionFutures.add(this.cleanupThreadpool.submit(() -> {
                this.ghfs.getGcsFs().getGcs().deleteObjects(ImmutableList.of(tempResourceId));
                return null;
            }));
        } else {
            this.curDestGenerationId = generationId;
        }
    }

    private URI getNextTemporaryPath() {
        Path basePath = this.ghfs.getHadoopPath(this.finalGcsPath);
        Path baseDir = basePath.getParent();
        Path tempPath = new Path(baseDir, String.format("%s%s.%d.%s", TEMPFILE_PREFIX, basePath.getName(), this.curComponentIndex, UUID.randomUUID().toString()));
        return this.ghfs.getGcsPath(tempPath);
    }

    private boolean isOpen() {
        return this.curDelegate != null;
    }

    private void throwIfNotOpen() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }
}

