/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.MoreObjects;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Internal;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.LoadBalancer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.LoadBalancerProvider;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.LoadBalancerRegistry;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.NameResolver;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.JsonUtil;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.ServiceConfigUtil;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.xds.ClusterManagerLoadBalancer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@Internal
public class ClusterManagerLoadBalancerProvider
extends LoadBalancerProvider {
    @Nullable
    private final LoadBalancerRegistry lbRegistry;

    public ClusterManagerLoadBalancerProvider() {
        this(null);
    }

    @VisibleForTesting
    ClusterManagerLoadBalancerProvider(@Nullable LoadBalancerRegistry lbRegistry) {
        this.lbRegistry = lbRegistry;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public String getPolicyName() {
        return "cluster_manager_experimental";
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawConfig) {
        LinkedHashMap<String, ServiceConfigUtil.PolicySelection> parsedChildPolicies = new LinkedHashMap<String, ServiceConfigUtil.PolicySelection>();
        try {
            Map<String, ?> childPolicies = JsonUtil.getObject(rawConfig, "childPolicy");
            if (childPolicies == null || childPolicies.isEmpty()) {
                return NameResolver.ConfigOrError.fromError(Status.INTERNAL.withDescription("No child policy provided for cluster_manager LB policy: " + rawConfig));
            }
            for (String name : childPolicies.keySet()) {
                Map<String, ?> childPolicy = JsonUtil.getObject(childPolicies, name);
                if (childPolicy == null) {
                    return NameResolver.ConfigOrError.fromError(Status.INTERNAL.withDescription("No config for child " + name + " in cluster_manager LB policy: " + rawConfig));
                }
                List<ServiceConfigUtil.LbConfig> childConfigCandidates = ServiceConfigUtil.unwrapLoadBalancingConfigList(JsonUtil.getListOfObjects(childPolicy, "lbPolicy"));
                if (childConfigCandidates == null || childConfigCandidates.isEmpty()) {
                    return NameResolver.ConfigOrError.fromError(Status.INTERNAL.withDescription("No config specified for child " + name + " in cluster_manager Lb policy: " + rawConfig));
                }
                LoadBalancerRegistry registry = this.lbRegistry != null ? this.lbRegistry : LoadBalancerRegistry.getDefaultRegistry();
                NameResolver.ConfigOrError selectedConfig = ServiceConfigUtil.selectLbPolicyFromList(childConfigCandidates, registry);
                if (selectedConfig.getError() != null) {
                    Status error = selectedConfig.getError();
                    return NameResolver.ConfigOrError.fromError(Status.INTERNAL.withCause(error.getCause()).withDescription(error.getDescription()).augmentDescription("Failed to select config for child " + name));
                }
                parsedChildPolicies.put(name, (ServiceConfigUtil.PolicySelection)selectedConfig.getConfig());
            }
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError(Status.fromThrowable(e).withDescription("Failed to parse cluster_manager LB config: " + rawConfig));
        }
        return NameResolver.ConfigOrError.fromConfig(new ClusterManagerConfig(parsedChildPolicies));
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new ClusterManagerLoadBalancer(helper);
    }

    static class ClusterManagerConfig {
        final Map<String, ServiceConfigUtil.PolicySelection> childPolicies;

        ClusterManagerConfig(Map<String, ServiceConfigUtil.PolicySelection> childPolicies) {
            this.childPolicies = Collections.unmodifiableMap(childPolicies);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClusterManagerConfig)) {
                return false;
            }
            ClusterManagerConfig config = (ClusterManagerConfig)o;
            return Objects.equals(this.childPolicies, config.childPolicies);
        }

        public int hashCode() {
            return Objects.hash(this.childPolicies);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("childPolicies", this.childPolicies).toString();
        }
    }
}

