/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import java.util.OptionalLong;

public class GrpcRequestTracingInfo {
    final String api = "grpc";
    final String objectName;
    final String requestType;

    private GrpcRequestTracingInfo(String objectName, String requestType) {
        this.objectName = objectName;
        this.requestType = requestType;
    }

    static GrpcRequestTracingInfo getReadRequestTraceInfo(String objectName, long objectGeneration, long offset, OptionalLong bytesToRead) {
        return new ReadRequestTracingInfo(objectName, objectGeneration, offset, bytesToRead);
    }

    static GrpcRequestTracingInfo getWriteRequestTraceInfo(String objectName) {
        return new GrpcRequestTracingInfo(objectName, "write");
    }

    public String getApi() {
        return this.api;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getRequestType() {
        return this.requestType;
    }

    private static class ReadRequestTracingInfo
    extends GrpcRequestTracingInfo {
        final long objectGeneration;
        final long offset;
        final OptionalLong bytesToRead;

        ReadRequestTracingInfo(String objectName, long objectGeneration, long offset, OptionalLong bytesToRead) {
            super(objectName, "read");
            this.objectGeneration = objectGeneration;
            this.offset = offset;
            this.bytesToRead = bytesToRead;
        }
    }
}

